/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache;

import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.cache.CacheException;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.IReleasable;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class ROLAPCacheBase
implements IReleasable {
    private final ROLAPCube mCube;
    private final AtomicInteger mReservationCount = new AtomicInteger(0);
    private final AtomicInteger mSoftReservationCount = new AtomicInteger(0);
    protected static final XQELogger LOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "ROLAPCubes", LogLevel.ERROR);
    private static final AtomicInteger NEXT_CACHE_ID = new AtomicInteger(0);
    private final int mCacheID = NEXT_CACHE_ID.getAndIncrement();
    private final long mCreationTimestamp = System.currentTimeMillis();
    private boolean mInvalid;
    private ROLAPCacheBase parent;

    protected ROLAPCacheBase(ROLAPCube cube) {
        this.mCube = cube;
        this.mInvalid = false;
    }

    protected ROLAPCacheBase(ROLAPCube cube, ROLAPCacheBase theParent) {
        this(cube);
        this.parent = theParent;
    }

    protected void assertValid() {
        if (this.mInvalid) {
            throw new OperationCanceledException();
        }
    }

    public void invalidate() {
        this.mInvalid = true;
    }

    public int getID() {
        return this.mCacheID;
    }

    public long getTimestamp() {
        return this.mCreationTimestamp;
    }

    public final ROLAPCube getCube() {
        return this.mCube;
    }

    public ROLAPCacheBase getParent() {
        return this.parent;
    }

    public final int getReservationCount() {
        return this.mReservationCount.get();
    }

    public final void incSoftRefCount() {
        this.mSoftReservationCount.incrementAndGet();
    }

    public final void decSoftRefCount() {
        this.mSoftReservationCount.decrementAndGet();
    }

    public final int getSoftReservationCount() {
        return this.mSoftReservationCount.get();
    }

    public final int reserve() {
        return this.mReservationCount.incrementAndGet();
    }

    public final int unreserve() {
        int count = this.mReservationCount.decrementAndGet();
        return count;
    }

    public static void throwCachePutException(CacheException e, String cube, String dim) {
        if (e instanceof CacheException.FileRemovalFailure) {
            throw new XQERuntimeException(XQEMessageKeys.ROL_DimFileDeleteException, cube, e.getFilename());
        }
        if (e instanceof CacheException.FileIOError) {
            throw new XQERuntimeException(XQEMessageKeys.ROL_DimensionFlushIOException, (Object)cube, (Object)dim, (Object)e.getFilename());
        }
        throw new XQERuntimeException(XQEMessageKeys.ROL_MemberCacheInternalError, e, (Object)cube, (Object)dim, (Object)e.getFilename());
    }

    public static void throwCacheRemoveException(CacheException e, String cube, String dim) {
        if (e instanceof CacheException.FileIOError) {
            throw new XQERuntimeException(XQEMessageKeys.ROL_DimensionReadIOException, cube, (Object)dim, (Object)e.getFilename(), (Object)e.toString());
        }
        throw new XQERuntimeException(XQEMessageKeys.ROL_MemberCacheInternalError, e, (Object)cube, (Object)dim, (Object)e.getFilename());
    }

    public static void throwCacheGetException(CacheException e, String cube, String dim) {
        if (e instanceof CacheException.FileIOError) {
            throw new XQERuntimeException(XQEMessageKeys.ROL_DimensionReadIOException, cube, (Object)dim, (Object)e.getFilename(), (Object)e.toString());
        }
        throw new XQERuntimeException(XQEMessageKeys.ROL_MemberCacheInternalError, e, (Object)cube, (Object)dim, (Object)e.getFilename());
    }
}

