/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache;

import com.cognos.xqe.cache.CacheException;
import com.cognos.xqe.cache.CacheMetricsTracker;
import com.cognos.xqe.cache.ICacheEngine;
import com.cognos.xqe.cache.ICacheFaultHandler;
import com.cognos.xqe.cache.ICacheKey;
import com.cognos.xqe.cache.ICacheStorage;
import com.cognos.xqe.cache.ICacheableObject;
import com.cognos.xqe.cache.util.CacheableNameValueBasedArray;
import com.cognos.xqe.cache.util.ICacheableNameValueBasedContent;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.runtree.olap.mdx.metadata.metadatacache.MetadataCacheKey;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.ROLAPCacheBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class ROLAPCacheEngine
implements ICacheEngine {
    public static final String CACHED_NAME_PROP = "NAME";
    public static final String PARENT_MEMBER_CACHE_KEY = "PARENT_MEMBER_CACHE_KEY";
    public static final String CHILD_MEMBERS_CACHED_KEYS = "CHILD_MEMBERS_CACHED_KEYS";
    public static final String LEVEL_MEMBERS_CACHE_KEYS = "LEVEL_MEMBERS_CACHE_KEYS";
    public static final String CACHED_LEVEL_KEYS_PROP = "LEVEL_KEYS";
    public static final String CACHED_BUSINESSKEY_PROP = "BUSINESS_KEY";
    public static final String CACHED_MUN_PROP = "MEMBER_UNIQUE_NAME";
    public static final String CACHED_IS_DM_PROP = "IS_DATA_MEMBER";
    public static final String CACHED_ORDINAL_PROP = "MEMBER_ORDINAL";
    public static final String CACHED_CAPTION = "CAPTION";
    private final AtomicInteger mCachedMemberCount = new AtomicInteger(0);
    private final AtomicInteger levelId = new AtomicInteger(0);
    private ICacheEngine storageImpl;

    public int getCachedMemberCount() {
        return this.mCachedMemberCount.get();
    }

    public ROLAPCacheEngine(ICacheEngine storage) {
        this.storageImpl = storage;
    }

    public List<ICacheKey> getMemberSiblingsFromCache(ICacheKey memberCacheKey) throws CacheException {
        ICacheKey parentCacheKey = this.getMemberParentFromCache(memberCacheKey);
        if (parentCacheKey != null) {
            return this.getMemberChildrenFromCache(parentCacheKey);
        }
        return null;
    }

    public ICacheKey getMemberParentFromCache(ICacheKey memberCacheKey) throws CacheException {
        return (ICacheKey)this.getMemberPropValueFromCache(memberCacheKey, PARENT_MEMBER_CACHE_KEY);
    }

    public String getMemberNameFromCache(ICacheKey memberCacheKey) throws CacheException {
        Object cachedObject = this.getMemberPropValueFromCache(memberCacheKey, CACHED_NAME_PROP);
        if (cachedObject != null) {
            return cachedObject.toString();
        }
        return null;
    }

    public List<ICacheKey> getMemberChildrenFromCache(ICacheKey parentCacheKey) throws CacheException {
        ICacheKey[] children = (ICacheKey[])this.getMemberPropValueFromCache(parentCacheKey, CHILD_MEMBERS_CACHED_KEYS);
        if (children != null) {
            return Arrays.asList(children);
        }
        return null;
    }

    public List<ICacheKey> getLevelMembersFromCache(ROLAPLevel level) throws CacheException {
        ICacheKey[] members;
        ICacheableNameValueBasedContent cacheData = (ICacheableNameValueBasedContent)this.storageImpl.get(level.getCacheKey());
        if (cacheData != null && (members = (ICacheKey[])cacheData.get(LEVEL_MEMBERS_CACHE_KEYS)) != null) {
            return Arrays.asList(members);
        }
        return null;
    }

    public void setPropValueInCache(ICacheKey cacheKey, String propName, Object propValue, IDimension dim, ICube cube) {
        try {
            ICacheableNameValueBasedContent cachedContent = (ICacheableNameValueBasedContent)this.storageImpl.get(cacheKey);
            if (cachedContent == null) {
                throw new XQERuntimeException(XQEMessageKeys.ROL_CacheKeyNotFoundInCache, cacheKey, (Object)dim.getName());
            }
            cachedContent.put(propName, propValue);
            this.storageImpl.cacheObject(cachedContent);
        }
        catch (CacheException e) {
            ROLAPCacheBase.throwCacheGetException(e, cube.getName(), dim.getName());
        }
    }

    public static ICacheableNameValueBasedContent createCacheableObject(MetadataCacheKey metadataCachekey, Map<String, Object> props) {
        return new CacheableNameValueBasedArray(metadataCachekey, props);
    }

    public ICacheKey createLevelCacheKey() {
        return new MetadataCacheKey(this.levelId.getAndIncrement());
    }

    public void addMembersToCachedLevel(ROLAPHierarchy hier, ICacheKey levelCacheKey, List<ICacheKey> members) throws CacheException {
        ROLAPCacheEngine storage = hier.getROLAPDimension().getMetadataStorage();
        ICacheKey[] t = new ICacheKey[]{};
        ICacheableNameValueBasedContent cacheData = (ICacheableNameValueBasedContent)storage.get(levelCacheKey);
        if (cacheData == null) {
            HashMap<String, Object> props = new HashMap<String, Object>(1, 1.0f);
            props.put(LEVEL_MEMBERS_CACHE_KEYS, members.toArray(t));
            cacheData = ROLAPCacheEngine.createCacheableObject((MetadataCacheKey)levelCacheKey, props);
        } else {
            cacheData.put(LEVEL_MEMBERS_CACHE_KEYS, (Object)members.toArray(t));
        }
        storage.cacheObject(cacheData);
        ROLAPLevel level = hier.getROLAPLevel(levelCacheKey);
        boolean dataMembersHidden = ((ROLAPHierarchy)level.getHierarchy()).isDataMemberHidden();
        if (dataMembersHidden) {
            int memberCount = 0;
            for (int i = 0; i < members.size(); ++i) {
                MetadataCacheKey cachedMemberKey = (MetadataCacheKey)members.get(i);
                if (this.getMemberPropValueFromCache(cachedMemberKey, CACHED_IS_DM_PROP) != null) continue;
                ++memberCount;
            }
            level.setCardinality(memberCount);
        } else {
            level.setCardinality(members.size());
        }
    }

    public void setMemberPropValueInCache(ICacheKey memberCacheKey, String propName, Object value) throws CacheException {
        ICacheableNameValueBasedContent memberData = (ICacheableNameValueBasedContent)this.storageImpl.get(memberCacheKey);
        if (memberData != null && memberData.getContent() != null) {
            memberData.getContent().put(propName, value);
        }
    }

    public Object getMemberPropValueFromCache(ICacheKey memberCacheKey, String propName) throws CacheException {
        ICacheableNameValueBasedContent memberData = (ICacheableNameValueBasedContent)this.storageImpl.get(memberCacheKey);
        Object propValue = null;
        if (memberData != null && memberData.getContent() != null) {
            propValue = memberData.getContent().get(propName);
        }
        return propValue;
    }

    public void bulkCacheMembers(List<ICacheableObject> members) throws CacheException {
        this.storageImpl.cacheAll(members);
        this.mCachedMemberCount.addAndGet(members.size());
    }

    public void bulkRemoveMembers(Set<ICacheKey> members) throws CacheException {
        for (ICacheKey key : members) {
            this.storageImpl.remove(key);
            this.mCachedMemberCount.decrementAndGet();
        }
    }

    public void cacheMember(ICacheableObject obj) throws CacheException {
        this.storageImpl.cacheObject(obj);
        this.mCachedMemberCount.incrementAndGet();
    }

    public void addChildrenToCachedParent(ICacheKey parentMemberKey, List<ICacheKey> members) throws CacheException {
        ICacheKey[] t = new ICacheKey[]{};
        ICacheableNameValueBasedContent cacheData = (ICacheableNameValueBasedContent)this.storageImpl.get(parentMemberKey);
        if (cacheData == null) {
            throw new XQERuntimeException();
        }
        cacheData.put(CHILD_MEMBERS_CACHED_KEYS, (Object)members.toArray(t));
        this.storageImpl.cacheObject(cacheData);
    }

    public void addMemberToCachedLevel(ROLAPLevel level, ICacheKey memberCacheKey) throws CacheException {
        ICacheKey[] t = new ICacheKey[]{};
        ICacheableNameValueBasedContent levelCacheData = (ICacheableNameValueBasedContent)this.storageImpl.get(level.getCacheKey());
        if (levelCacheData == null) {
            HashMap<String, Object> props = new HashMap<String, Object>(1, 1.0f);
            ArrayList<ICacheKey> levelMembers = new ArrayList<ICacheKey>();
            levelMembers.add(memberCacheKey);
            props.put(LEVEL_MEMBERS_CACHE_KEYS, levelMembers.toArray(t));
            levelCacheData = ROLAPCacheEngine.createCacheableObject((MetadataCacheKey)level.getCacheKey(), props);
        } else {
            ArrayList<ICacheKey> levelMembers = (ArrayList<ICacheKey>)levelCacheData.get(LEVEL_MEMBERS_CACHE_KEYS);
            if (levelMembers == null) {
                levelMembers = new ArrayList<ICacheKey>();
            }
            levelMembers.add(memberCacheKey);
            levelCacheData.put(LEVEL_MEMBERS_CACHE_KEYS, (Object)levelMembers.toArray(t));
        }
        this.storageImpl.cacheObject(levelCacheData);
    }

    @Override
    public boolean contains(ICacheKey key) throws CacheException {
        return this.storageImpl.contains(key);
    }

    @Override
    public void cacheObject(ICacheableObject obj) throws CacheException {
        this.storageImpl.cacheObject(obj);
    }

    @Override
    public void cacheAll(List<ICacheableObject> objects) throws CacheException {
        this.storageImpl.cacheAll(objects);
    }

    @Override
    public ICacheableObject get(ICacheKey key) throws CacheException {
        return this.storageImpl.get(key);
    }

    @Override
    public ICacheableObject get(ICacheKey key, CacheMetricsTracker metrics) throws CacheException {
        return this.storageImpl.get(key, metrics);
    }

    @Override
    public List<ICacheableObject> getAll(List<ICacheKey> keys) throws CacheException {
        return this.storageImpl.getAll(keys);
    }

    @Override
    public List<ICacheableObject> getAll(List<ICacheKey> keys, CacheMetricsTracker metrics) throws CacheException {
        return null;
    }

    @Override
    public void remove(ICacheKey key) throws CacheException {
        this.storageImpl.remove(key);
    }

    @Override
    public void addStorage(ICacheStorage cacheStorage) {
        this.storageImpl.addStorage(cacheStorage);
    }

    @Override
    public void addFaultHandler(ICacheFaultHandler handler) {
        this.addFaultHandler(handler);
    }

    @Override
    public void close() throws CacheException {
    }

    @Override
    public void flush() throws CacheException {
        this.storageImpl.flush();
    }

    @Override
    public void clear() throws CacheException {
        this.storageImpl.clear();
    }

    @Override
    public int getCacheSize() {
        return this.storageImpl.getCacheSize();
    }

    @Override
    public int getCacheSizeBytes() {
        return this.storageImpl.getCacheSizeBytes();
    }

    @Override
    public CacheMetricsTracker getMetrics() {
        return this.storageImpl.getMetrics();
    }

    @Override
    public int getFreeSize() {
        return this.storageImpl.getFreeSize();
    }
}

