/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache;

import com.cognos.xqe.cache.CacheMetricsTracker;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPBaseCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeMetrics;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeReservation;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.model.ROLAPMetaInMemoryAggregate;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.ROLAPCacheBase;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.security.IROLAPSecurityManager;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualCube;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.BlockTupleStorageFactory;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.IBlockTupleStorage;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.AggregateCubeletStorage;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.composite.CompositeCubeletStorage;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.CubeletStorage;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.UpdateableCubeletStorage;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.incremental.IncrementManager;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.incremental.QueryIncrementalStagingAdaper;
import java.util.concurrent.atomic.AtomicLong;

public class ROLAPDataCache
extends ROLAPCacheBase {
    private final IBlockTupleStorage blockTupleStorage;
    private AggregateCubeletStorage aggregateStorage = null;
    private final IncrementManager incrementManager;
    private CacheMetricsTracker tupleStorageMetrics;
    private final AtomicLong inMemoryAggregateLoadStartTime = new AtomicLong();
    private final AtomicLong inMemoryAggregateLoadEndTime = new AtomicLong();
    private final AtomicLong loadedInMemoryAggregateCount = new AtomicLong();
    private final AtomicLong definedInMemoryAggregateCount = new AtomicLong();
    private final ROLAPCubeMetrics.Average inMemoryAggregateCacheHitRate = new ROLAPCubeMetrics.Average();
    private final ROLAPCubeMetrics.SlidingWindowValue inMemoryAggregateCacheHitRateLastHour = new ROLAPCubeMetrics.SlidingWindowValue();

    public ROLAPDataCache(ROLAPCube cube, ROLAPCacheBase theParent) {
        super(cube, theParent);
        int maxDataCacheSize = cube.getConfigMaxDataCacheSize();
        if (maxDataCacheSize > 0) {
            this.blockTupleStorage = this.isCompositeStorageNeeded(cube) ? new CompositeCubeletStorage(cube) : BlockTupleStorageFactory.getBlockTupleStorage(this.getCube());
            this.blockTupleStorage.initialize();
            if (this.blockTupleStorage instanceof CubeletStorage) {
                ((CubeletStorage)this.blockTupleStorage).setMaxSize(maxDataCacheSize);
            }
        } else {
            this.blockTupleStorage = null;
        }
        if (!cube.isVirtual()) {
            ROLAPMetaInMemoryAggregate model = ((ROLAPBaseCube)cube).getInMemoryAggregateModel();
            if (model != null) {
                this.definedInMemoryAggregateCount.set(model.getAggregateCount());
            }
            this.incrementManager = new IncrementManager((ROLAPBaseCube)cube, new QueryIncrementalStagingAdaper((ROLAPBaseCube)cube));
            if (this.blockTupleStorage instanceof UpdateableCubeletStorage) {
                ((UpdateableCubeletStorage)this.blockTupleStorage).setIncrementManager(this.incrementManager);
            }
        } else {
            this.incrementManager = null;
        }
        this.tupleStorageMetrics = new CacheMetricsTracker(false);
        cube.getMetrics().notifyDataCacheCleared();
        ROLAPLog.log("ROLAPCubes.Management", String.format("Data cache %d was created with a max size of %d MB.", this.getID(), maxDataCacheSize));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isCompositeStorageNeeded(ROLAPCube cube) {
        if (!cube.isVirtual()) {
            return false;
        }
        boolean tmpAllAccess = true;
        ROLAPCube[] sourceCubes = ((ROLAPVirtualCube)cube).getSourceCubes();
        ROLAPCubeReservation[] res = ROLAPVirtualCube.reserveSourceCubes(sourceCubes);
        try {
            for (int i = 0; i < sourceCubes.length; ++i) {
                IROLAPSecurityManager secMan = (IROLAPSecurityManager)sourceCubes[i].getSecurityManager();
                if (secMan == null || secMan.hasNoRestrictions()) continue;
                tmpAllAccess = false;
            }
        }
        finally {
            ROLAPVirtualCube.unreserveSourceCubes(res);
        }
        return !tmpAllAccess;
    }

    public CacheMetricsTracker getTupleStorageMetrics() {
        this.assertValid();
        return this.tupleStorageMetrics;
    }

    public IBlockTupleStorage getBlockTupleStorage() {
        this.assertValid();
        return this.blockTupleStorage;
    }

    public final AggregateCubeletStorage getAggregateStorage() {
        this.assertValid();
        return this.aggregateStorage;
    }

    public void setAggregateStorage(AggregateCubeletStorage theAggregateStorage) {
        this.assertValid();
        this.aggregateStorage = theAggregateStorage;
    }

    public void initialize() {
    }

    public long getInMemoryAggregateLoadStartTime() {
        return this.inMemoryAggregateLoadStartTime.get();
    }

    public void setInMemoryAggregateLoadStartTime(long theInMemoryAggregateLoadStartTime) {
        this.assertValid();
        this.inMemoryAggregateLoadStartTime.set(theInMemoryAggregateLoadStartTime);
    }

    public long getInMemoryAggregateLoadEndTime() {
        return this.inMemoryAggregateLoadEndTime.get();
    }

    public void setInMemoryAggregateLoadEndTime(long theInMemoryAggregateLoadEndTime) {
        this.assertValid();
        this.inMemoryAggregateLoadEndTime.set(theInMemoryAggregateLoadEndTime);
    }

    public long getLoadedInMemoryAggregateCount() {
        return this.loadedInMemoryAggregateCount.get();
    }

    public void setLoadedInMemoryAggregateCount(long theLoadedInMemoryAggregateCount) {
        this.assertValid();
        this.loadedInMemoryAggregateCount.set(theLoadedInMemoryAggregateCount);
    }

    public void incrementLoadedInMemoryAggregateCount() {
        this.assertValid();
        this.loadedInMemoryAggregateCount.incrementAndGet();
    }

    public void decrementLoadedInMemoryAggregateCount(long delta) {
        this.assertValid();
        this.loadedInMemoryAggregateCount.addAndGet(-1L * delta);
    }

    public long getDefinedInMemoryAggregateCount() {
        return this.definedInMemoryAggregateCount.get();
    }

    public void setDefinedInMemoryAggregateCount(long theDefinedInMemoryAggregateCount) {
        this.assertValid();
        this.definedInMemoryAggregateCount.set(theDefinedInMemoryAggregateCount);
    }

    public void incrementDefinedInMemoryAggregateCount(long delta) {
        this.assertValid();
        this.definedInMemoryAggregateCount.addAndGet(delta);
    }

    public void decrementDefinedInMemoryAggregateCount(long delta) {
        this.assertValid();
        this.definedInMemoryAggregateCount.addAndGet(-1L * delta);
    }

    public double getInMemoryAggregateCacheHitRate() {
        return this.inMemoryAggregateCacheHitRate.getValue();
    }

    public double getInMemoryAggregateCacheHitRateInLastHour() {
        return this.inMemoryAggregateCacheHitRateLastHour.getAverage();
    }

    public void recordInMemoryAggregateCacheStats(long hits, long accesses) {
        this.assertValid();
        this.inMemoryAggregateCacheHitRate.addValue(hits, accesses);
        this.inMemoryAggregateCacheHitRateLastHour.recordValue(hits, accesses);
    }

    public IncrementManager getIncrementManager() {
        this.assertValid();
        return this.incrementManager;
    }

    @Override
    public void release() {
        try {
            this.tupleStorageMetrics = null;
            this.aggregateStorage = null;
        }
        finally {
            this.getCube().onDataCacheReleased(this.getParent().getID(), this.getID());
        }
    }
}

