/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache;

import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPContext;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPBaseCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeAction;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeManager;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeReservation;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.ROLAPCacheBase;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualCube;
import com.cognos.xqe.runtree.olap.mdx.security.SecurityManagerInterface;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import java.util.ArrayList;

public class ROLAPSecurityCache
extends ROLAPCacheBase {
    private SecurityManagerInterface securityManager;

    public ROLAPSecurityCache(ROLAPCube cube) {
        super(cube);
        ROLAPLog.log("ROLAPCubes.Management", String.format("Security cache %d was created.", this.getID()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(ROLAPCubeAction cubeAction, SecurityManagerInterface currentSecurityManager) {
        ROLAPCube cube = this.getCube();
        if (ROLAPCubeAction.REFRESH_SECURITY == cubeAction) {
            ExecutionEnvironment execEnv = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
            ROLAPContext context = ROLAPContext.get(execEnv);
            ROLAPCubeReservation reservation = new ROLAPCubeReservation(cube, cube.getMemberCacheManager().getCurrentRevision(), cube.getMemberCacheManager().getCurrentRevision().getDataCacheManager().getCurrentRevision(), cube.getMemberCacheManager().getCurrentRevision().getSecurityCacheManager().getCurrentRevision());
            context.addReservation(reservation, execEnv);
            ArrayList<ROLAPCubeReservation> missingRes = new ArrayList<ROLAPCubeReservation>();
            context.reserveMissingLeaves(cube, missingRes);
            try {
                cube.onMemberCacheReleased(cube.getMemberCacheManager().getCurrentRevision().getID());
                this.initializeSecurityCacheWithoutReservation(ROLAPCubeAction.REFRESH_SECURITY, currentSecurityManager, cube);
            }
            finally {
                context.unreserveMissingLeaves(missingRes);
                context.removeReservation(reservation);
            }
        } else {
            this.initializeSecurityCacheWithoutReservation(cubeAction, currentSecurityManager, cube);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeSecurityCacheWithoutReservation(ROLAPCubeAction cubeAction, SecurityManagerInterface currentSecurityManager, ROLAPCube cube) {
        boolean needToRemoveCubeName = ROLAPContext.setCurrentCubeName(cube.getName());
        try {
            this.securityManager = !cube.isVirtual() ? ROLAPCubeManager.getInstance().getSecurityManagerFactory().create(cubeAction, (ROLAPBaseCube)cube, currentSecurityManager) : ROLAPCubeManager.getInstance().getSecurityManagerFactory().create(cubeAction, (ROLAPVirtualCube)cube);
        }
        finally {
            ROLAPContext.removeCurrentCubeName(needToRemoveCubeName);
        }
    }

    public SecurityManagerInterface getSecurityManager() {
        this.assertValid();
        return this.securityManager;
    }

    @Override
    public void release() {
        this.securityManager = null;
    }
}

