/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.aggregate;

import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.bibushandler.SQLQueryMetrics;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.V5ConnectionInfo;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Cell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.CrossJoinedSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IResultSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.ResultSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.SetSelections;
import com.cognos.xqe.runtree.olap.mdx.interpreter.TupleOrdinalCalculationCache;
import com.cognos.xqe.runtree.olap.mdx.interpreter.TupleValue;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPContext;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPQueryExecuteMetrics;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPQueryStrategy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPBaseCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log.QueryType;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.aggregate.ROLAPAggregateDefinition;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.BlockTupleStorageUtil;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.IBlockTupleStorage;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.AggregateDefinition;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.AggregateUtilities;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.CubeletStorage;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AggregateCacheLoader {
    private static final String REVIEW_MODEL_MSG = "Review the level key definitions and the join relationships (ex: The 1 to N cardinalities).  ";
    private static final String VIEW_SQL_MSG = "View the generated sql by adding the following log group '<eventGroup name=\"QueryService.SQL\" level=\"trace\"/>' and rerunning the aggregate load. ";
    private static final String AGGREGATE_MSG = "Aggregate ";
    private static final String CUBE_MODEL_PROBLEM_MSG = "This indicates a problem with the cube model or data.  ";
    private static final String CUBE_LOG_MSG = "Cube ";
    private static final String REQUEST_ID_FOR_AGGREGATE_POPULATION = "requestIDForAggregatePopulation";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ROLAPQueryExecuteMetrics loadSingleCacheSlice(ROLAPBaseCube cube, IBlockTupleStorage aggregateCache, AggregateDefinition aggregateDefinition) throws InterpreterException {
        ROLAPLog.logOpStart(LogLevel.INFO, "ROLAPCubes.AggregateCache", CUBE_LOG_MSG + UniqueNameGenerator.createUniqueName(cube.getName()) + " started loading aggregate " + UniqueNameGenerator.createUniqueName(aggregateDefinition.getName()) + " from the database.");
        ROLAPQueryExecuteMetrics queryMetrics = new ROLAPQueryExecuteMetrics(0);
        boolean needToRemoveCubeName = false;
        try {
            IMember[][] members = AggregateCacheLoader.getMembersForSlice(cube, aggregateDefinition);
            if (!AggregateUtilities.validateDimensionalSize(members)) {
                throw new XQERuntimeException(XQEMessageKeys.ROL_InMemoryAggregateDefinition_DimensionSpaceTooLarge, UniqueNameGenerator.createUniqueName(aggregateDefinition.getName()), UniqueNameGenerator.createUniqueName(cube.getName()));
            }
            CrossJoinedSet setToFetch = BlockTupleStorageUtil.createCjsFromMemberSelections(members, null, true);
            if (setToFetch.isLargeSet()) {
                ROLAPLog.log("ROLAPCubes.AggregateCache", CUBE_LOG_MSG + UniqueNameGenerator.createUniqueName(cube.getName()) + " has aggregate " + UniqueNameGenerator.createUniqueName(aggregateDefinition.getName()) + " with a large ordinal dimenational space (greater than 2**63).");
            }
            Collection<IMember>[] membersInCollections = BlockTupleStorageUtil.arraysToSelectionSets(members);
            SetSelections setSel = new SetSelections(setToFetch, membersInCollections);
            ROLAPQueryStrategy queryStrategy = new ROLAPQueryStrategy();
            queryStrategy.setCube(cube);
            queryStrategy.setCubeletHint(aggregateDefinition.getName());
            queryStrategy.setSystemGenerated(true);
            needToRemoveCubeName = ROLAPContext.setCurrentCubeName(cube.getName());
            RequestEnvironment reqEnv = AggregateCacheLoader.createRequestEnvironment(REQUEST_ID_FOR_AGGREGATE_POPULATION, null, cube.getName());
            V5ConnectionInfo qc = V5ConnectionInfo.getNewInstance(reqEnv.getRunLocale());
            queryStrategy.setInfoData(qc);
            MetricsOnlyResultSet resultSet = new MetricsOnlyResultSet(setToFetch);
            queryStrategy.executeColdCacheToTupleStorage(setSel, resultSet, aggregateCache, queryMetrics, QueryType.AGGREGATE_LOAD_QUERY);
            AggregateCacheLoader.validateAggregate(aggregateDefinition, queryMetrics, ((ResultSet)resultSet).cellCount());
            ((ROLAPAggregateDefinition)aggregateDefinition).setCellCount(((ResultSet)resultSet).cellCount());
            int requestIncrementId = MultiRequestContext.getCurrentIncrementId(cube);
            ((ROLAPAggregateDefinition)aggregateDefinition).setBaseIncrementId(requestIncrementId);
            long cubeletSize = ((CubeletStorage)aggregateCache).getCubeletSize(aggregateDefinition.getName());
            ROLAPLog.log("ROLAPCubes.AggregateCache", CUBE_LOG_MSG + UniqueNameGenerator.createUniqueName(cube.getName()) + " successfully loaded aggregate " + UniqueNameGenerator.createUniqueName(aggregateDefinition.getName()) + " from the db with " + NumberFormat.getInstance().format(((ResultSet)resultSet).cellCount()) + " cells using " + NumberFormat.getInstance().format(cubeletSize) + " bytes for increment " + requestIncrementId + ".");
        }
        finally {
            ROLAPContext.removeCurrentCubeName(needToRemoveCubeName);
            ROLAPLog.logOpEnd(LogLevel.INFO, "ROLAPCubes.AggregateCache", CUBE_LOG_MSG + UniqueNameGenerator.createUniqueName(cube.getName()) + " ended loading aggregate " + UniqueNameGenerator.createUniqueName(aggregateDefinition.getName()) + " from the database. ");
        }
        return queryMetrics;
    }

    private static void validateAggregate(AggregateDefinition aggregateDefinition, ROLAPQueryExecuteMetrics queryMetrics, int cellCount) {
        long totalDiscardedRows = 0L;
        long totalRows = 0L;
        for (SQLQueryMetrics sqlMetric : queryMetrics.getSqlQueryMetrics()) {
            totalDiscardedRows += sqlMetric.getNumberOfRowsDiscarded();
            totalRows += sqlMetric.getNumberOfRowsFetched();
        }
        if (totalDiscardedRows > 0L) {
            ROLAPLog.logError("ROLAPCubes.AggregateCache", AGGREGATE_MSG + UniqueNameGenerator.createUniqueName(aggregateDefinition.getName()) + " has discarded " + NumberFormat.getInstance().format(totalDiscardedRows) + " out of " + NumberFormat.getInstance().format(totalRows) + " rows fetched.  In-memory aggregates are full slices, so no rows should ever be discarded.  " + CUBE_MODEL_PROBLEM_MSG + REVIEW_MODEL_MSG + VIEW_SQL_MSG);
        } else if (cellCount == 0) {
            ROLAPLog.logError("ROLAPCubes.AggregateCache", AGGREGATE_MSG + UniqueNameGenerator.createUniqueName(aggregateDefinition.getName()) + " has zero values.  This is correct if the fact table has zero rows, otherwise it indicates a problem with either the cube model or data.  " + REVIEW_MODEL_MSG + VIEW_SQL_MSG);
        }
    }

    public static IMember[][] getMembersForSlice(ROLAPCube cube, AggregateDefinition aggregateDefinition) {
        List<IHierarchy> hiers = cube.getHierarchies();
        List<ILevel> levels = aggregateDefinition.getLevels();
        IMember[][] members = null;
        members = new IMember[levels.size() + 1][];
        IHierarchy measureHier = cube.getMeasureDimension().getHierarchy(0);
        int measureHierarchyIndex = hiers.indexOf(measureHier);
        members[measureHierarchyIndex] = aggregateDefinition.getMeasures();
        for (int i = 0; i < levels.size(); ++i) {
            ILevel level = levels.get(i);
            List<IMember> levelMembersList = level.getMembers();
            IMember[] levelMembers = new IMember[levelMembersList.size()];
            levelMembersList.toArray(levelMembers);
            if (levelMembers.length == 0) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Could not get levelMembers for level " + level.getUniqueName());
            }
            IHierarchy hier = level.getHierarchy();
            int index = hiers.indexOf(hier);
            members[index] = levelMembers;
        }
        return members;
    }

    private static RequestEnvironment createRequestEnvironment(String requestID, IHierarchy hierarchy, String cubeName) {
        ExecutionEnvironment execEnv = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        RequestEnvironment reqEnv = ((RequestEnvironment)execEnv.getRequestEnvironment()).duplicate();
        reqEnv.setRequestID(requestID);
        reqEnv.setSubRequestID(null);
        if (hierarchy != null) {
            String reportName = hierarchy.getDimension().getName() + "_" + hierarchy.getName();
            reqEnv.setReportName(reportName);
        }
        reqEnv.setCubeName(cubeName);
        return reqEnv;
    }

    public static class MetricsOnlyResultSet
    extends ResultSet {
        private int addedCellCount = 0;
        private static final ArrayList<long[]> EMPTY_ORDINALS = new ArrayList();

        public MetricsOnlyResultSet(CrossJoinedSet qs) {
            super(qs);
        }

        @Override
        public void add(IResultSet other, boolean combineExistingCells) {
            ++this.addedCellCount;
        }

        @Override
        public void addCell(Cell c) {
            ++this.addedCellCount;
        }

        @Override
        public void addCell(ITuple tuple, Cell c, boolean isCalc) {
            ++this.addedCellCount;
        }

        @Override
        public void addCell(ITuple tuple, Cell c) {
            ++this.addedCellCount;
        }

        @Override
        public void addCell(List<long[]> tupleOrdinals, Cell c, boolean isCalc, boolean alwaysDupCell) {
            ++this.addedCellCount;
        }

        @Override
        public void addCell(List<TupleValue> tupleValues) {
            ++this.addedCellCount;
        }

        @Override
        public List<long[]> getTupleOrdinals(ITuple tuple, TupleOrdinalCalculationCache cache, List<long[]> result) {
            return EMPTY_ORDINALS;
        }

        @Override
        public int cellCount() {
            return this.addedCellCount;
        }
    }
}

