/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.aggregate;

import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPQueryExecuteMetrics;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPBaseCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeManager;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeReservation;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log.AggregateLoadTaskInfo;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.ROLAPBaseDataCache;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.aggregate.AbstractAggregateLoadManagerCubeTask;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.aggregate.AggregateLoadTask;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.aggregate.AggregateLoadTaskResult;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.IBlockTupleStorage;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.AggregateCubeletStorage;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.AggregateDefinition;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.DataCacheCubeletMonitor;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.CubeletStorage;
import com.cognos.xqe.util.UniqueNameGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;

public class AggregateLoadManagerTask
extends AbstractAggregateLoadManagerCubeTask
implements Callable<Object> {
    public AggregateLoadManagerTask(ROLAPBaseCube theCube) {
        super(theCube);
    }

    @Override
    public Object call() throws Exception {
        this.cube.loadInMemoryAggregates(this);
        return null;
    }

    @Override
    protected void loadAggregates(ROLAPCubeReservation reservation) {
        ROLAPBaseDataCache dataCache = (ROLAPBaseDataCache)reservation.getDataCache();
        this.throwExceptionIfLoadIsUnnecessary(dataCache);
        ROLAPLog.log("ROLAPCubes.AggregateCache", String.format("Loading the aggregates into data cache %d began.", dataCache.getID()));
        try {
            AggregateCubeletStorage aggregateCubletStorage = dataCache.createAggregateStorage(this.cube);
            dataCache.setAggregateStorage(aggregateCubletStorage);
            IBlockTupleStorage dataCacheStg = dataCache.getBlockTupleStorage();
            if (dataCacheStg != null && aggregateCubletStorage != null) {
                DataCacheCubeletMonitor cubeletMonitor = new DataCacheCubeletMonitor(aggregateCubletStorage, (CubeletStorage)dataCacheStg);
                ((CubeletStorage)dataCacheStg).setCubeletMonitor(cubeletMonitor);
            }
            this.loadAggregatesInParallel(reservation);
            ROLAPCubeManager.adminNotify(dataCache);
            ROLAPLog.log("ROLAPCubes.AggregateCache", String.format("Loading the aggregates into data cache %d succeeded.", dataCache.getID()));
        }
        catch (XQERuntimeException ex) {
            ROLAPLog.logError("ROLAPCubes.AggregateCache", String.format("Loading the aggregates into data cache %d failed.", dataCache.getID()), ex);
            throw ex;
        }
        finally {
            dataCache.setFinishedLoadingAggregates(true);
        }
    }

    private void loadAggregatesInParallel(ROLAPCubeReservation reservation) {
        ROLAPBaseDataCache dataCache = (ROLAPBaseDataCache)reservation.getDataCache();
        AggregateCubeletStorage aggregateCache = dataCache.getAggregateStorage();
        List<AggregateDefinition> aggregateDefinitions = null;
        if (aggregateCache != null && aggregateCache.getMaxSize() > 0) {
            aggregateDefinitions = aggregateCache.getAllAggregateDefinitions(false);
        }
        if (aggregateDefinitions == null || aggregateDefinitions.isEmpty()) {
            ROLAPLog.log("ROLAPCubes.AggregateCache", String.format("There are no aggregates to load into data cache %d.", dataCache.getID()));
            return;
        }
        List<AggregateLoadTask> aggregateLoadTasks = this.createLoadTasks(aggregateCache, aggregateDefinitions, reservation);
        List<Callable<AggregateLoadTaskResult>> loadTasks = this.decorateLoadTasks(aggregateLoadTasks);
        int loadTaskCount = loadTasks.size();
        ExecutorService executorService = ROLAPCubeManager.getInstance().createAggregateLoadExecutorService(loadTaskCount, reservation.getCube().getConfigMaxAggregateLoadThreads());
        int poolSize = -1;
        if (executorService instanceof ThreadPoolExecutor) {
            poolSize = ((ThreadPoolExecutor)executorService).getMaximumPoolSize();
        }
        ROLAPLog.log("ROLAPCubes.AggregateCache", String.format("Created %d tasks to load the aggregates into data cache %d.  %d tasks will execute in parallel.", loadTaskCount, dataCache.getID(), poolSize));
        try {
            long loadStartTime = System.currentTimeMillis();
            dataCache.setInMemoryAggregateLoadStartTime(loadStartTime);
            ArrayList<Future<AggregateLoadTaskResult>> loadTaskFutures = new ArrayList<Future<AggregateLoadTaskResult>>();
            for (Callable<AggregateLoadTaskResult> loadTask : loadTasks) {
                Future<AggregateLoadTaskResult> loadTaskFuture = executorService.submit(loadTask);
                loadTaskFutures.add(loadTaskFuture);
            }
            int loadTaskFailureCount = 0;
            int numSuccessfulDBAggregates = 0;
            int numSuccessfulRollupAggregates = 0;
            int numFailedAggregates = 0;
            for (int loadTaskIndex = 0; loadTaskIndex < loadTaskCount; ++loadTaskIndex) {
                Future loadTaskFuture = (Future)loadTaskFutures.get(loadTaskIndex);
                try {
                    AggregateLoadTaskResult loadMetrics = (AggregateLoadTaskResult)loadTaskFuture.get();
                    for (ROLAPQueryExecuteMetrics metricsForSingleAggregate : loadMetrics.getMetricsFromDBExecution()) {
                        dataCache.addMetricsForSingleAggregate(metricsForSingleAggregate);
                    }
                    numSuccessfulDBAggregates += loadMetrics.getNumSuccessfullyLoadedFromDB();
                    numSuccessfulRollupAggregates += loadMetrics.getNumSuccessfullyLoadedFromOtherAggregates();
                    numFailedAggregates += loadMetrics.getNumFailedAggregates();
                }
                catch (InterruptedException ex) {
                    throw new OperationCanceledException();
                }
                catch (CancellationException ex) {
                    throw new OperationCanceledException();
                }
                catch (ExecutionException ex) {
                    ROLAPLog.logError("ROLAPCubes.AggregateCache", String.format("The task loading the aggregate %s failed.", UniqueNameGenerator.createUniqueName(aggregateDefinitions.get(loadTaskIndex).getName())), ex.getCause());
                    ++loadTaskFailureCount;
                }
                AggregateLoadTask aggregateLoadTask = aggregateLoadTasks.get(loadTaskIndex);
                List<AggregateLoadTaskInfo> aggregateLoadTaskInfo = aggregateLoadTask.getAggregateLoadTaskInfo();
                this.aggregateLoadManagerTaskInfo.addAggregateLoadTaskInfo(aggregateLoadTaskInfo);
            }
            long loadEndTime = System.currentTimeMillis();
            dataCache.setInMemoryAggregateLoadEndTime(loadEndTime);
            this.logAggregateLoadManagerTaskInfo(loadStartTime, loadEndTime);
            ROLAPLog.log("ROLAPCubes.AggregateCache", String.format("The %d tasks that were created to load the aggregates into data cache %d completed (%d succeeded and %d failed) in %,dms.  %,d aggregates loaded from the db, %,d aggregates loaded from other aggregates, %,d aggregates failed.  Total aggregate cache size is %,d bytes.", loadTaskCount, dataCache.getID(), loadTaskCount - loadTaskFailureCount, loadTaskFailureCount, loadEndTime - loadStartTime, numSuccessfulDBAggregates, numSuccessfulRollupAggregates, numFailedAggregates, aggregateCache.getSize()));
        }
        catch (Exception e) {
            throw XQERuntimeException.wrap(e);
        }
        finally {
            executorService.shutdownNow();
        }
    }

    private void throwExceptionIfLoadIsUnnecessary(ROLAPBaseDataCache dataCache) {
        if (!dataCache.canStartLoadingAggregates()) {
            String logMessage = "Loading the aggregates into data cache %d does not need to be performed by this thread; it %s performed by another thread.";
            if (dataCache.isFinishedLoadingAggregates()) {
                ROLAPLog.log("ROLAPCubes.AggregateCache", String.format(logMessage, dataCache.getID(), "was"));
            } else {
                ROLAPLog.log("ROLAPCubes.AggregateCache", String.format(logMessage, dataCache.getID(), "is being"));
            }
            throw new XQERuntimeException(XQEMessageKeys.ROL_InMemoryAggregatesDoNotNeedToBeLoaded, this.cube.getName());
        }
    }

    @Override
    protected void logAggregateLoadManagerTaskInfo() throws Exception {
        this.cube.getAggregateLoadInfoLogger().logInitialLoad(this.aggregateLoadManagerTaskInfo);
    }
}

