/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.aggregate;

import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.CrossJoinedSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.TupleValue;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPQueryExecuteMetrics;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPBaseCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.aggregate.AggregateCacheLoader;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.aggregate.IAggregateLoadListener;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.aggregate.ROLAPAggregateDefinition;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.BlockTupleStorageUtil;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.AggregateCalculationMetrics;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.AggregateCubeletSizeException;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.AggregateCubeletStorage;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.AggregateDefinition;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.AggregateDefinitionGraphSubscriber;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.AggregateUtilities;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.incremental.AggregateCalculationGraph;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.incremental.AggregateCalculationGraphSubscriber;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.incremental.AggregateCalculationStrategy;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.util.UniqueNameGenerator;
import java.sql.SQLException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class AggregateLoadTreeExecution {
    private static final int MAX_NUM_AGGREGATES_IN_TOSTRING = 4;
    private final List<IHierarchy> hierarchies;
    private final AggregateCubeletStorage aggregateCache;
    private final ROLAPBaseCube cube;
    private final AggregateCalculationGraph.AGNode startNode;
    private IAggregateLoadListener loadListener = null;

    public static Collection<AggregateLoadTreeExecution> createExecutionTrees(Collection<AggregateDefinition> newAggregrates, ROLAPBaseCube theCube, AggregateCubeletStorage cubeletStorage) {
        AggregateCalculationGraph acg = new AggregateCalculationGraph(theCube, true);
        ArrayList<AggregateDefinitionGraphSubscriber> aggregrateSubscribers = new ArrayList<AggregateDefinitionGraphSubscriber>();
        AggregateLoadTreeExecution.createSubscribers(theCube, cubeletStorage.getAvailableAggregateDefinitions(false), true, aggregrateSubscribers);
        AggregateLoadTreeExecution.createSubscribers(theCube, newAggregrates, false, aggregrateSubscribers);
        AggregateCalculationStrategy.buildCalculationGraph(aggregrateSubscribers, acg, "ROLAPCubes.AggregateCache", true);
        acg.optimize();
        if (ROLAPLog.isOn("ROLAPCubes.AggregateCache", LogLevel.TRACE)) {
            ROLAPLog.logTrace("ROLAPCubes.AggregateCache", "Aggregate load graph is " + acg);
        }
        for (AggregateCalculationGraph.AGNode node : acg) {
            node.setValues(null);
        }
        ArrayList<AggregateLoadTreeExecution> loadTrees = new ArrayList<AggregateLoadTreeExecution>();
        for (AggregateCalculationGraph.AGNode node : acg.getRootNode().getDependents()) {
            if (!AggregateLoadTreeExecution.hasUnpopulatedAggregates(node)) continue;
            loadTrees.add(new AggregateLoadTreeExecution(theCube, cubeletStorage, node));
        }
        return loadTrees;
    }

    private static boolean hasUnpopulatedAggregates(AggregateCalculationGraph.AGNode node) {
        for (AggregateCalculationGraphSubscriber subscriber : node.getSubscribers()) {
            if (((AggregateDefinitionGraphSubscriber)subscriber).isLoaded()) continue;
            return true;
        }
        for (AggregateCalculationGraph.AGNode dependent : node.getDependents()) {
            if (!AggregateLoadTreeExecution.hasUnpopulatedAggregates(dependent)) continue;
            return true;
        }
        return false;
    }

    private static void createSubscribers(ROLAPCube cube, Collection<AggregateDefinition> aggregateDefinitions, boolean loaded, List<AggregateDefinitionGraphSubscriber> aggregrateSubscribers) {
        for (AggregateDefinition aggDef : aggregateDefinitions) {
            AggregateDefinitionGraphSubscriber subscriber = new AggregateDefinitionGraphSubscriber(cube, loaded, aggDef);
            aggregrateSubscribers.add(subscriber);
        }
    }

    public AggregateLoadTreeExecution(ROLAPBaseCube theCube, AggregateCubeletStorage cubeletStorage, AggregateCalculationGraph.AGNode startingNode) {
        this.cube = theCube;
        this.hierarchies = this.cube.getHierarchies();
        this.aggregateCache = cubeletStorage;
        this.startNode = startingNode;
    }

    public void execute(IAggregateLoadListener listener) throws InterpreterException {
        this.loadListener = listener;
        this.traverseNode(this.startNode);
    }

    public String toString() {
        ArrayList<AggregateDefinitionGraphSubscriber> unpouplatedSubscribers = new ArrayList<AggregateDefinitionGraphSubscriber>();
        this.getAllUnpopulatedSubscribers(this.startNode, unpouplatedSubscribers);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < unpouplatedSubscribers.size(); ++i) {
            if (i >= 4) {
                sb.append("...");
                sb.append(unpouplatedSubscribers.size() - i);
                sb.append(" more.");
                break;
            }
            if (i > 0) {
                sb.append("->");
            }
            sb.append(UniqueNameGenerator.createUniqueName(((AggregateDefinitionGraphSubscriber)unpouplatedSubscribers.get(i)).getAggregateDefinition().getName()));
        }
        if (sb.length() == 0) {
            sb.append("No unpopulated aggregates");
        }
        return sb.toString();
    }

    private void traverseNode(AggregateCalculationGraph.AGNode node) {
        this.processNode(node);
        for (AggregateCalculationGraph.AGNode targetNode : node.getDependents()) {
            this.traverseNode(targetNode);
        }
    }

    private void processNode(AggregateCalculationGraph.AGNode node) {
        List<AggregateCalculationGraph.AGNode> targetNodesNeedingValues;
        boolean nodeCanSupplyValues = node.getSubscribers().size() > 0;
        IMember[][] aggregateMembers = null;
        for (AggregateCalculationGraphSubscriber subscriber : node.getSubscribers()) {
            AggregateDefinitionGraphSubscriber aggDefSubscriber = (AggregateDefinitionGraphSubscriber)subscriber;
            if (aggDefSubscriber.isLoaded()) continue;
            AggregateDefinition aggregateDefinition = aggDefSubscriber.getAggregateDefinition();
            if (ROLAPLog.isOn("ROLAPCubes.AggregateCache", LogLevel.TRACE)) {
                ROLAPLog.logTrace("ROLAPCubes.AggregateCache", "Populating aggregate " + aggregateDefinition.getName());
            }
            ROLAPQueryExecuteMetrics queryMetrics = null;
            boolean loadFromDB = true;
            try {
                long startLoadTime = System.currentTimeMillis();
                if (node.getValues() == null) {
                    queryMetrics = AggregateCacheLoader.loadSingleCacheSlice(this.cube, this.aggregateCache, aggregateDefinition);
                } else {
                    loadFromDB = false;
                    aggregateMembers = AggregateCacheLoader.getMembersForSlice(this.cube, aggregateDefinition);
                    CrossJoinedSet cjs = BlockTupleStorageUtil.createCjsFromMemberSelections(aggregateMembers, null, true);
                    this.aggregateCache.putTupleValues(cjs, node.getValues().iterator(), aggregateDefinition.getName());
                    int requestIncrementId = MultiRequestContext.getCurrentIncrementId(this.cube);
                    ((ROLAPAggregateDefinition)aggregateDefinition).setBaseIncrementId(requestIncrementId);
                    ((ROLAPAggregateDefinition)aggregateDefinition).setCellCount(node.getValues().size());
                    long cubeletSize = this.aggregateCache.getCubeletSize(aggregateDefinition.getName());
                    ROLAPLog.log("ROLAPCubes.AggregateCache", "Cube " + UniqueNameGenerator.createUniqueName(this.cube.getName()) + " successfully loaded internally created aggregate " + UniqueNameGenerator.createUniqueName(aggregateDefinition.getName()) + " with " + NumberFormat.getInstance().format(node.getValues().size()) + " cells using " + NumberFormat.getInstance().format(cubeletSize) + " bytes for increment " + requestIncrementId + ".");
                }
                if (this.loadListener == null) continue;
                this.loadListener.aggregateLoadSuccessful(aggregateDefinition, queryMetrics, System.currentTimeMillis() - startLoadTime);
            }
            catch (AggregateCubeletSizeException e) {
                this.notifyAggregateLoadError(aggregateDefinition, loadFromDB, e);
                nodeCanSupplyValues = false;
            }
            catch (InterpreterException e) {
                this.notifyAggregateLoadError(aggregateDefinition, loadFromDB, e);
                nodeCanSupplyValues = false;
            }
            catch (XQERuntimeException e) {
                if (XQERuntimeException.isACause(e, SQLException.class)) {
                    this.notifyAggregateLoadError(aggregateDefinition, loadFromDB, e);
                    nodeCanSupplyValues = false;
                    continue;
                }
                throw e;
            }
        }
        if (nodeCanSupplyValues && (targetNodesNeedingValues = this.getTargetNodesWithUnpopulatedSubscribers(node)).size() > 0) {
            try {
                if (node.getValues() == null && node.getValueIterators() == null) {
                    node.setValueIterators(this.fetchValueIteratorsFromNode(node, targetNodesNeedingValues, aggregateMembers));
                }
                AggregateCalculationStrategy.executeRollupForNode(node, 0, false, targetNodesNeedingValues, this.hierarchies, false, "ROLAPCubes.AggregateCache");
            }
            catch (InterpreterException e) {
                ROLAPLog.logError("ROLAPCubes.AggregateCache", "Error creating higher level aggregate values.  Aggregate will be loaded from DB.", e);
            }
        }
        node.setValues(null);
        node.setValueIterators(null);
    }

    private void notifyAggregateLoadError(AggregateDefinition aggregateDefinition, boolean loadFromDB, Exception e) {
        ROLAPLog.logError("ROLAPCubes.AggregateCache", "Error loading aggregate " + aggregateDefinition.getName(), e);
        if (this.loadListener != null) {
            this.loadListener.aggregateLoadFailed(aggregateDefinition, loadFromDB, e);
        }
    }

    private Iterator<TupleValue>[] fetchValueIteratorsFromNode(AggregateCalculationGraph.AGNode node, List<AggregateCalculationGraph.AGNode> targetNodesNeedingValues, IMember[][] aggregateMembers) throws InterpreterException {
        AggregateDefinition aggDef = ((AggregateDefinitionGraphSubscriber)node.getSubscribers().iterator().next()).getAggregateDefinition();
        if (aggregateMembers == null) {
            aggregateMembers = AggregateCacheLoader.getMembersForSlice(this.cube, aggDef);
        } else {
            IMember[][] newMembers = new IMember[aggregateMembers.length][];
            System.arraycopy(aggregateMembers, 0, newMembers, 0, aggregateMembers.length);
            aggregateMembers = newMembers;
        }
        HashSet<IMember> neededMeasures = new HashSet<IMember>();
        for (AggregateCalculationGraph.AGNode targetNode : targetNodesNeedingValues) {
            neededMeasures.addAll(targetNode.getSelfAndDepsAdditiveMeasures());
        }
        IMember[] neededMeasuresArray = neededMeasures.toArray(new IMember[neededMeasures.size()]);
        for (int i = 0; i < aggregateMembers.length; ++i) {
            if (!aggregateMembers[i][0].isMeasure()) continue;
            aggregateMembers[i] = neededMeasuresArray;
            break;
        }
        AggregateCalculationMetrics metrics = new AggregateCalculationMetrics();
        List<Iterator<TupleValue>> sourceTupleIters = AggregateUtilities.fetchAggregateValueIterators(this.aggregateCache, aggDef, aggregateMembers, metrics);
        return AggregateUtilities.wrapIteratorsForAggregateCache(sourceTupleIters);
    }

    private List<AggregateCalculationGraph.AGNode> getTargetNodesWithUnpopulatedSubscribers(AggregateCalculationGraph.AGNode node) {
        ArrayList<AggregateCalculationGraph.AGNode> nodes = new ArrayList<AggregateCalculationGraph.AGNode>();
        block0: for (AggregateCalculationGraph.AGNode targetNode : node.getDependents()) {
            for (AggregateCalculationGraphSubscriber subscriber : targetNode.getSubscribers()) {
                if (((AggregateDefinitionGraphSubscriber)subscriber).isLoaded()) continue;
                nodes.add(targetNode);
                continue block0;
            }
        }
        return nodes;
    }

    private void getAllUnpopulatedSubscribers(AggregateCalculationGraph.AGNode node, List<AggregateDefinitionGraphSubscriber> unpouplatedSubscribers) {
        for (AggregateCalculationGraphSubscriber subscriber : node.getSubscribers()) {
            if (((AggregateDefinitionGraphSubscriber)subscriber).isLoaded()) continue;
            unpouplatedSubscribers.add((AggregateDefinitionGraphSubscriber)subscriber);
        }
        for (AggregateCalculationGraph.AGNode dependent : node.getDependents()) {
            this.getAllUnpopulatedSubscribers(dependent, unpouplatedSubscribers);
        }
    }
}

