/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.model;

import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPAbstractHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPCalculatedMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPRelativeTimeMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaAggregateMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaObject;
import java.util.ArrayList;
import java.util.List;

public class ROLAPMetaAggregateSlice
extends ROLAPMetaObject {
    private ArrayList<ROLAPMetaAggregateMember> aggregateMembers = null;

    @Override
    public void captureContents() {
        super.captureContents();
        this.getAggregateMembers();
        this.clearDOMNode();
    }

    public ArrayList<ROLAPMetaAggregateMember> getAggregateMembers() {
        if (this.aggregateMembers == null) {
            this.aggregateMembers = new ArrayList();
            int ct = this.getChildCount();
            for (int i = 0; i < ct; ++i) {
                ROLAPMetaObject obj = this.getChild(i);
                if (!(obj instanceof ROLAPMetaAggregateMember)) continue;
                ROLAPMetaAggregateMember aggregateMember = (ROLAPMetaAggregateMember)obj;
                this.aggregateMembers.add(aggregateMember);
            }
        }
        return this.aggregateMembers;
    }

    public boolean containsMember(IMember member) {
        ILevel level = member.getLevel();
        for (ROLAPMetaAggregateMember aggregateMember : this.getAggregateMembers()) {
            IHierarchy hierarchy;
            IMember aggrMember = level.getMember(aggregateMember.getName());
            if (aggrMember != null && aggrMember.getUniqueName().equals(aggregateMember.getName()) && aggrMember.getUniqueName().equals(member.getUniqueName())) {
                return true;
            }
            if (aggrMember != null || !(hierarchy = member.getHierarchy()).getDimension().isTimeDimension()) continue;
            String cubeName = hierarchy.getDimension().getCube().getName();
            List<ROLAPCalculatedMember> calcMembers = ((ROLAPAbstractHierarchy)hierarchy).getROLAPCalculatedMembers(cubeName);
            for (IMember iMember : calcMembers) {
                if (!(iMember instanceof ROLAPRelativeTimeMember) || iMember.isExtendedCalculatedMemberWithFormula() || !iMember.getUniqueName().equals(aggregateMember.getName()) || level != iMember.getLevel() || !(aggrMember = ((ROLAPRelativeTimeMember)iMember).getReferenceMember()).getUniqueName().equals(member.getUniqueName())) continue;
                return true;
            }
        }
        return false;
    }
}

