/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.model;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPQuery;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaObject;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaQueryItem;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.util.RolapV5Builder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class ROLAPMetaAttribute
extends ROLAPMetaObject {
    private static final String UNDERSCORE = "_";
    private IDataType dataType = null;
    private final LinkedHashMap<String, String> localizedqueryItems = new LinkedHashMap();

    public String getQueryItem() {
        return this.getQueryItem(this.getDefaultLocale());
    }

    public int getQueryItemCount() {
        return this.localizedqueryItems.size();
    }

    public String getQueryItem(String locale) {
        if (this.localizedqueryItems.size() == 0) {
            String refObject = null;
            String qiLocale = null;
            ArrayList<ROLAPMetaObject> queryItems = new ArrayList<ROLAPMetaObject>();
            this.getFirstChildByType(ROLAPMetaQueryItem.class, queryItems);
            for (ROLAPMetaObject object : queryItems) {
                qiLocale = ((ROLAPMetaQueryItem)object).getLocale();
                if (qiLocale == null || qiLocale.length() == 0) {
                    qiLocale = this.getDefaultLocale();
                }
                refObject = ((ROLAPMetaQueryItem)object).getRefObject();
                this.localizedqueryItems.put(qiLocale, refObject);
            }
        }
        return this.localizedqueryItems.get(locale);
    }

    public Set<String> getLocales() {
        return this.localizedqueryItems.keySet();
    }

    public IDataType getDataType() {
        return this.dataType;
    }

    public void setDataType(IDataType theDataType) {
        this.dataType = theDataType;
    }

    @Override
    public void captureContents() {
        super.captureContents();
        this.collectNames();
        this.collectDescriptions();
        this.collectComplete();
        this.getQueryItem();
        this.clearDOMNode();
    }

    public int addAttributeAvoidingDuplicates(IROLAPQuery query, IROLAPQuery.QueryTarget target) {
        int index = -1;
        int count = 0;
        for (ROLAPMetaAttribute attribute : query.getAttributeSelections(target)) {
            if (this.equals(attribute)) {
                index = count;
                break;
            }
            count += attribute.getQueryItemCount();
        }
        if (index == -1) {
            query.addAttribute(this, target);
            index = count;
        }
        return index;
    }

    public void buildMemberQuerySelection(XQENodeFactory nodeFactory, IXQEQueryNode selection, IXQEQueryNode groupBody) {
        String dataItemName = null;
        Integer suffix = 1;
        String aggregateType = "none";
        for (Map.Entry<String, String> entry : this.localizedqueryItems.entrySet()) {
            String dataItemExpression = entry.getValue();
            if (dataItemName == null) {
                dataItemName = this.getName();
            } else {
                dataItemName = dataItemName + UNDERSCORE + suffix.toString();
                Integer n = suffix;
                Integer n2 = suffix = Integer.valueOf(suffix + 1);
            }
            RolapV5Builder.addDataItem(nodeFactory, selection, groupBody, dataItemName, dataItemExpression, aggregateType);
        }
    }

    public String getParentQualifiedQueryName() {
        String parentQualifiedName = this.getParent().getName() + UNDERSCORE + this.getName();
        return parentQualifiedName;
    }
}

