/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.model;

import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaCubeModel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaDefaultConvergenceLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaDefaultHierarchyRef;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaDirtyDataCompensation;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaMdSchema;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaObject;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaObjectKey;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaSecurityRules;
import com.cognos.xqe.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;

public class ROLAPMetaDimension
extends ROLAPMetaObject {
    private String type = null;
    private String localizationMethod = null;
    private ROLAPMetaDirtyDataCompensation dirtyDataCompensation = null;
    private ROLAPMetaLevel convergenceLevel = null;
    private String uuid = null;
    private static HashMap<Pair, String> tempUUIDMap;
    private static final int MAGIC3 = 3;

    public String getCategory() {
        ROLAPMetaCubeModel dimParent = (ROLAPMetaCubeModel)this.getParent();
        if (dimParent.isCommonCubeModel()) {
            return "public";
        }
        return "private";
    }

    public String getType() {
        if (this.type == null) {
            this.type = this.captureAttribute("type");
        }
        return this.type;
    }

    public String getDefaultHierarchyName() {
        String defaultHierarchyName = null;
        ArrayList<ROLAPMetaObject> children = this.getChildren();
        for (ROLAPMetaObject metaObj : children) {
            if (!(metaObj instanceof ROLAPMetaDefaultHierarchyRef)) continue;
            defaultHierarchyName = metaObj.getName();
            break;
        }
        return defaultHierarchyName;
    }

    public ROLAPMetaDirtyDataCompensation getDirtyDataCompensation() {
        if (this.dirtyDataCompensation == null) {
            this.dirtyDataCompensation = (ROLAPMetaDirtyDataCompensation)this.getFirstChildByType(ROLAPMetaDirtyDataCompensation.class);
        }
        return this.dirtyDataCompensation;
    }

    public void collectUUID() {
        if (this.getNode() != null) {
            this.uuid = this.captureAttribute("uuid");
        }
    }

    public String getLocalizationMethod() {
        if (this.localizationMethod == null && this.getNode() != null) {
            this.localizationMethod = this.captureAttribute("localizationMethod");
        }
        return this.localizationMethod;
    }

    public ROLAPMetaLevel getConvergenceLevel() {
        ROLAPMetaDefaultConvergenceLevel metaConvergenceLevel;
        if (this.convergenceLevel == null && (metaConvergenceLevel = (ROLAPMetaDefaultConvergenceLevel)this.getFirstChildByType(ROLAPMetaDefaultConvergenceLevel.class)) != null) {
            String name = metaConvergenceLevel.getName();
            ROLAPMetaMdSchema mdSchema = this.getMdSchema();
            ROLAPMetaCubeModel cubeModel = this.getMetaCubeModel();
            ROLAPMetaObjectKey objectKey = ROLAPMetaObject.createMetaObjectKey(cubeModel.getName(), this.getClass(), this.getName(), ROLAPMetaLevel.class, name);
            this.convergenceLevel = (ROLAPMetaLevel)mdSchema.get(objectKey);
        }
        return this.convergenceLevel;
    }

    @Override
    public void captureContents() {
        super.captureContents();
        this.collectNames();
        this.collectDescriptions();
        this.collectComplete();
        this.getType();
        this.getLocalizationMethod();
        this.collectUUID();
        this.clearDOMNode();
    }

    public boolean isTimeDimension() {
        boolean bTime = false;
        if (this.getType().equalsIgnoreCase("time")) {
            bTime = true;
        }
        return bTime;
    }

    public ROLAPMetaSecurityRules getSecurityRules() {
        return (ROLAPMetaSecurityRules)this.getChild("ROLAPMetaSecurityRules");
    }

    public String getSharedDimensionUUID(ROLAPCube cube) {
        if (this.uuid != null) {
            return this.uuid;
        }
        if (tempUUIDMap == null) {
            return null;
        }
        Pair pair = new Pair(cube.getName(), this.getName());
        return tempUUIDMap.get(pair);
    }

    public static void parseSharableDimUUIDs() {
        tempUUIDMap = new HashMap();
        String value = System.getProperty("shareableDimensions");
        if (value != null) {
            String[] uuidDefs;
            for (String uuidDef : uuidDefs = value.split("\\|")) {
                String[] cubes;
                String[] def = uuidDef.split("Cubes:|Dim:|UUID:");
                for (String cube : cubes = def[1].split(",")) {
                    String cubeName = cube.trim();
                    String dimensionName = def[2].trim();
                    String uuid = def[3];
                    Pair pair = new Pair(cubeName, dimensionName);
                    tempUUIDMap.put(pair, uuid);
                }
            }
        }
    }

    public static void clearTempUUIDMap() {
        tempUUIDMap = null;
    }
}

