/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.model;

import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaAllLevelName;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaAllMemberCaption;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaDefaultMemberRef;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaLevelRef;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaMdSchema;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaObject;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaObjectKey;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaSecurityRules;
import com.cognos.xqe.util.AbstractSingleLocaleString;
import com.cognos.xqe.util.ILocalizedString;
import com.cognos.xqe.util.LocaleUtility;
import java.util.ArrayList;
import java.util.List;

public class ROLAPMetaHierarchy
extends ROLAPMetaObject {
    private static final String ALL_MEMBER_NAME_ATTR = "allMemberName";
    private static final String TYPE = "type";
    private static final String STRING_NO = "no";
    public static final String ALL_MEMBER_TEXT = "All";
    private static final String MEMBER_CAPTION_TYPE_DEFAULT = "parent";
    private static final String STRING_YES = "yes";
    private String dimensionCategory = null;
    private String dimensionName = null;
    private String deployment = null;
    private String showMembers = null;
    private boolean capturedShowMembers = false;
    private String type = null;
    private String hasRelativeTimeMembers = null;
    private boolean capturedHasRelativeTimeMembers = false;
    private String showRelativeTimePriorPeriodMembers = null;
    private boolean capturedShowRelativeTimePriorPeriodMembers = false;
    private String showRelativeTimeNextPeriodMembers = null;
    private boolean capturedShowRelativeTimeNextPeriodMembers = false;
    private String showRelativeTimeSubtreeMembers = null;
    private boolean capturedShowRelativeTimeSubtreeMembers = false;
    private String hasAllLevel = null;
    private boolean capturedHasAllLevel = false;
    private List<ROLAPMetaLevel> levels = null;
    private String captionType = null;
    private boolean capturedCaptionType = false;
    private ILocalizedString allMemberCaptionCache = null;
    private String allMemberName = null;
    private ILocalizedString allLevelNameCache = null;

    public ILocalizedString getAllLevelNames() {
        return this.allLevelNameCache;
    }

    public ILocalizedString getAllMemberCaptions() {
        if (this.allMemberCaptionCache == null) {
            return AbstractSingleLocaleString.getSingleLocaleString(this.getDefaultLocale(), this.allMemberName);
        }
        return this.allMemberCaptionCache;
    }

    public String getDefaultMemberName() {
        ROLAPMetaDefaultMemberRef dmr;
        String htype = this.getType();
        if (!htype.equals("Measures") && (dmr = (ROLAPMetaDefaultMemberRef)this.getFirstChildByType(ROLAPMetaDefaultMemberRef.class)) != null) {
            return dmr.getDefaultMemberName();
        }
        return null;
    }

    public String getDeployment() {
        if (this.deployment == null) {
            this.deployment = this.captureAttribute("deployment");
        }
        return this.deployment;
    }

    public ROLAPMetaDimension getDimension(ROLAPMetaCube metaCube) {
        String dimName = this.getDimensionName();
        if (dimName == null) {
            dimName = this.getName();
        }
        ROLAPMetaMdSchema mdSchema = this.getMdSchema();
        ROLAPMetaObject parent = null;
        parent = "public".equals(this.getDimensionCategory().toLowerCase()) ? mdSchema.getCommonCubeModel() : metaCube.getParent();
        ROLAPMetaObjectKey objectKey = ROLAPMetaObject.createMetaObjectKey(parent.getName(), parent.getClass(), parent.getName(), ROLAPMetaDimension.class, dimName);
        ROLAPMetaDimension dim = (ROLAPMetaDimension)mdSchema.get(objectKey);
        return dim;
    }

    public String getDimensionCategory() {
        return this.dimensionCategory;
    }

    public String getDimensionName() {
        return this.dimensionName;
    }

    public String getHasAllLevel() {
        if (!this.capturedHasAllLevel) {
            this.hasAllLevel = this.captureAttribute("hasAllLevel");
            this.capturedHasAllLevel = true;
        }
        return this.hasAllLevel;
    }

    public String getHierarchyType() {
        if (this.type == null) {
            this.type = this.captureAttribute(TYPE);
        }
        return this.type;
    }

    public ROLAPMetaLevel getLevel(String name) {
        ROLAPMetaLevel[] levs = this.getLevels();
        for (int i = 0; i < levs.length; ++i) {
            ROLAPMetaLevel lev = levs[i];
            if (!lev.getName().equals(name)) continue;
            return lev;
        }
        return null;
    }

    public ROLAPMetaLevel[] getLevels() {
        if (this.levels == null) {
            this.levels = new ArrayList<ROLAPMetaLevel>();
            int ct = this.getChildCount();
            for (int i = 0; i < ct; ++i) {
                ROLAPMetaObject obj = this.getChild(i);
                if (obj instanceof ROLAPMetaLevelRef) {
                    ROLAPMetaLevel lev = ((ROLAPMetaLevelRef)obj).getLevel(this.getParent());
                    if (lev == null) {
                        throw new XQERuntimeException(XQEMessageKeys.ROL_CannotFindLevel, (Object)obj.getName(), (Object)this.getName(), (Object)this.getParent().getName());
                    }
                    this.levels.add(lev);
                    continue;
                }
                if (!(obj instanceof ROLAPMetaLevel)) continue;
                this.levels.add((ROLAPMetaLevel)obj);
            }
        }
        return this.levels.toArray(new ROLAPMetaLevel[0]);
    }

    private String getShowMembers() {
        if (!this.capturedShowMembers) {
            this.showMembers = this.captureAttribute("showMembers");
            this.capturedShowMembers = true;
        }
        return this.showMembers;
    }

    public String getType() {
        if (this.type == null) {
            this.type = this.captureAttribute(TYPE);
        }
        return this.type;
    }

    public boolean hasAllLevel() {
        String bHasAllLevel = this.getHasAllLevel();
        boolean result = false;
        if (bHasAllLevel != null && bHasAllLevel.equalsIgnoreCase("Yes")) {
            result = true;
        }
        return result;
    }

    public String getHasRelativeTimeMembers() {
        if (!this.capturedHasRelativeTimeMembers) {
            this.hasRelativeTimeMembers = this.captureAttribute("hasRelativeTimeMembers");
            this.capturedHasRelativeTimeMembers = true;
        }
        return this.hasRelativeTimeMembers;
    }

    public boolean hasRelativeTimeMembers() {
        String hasRelativeTimeMembersAttribute = this.getHasRelativeTimeMembers();
        return hasRelativeTimeMembersAttribute != null && hasRelativeTimeMembersAttribute.equalsIgnoreCase("True");
    }

    public String getShowRelativeTimePriorPeriodMembers() {
        if (!this.capturedShowRelativeTimePriorPeriodMembers) {
            this.showRelativeTimePriorPeriodMembers = this.captureAttribute("showRelativeTimePriorPeriodMembers");
        }
        this.capturedShowRelativeTimePriorPeriodMembers = true;
        return this.showRelativeTimePriorPeriodMembers;
    }

    public boolean shouldShowRelativeTimePriorPeriodMembers() {
        if (this.capturedShowRelativeTimePriorPeriodMembers && this.showRelativeTimePriorPeriodMembers == null) {
            return true;
        }
        if (this.showRelativeTimePriorPeriodMembers != null && !this.showRelativeTimePriorPeriodMembers.equalsIgnoreCase(STRING_YES)) {
            return false;
        }
        if (this.showRelativeTimePriorPeriodMembers != null && this.showRelativeTimePriorPeriodMembers.equalsIgnoreCase(STRING_YES)) {
            return true;
        }
        String shouldShowRelativeTimePriorPeriodMembers = this.getShowRelativeTimePriorPeriodMembers();
        return shouldShowRelativeTimePriorPeriodMembers != null && shouldShowRelativeTimePriorPeriodMembers.equalsIgnoreCase(STRING_YES);
    }

    public String getShowRelativeTimeNextPeriodMembers() {
        if (!this.capturedShowRelativeTimeNextPeriodMembers) {
            this.showRelativeTimeNextPeriodMembers = this.captureAttribute("showRelativeTimeNextPeriodMembers");
        }
        this.capturedShowRelativeTimeNextPeriodMembers = true;
        return this.showRelativeTimeNextPeriodMembers;
    }

    public boolean shouldShowRelativeTimeNextPeriodMembers() {
        if (this.capturedShowRelativeTimeSubtreeMembers && this.showRelativeTimeNextPeriodMembers == null) {
            return false;
        }
        if (this.capturedShowRelativeTimeNextPeriodMembers && !this.showRelativeTimeNextPeriodMembers.equalsIgnoreCase(STRING_YES)) {
            return false;
        }
        if (this.capturedShowRelativeTimeNextPeriodMembers && this.showRelativeTimeNextPeriodMembers.equalsIgnoreCase(STRING_YES)) {
            return true;
        }
        String shouldShowRelativeTimeNextPeriodMembers = this.getShowRelativeTimeNextPeriodMembers();
        return shouldShowRelativeTimeNextPeriodMembers != null && shouldShowRelativeTimeNextPeriodMembers.equalsIgnoreCase(STRING_YES);
    }

    public String getShowRelativeTimeSubtreeMembers() {
        if (!this.capturedShowRelativeTimeSubtreeMembers) {
            this.showRelativeTimeSubtreeMembers = this.captureAttribute("showRelativeTimeSubtreeMembers");
        }
        this.capturedShowRelativeTimeSubtreeMembers = true;
        return this.showRelativeTimeSubtreeMembers;
    }

    public boolean shouldShowRelativeTimeSubtreeMembers() {
        if (this.capturedShowRelativeTimeSubtreeMembers && this.showRelativeTimeSubtreeMembers == null) {
            return true;
        }
        if (this.showRelativeTimeSubtreeMembers != null && !this.showRelativeTimeSubtreeMembers.equalsIgnoreCase(STRING_YES)) {
            return false;
        }
        if (this.showRelativeTimeSubtreeMembers != null && this.showRelativeTimeSubtreeMembers.equalsIgnoreCase(STRING_YES)) {
            return true;
        }
        String shouldShowRelativeTimeSubtreeMembers = this.getShowRelativeTimeSubtreeMembers();
        return shouldShowRelativeTimeSubtreeMembers != null && shouldShowRelativeTimeSubtreeMembers.equalsIgnoreCase(STRING_YES);
    }

    public boolean isBalancedType() {
        return this.getType().equalsIgnoreCase("balanced");
    }

    public boolean isDataMemberHidden() {
        return this.getShowMembers() != null && this.getShowMembers().equalsIgnoreCase(STRING_NO) && this.isRecursive();
    }

    public boolean isRemoveExtraneousPaddingMembers() {
        return this.getShowMembers() != null && this.getShowMembers().equalsIgnoreCase(STRING_NO) && !this.isRecursive();
    }

    public boolean isRaggedType() {
        return false;
    }

    public boolean isRecursive() {
        return this.getDeployment().equalsIgnoreCase("recursive");
    }

    public boolean isUnbalancedType() {
        return this.isRecursive();
    }

    public void setDimensionCategory(String dimCategory) {
        this.dimensionCategory = dimCategory;
    }

    public void setDimensionName(String dimName) {
        this.dimensionName = dimName;
    }

    @Override
    public void captureContents() {
        super.captureContents();
        this.collectNames();
        this.collectDescriptions();
        this.collectAllMemberCaption();
        this.collectAllLevelName();
        this.collectComplete();
        this.getDimensionName();
        this.getDimensionCategory();
        this.getDeployment();
        this.getShowMembers();
        this.getHierarchyType();
        this.getCaptionTypeAttribute();
        this.isRecursive();
        this.isRaggedType();
        this.isUnbalancedType();
        this.isBalancedType();
        this.hasAllLevel();
        this.hasRelativeTimeMembers();
        this.shouldShowRelativeTimePriorPeriodMembers();
        this.shouldShowRelativeTimeNextPeriodMembers();
        this.shouldShowRelativeTimeSubtreeMembers();
        this.clearDOMNode();
    }

    public ROLAPMetaSecurityRules getSecurityRules() {
        return (ROLAPMetaSecurityRules)this.getChild("ROLAPMetaSecurityRules");
    }

    public String getCaptionTypeAttribute() {
        if (!this.capturedCaptionType) {
            this.captionType = this.captureAttribute("fillerDataMemberCaptionType");
            if (this.captionType == null) {
                this.captionType = MEMBER_CAPTION_TYPE_DEFAULT;
            }
            this.capturedCaptionType = true;
        }
        return this.captionType;
    }

    public IROLAPHierarchy.FillerCaptionType getCaptionType() {
        IROLAPHierarchy.FillerCaptionType ctype = IROLAPHierarchy.FillerCaptionType.PARENT_CAPTION;
        if (this.getCaptionTypeAttribute().equalsIgnoreCase(MEMBER_CAPTION_TYPE_DEFAULT)) {
            ctype = IROLAPHierarchy.FillerCaptionType.PARENT_CAPTION;
        } else if (this.getCaptionTypeAttribute().equalsIgnoreCase("blank")) {
            ctype = IROLAPHierarchy.FillerCaptionType.BLANK_CAPTION;
        } else if (this.getCaptionTypeAttribute().equalsIgnoreCase("custom")) {
            ctype = IROLAPHierarchy.FillerCaptionType.PARENT_CAPTION;
        }
        return ctype;
    }

    protected void collectAllMemberCaption() {
        ROLAPMetaAllMemberCaption allMemberCaption;
        if (this.allMemberCaptionCache != null) {
            return;
        }
        ArrayList<ROLAPMetaObject> names = new ArrayList<ROLAPMetaObject>();
        this.getFirstChildByType(ROLAPMetaAllMemberCaption.class, names);
        for (ROLAPMetaObject object : names) {
            allMemberCaption = (ROLAPMetaAllMemberCaption)object;
            if (!this.getDefaultLocale().equalsIgnoreCase(allMemberCaption.getLocale())) continue;
            this.allMemberCaptionCache = this.generateLocalizedString(names.size(), allMemberCaption.getLocale(), allMemberCaption.getAllMemberCaption());
            names.remove(allMemberCaption);
            break;
        }
        for (ROLAPMetaObject object : names) {
            allMemberCaption = (ROLAPMetaAllMemberCaption)object;
            if (this.allMemberCaptionCache == null) {
                this.allMemberCaptionCache = this.generateLocalizedString(names.size(), allMemberCaption.getLocale(), allMemberCaption.getAllMemberCaption());
                continue;
            }
            this.allMemberCaptionCache.put(allMemberCaption.getLocale(), allMemberCaption.getAllMemberCaption());
        }
        this.allMemberName = this.captureAttribute(ALL_MEMBER_NAME_ATTR);
        if (this.allMemberName == null && this.hasAllLevel()) {
            this.allMemberName = ALL_MEMBER_TEXT;
        }
    }

    protected void collectAllLevelName() {
        ROLAPMetaAllLevelName allLevelName;
        if (this.allLevelNameCache != null) {
            return;
        }
        ArrayList<ROLAPMetaObject> names = new ArrayList<ROLAPMetaObject>();
        this.getFirstChildByType(ROLAPMetaAllLevelName.class, names);
        for (ROLAPMetaObject object : names) {
            allLevelName = (ROLAPMetaAllLevelName)object;
            if (!this.getDefaultLocale().equalsIgnoreCase(allLevelName.getLocale())) continue;
            this.allLevelNameCache = this.generateLocalizedString(names.size(), allLevelName.getLocale(), allLevelName.getAllLevelName());
            names.remove(allLevelName);
            break;
        }
        for (ROLAPMetaObject object : names) {
            allLevelName = (ROLAPMetaAllLevelName)object;
            if (this.allLevelNameCache == null) {
                this.allLevelNameCache = this.generateLocalizedString(names.size(), allLevelName.getLocale(), allLevelName.getAllLevelName());
                continue;
            }
            this.allLevelNameCache.put(allLevelName.getLocale(), allLevelName.getAllLevelName());
        }
    }

    public String getAllMemberName() {
        if (this.allMemberName == null) {
            this.allMemberName = this.captureAttribute(ALL_MEMBER_NAME_ATTR);
            if (this.allMemberName == null && this.hasAllLevel()) {
                this.allMemberName = ALL_MEMBER_TEXT;
            }
        }
        return this.allMemberName;
    }

    public String getAllLevelName(String locale) {
        if (this.allLevelNameCache == null) {
            return null;
        }
        locale = LocaleUtility.getSupportedLocale(locale, this.allLevelNameCache, this.getDefaultLocale());
        return this.allLevelNameCache.toString(locale);
    }
}

