/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.security;

import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IProperty;
import com.cognos.xqe.metadata.MemberTypeEnum;
import com.cognos.xqe.runtree.olap.mdx.metadata.Level;
import com.cognos.xqe.runtree.olap.mdx.metadata.NullMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.security.SecManager;
import java.util.HashSet;

public class SecViewHierarchyRestriction {
    private HashSet<IMember> grantedSelves;
    private HashSet<IMember> grantedAncestors;
    private HashSet<IMember> deniedSelves;
    private HashSet<IMember> deniedAncestors;
    private HashSet<IMember> visibleAncestors;
    private HashSet<IProperty> deniedAttributes;
    private HashSet<IProperty> grantedAttributes;
    private boolean isAllAccess;
    private boolean isAllMemberGrantedAncestor;
    private boolean isAllMemberDeniedAncestor;
    private GrantType grantType;
    private boolean isAllDenied;

    public SecViewHierarchyRestriction(HashSet<IMember> pGrantedSelves, HashSet<IMember> pGrantedAncestors, HashSet<IMember> pDeniedSelves, HashSet<IMember> pDeniedAncestors, boolean pIsAllDenied, GrantType pGrantType) {
        this.grantType = pGrantType;
        this.isAllDenied = pIsAllDenied;
        this.grantedSelves = pGrantedSelves;
        this.grantedAncestors = pGrantedAncestors;
        this.deniedSelves = pDeniedSelves;
        this.deniedAncestors = pDeniedAncestors;
        this.visibleAncestors = new HashSet();
        this.deniedAttributes = SecManager.EMPTY_ATTRIBUTES_SET;
        this.grantedAttributes = SecManager.EMPTY_ATTRIBUTES_SET;
        SecViewHierarchyRestriction.removeDescendants(this.grantedAncestors, this.deniedAncestors, true);
        SecViewHierarchyRestriction.removeDescendants(this.grantedAncestors, this.grantedAncestors, false);
        SecViewHierarchyRestriction.removeDescendants(this.grantedSelves, this.deniedAncestors, true);
        SecViewHierarchyRestriction.removeDescendants(this.grantedSelves, this.grantedAncestors, true);
        this.grantedSelves.removeAll(this.deniedSelves);
        SecViewHierarchyRestriction.populateVisibleAncestors(this.visibleAncestors, this.grantedSelves, this.grantedAncestors);
        this.isAllMemberGrantedAncestor = this.containsAllMember(this.grantedAncestors);
        this.isAllMemberDeniedAncestor = this.containsAllMember(this.deniedAncestors);
        this.isAllAccess = !this.isAllDenied && this.grantedSelves.size() == 0 && this.grantedAncestors.size() == 0 && this.grantType != GrantType.EXPR && this.deniedSelves.size() == 0 && this.deniedAncestors.size() == 0;
    }

    public SecViewHierarchyRestriction(HashSet<IProperty> pGrantedProperties, HashSet<IProperty> pDeniedProperties, boolean pIsAllDenied, GrantType pGrantType) {
        this.grantType = pGrantType;
        this.isAllDenied = pIsAllDenied;
        this.grantedSelves = SecManager.EMPTY_SET;
        this.grantedAncestors = SecManager.EMPTY_SET;
        this.deniedSelves = SecManager.EMPTY_SET;
        this.deniedAncestors = SecManager.EMPTY_SET;
        this.visibleAncestors = SecManager.EMPTY_SET;
        this.deniedAttributes = pDeniedProperties;
        this.grantedAttributes = pGrantedProperties;
        this.isAllAccess = !this.isAllDenied && this.grantedSelves.size() == 0 && this.grantedAncestors.size() == 0 && this.grantType != GrantType.EXPR && this.deniedSelves.size() == 0 && this.deniedAncestors.size() == 0;
    }

    public static void removeDescendants(HashSet<IMember> members, HashSet<IMember> ancestors, boolean includeSelf) {
        HashSet<IMember> descendants = new HashSet<IMember>();
        for (IMember member : members) {
            if (!SecViewHierarchyRestriction.isDescendant(member, ancestors, includeSelf)) continue;
            descendants.add(member);
        }
        members.removeAll(descendants);
    }

    private static boolean isDescendant(IMember member, HashSet<IMember> ancestors, boolean includeSelf) {
        if (member == null) {
            return false;
        }
        if (includeSelf && ancestors.contains(member)) {
            return true;
        }
        return SecViewHierarchyRestriction.isDescendant(member.getParent(), ancestors, includeSelf);
    }

    public static void populateVisibleAncestors(HashSet<IMember> pVisibleAncestors, HashSet<IMember> pGrantedMembers, HashSet<IMember> pGrantedAncestors) {
        for (IMember member : pGrantedMembers) {
            SecViewHierarchyRestriction.populateVisibleAncestors(pVisibleAncestors, pGrantedMembers, pGrantedAncestors, member.getParent());
        }
        for (IMember member : pGrantedAncestors) {
            SecViewHierarchyRestriction.populateVisibleAncestors(pVisibleAncestors, pGrantedMembers, pGrantedAncestors, member.getParent());
        }
    }

    private static void populateVisibleAncestors(HashSet<IMember> pVisibleAncestors, HashSet<IMember> pGrantedMembers, HashSet<IMember> pGrantedAncestors, IMember member) {
        if (member == null || pGrantedMembers.contains(member) || pGrantedAncestors.contains(member)) {
            return;
        }
        boolean memberNotInSet = pVisibleAncestors.add(member);
        if (memberNotInSet) {
            SecViewHierarchyRestriction.populateVisibleAncestors(pVisibleAncestors, pGrantedMembers, pGrantedAncestors, member.getParent());
        }
    }

    private boolean containsAllMember(HashSet<IMember> securedMemberList) {
        for (IMember member : securedMemberList) {
            if (!((Level)member.getLevel()).isAllLevel()) continue;
            return true;
        }
        return false;
    }

    public HashSet<IProperty> getDeniedAttributes() {
        return this.deniedAttributes;
    }

    public HashSet<IProperty> getGrantedAttributes() {
        return this.grantedAttributes;
    }

    public boolean hasDeniedMembers() {
        return this.deniedSelves.size() > 0 || this.deniedAncestors.size() > 0;
    }

    public boolean hasDeniedAttributes() {
        return this.deniedAttributes.size() > 0;
    }

    public boolean hasVisibleAncestors() {
        return this.visibleAncestors.size() > 0;
    }

    public HashSet<IMember> getGrantedSelves() {
        return this.grantedSelves;
    }

    public HashSet<IMember> getGrantedAncestors() {
        return this.grantedAncestors;
    }

    public HashSet<IMember> getDeniedSelves() {
        return this.deniedSelves;
    }

    public HashSet<IMember> getDeniedAncestors() {
        return this.deniedAncestors;
    }

    public HashSet<IMember> getVisibleAncestors() {
        return this.visibleAncestors;
    }

    public boolean isAllAccess() {
        return this.isAllAccess;
    }

    public boolean isAllDenied() {
        return this.isAllDenied;
    }

    public GrantType getGrantType() {
        return this.grantType;
    }

    protected boolean isVisibleAncestor(IMember member) {
        return this.visibleAncestors.contains(member);
    }

    protected boolean isDeniedMember(IMember member) {
        return this.isDeniedMember(member, null);
    }

    protected boolean isDeniedMember(IMember member, SecManager.MostRecentlyCheckedAncestors mrcAncestors) {
        if (member == null) {
            return false;
        }
        if (this.isAllMemberDeniedAncestor) {
            return true;
        }
        if (this.deniedSelves.contains(member) || this.deniedAncestors.contains(member)) {
            return true;
        }
        IMember parent = member.getParent();
        if (parent == null) {
            return false;
        }
        if (mrcAncestors != null) {
            mrcAncestors.initAncestorCheckResult(parent, this);
        }
        int ancestorIdx = 0;
        while (parent != null) {
            if (mrcAncestors != null) {
                Boolean ancCheckResult = mrcAncestors.getAncestorCheckResult(parent, ancestorIdx);
                if (ancCheckResult != null) {
                    return ancCheckResult;
                }
                mrcAncestors.setCheckedAncestor(ancestorIdx, parent);
            }
            if (this.deniedAncestors.contains(parent)) {
                if (mrcAncestors != null) {
                    mrcAncestors.setCheckedAncestorResult(ancestorIdx, true);
                }
                return true;
            }
            parent = parent.getParent();
            ++ancestorIdx;
        }
        if (mrcAncestors != null) {
            mrcAncestors.setCheckedAncestorResult(ancestorIdx, false);
        }
        return false;
    }

    protected boolean isDeniedAttribute(IProperty property) {
        return this.deniedAttributes.contains(property);
    }

    protected boolean isDeniedAttribute(String propertyName) {
        boolean isDenied = false;
        for (IProperty attribute : this.deniedAttributes) {
            if (!attribute.getName().contains(propertyName)) continue;
            isDenied = true;
            break;
        }
        return isDenied;
    }

    protected boolean isGrantedMember(IMember member) {
        return this.isGrantedMember(member, null);
    }

    protected boolean isGrantedMember(IMember member, SecManager.MostRecentlyCheckedAncestors mrcAncestors) {
        if (member == null) {
            return false;
        }
        if (this.isAllMemberGrantedAncestor) {
            return true;
        }
        if (this.grantedSelves.contains(member) || this.grantedAncestors.contains(member)) {
            return true;
        }
        IMember parent = member.getParent();
        if (parent == null) {
            return false;
        }
        if (mrcAncestors != null) {
            mrcAncestors.initAncestorCheckResult(parent, this);
        }
        int ancestorIdx = 0;
        while (parent != null) {
            if (mrcAncestors != null) {
                Boolean ancCheckResult = mrcAncestors.getAncestorCheckResult(parent, ancestorIdx);
                if (ancCheckResult != null) {
                    return ancCheckResult;
                }
                mrcAncestors.setCheckedAncestor(ancestorIdx, parent);
            }
            if (this.grantedAncestors.contains(parent)) {
                if (mrcAncestors != null) {
                    mrcAncestors.setCheckedAncestorResult(ancestorIdx, true);
                }
                return true;
            }
            parent = parent.getParent();
            ++ancestorIdx;
        }
        if (mrcAncestors != null) {
            mrcAncestors.setCheckedAncestorResult(ancestorIdx, false);
        }
        return false;
    }

    protected boolean isGrantedAttribute(IProperty property) {
        return this.grantedAttributes.contains(property);
    }

    protected boolean isGrantedAttribute(String propertyName) {
        boolean isGranted = false;
        for (IProperty attribute : this.grantedAttributes) {
            if (!attribute.getName().contains(propertyName)) continue;
            isGranted = true;
            break;
        }
        return isGranted;
    }

    protected boolean isRestricted(IMember member) {
        if (member instanceof NullMember) {
            return false;
        }
        if (this.isAllDenied) {
            return true;
        }
        if (this.isAllAccess) {
            return false;
        }
        while (member.getType() == MemberTypeEnum.QUERY_CALCULATION || member.getType() == MemberTypeEnum.SESSION_CALCULATION) {
            IMember parent = member.getParent();
            if (parent == null) {
                return false;
            }
            member = parent;
        }
        if (this.isDeniedMember(member)) {
            return true;
        }
        if (this.grantType == GrantType.EXPR) {
            return !this.isGrantedMember(member);
        }
        return false;
    }

    protected void setAllDenied() {
        this.isAllDenied = true;
        this.isAllAccess = false;
        this.clearMemberLists();
    }

    protected void clearMemberLists() {
        if (this.grantedSelves != null) {
            this.grantedSelves.clear();
        }
        if (this.grantedAncestors != null) {
            this.grantedAncestors.clear();
        }
        if (this.deniedSelves != null) {
            this.deniedSelves.clear();
        }
        if (this.deniedAncestors != null) {
            this.deniedAncestors.clear();
        }
        if (this.visibleAncestors != null) {
            this.visibleAncestors.clear();
        }
    }

    public HashSet<IMember> getDeniedMembers() {
        HashSet<IMember> set = new HashSet<IMember>();
        set.addAll(this.getDeniedSelves());
        set.addAll(this.getDeniedAncestors());
        return set;
    }

    public HashSet<IMember> getGrantedMembers() {
        return this.getGrantedSelves();
    }

    public static enum GrantType {
        ALL,
        EXPR,
        NONE;

    }
}

