/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.security;

import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.security.SecManager;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.security.SecViewHierarchyLookupTableRestriction;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.security.SecViewHierarchyRestriction;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class SecViewRestriction {
    private HashMap<IHierarchy, SecViewHierarchyRestriction> hierarchyMembersRestrictionMap;
    private HashMap<IHierarchy, SecViewHierarchyRestriction> hierarchyValuesRestrictionMap;
    private HashMap<IHierarchy, SecViewHierarchyLookupTableRestriction> hierarchyLookupTableRestrictionMap;
    private HashMap<IHierarchy, SecViewHierarchyRestriction> hierarchyAttributesRestrictionMap;
    private Set<IDimension> grantedDimensions = new HashSet<IDimension>();
    private Set<IDimension> deniedDimensions = new HashSet<IDimension>();
    private String viewName;
    private Set<IHierarchy> securedHierarchies = new HashSet<IHierarchy>();
    private Set<IHierarchy> visibleAncestorHierarchies = new HashSet<IHierarchy>();

    public SecViewRestriction(String name) {
        this.viewName = name;
    }

    public String getName() {
        return this.viewName;
    }

    public boolean isUnsecured() {
        return this.securedHierarchies.isEmpty();
    }

    public void addRestriction(IHierarchy hierarchy, SecViewHierarchyRestriction restriction, SecManager.SecurityType securityType) {
        HashMap<IHierarchy, SecViewHierarchyRestriction> theMap = null;
        if (SecManager.SecurityType.member == securityType) {
            if (this.hierarchyMembersRestrictionMap == null) {
                this.hierarchyMembersRestrictionMap = new HashMap();
            }
            theMap = this.hierarchyMembersRestrictionMap;
            if (!restriction.getVisibleAncestors().isEmpty()) {
                this.visibleAncestorHierarchies.add(hierarchy);
            }
        } else if (SecManager.SecurityType.value == securityType) {
            if (this.hierarchyValuesRestrictionMap == null) {
                this.hierarchyValuesRestrictionMap = new HashMap();
            }
            theMap = this.hierarchyValuesRestrictionMap;
        } else if (SecManager.SecurityType.attribute == securityType) {
            if (this.hierarchyAttributesRestrictionMap == null) {
                this.hierarchyAttributesRestrictionMap = new HashMap();
            }
            theMap = this.hierarchyAttributesRestrictionMap;
        }
        theMap.put(hierarchy, restriction);
        this.securedHierarchies.add(hierarchy);
    }

    public void addRestriction(IHierarchy hierarchy, SecViewHierarchyLookupTableRestriction restriction) {
        if (this.hierarchyLookupTableRestrictionMap == null) {
            this.hierarchyLookupTableRestrictionMap = new HashMap();
        }
        this.hierarchyLookupTableRestrictionMap.put(hierarchy, restriction);
    }

    public Set<IHierarchy> getSecuredHierarchies() {
        return this.securedHierarchies;
    }

    public SecViewHierarchyRestriction getRestriction(IHierarchy hierarchy, SecManager.SecurityType securityType) {
        HashMap<IHierarchy, SecViewHierarchyRestriction> theMap = null;
        if (SecManager.SecurityType.member == securityType) {
            theMap = this.hierarchyMembersRestrictionMap;
        } else if (SecManager.SecurityType.value == securityType) {
            theMap = this.hierarchyValuesRestrictionMap;
        } else if (SecManager.SecurityType.attribute == securityType) {
            theMap = this.hierarchyAttributesRestrictionMap;
        }
        if (theMap != null) {
            return theMap.get(hierarchy);
        }
        return null;
    }

    public SecViewHierarchyLookupTableRestriction getLookupTableRestriction(IHierarchy hierarchy) {
        if (this.hierarchyLookupTableRestrictionMap != null) {
            return this.hierarchyLookupTableRestrictionMap.get(hierarchy);
        }
        return null;
    }

    public Collection<SecViewHierarchyLookupTableRestriction> getLookupTableRestrictions() {
        return this.hierarchyLookupTableRestrictionMap.values();
    }

    public boolean isMemberAndOrValueRestricted(IMember member, String secKey) {
        if (member == null) {
            return false;
        }
        boolean isRestrictedByRegularRule = this.isMemberAndOrValueRestricted(member, this.hierarchyMembersRestrictionMap, true);
        boolean isRestrictedByLookupTableRule = this.isMemberRestricted(member, secKey, this.hierarchyLookupTableRestrictionMap, true);
        if (isRestrictedByRegularRule && isRestrictedByLookupTableRule) {
            return true;
        }
        if (isRestrictedByRegularRule && this.hierarchyLookupTableRestrictionMap == null || isRestrictedByLookupTableRule && this.hierarchyMembersRestrictionMap == null) {
            return true;
        }
        if (this.isMemberAndOrValueRestricted(member, this.hierarchyValuesRestrictionMap, false)) {
            return true;
        }
        return isRestrictedByLookupTableRule && this.isAllAccessInOtherDimensions(member);
    }

    private boolean isMemberAndOrValueRestricted(IMember member, HashMap<IHierarchy, SecViewHierarchyRestriction> hierarchyRestrictionMap, boolean checkVisibleAncestors) {
        IHierarchy hierarchy;
        SecViewHierarchyRestriction hierarchyRestriction;
        if (hierarchyRestrictionMap != null && (hierarchyRestriction = hierarchyRestrictionMap.get(hierarchy = member.getHierarchy())) != null) {
            if (hierarchyRestriction.isRestricted(member)) {
                return true;
            }
            if (checkVisibleAncestors && hierarchyRestriction.isVisibleAncestor(member)) {
                return true;
            }
        }
        return false;
    }

    private boolean isMemberRestricted(IMember member, String secKey, HashMap<IHierarchy, SecViewHierarchyLookupTableRestriction> hierarchyRestrictionMap, boolean checkVisibleAncestors) {
        if (hierarchyRestrictionMap != null) {
            IHierarchy hierarchy = member.getHierarchy();
            SecViewHierarchyLookupTableRestriction hierLookupTableRestriction = hierarchyRestrictionMap.get(hierarchy);
            if (hierLookupTableRestriction == null) {
                return false;
            }
            SecViewHierarchyRestriction hierarchyRestriction = hierLookupTableRestriction.getUserHierarchyRestriction(secKey);
            if (hierarchyRestriction != null) {
                if (hierarchyRestriction.isRestricted(member)) {
                    return true;
                }
                if (checkVisibleAncestors && hierarchyRestriction.isVisibleAncestor(member)) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isAllAccessInOtherDimensions(IMember member) {
        if (this.hierarchyMembersRestrictionMap != null) {
            IHierarchy memHier = member.getHierarchy();
            for (IHierarchy keyHier : this.hierarchyMembersRestrictionMap.keySet()) {
                SecViewHierarchyRestriction hierRestriction;
                if (keyHier.getName().equals(memHier.getName()) || (hierRestriction = this.hierarchyMembersRestrictionMap.get(keyHier)).isAllAccess()) continue;
                return false;
            }
            return 1 != this.hierarchyMembersRestrictionMap.size() || !this.hierarchyMembersRestrictionMap.containsKey(memHier);
        }
        return false;
    }

    public void addDimensionDenied(IDimension dimension) {
        this.deniedDimensions.add(dimension);
    }

    public void addDimensionGranted(IDimension dimension) {
        this.grantedDimensions.add(dimension);
    }

    public Set<IDimension> getDimensionsGranted() {
        return this.grantedDimensions;
    }

    public Set<IDimension> getDimensionsDenied() {
        return this.deniedDimensions;
    }

    public boolean isLookupRuleDefined() {
        return this.hierarchyLookupTableRestrictionMap != null && !this.hierarchyLookupTableRestrictionMap.isEmpty();
    }
}

