/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.security;

import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeManager;
import com.cognos.xqe.trace.LogLevel;
import java.util.HashSet;
import org.apache.commons.collections.map.ListOrderedMap;

public class SecurityLookupQueryCache {
    private static final int NO_LIMIT_CACHE_SIZE = -1;
    private static final int PRINT_LIMIT = 100;
    private static final String OPEN_BRACE = "{";
    private static final String CLOSE_BRACE = "}";
    private static final String COMMA_SPACE = ", ";
    private static final String OPEN_BRACKET = "[";
    private int mMaxMemberLimit;
    private int mTotalMemberCount = 0;
    private final ListOrderedMap mMemberSetEntries = new ListOrderedMap();

    public SecurityLookupQueryCache() {
        this.mMaxMemberLimit = ROLAPCubeManager.getInstance().getConfig().getSecurityMaxCachedMembers();
        if (ROLAPLog.isOn("ROLAPCubes.Security", LogLevel.INFO)) {
            ROLAPLog.log("ROLAPCubes.Security", "Security cache member limit:" + this.mMaxMemberLimit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MemberSetEntry get(String query) {
        SecurityLookupQueryCache securityLookupQueryCache = this;
        synchronized (securityLookupQueryCache) {
            MemberSetEntry entry = (MemberSetEntry)this.mMemberSetEntries.remove((Object)query);
            this.mMemberSetEntries.put((Object)query, (Object)entry);
            return entry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MemberSetEntry put(String query, HashSet<IMember> generalSet) {
        SecurityLookupQueryCache securityLookupQueryCache = this;
        synchronized (securityLookupQueryCache) {
            MemberSetEntry newEntry = new MemberSetEntry(generalSet);
            this.mTotalMemberCount += generalSet.size();
            if (ROLAPLog.isOn("ROLAPCubes.Security", LogLevel.INFO)) {
                ROLAPLog.log("ROLAPCubes.Security", String.format("Adding cache entry, sizes before: %d queries, %d members", this.getQueryCacheSize(), this.getTotalCachedMemberCount()));
            }
            this.mMemberSetEntries.put((Object)query, (Object)newEntry);
            if (ROLAPLog.isOn("ROLAPCubes.Security", LogLevel.INFO)) {
                ROLAPLog.log("ROLAPCubes.Security", String.format("Adding cache entry, sizes after: %d queries,  %d members", this.getQueryCacheSize(), this.getTotalCachedMemberCount()));
            }
            if (ROLAPLog.isOn("ROLAPCubes.Security", LogLevel.TRACE)) {
                ROLAPLog.log("ROLAPCubes.Security", "Adding cache entry, key: " + query);
                ROLAPLog.log("ROLAPCubes.Security", "Adding cache entry, value: " + newEntry.toString());
            }
            if (this.mMaxMemberLimit == -1) {
                return newEntry;
            }
            while (this.mTotalMemberCount > this.mMaxMemberLimit) {
                String key = (String)this.mMemberSetEntries.firstKey();
                if (key.equals(query)) {
                    if (!ROLAPLog.isOn("ROLAPCubes.Security", LogLevel.INFO)) break;
                    ROLAPLog.log("ROLAPCubes.Security", "Keeping the entry that we just added");
                    break;
                }
                if (ROLAPLog.isOn("ROLAPCubes.Security", LogLevel.INFO)) {
                    ROLAPLog.log("ROLAPCubes.Security", String.format("Removing cache entry, sizes before: %d queries, %d members", this.getQueryCacheSize(), this.getTotalCachedMemberCount()));
                }
                MemberSetEntry entry = (MemberSetEntry)this.mMemberSetEntries.remove((Object)key);
                if (ROLAPLog.isOn("ROLAPCubes.Security", LogLevel.TRACE)) {
                    ROLAPLog.log("ROLAPCubes.Security", "Removing cache entry, key: " + key);
                    ROLAPLog.log("ROLAPCubes.Security", "Removing cache entry, value: " + entry.toString());
                }
                this.mTotalMemberCount -= entry.getGeneralSet().size();
                if (!ROLAPLog.isOn("ROLAPCubes.Security", LogLevel.INFO)) continue;
                ROLAPLog.log("ROLAPCubes.Security", String.format("Removing cache entry, sizes after: %d queries, %d members", this.getQueryCacheSize(), this.getTotalCachedMemberCount()));
            }
            return newEntry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getQueryCacheSize() {
        SecurityLookupQueryCache securityLookupQueryCache = this;
        synchronized (securityLookupQueryCache) {
            return this.mMemberSetEntries.size();
        }
    }

    public int getTotalCachedMemberCount() {
        return this.mTotalMemberCount;
    }

    public void setMaxMemberLimit(int limit) {
        this.mMaxMemberLimit = limit;
    }

    public final class MemberSetEntry {
        private HashSet<IMember> mMemberSet = new HashSet();

        private MemberSetEntry(HashSet<IMember> generalSet) {
            this.mMemberSet.addAll(generalSet);
        }

        public HashSet<IMember> getGeneralSet() {
            return this.mMemberSet;
        }

        public void addAllTo(HashSet<IMember> destinationMemberSet) {
            destinationMemberSet.addAll(this.mMemberSet);
        }

        public String toString() {
            StringBuilder str = new StringBuilder(SecurityLookupQueryCache.OPEN_BRACE);
            this.printMemberSet(str, this.mMemberSet);
            str.append(SecurityLookupQueryCache.CLOSE_BRACE);
            return str.toString();
        }

        private void printMemberSet(StringBuilder str, HashSet<IMember> set) {
            str.append(SecurityLookupQueryCache.OPEN_BRACE);
            int count = 0;
            for (IMember member : set) {
                if (count != 0) {
                    str.append(SecurityLookupQueryCache.COMMA_SPACE);
                }
                str.append(SecurityLookupQueryCache.OPEN_BRACKET).append(member.getName()).append("]");
                if (++count < 100) continue;
                str.append(", remaining ").append(set.size() - count).append(" members skipped");
                break;
            }
            str.append(SecurityLookupQueryCache.CLOSE_BRACE);
        }
    }
}

