/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.util;

import com.cognos.xqe.cache.CacheException;
import com.cognos.xqe.cache.ICacheEngine;
import com.cognos.xqe.cache.ICacheKey;
import com.cognos.xqe.cache.util.ICacheableNameValueBasedContent;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.provider.Metadata;
import com.cognos.xqe.runtree.olap.mdx.metadata.Dimension;
import com.cognos.xqe.runtree.olap.mdx.metadata.Level;
import com.cognos.xqe.runtree.olap.mdx.metadata.Member;
import com.cognos.xqe.runtree.olap.mdx.metadata.metadatacache.MemberProxy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPAllLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPCalculatedMeasure;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPCalculatedMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPMemberProxy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPRelativeTimeMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeMetrics;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaAttribute;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaObjectKey;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualHierarchyModelRef;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualMemberModelRef;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualMemberProxy;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.util.IOrderedMap;
import com.cognos.xqe.util.MemoryWalker;
import com.cognos.xqe.util.OrderedMap;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.instrument.Instrumentation;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Stack;
import java.util.concurrent.TimeUnit;

public class ROLAPMemoryWalker {
    private static Instrumentation mInstrumentation = MemoryWalker.getInstrumentation();
    private static boolean mCalcROLAPMemberSizes = System.getProperty("calcROLAPMemberSizes") != null;
    private static boolean mRecordDuplicates = System.getProperty("recordDuplicates") != null;
    private static boolean mRecordMemberCacheSnapshots = System.getProperty("recordYourKitMemberCacheSnapshots") != null;
    private static final boolean DETAILED_LOGGING = false;
    private static final String DUPLICATE_MARK = "***";
    private static final double PERCENT = 100.0;
    private static final int DEFAULT_GC_DELAY = 1000;
    private static final int MEMBER_COUNT_CUTOFF = 300000;
    private static final String FIELD_PARENT_MEMBER = "parentMember";
    private static final String FIELD_ROLLUP_TYPE = "rollupType";
    private static final String FIELD_HIERARCHY = "hierarchy";
    private static final String FIELD_META_HIERARCHY = "metaHierarchy";
    private static final String FIELD_M_ERROR_LOGGER = "mErrorLogger";
    private static final String FIELD_CUBE = "cube";
    private static final String FIELD_M_CURRENT_PERIOD_MEMBER = "mCurrentPeriodMember";
    private static final String CAPTURE_MEMORY_SNAPSHOT_METHOD = "captureMemorySnapshot";
    private static PrintWriter mStatsFile = null;
    private static final int OBJECT_PER_MEMBER_FACTOR = 25;
    private static HashSet<Field> skipFields;
    private static final String FIELD_COUNT_NOT_FIND_MSG = "Could not find the expected class field";
    private static HashSet<Class<?>> skipClasses;

    private static synchronized void writeStats(Object ... stats) {
        if (mStatsFile == null) {
            XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
            SimpleDateFormat format = new SimpleDateFormat("yyMMdd-HHmmssSSS");
            File statsFile = new File(configuration.getXqeLogsDirectory() + File.separator + "rolapMemberStats-" + format.format(new Date(System.currentTimeMillis())) + ".csv");
            if (statsFile.exists()) {
                statsFile.delete();
            }
            try {
                mStatsFile = new PrintWriter((Writer)new BufferedWriter(new FileWriter(statsFile)), true);
                mStatsFile.println("Cube,Object type,Num objects,Total size,Avg size,String size,Children size");
            }
            catch (IOException e) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_InternalException, (Throwable)e);
            }
        }
        for (int i = 0; i < stats.length; ++i) {
            if (i != 0) {
                mStatsFile.print(",");
            }
            mStatsFile.print(stats[i].toString());
        }
        mStatsFile.println();
    }

    public static void analyzeSizes(ROLAPCube cube, ROLAPMemoryWalkerState state) throws XQERuntimeException {
        if (mRecordMemberCacheSnapshots && state.getYourKitController() != null) {
            try {
                Object controller = state.getYourKitController();
                Class<?> cls = controller.getClass();
                Method captureMemorySnapshot = cls.getMethod(CAPTURE_MEMORY_SNAPSHOT_METHOD, new Class[0]);
                Method stopAllocMethod = cls.getMethod("stopAllocationRecording", new Class[0]);
                Method stopCPUMethod = cls.getMethod("stopCPUProfiling", new Class[0]);
                String fileName = (String)captureMemorySnapshot.invoke(controller, new Object[0]);
                stopAllocMethod.invoke(controller, new Object[0]);
                stopCPUMethod.invoke(controller, new Object[0]);
                String message = String.format("Recorded YourKit memory snapshot after loading member cache for cube %s in file %s", cube.getName(), fileName);
                ROLAPLog.logError("ROLAPCubes.Loader", message);
                XQEDebugLog.err.println(message);
            }
            catch (Exception e) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalError_INTERNAL, (Throwable)e);
            }
        }
        if (mCalcROLAPMemberSizes) {
            if (mInstrumentation == null) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Memory analysis agent not initialized - use command line option -javaagent:<product_root>/webapps/p2pd/WEB-INF/lib/xqeService.jar");
            }
            int memberCount = cube.getMemberCacheInContext().getCachedMemberCount();
            long newUsedSize = ROLAPMemoryWalker.getUsedMemory(memberCount);
            MemoryStats stats = new MemoryStats();
            stats.totalSize = newUsedSize - state.getPrevUsedSize();
            ROLAPMemoryWalker.publishMetrics(stats, cube, "cache", 1L, 0L);
            IdentityHashMap<Object, Object> alreadyFollowed = new IdentityHashMap<Object, Object>(memberCount * 25);
            HashSet<Object> uniqueObjects = null;
            HashMap duplicateClasses = null;
            if (mRecordDuplicates) {
                uniqueObjects = new HashSet<Object>(memberCount * 25);
                duplicateClasses = new HashMap();
            }
            ROLAPMemoryWalker.analyzeMemberSizesImpl(cube, alreadyFollowed, uniqueObjects, duplicateClasses);
            ROLAPMemoryWalker.analyzeLevelSizesImpl(cube, alreadyFollowed, uniqueObjects, duplicateClasses);
            ROLAPMemoryWalker.analyzeHierarchySizesImpl(cube, alreadyFollowed, uniqueObjects, duplicateClasses);
            ROLAPMemoryWalker.analyzeDimensionSizesImpl(cube, alreadyFollowed, uniqueObjects, duplicateClasses);
            if (mRecordDuplicates) {
                XQEDebugLog.err.println(String.format("Total: %d duplicates: %d", alreadyFollowed.size(), alreadyFollowed.size() - uniqueObjects.size()));
                XQEDebugLog.err.println(duplicateClasses.toString());
                stats = new MemoryStats();
                ROLAPMemoryWalker.publishMetrics(stats, cube, "duplicates", alreadyFollowed.size() - uniqueObjects.size(), 0L);
            }
        }
    }

    private static void analyzeMemberSizesImpl(ROLAPCube cube, IdentityHashMap<Object, Object> alreadyFollowed, HashSet<Object> uniqueObjects, HashMap<Class<?>, Integer> duplicateClasses) throws XQERuntimeException {
        long startTime = System.nanoTime();
        MemoryStats stats = new MemoryStats();
        long numProxyMembers = 0L;
        for (IDimension dimension : cube.getDimensions()) {
            List<IHierarchy> hierarchies = dimension.getHierarchies();
            for (IHierarchy h : hierarchies) {
                List<ILevel> levels = h.getLevels();
                for (ILevel l : levels) {
                    List<IMember> members = l.getMembers();
                    for (IMember m : members) {
                        if (!(m instanceof ROLAPMemberProxy) && !(m instanceof ROLAPVirtualMember)) continue;
                        ++numProxyMembers;
                        ROLAPMemoryWalker.collectMetadataSizes(m, stats, alreadyFollowed, uniqueObjects, duplicateClasses);
                    }
                }
            }
        }
        long endTime = System.nanoTime();
        ROLAPCubeMetrics metrics = cube.getMetrics();
        metrics.setMemberSizingMemberNo(numProxyMembers);
        metrics.setMemberSizingMemberSize(stats.totalSize);
        metrics.setMemberSizingStringSize(stats.stringSize);
        metrics.setMemberSizingChildSize(stats.stringSize);
        ROLAPMemoryWalker.publishMetrics(stats, cube, "members", numProxyMembers, endTime - startTime);
    }

    private static void analyzeHierarchySizesImpl(ROLAPCube cube, IdentityHashMap<Object, Object> alreadyFollowed, HashSet<Object> uniqueObjects, HashMap<Class<?>, Integer> duplicateClasses) throws XQERuntimeException {
        long startTime = System.nanoTime();
        MemoryStats hierarchyStats = new MemoryStats();
        int numHierarchies = 0;
        for (IDimension dimension : cube.getDimensions()) {
            if (dimension.isMeasuresDimension()) continue;
            List<IHierarchy> hierarchies = dimension.getHierarchies();
            for (IHierarchy h : hierarchies) {
                ROLAPMemoryWalker.collectMetadataSizes(h, hierarchyStats, alreadyFollowed, uniqueObjects, duplicateClasses);
                ++numHierarchies;
            }
        }
        long endTime = System.nanoTime();
        ROLAPMemoryWalker.publishMetrics(hierarchyStats, cube, "hierarchies", numHierarchies, endTime - startTime);
    }

    private static void analyzeDimensionSizesImpl(ROLAPCube cube, IdentityHashMap<Object, Object> alreadyFollowed, HashSet<Object> uniqueObjects, HashMap<Class<?>, Integer> duplicateClasses) throws XQERuntimeException {
        long startTime = System.nanoTime();
        MemoryStats dimensionStats = new MemoryStats();
        int numDimensions = 0;
        for (IDimension dimension : cube.getDimensions()) {
            ++numDimensions;
            ROLAPMemoryWalker.collectMetadataSizes(dimension, dimensionStats, alreadyFollowed, uniqueObjects, duplicateClasses);
        }
        long endTime = System.nanoTime();
        ROLAPMemoryWalker.publishMetrics(dimensionStats, cube, "dimensions", numDimensions, endTime - startTime);
    }

    private static void analyzeLevelSizesImpl(ROLAPCube cube, IdentityHashMap<Object, Object> alreadyFollowed, HashSet<Object> uniqueObjects, HashMap<Class<?>, Integer> duplicateClasses) throws XQERuntimeException {
        long startTime = System.nanoTime();
        MemoryStats levelStats = new MemoryStats();
        int numLevels = 0;
        for (IDimension dimension : cube.getDimensions()) {
            if (dimension.isMeasuresDimension()) continue;
            List<IHierarchy> hierarchies = dimension.getHierarchies();
            for (IHierarchy h : hierarchies) {
                List<ILevel> levels = h.getLevels();
                for (ILevel l : levels) {
                    ROLAPMemoryWalker.collectMetadataSizes(l, levelStats, alreadyFollowed, uniqueObjects, duplicateClasses);
                    ++numLevels;
                }
            }
        }
        long endTime = System.nanoTime();
        ROLAPMemoryWalker.publishMetrics(levelStats, cube, "levels", numLevels, endTime - startTime);
    }

    private static void publishMetrics(MemoryStats stats, ROLAPCube cube, String objType, long numObjects, long runTime) {
        long stringPercentage = 0L;
        long childrenPercentage = 0L;
        if (stats.totalSize != 0L) {
            stringPercentage = (long)((double)stats.stringSize * 100.0 / (double)stats.totalSize);
            childrenPercentage = (long)((double)stats.childListSize * 100.0 / (double)stats.totalSize);
        }
        String message = String.format("%s size calculation: cube '%s', %,d %s, %,d total size, %,d avg size, %,d allocated to strings (%d%% of total), %,d allocated to children (%d%% of total) (took %,d second(s))", objType, cube.getName(), numObjects, objType, stats.totalSize, stats.totalSize / numObjects, stats.stringSize, stringPercentage, stats.childListSize, childrenPercentage, TimeUnit.NANOSECONDS.toSeconds(runTime));
        ROLAPLog.logError("ROLAPCubes.Loader", message);
        XQEDebugLog.err.println(message);
        ROLAPMemoryWalker.writeStats(cube.getName(), objType, numObjects, stats.totalSize, stats.totalSize / numObjects, stats.stringSize, stats.childListSize);
    }

    private static void collectMetadataSizes(IMetadata metadataObj, MemoryStats stats, IdentityHashMap<Object, Object> alreadyFollowed, HashSet<Object> uniqueObjects, HashMap<Class<?>, Integer> duplicateClasses) {
        String name = metadataObj.getUniqueName();
        String objType = metadataObj.getClass().getSimpleName();
        MemoryStats localStats = new MemoryStats();
        if (metadataObj instanceof ROLAPMemberProxy) {
            ((ROLAPMemberProxy)metadataObj).retrievePropValueFromCache("");
        } else if (metadataObj instanceof ROLAPLevel) {
            ROLAPLevel level = (ROLAPLevel)metadataObj;
            ROLAPCube cube = (ROLAPCube)level.getDimension().getCube();
            Map<String, Object> cachedProperties = ROLAPMemoryWalker.retrivePropertiesFromCache(level.getCacheKey(), cube);
            ROLAPMemoryWalker.collectSizes(cachedProperties, localStats, alreadyFollowed, uniqueObjects, duplicateClasses);
        } else if (metadataObj instanceof IROLAPHierarchy) {
            ((IROLAPHierarchy)metadataObj).getMembers();
        }
        ROLAPMemoryWalker.collectSizes(metadataObj, localStats, alreadyFollowed, uniqueObjects, duplicateClasses);
        stats.add(localStats);
    }

    private static Map<String, Object> retrivePropertiesFromCache(ICacheKey cacheKey, ROLAPCube cube) {
        try {
            Map<String, Object> cachedMemberProps = null;
            ICacheEngine metadataCache = cube.getMetadataStorage();
            ICacheableNameValueBasedContent cachedMemberContent = (ICacheableNameValueBasedContent)metadataCache.get(cacheKey);
            if (cachedMemberContent != null) {
                cachedMemberProps = cachedMemberContent.getContent();
            }
            return cachedMemberProps;
        }
        catch (CacheException ce) {
            throw new XQERuntimeException(ce);
        }
    }

    private static void collectSizes(Object rootObj, MemoryStats stats, IdentityHashMap<Object, Object> alreadyFollowed, HashSet<Object> uniqueObjects, HashMap<Class<?>, Integer> duplicateClasses) {
        if (rootObj == null) {
            return;
        }
        Object fieldStack = null;
        Object fieldArray = null;
        Object parentStack = null;
        Stack<Queue<Object>> stack = new Stack<Queue<Object>>();
        Queue<Object> queue = new LinkedList<Object>();
        alreadyFollowed.put(rootObj, rootObj);
        if (mRecordDuplicates) {
            uniqueObjects.add(rootObj);
        }
        queue.add(rootObj);
        stack.add(queue);
        int childrenDepth = -1;
        int stringDepth = -1;
        Object indent = null;
        while (!stack.isEmpty()) {
            Class<?> objClass;
            Object obj;
            queue = (Queue)stack.peek();
            if (queue.isEmpty()) {
                stack.pop();
                continue;
            }
            if (stringDepth >= stack.size()) {
                stringDepth = -1;
            }
            if (childrenDepth >= stack.size()) {
                childrenDepth = -1;
            }
            if ((obj = queue.remove()).getClass() == String.class) {
                stringDepth = stack.size();
            }
            if (obj instanceof IOrderedMap) {
                childrenDepth = stack.size();
            }
            long primSize = mInstrumentation.getObjectSize(obj);
            stats.totalSize += primSize;
            if (stringDepth != -1 && stringDepth <= stack.size()) {
                stats.stringSize += primSize;
            } else if (childrenDepth != -1 && childrenDepth <= stack.size()) {
                stats.childListSize += primSize;
            }
            queue = new LinkedList();
            stack.add(queue);
            if (objClass.isArray()) {
                if (objClass.getComponentType().isPrimitive()) continue;
                int length = Array.getLength(obj);
                for (int i = 0; i < length; ++i) {
                    Object obj2 = Array.get(obj, i);
                    if (obj2 == null || alreadyFollowed.containsKey(obj2) || skipClasses.contains(obj2.getClass())) continue;
                    alreadyFollowed.put(obj2, obj2);
                    boolean visited = false;
                    if (mRecordDuplicates && !uniqueObjects.add(obj2)) {
                        Class<?> cls = obj2.getClass();
                        Integer cnt = duplicateClasses.get(cls);
                        if (cnt == null) {
                            duplicateClasses.put(cls, 1);
                        } else {
                            duplicateClasses.put(cls, cnt + 1);
                        }
                        visited = true;
                    }
                    queue.add(obj2);
                }
                continue;
            }
            for (objClass = obj.getClass(); objClass != null; objClass = objClass.getSuperclass()) {
                Field[] fields;
                for (Field field : fields = objClass.getDeclaredFields()) {
                    if (Modifier.isStatic(field.getModifiers())) continue;
                    field.setAccessible(true);
                    if (field.getType().isPrimitive()) continue;
                    try {
                        Object obj2 = field.get(obj);
                        if (obj2 == null || alreadyFollowed.containsKey(obj2) || skipFields.contains(field) || skipClasses.contains(obj2.getClass())) continue;
                        alreadyFollowed.put(obj2, obj2);
                        boolean visited = false;
                        if (mRecordDuplicates && !uniqueObjects.add(obj2)) {
                            Class<?> cls = obj2.getClass();
                            Integer cnt = duplicateClasses.get(cls);
                            if (cnt == null) {
                                duplicateClasses.put(cls, 1);
                            } else {
                                duplicateClasses.put(cls, cnt + 1);
                            }
                            visited = true;
                        }
                        queue.add(obj2);
                    }
                    catch (ClassCastException ce) {
                        throw ce;
                    }
                    catch (IllegalAccessException ex) {
                        throw new RuntimeException(ex);
                    }
                }
            }
        }
    }

    public static ROLAPMemoryWalkerState initMemoryWalker(ROLAPCube cube) {
        Object controller = null;
        if (mRecordMemberCacheSnapshots) {
            Class<?> cls;
            try {
                cls = Class.forName("com.yourkit.api.Controller");
            }
            catch (ClassNotFoundException e) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "You have chosen to record memory snapshots for member cache. Please make sure you specify YourKit jar file (e.g. C:\\Program Files (x86)\\YourKit Java Profiler 12.0.1\\lib\\yjp.jar) in classpath. Also please specify YourKit agent specific to your OS on command line, for example: -agentpath:\"C:\\Program Files (x86)\\YourKit Java Profiler 12.0.1\\bin\\win32\\yjpagent.dll\"");
            }
            try {
                controller = cls.newInstance();
                Method captureMemorySnapshot = cls.getMethod(CAPTURE_MEMORY_SNAPSHOT_METHOD, new Class[0]);
                Method startCPUMethod = cls.getMethod("startCPUTracing", String.class);
                Method startAllocMethod = cls.getMethod("startAllocationRecording", Boolean.TYPE, Integer.TYPE, Boolean.TYPE, Integer.TYPE, Boolean.TYPE, Boolean.TYPE);
                startCPUMethod.invoke(controller, new Object[]{null});
                startAllocMethod.invoke(controller, false, 0, false, 0, true, false);
                String fileName = (String)captureMemorySnapshot.invoke(controller, new Object[0]);
                String message = String.format("Recorded YourKit memory snapshot before loading member cache for cube %s in file %s", cube.getName(), fileName);
                ROLAPLog.logError("ROLAPCubes.Loader", message);
                XQEDebugLog.err.println(message);
            }
            catch (Exception e) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalError_INTERNAL, (Throwable)e);
            }
        }
        long prevSize = 0L;
        if (mCalcROLAPMemberSizes) {
            prevSize = ROLAPMemoryWalker.getUsedMemory(0);
        }
        return new ROLAPMemoryWalkerState(prevSize, controller);
    }

    private static long getUsedMemory(int memberCount) {
        MemoryMXBean mxBean = ManagementFactory.getMemoryMXBean();
        int delay = 1000;
        if (memberCount > 300000) {
            delay = memberCount / 300000 * 1000;
        }
        try {
            mxBean.gc();
            Thread.sleep(delay);
            mxBean.gc();
            Thread.sleep(delay);
            mxBean.gc();
            Thread.sleep(delay);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return mxBean.getHeapMemoryUsage().getUsed();
    }

    static {
        try {
            skipFields = new HashSet<Field>(Arrays.asList(OrderedMap.class.getDeclaredField("nullOrder"), MemberProxy.class.getDeclaredField("memberLevel"), MemberProxy.class.getDeclaredField(FIELD_PARENT_MEMBER), ROLAPVirtualMember.class.getDeclaredField("mParent"), ROLAPVirtualMember.class.getDeclaredField("mSourceMembers"), Metadata.class.getDeclaredField("connection"), Member.class.getDeclaredField("dimension"), Member.class.getDeclaredField(FIELD_HIERARCHY), Member.class.getDeclaredField("level"), Member.class.getDeclaredField(FIELD_PARENT_MEMBER), Metadata.class.getDeclaredField("parentObject"), Member.class.getDeclaredField(FIELD_ROLLUP_TYPE), Member.class.getDeclaredField("type"), ROLAPAllLevel.class.getDeclaredField(FIELD_META_HIERARCHY), ROLAPLevel.class.getDeclaredField("singleMetaLevel"), Level.class.getDeclaredField(FIELD_HIERARCHY), Level.class.getDeclaredField(FIELD_M_ERROR_LOGGER), Level.class.getDeclaredField("mPushdownManager"), ROLAPHierarchy.class.getDeclaredField(FIELD_META_HIERARCHY), ROLAPHierarchy.class.getDeclaredField("recursiveMemberMetaLevel"), ROLAPHierarchy.class.getDeclaredField("recursiveParentMetaLevel"), ROLAPHierarchy.class.getDeclaredField(FIELD_M_CURRENT_PERIOD_MEMBER), ROLAPVirtualHierarchy.class.getDeclaredField(FIELD_M_CURRENT_PERIOD_MEMBER), Dimension.class.getDeclaredField(FIELD_M_ERROR_LOGGER), Dimension.class.getDeclaredField(FIELD_CUBE), Dimension.class.getDeclaredField("dimensionType"), ROLAPDimension.class.getDeclaredField(FIELD_M_ERROR_LOGGER), ROLAPDimension.class.getDeclaredField("metaDimension"), ROLAPDimension.class.getDeclaredField("rolapDefaultHierarchy")));
        }
        catch (NoSuchFieldException e) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, (Throwable)e, FIELD_COUNT_NOT_FIND_MSG);
        }
        skipClasses = new HashSet<Class>(Arrays.asList(ROLAPMemberProxy.class, ROLAPVirtualMemberProxy.class, ROLAPLevel.class, ROLAPVirtualLevel.class, ROLAPAllLevel.class, ROLAPHierarchy.class, ROLAPVirtualHierarchy.class, ROLAPVirtualHierarchyModelRef.class, ROLAPVirtualMemberModelRef.class, ROLAPDimension.class, ROLAPVirtualDimension.class, ROLAPCalculatedMember.class, ROLAPCalculatedMeasure.class, ROLAPRelativeTimeMember.class, ROLAPMetaAttribute.class, ROLAPMetaObjectKey.class));
    }

    public static class ROLAPMemoryWalkerState {
        private long mPreviousUsedSize;
        private Object mYourKitController;

        ROLAPMemoryWalkerState(long prevSize, Object controller) {
            this.mPreviousUsedSize = prevSize;
            this.mYourKitController = controller;
        }

        public long getPrevUsedSize() {
            return this.mPreviousUsedSize;
        }

        public Object getYourKitController() {
            return this.mYourKitController;
        }
    }

    private static class MemoryStats {
        long totalSize = 0L;
        long stringSize = 0L;
        long childListSize = 0L;

        private MemoryStats() {
        }

        void add(MemoryStats stats) {
            this.totalSize += stats.totalSize;
            this.stringSize += stats.stringSize;
            this.childListSize += stats.childListSize;
        }
    }
}

