/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.util;

import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.util.LightweightOrderedMap;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class SecurityPaddingOrderedMap<V>
extends LightweightOrderedMap<V> {
    protected volatile IMember mSecurityPaddingMember = null;

    @Override
    public String toString() {
        if (this.mSecurityPaddingMember == null) {
            return super.toString();
        }
        StringBuilder str = new StringBuilder(super.toString());
        str.append(" Security padding: ").append(this.mSecurityPaddingMember.getUniqueName());
        return str.toString();
    }

    @Override
    public Iterator<V> iterator() {
        return new ArrayIteratorWithPadding(this.array, this.mSecurityPaddingMember);
    }

    @Override
    public V get(String key) {
        if (this.mSecurityPaddingMember != null && this.mSecurityPaddingMember.getName().equals(key)) {
            return (V)this.mSecurityPaddingMember;
        }
        return super.get(key);
    }

    @Override
    public V get(int index) {
        if (this.array == null) {
            if (this.mSecurityPaddingMember != null && index == 0) {
                return (V)this.mSecurityPaddingMember;
            }
            throw new ArrayIndexOutOfBoundsException();
        }
        if (this.mSecurityPaddingMember != null && index == this.array.length) {
            return (V)this.mSecurityPaddingMember;
        }
        return (V)this.array[index];
    }

    @Override
    public int size() {
        int size = 0;
        if (this.array != null) {
            size += this.array.length;
        }
        if (this.mSecurityPaddingMember != null) {
            ++size;
        }
        return size;
    }

    @Override
    public Object[] toArray(Object[] o) {
        IMember padding = this.mSecurityPaddingMember;
        int requiredArrayLength = 0;
        if (this.array != null) {
            if (padding == null && this.array.getClass().getComponentType() == o.getClass().getComponentType()) {
                return this.array;
            }
            requiredArrayLength = this.array.length;
        }
        if (padding != null) {
            ++requiredArrayLength;
        }
        Object[] destArray = o.length >= requiredArrayLength ? o : (Object[])Array.newInstance(o.getClass().getComponentType(), requiredArrayLength);
        Arrays.fill(destArray, null);
        if (this.array != null) {
            System.arraycopy(this.array, 0, destArray, 0, this.array.length);
        }
        if (padding != null) {
            destArray[requiredArrayLength - 1] = padding;
        }
        return destArray;
    }

    public void setSecurityPaddingMember(IMember securityPaddingMember) {
        if (this.mSecurityPaddingMember != null) {
            throw new UnsupportedOperationException("Once the padding member has been set we do not allow changing it");
        }
        this.mSecurityPaddingMember = securityPaddingMember;
    }

    private class ArrayIteratorWithPadding
    implements Iterator<V> {
        private int index = 0;
        private V[] arrayRef = null;
        private IMember padding = null;

        ArrayIteratorWithPadding(V[] arr, IMember securityPaddingMember) {
            this.arrayRef = arr;
            this.padding = securityPaddingMember;
        }

        @Override
        public boolean hasNext() {
            if (this.padding != null) {
                if (this.arrayRef == null) {
                    return this.index == 0;
                }
                return this.index < this.arrayRef.length + 1;
            }
            if (this.arrayRef == null) {
                return false;
            }
            return this.index < this.arrayRef.length;
        }

        @Override
        public V next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.padding != null) {
                if (this.arrayRef == null) {
                    ++this.index;
                    return this.padding;
                }
                if (this.index == this.arrayRef.length) {
                    ++this.index;
                    return this.padding;
                }
                return this.arrayRef[this.index++];
            }
            return this.arrayRef[this.index++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

