/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.util;

import com.cognos.xqe.exception.XQERuntimeException;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class SimpleSaxParser {
    private static final String PATH_PREFIX = "//";
    private Document document = null;

    public void parseStream(InputStream parseMe) {
        this.saxParse(parseMe);
    }

    public void parseFile(String parseMe) throws FileNotFoundException {
        FileInputStream istream = new FileInputStream(parseMe);
        this.saxParse(istream);
    }

    public void parseString(String parseMe) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(parseMe.getBytes("UTF-8"));
            this.saxParse(bais);
        }
        catch (UnsupportedEncodingException e) {
            throw new XQERuntimeException(e);
        }
    }

    private void saxParse(InputStream parseMe) {
        SAXReader xmlReader = new SAXReader();
        try {
            this.document = xmlReader.read(parseMe);
        }
        catch (DocumentException e) {
            throw new XQERuntimeException(e);
        }
    }

    public String getAttributeValue(Node node, String name) {
        String result = null;
        if (node instanceof Element) {
            Element elt = (Element)node;
            result = elt.attributeValue(name);
        }
        return result;
    }

    public Node getFirstChildByName(Node node, String name) {
        Element result = null;
        if (node instanceof Element) {
            Element elt = (Element)node;
            result = elt.element(name);
        }
        return result;
    }

    public Node getNextSiblingByName(Node node, String name) {
        Element after;
        Element parent;
        Element result = null;
        if (node instanceof Element && (parent = (after = (Element)node).getParent()) != null) {
            List children = parent.elements();
            int index = children.indexOf(after);
            int size = children.size();
            if (index >= 0) {
                for (int i = index + 1; i < size && result == null; ++i) {
                    Element elt = (Element)children.get(i);
                    if (!elt.getName().equals(name)) continue;
                    result = elt;
                }
            }
        }
        return result;
    }

    public String getChildValueByName(Node item, String name) {
        String value = null;
        if (item instanceof Element) {
            value = ((Element)item).elementText(name);
        }
        return value;
    }

    public String getChildData(String parentTag, String childTag) {
        int len;
        String result = null;
        List nodes = this.document.selectNodes(PATH_PREFIX + parentTag);
        if (nodes != null && (len = nodes.size()) > 0) {
            Node item = (Node)nodes.get(0);
            result = this.getChildValueByName(item, childTag);
        }
        return result;
    }

    public Node getFirstNode(String parentTag, String childTag) {
        int len;
        Node result = null;
        List nodes = this.document.selectNodes(PATH_PREFIX + parentTag);
        if (nodes != null && (len = nodes.size()) > 0) {
            Node item;
            result = item = (Node)nodes.get(0);
        }
        return result;
    }

    public Document getDocument() {
        return this.document;
    }
}

