/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SimpleXMLValidator
implements ErrorHandler {
    ArrayList<SAXParseException> errorExceptions = new ArrayList();
    ArrayList<SAXParseException> fatalExceptions = new ArrayList();
    ArrayList<SAXParseException> warningExceptions = new ArrayList();

    @Override
    public void error(SAXParseException e) throws SAXException {
        this.errorExceptions.add(e);
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        this.fatalExceptions.add(e);
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        this.warningExceptions.add(e);
    }

    public boolean encounteredErrors() {
        return !this.fatalExceptions.isEmpty() || !this.errorExceptions.isEmpty();
    }

    public boolean wasFatal() {
        return !this.fatalExceptions.isEmpty();
    }

    public ArrayList<SAXParseException> getErrors() {
        return this.errorExceptions;
    }

    public ArrayList<SAXParseException> getFatalErrors() {
        return this.fatalExceptions;
    }

    public ArrayList<SAXParseException> getWarnings() {
        return this.warningExceptions;
    }

    private void validateSource(StreamSource source, URL schemaURL) throws IOException, SAXException {
        this.clear();
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = null;
        schema = factory.newSchema(schemaURL);
        Validator validator = schema.newValidator();
        validator.setErrorHandler(this);
        validator.validate(source);
    }

    public void validateString(String xmlcText, URL schemaURL) throws IOException, SAXException {
        ByteArrayInputStream bais = new ByteArrayInputStream(xmlcText.getBytes("UTF-8"));
        StreamSource source = new StreamSource(bais);
        this.validateSource(source, schemaURL);
    }

    public void clear() {
        this.errorExceptions = new ArrayList();
        this.fatalExceptions = new ArrayList();
        this.warningExceptions = new ArrayList();
    }
}

