/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual;

import com.cognos.xqe.bibushandler.CubeRequestMetrics;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.bibushandler.SQLQueryMetrics;
import com.cognos.xqe.data.providers.relational.jdbc.util.DirectAccessJDBCValue;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.TextValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueState;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.metadata.AggregateTypeEnum;
import com.cognos.xqe.metadata.DimensionTypeEnum;
import com.cognos.xqe.metadata.IAggregateRule;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.query.engine.TestEnvironmentOptions;
import com.cognos.xqe.resultset.interfaces.IIterator;
import com.cognos.xqe.rsapi.RSAPIResultSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Cell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.ExternalAggregateStrategyException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IExternalAggregateStrategy;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.QueryContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.QueryStrategy;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.SetSelections;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.TupleValue;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.CrossJoinTupleList;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.ITupleList;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.SimpleTupleList;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.SingleHierarchySimpleTupleList;
import com.cognos.xqe.runtree.olap.mdx.metadata.Cube;
import com.cognos.xqe.runtree.olap.mdx.metadata.Hierarchy;
import com.cognos.xqe.runtree.olap.mdx.metadata.Level;
import com.cognos.xqe.runtree.olap.mdx.metadata.MemberOperations;
import com.cognos.xqe.runtree.olap.mdx.metadata.NullMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPCommonMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPQuery;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPQueryResultIterator;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPAbstractHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPCompoundKeyMapping;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPContext;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPMeasure;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPQuery;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPQueryExecuteMetrics;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPQueryGroup;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPQueryStrategy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPRelativeTimeMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPBaseCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.HighPrecisionStopWatch;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaAttribute;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaDirtyDataCompensation;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.security.ROLAPSecurityPaddingMemberProxy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.util.AggregationUtils;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualMeasure;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualQueryStrategy;
import com.cognos.xqe.runtree.olap.mdx.v5provider.V5ProviderQueryResult;
import com.cognos.xqe.runtree.olap.mdx.v5provider.V5ProviderSelection;
import com.cognos.xqe.runtree.olap.mdx.v5provider.XQueryStrategy;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.TraceContext;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqe.util.primitive.HashMapIntObject;
import com.cognos.xqe.util.primitive.HashMapObjectInt;
import com.cognos.xqe.util.primitive.IteratorInt;
import com.cognos.xqe.zipi.ZipiBridge;
import com.cognos.xqe.zipi.ZipiContext;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.MultiValueMap;

public class ROLAPVirtualExternalAggregateStrategy
extends ROLAPQueryStrategy
implements IExternalAggregateStrategy {
    private static final String ROLAP_VIRTUAL_EXTERNAL_AGGREGATE_STRATEGY_FAILURE = "ROLAPVirtualExternalAggregateStrategy failure";
    private static final String NEWLN = System.getProperty("line.separator");
    HashMapObjectInt<String> hierToIndex = null;
    private ROLAPBaseCube qCube;
    private final HashSet<ILevel> aggregateLevels = new HashSet();

    public ROLAPBaseCube getQueryCube() {
        return this.qCube;
    }

    public void setQueryCube(ROLAPBaseCube c) {
        this.qCube = c;
    }

    @Override
    public Value[] execute(InterpreterContext interpreterContext, IHierarchy[] aggHiers, Set[] aggSets) throws ExternalAggregateStrategyException {
        try {
            return this.execute(interpreterContext, aggHiers, aggSets, null);
        }
        catch (InterpreterException ie) {
            throw new ExternalAggregateStrategyException(ROLAP_VIRTUAL_EXTERNAL_AGGREGATE_STRATEGY_FAILURE, ie);
        }
    }

    public Value[] execute(InterpreterContext interpreterContext, IHierarchy[] aggHiers, Set[] aggSets, Map<Set, List<List<Tuple>>> aggregateSetToContextTupleListListsMap) throws ExternalAggregateStrategyException {
        ZipiTimer zipiTimer = ZipiBridge.startTimer("DCExternalAggregateExecution", ZipiContext.getQRDName());
        try {
            Value[] valueArray = this.tryToExecute(interpreterContext, aggHiers, aggSets, aggregateSetToContextTupleListListsMap);
            return valueArray;
        }
        catch (InterpreterException ie) {
            throw new ExternalAggregateStrategyException(ROLAP_VIRTUAL_EXTERNAL_AGGREGATE_STRATEGY_FAILURE, ie);
        }
        finally {
            if (zipiTimer != null) {
                zipiTimer.stop();
            }
        }
    }

    private void executeAggregateByContextSet(InterpreterContext interpreterContext, Set aggSet, Set contextSet, Set[] aggSets, Value[] aggValues) throws ExternalAggregateStrategyException {
        ROLAPQueryExecuteMetrics queryMetrics = new ROLAPQueryExecuteMetrics(0);
        Cube cube = (Cube)interpreterContext.getCube();
        this.aggregateLevels.addAll(AggregationUtils.getAggregateLevels(aggSet));
        HashSet<IHierarchy> aggHierarchies = new HashSet<IHierarchy>();
        ArrayList<ITupleList> childTupleLists = new ArrayList<ITupleList>();
        childTupleLists.add(contextSet.getTupleList());
        for (IHierarchy hier : aggSet.getHierarchies()) {
            IMember[] members = aggSet.getMembers(hier);
            if (members.length == 1) {
                childTupleLists.add(SingleHierarchySimpleTupleList.construct(members));
                continue;
            }
            childTupleLists.add(SingleHierarchySimpleTupleList.construct(new IMember[]{NullMember.getNullMember(hier)}));
            aggHierarchies.add(hier);
        }
        Set executionSet = new Set(CrossJoinTupleList.construct(childTupleLists));
        queryMetrics.notifyOperationStart(XQueryStrategy.Operation.CUBE_RETRIEVAL);
        this.setCube(cube);
        this.setInfoData(interpreterContext.getQueryContext());
        ROLAPQueryGroup queries = new ROLAPQueryGroup();
        ROLAPCube[] sourceCubes = ((ROLAPVirtualCube)cube).getSourceCubes();
        boolean needToRemoveCubeName = false;
        String previousCurrentCubeName = ROLAPContext.getCurrentCubeName();
        for (ROLAPCube sourceCube : sourceCubes) {
            try {
                ROLAPContext.removeCurrentCubeName(previousCurrentCubeName != null);
                needToRemoveCubeName = ROLAPContext.setCurrentCubeName(sourceCube.getName());
                this.setQueryCube((ROLAPBaseCube)sourceCube);
                this.buildROLAPQueries(new SetSelections(executionSet), true, true, false, queries, null);
            }
            catch (InterpreterException ie) {
                throw new ExternalAggregateStrategyException(ROLAP_VIRTUAL_EXTERNAL_AGGREGATE_STRATEGY_FAILURE, ie);
            }
            finally {
                ROLAPContext.removeCurrentCubeName(needToRemoveCubeName);
                if (previousCurrentCubeName != null) {
                    ROLAPContext.setCurrentCubeName(previousCurrentCubeName);
                }
            }
        }
        if (queries.getQueries().isEmpty()) {
            return;
        }
        for (int queryIdx = 0; queryIdx < queries.getQueries().size(); ++queryIdx) {
            ROLAPQuery query = (ROLAPQuery)queries.getQuery(queryIdx);
            V5ProviderQueryResult v5Result = null;
            ROLAPQueryStrategy.TupleValueIterator tupleValueIterator = null;
            try {
                ROLAPContext.removeCurrentCubeName(previousCurrentCubeName != null);
                needToRemoveCubeName = ROLAPContext.setCurrentCubeName(query.getQueryCube().getName());
                HashMapObjectInt<String> hierToIndexMap = this.getHierToIndexMap(cube);
                HashMapIntObject<ArrayList<ROLAPCompoundKeyMapping>> extraAggregationFilters = new HashMapIntObject<ArrayList<ROLAPCompoundKeyMapping>>();
                for (IHierarchy hier : aggHierarchies) {
                    IMember[] members;
                    ArrayList<ROLAPCompoundKeyMapping> compoundKeyMappings = new ArrayList<ROLAPCompoundKeyMapping>();
                    int hierNdx = hierToIndexMap.get(hier.getUniqueName());
                    for (IMember member : members = aggSet.getMembers(hier)) {
                        if (member.getLevel().isRootLevel() || MemberOperations.isValueSecured(member, interpreterContext)) continue;
                        ROLAPCompoundKeyMapping keyMappingForListMember = new ROLAPCompoundKeyMapping(false);
                        if (member instanceof ROLAPVirtualMember) {
                            IMember sourceMem = ((ROLAPVirtualMember)member).getSourceMember(query.getQueryCube());
                            if (sourceMem == null) continue;
                            keyMappingForListMember.addMemberSelection(sourceMem);
                        } else {
                            keyMappingForListMember.addMemberSelection(member);
                        }
                        compoundKeyMappings.add(keyMappingForListMember);
                    }
                    if (compoundKeyMappings.isEmpty()) continue;
                    extraAggregationFilters.put(hierNdx, compoundKeyMappings);
                }
                query.setComputeAggregationOnly(true);
                query.setReturnContextTuple(true);
                query.setAggregateLevels(this.aggregateLevels);
                query.setExtraAggregateFilters(extraAggregationFilters);
                v5Result = query.execute(null);
                if (v5Result == null) {
                    return;
                }
                tupleValueIterator = new ROLAPQueryStrategy.TupleValueIterator(hierToIndexMap, v5Result, query, null, queryMetrics, true);
                tupleValueIterator.setReuseTupleObjects(false, cube);
                HashMap<String, String> fqMemberNameToMergeOperator = ((ROLAPVirtualCube)cube).getROLAPVirtualCubeDef().getFqMemberNameToMergeOperator();
                while (tupleValueIterator.hasNext()) {
                    TupleValue tv = tupleValueIterator.next();
                    Tuple t = tv.getTuple();
                    IMember measure = t.getMember(query.getQueryCube().getMeasureDimension());
                    String fqName = ROLAPVirtualCube.getFullyQualifiedUniqueName(query.getQueryCube(), (IMetadata)measure);
                    String mergeOpString = fqMemberNameToMergeOperator.get(fqName);
                    int opId = ROLAPVirtualQueryStrategy.opStringToId(mergeOpString);
                    for (IHierarchy aHier : aggSet.getHierarchies()) {
                        t = (Tuple)t.remove(aHier);
                    }
                    for (int i = 0; i < aggSets.length; ++i) {
                        List<Number> ordinals;
                        Set aContextSet;
                        Set anAggSet = aggSets[i];
                        if (anAggSet == null || !AggregationUtils.getAggregateSet(anAggSet, aggSet.getHierarchies()).equals(aggSet) || (aContextSet = new Set(((Set)anAggSet.removeHierarchies(aggSet.getHierarchies(), false)).getTupleList())).size() != 1L || contextSet.intersect(aContextSet, false).isEmpty() || (ordinals = anAggSet.getTupleList().findSubTuple(t.getMembers(), true)).isEmpty()) continue;
                        aggValues[i] = aggValues[i] == null || mergeOpString == null ? this.adjustMeasureFormat((Value)tv.getCell().getValue().copy(), measure) : this.calculateMergedValue(tv.getCell(), opId, i, aggValues[i]);
                    }
                }
                continue;
            }
            catch (InterpreterException ie) {
                if (v5Result != null) {
                    v5Result.release();
                    v5Result = null;
                }
                throw new ExternalAggregateStrategyException(ROLAP_VIRTUAL_EXTERNAL_AGGREGATE_STRATEGY_FAILURE, ie);
            }
            catch (RuntimeException ex) {
                if (v5Result != null) {
                    v5Result.release();
                    v5Result = null;
                }
                throw ex;
            }
            catch (Throwable ex) {
                if (v5Result != null) {
                    v5Result.release();
                    v5Result = null;
                }
                throw XQERuntimeException.wrap(XQEMessageKeys.GEN_UnexpectedException, ex);
            }
            finally {
                if (tupleValueIterator != null) {
                    tupleValueIterator.close();
                }
                if (v5Result != null) {
                    v5Result.release();
                    v5Result = null;
                }
                ROLAPContext.removeCurrentCubeName(needToRemoveCubeName);
                if (previousCurrentCubeName != null) {
                    ROLAPContext.setCurrentCubeName(previousCurrentCubeName);
                }
            }
        }
    }

    private Value[] tryToExecute(InterpreterContext interpreterContext, IHierarchy[] aggHiers, Set[] aggSets, Map<Set, List<List<Tuple>>> aggregateSetToContextTupleListListsMap) throws ExternalAggregateStrategyException {
        Value[] valueArray;
        ROLAPQueryExecuteMetrics queryMetrics = new ROLAPQueryExecuteMetrics(0);
        QueryContext info = interpreterContext.getQueryContext();
        XQueryStrategy queryStrategyProfiler = (XQueryStrategy)info.getQueryStrategyProfileNode();
        queryMetrics.setProfileNode(queryStrategyProfiler);
        queryStrategyProfiler.begin();
        TraceContext traceCtx = TraceContext.enter();
        ICube cube = interpreterContext.getCube();
        traceCtx.addAttribute("rolapCube", cube.getName());
        ROLAPLog.logOpStart(LogLevel.INFO, "ROLAPQuery.Performance", "Started execution of Virtual External Aggregate Strategy.");
        boolean modifiedAtLeastOneSet = false;
        for (int i = 0; i < aggSets.length; ++i) {
            Set originalSet = aggSets[i];
            aggSets[i] = this.replaceReferenceRelativeTimeMembers(aggSets[i]);
            if (originalSet == aggSets[i]) continue;
            modifiedAtLeastOneSet = true;
        }
        Value[] aggValues = new Value[aggSets.length];
        HighPrecisionStopWatch dataQueryStartTime = new HighPrecisionStopWatch(true);
        queryMetrics.notifyOperationStart(XQueryStrategy.Operation.CUBE_RETRIEVAL);
        try {
            int i;
            for (int i2 = 0; i2 < aggSets.length; ++i2) {
                Set originalSet = aggSets[i2];
                Set collapsedSet = aggSets[i2].collapseToRollupMembers();
                if (collapsedSet != null) {
                    aggSets[i2] = collapsedSet;
                }
                if (originalSet == aggSets[i2]) continue;
                modifiedAtLeastOneSet = true;
            }
            boolean executedCalculationSet = AggregationUtils.executeCalculationSet(interpreterContext, aggSets, aggValues);
            if (executedCalculationSet) {
                modifiedAtLeastOneSet = true;
            }
            for (i = 0; i < aggSets.length; ++i) {
                Set originalSet = aggSets[i];
                aggSets[i] = this.collapseToFirstLastMember(aggSets[i], interpreterContext);
                if (originalSet == aggSets[i]) continue;
                modifiedAtLeastOneSet = true;
            }
            for (i = 0; i < aggSets.length; ++i) {
                if (aggSets[i] == null) continue;
                this.aggregateLevels.addAll(AggregationUtils.getAggregateLevels(aggSets[i]));
            }
            boolean executedAsymmetricSet = this.executeAsymmetricSets(aggSets, aggValues);
            if (executedAsymmetricSet) {
                modifiedAtLeastOneSet = true;
            }
            Map<Set, List<List<Tuple>>> executionSets = null;
            executionSets = aggregateSetToContextTupleListListsMap != null && !aggregateSetToContextTupleListListsMap.isEmpty() && !modifiedAtLeastOneSet ? aggregateSetToContextTupleListListsMap : AggregationUtils.getExecutionSets(aggSets, aggHiers);
            if (executionSets != null) {
                for (Set anAggSet : executionSets.keySet()) {
                    List<List<Tuple>> contextSets = executionSets.get(anAggSet);
                    for (List<Tuple> aContextSet : contextSets) {
                        Set contextSet = new Set(SimpleTupleList.construct(aContextSet.toArray(new Tuple[0])));
                        this.executeAggregateByContextSet(interpreterContext, anAggSet, contextSet, aggSets, aggValues);
                    }
                }
            } else {
                this.executeBaseSet(interpreterContext, aggSets, aggValues);
            }
            valueArray = aggValues;
            SQLQueryMetrics sqlMetrics = new SQLQueryMetrics(dataQueryStartTime.getElapsedTimeInMilliseconds(), SQLQueryMetrics.QueryType.ExternalAggregateStrategy);
            queryMetrics.getSqlQueryMetrics().add(sqlMetrics);
        }
        catch (InterpreterException ie) {
            try {
                throw new ExternalAggregateStrategyException(ROLAP_VIRTUAL_EXTERNAL_AGGREGATE_STRATEGY_FAILURE, ie);
            }
            catch (Throwable throwable) {
                SQLQueryMetrics sqlMetrics = new SQLQueryMetrics(dataQueryStartTime.getElapsedTimeInMilliseconds(), SQLQueryMetrics.QueryType.ExternalAggregateStrategy);
                queryMetrics.getSqlQueryMetrics().add(sqlMetrics);
                queryMetrics.notifyOperationEnd(XQueryStrategy.Operation.CUBE_RETRIEVAL, aggValues.length, true);
                if (ROLAPLog.isOn("ROLAPQuery.Performance", LogLevel.INFO)) {
                    long cacheMisses = queryMetrics.getFetchCount();
                    String msg = String.format("Finished execution of Virtual External Aggregate Strategy for report " + QueryStrategy.getReportName() + NEWLN + "   Retrieved %d tuples" + NEWLN, cacheMisses);
                    ROLAPLog.logOpEnd(LogLevel.INFO, "ROLAPQuery.Performance", msg);
                }
                TestEnvironmentOptions.TestHitCountTracker.updateFromQueryMetrics(queryMetrics);
                RequestEnvironment reqEnv = (RequestEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment().getRequestEnvironment();
                CubeRequestMetrics reqMetrics = reqEnv.getRequestMetrics().getCubeMetrics(cube);
                reqMetrics.update(queryMetrics);
                queryStrategyProfiler.end();
                traceCtx.exit();
                throw throwable;
            }
        }
        queryMetrics.notifyOperationEnd(XQueryStrategy.Operation.CUBE_RETRIEVAL, aggValues.length, true);
        if (ROLAPLog.isOn("ROLAPQuery.Performance", LogLevel.INFO)) {
            long cacheMisses = queryMetrics.getFetchCount();
            String msg = String.format("Finished execution of Virtual External Aggregate Strategy for report " + QueryStrategy.getReportName() + NEWLN + "   Retrieved %d tuples" + NEWLN, cacheMisses);
            ROLAPLog.logOpEnd(LogLevel.INFO, "ROLAPQuery.Performance", msg);
        }
        TestEnvironmentOptions.TestHitCountTracker.updateFromQueryMetrics(queryMetrics);
        RequestEnvironment reqEnv = (RequestEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment().getRequestEnvironment();
        CubeRequestMetrics reqMetrics = reqEnv.getRequestMetrics().getCubeMetrics(cube);
        reqMetrics.update(queryMetrics);
        queryStrategyProfiler.end();
        traceCtx.exit();
        return valueArray;
    }

    private boolean executeAsymmetricSets(Set[] externalAggregateSets, Value[] extAggValues) {
        boolean modifiedAtLeastOneSet = false;
        for (int i = 0; i < externalAggregateSets.length; ++i) {
            Set set = externalAggregateSets[i];
            if (set == null || set.isEmpty() || !set.isAsymmetricSet()) continue;
            extAggValues[i] = TextValue.ERROR_VALUE;
            externalAggregateSets[i] = null;
            modifiedAtLeastOneSet = true;
        }
        return modifiedAtLeastOneSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeBaseSet(InterpreterContext interpreterContext, Set[] aggSets, Value[] aggValues) throws ExternalAggregateStrategyException {
        List<IHierarchy> hierarchies = ((ROLAPCube)interpreterContext.getCube()).getHierarchies();
        MultiValueMap combinationToSetIndex = new MultiValueMap();
        List<List<Object>> combinations = AggregationUtils.getSelectionCombinations(interpreterContext.getCube(), aggSets, this.aggregateLevels, hierarchies, combinationToSetIndex);
        block5: for (int i = 0; i < combinations.size(); ++i) {
            IMember measure = this.getMeasure(combinations.get(i));
            ROLAPQuery query = this.combinationToROLAPQuery(interpreterContext, "Query" + (i + 1), combinations.get(i));
            if (query == null) continue;
            if (combinations.size() == aggSets.length && this.requireTupleFilters(combinations.get(0), new Set[]{aggSets[i]})) {
                query.setTupleFilterExpression(new Set[]{aggSets[i]});
            }
            query.setAggregateLevels(this.aggregateLevels);
            V5ProviderQueryResult v5Result = query.execute(null);
            RSAPIResultSet rs = null;
            try {
                IROLAPQueryResultIterator resultIter;
                if (v5Result == null || (resultIter = v5Result.getProviderQueryResultIter()) == null) continue;
                MultiRequestContext context = ExecutionEnvironmentContext.getExecutionEnvironment().getMultiRequestContext();
                rs = context.removeResultset(resultIter.getRSAPIDataset());
                IteratorInt hierIt = null;
                ROLAPLevel level = null;
                if (query.getAggregateCombinationFilters() != null && !query.getAggregateCombinationFilters().isEmpty()) {
                    hierIt = query.getAggregateCombinationFilters().keySetIterator();
                }
                if (hierIt != null && hierIt.hasNext()) {
                    int hierNdx = hierIt.next();
                    ArrayList<ROLAPCompoundKeyMapping> memberKeyMappings = query.getAggregateCombinationFilters().get(hierNdx);
                    level = memberKeyMappings.get(0).getLevel();
                }
                List indexes = (List)combinationToSetIndex.get((Object)i);
                while (resultIter.hasNext()) {
                    IValue[] values = resultIter.next().getColumns();
                    if (values.length == 0) continue;
                    if (indexes.size() == 1) {
                        aggValues[((Integer)indexes.get((int)0)).intValue()] = this.adjustMeasureFormat((Value)values[0].copy(), measure);
                        continue block5;
                    }
                    IValue[] levelKeys = new IValue[values.length - 1];
                    for (int v = 1; v < values.length; ++v) {
                        levelKeys[v - 1] = values[v];
                    }
                    for (int s = 0; s < indexes.size(); ++s) {
                        if (level == null) {
                            ROLAPLog.logTrace("ROLAPQuery", "The result for the external aggregate query " + query.getName() + " is returning more than one value without the level needed to perform the mapping.");
                            aggValues[((Integer)indexes.get((int)s)).intValue()] = TextValue.ERROR_VALUE;
                            continue;
                        }
                        Tuple tuple = (Tuple)aggSets[(Integer)indexes.get(s)].getTuple(0L);
                        IValue[] memberLevelKeys = ((IROLAPCommonMember)((Object)tuple.getMember(level.getHierarchy()))).getLevelKeys().getKeyValues();
                        boolean equal = true;
                        for (int ind = 0; ind < memberLevelKeys.length; ++ind) {
                            IValue value = levelKeys[ind];
                            if (value instanceof DirectAccessJDBCValue) {
                                value = ((DirectAccessJDBCValue)value).getValue();
                            }
                            if (memberLevelKeys[ind].compareTo(value) == 0) continue;
                            equal = false;
                            break;
                        }
                        if (!equal) continue;
                        aggValues[((Integer)indexes.get((int)s)).intValue()] = this.adjustMeasureFormat((Value)values[0].copy(), measure);
                    }
                }
                continue;
            }
            finally {
                if (v5Result != null) {
                    v5Result.release();
                    v5Result = null;
                }
                if (rs != null) {
                    rs.release();
                }
            }
        }
    }

    private Value adjustMeasureFormat(Value measureValue, IMember measure) {
        if (measure == null) {
            ROLAPLog.logTrace("ROLAPQuery", "No measure present in aggregation set");
            return null;
        }
        if (measureValue != null) {
            FormatId formatId = null;
            if (measure instanceof ROLAPVirtualMeasure) {
                formatId = ((ROLAPVirtualMeasure)measure).getFormatId();
            }
            if (formatId == null) {
                String measureFormat = (String)measure.getProperty("format");
                formatId = measureFormat == null && measureValue.isNumeric() ? FormatId.DEFAULT_NUMBER_FORMAT_FID : FormatService.getInstance().registerV5Format(measureFormat, null);
            }
            measureValue.setFormatId(formatId);
        }
        return measureValue;
    }

    private IMember getMeasure(List<Object> combination) {
        IMember measure = null;
        for (int i = 0; i < combination.size(); ++i) {
            Object memberOrList = combination.get(i);
            IMember measureVar = null;
            ArrayList memberList = null;
            if (memberOrList instanceof ArrayList) {
                memberList = (ArrayList)memberOrList;
                measureVar = (IMember)memberList.get(0);
            } else {
                measureVar = (IMember)memberOrList;
            }
            if (!measureVar.getDimension().isMeasuresDimension()) continue;
            measure = measureVar;
            break;
        }
        return measure;
    }

    private ROLAPQuery combinationToROLAPQuery(InterpreterContext interpreterContext, String queryName, List<Object> selections) {
        ROLAPQuery result = null;
        Cube cube = (Cube)interpreterContext.getCube();
        Hierarchy[] hierarchies = cube.getHierarchies().toArray(new Hierarchy[0]);
        IMember[] outputTuple = new IMember[hierarchies.length];
        HashMapObjectInt<String> hierToIndexMap = this.getHierToIndexMap(cube);
        ArrayList<ROLAPVirtualMeasure> measuresSelections = null;
        int measuresIndex = -1;
        HashMapIntObject<ArrayList<ROLAPCompoundKeyMapping>> extraAggregationFilters = new HashMapIntObject<ArrayList<ROLAPCompoundKeyMapping>>();
        HashMapIntObject<ArrayList<ROLAPCompoundKeyMapping>> aggregationCombinationFilters = new HashMapIntObject<ArrayList<ROLAPCompoundKeyMapping>>();
        for (int i = 0; i < selections.size(); ++i) {
            Object memberOrList = selections.get(i);
            IMember measureVar = null;
            ArrayList memberList = null;
            if (memberOrList instanceof ArrayList) {
                memberList = (ArrayList)memberOrList;
                measureVar = (IMember)memberList.get(0);
            } else {
                measureVar = (IMember)memberOrList;
            }
            if (!measureVar.getDimension().isMeasuresDimension()) continue;
            measuresIndex = i;
            if (memberList != null) {
                measuresSelections = (ArrayList<ROLAPVirtualMeasure>)memberOrList;
                break;
            }
            measuresSelections = new ArrayList<ROLAPVirtualMeasure>();
            measuresSelections.add((ROLAPVirtualMeasure)measureVar);
            break;
        }
        ROLAPBaseCube rolapCube = null;
        rolapCube = ((ROLAPCube)cube).isVirtual() ? (ROLAPBaseCube)((ROLAPVirtualCube)cube).getSourceCubes()[0] : (ROLAPBaseCube)cube;
        result = new ROLAPQuery(queryName, rolapCube.getSchema(), rolapCube, true);
        result.setXmdxNodeId(interpreterContext.getQueryContext().getXmdxSelectId());
        for (int i = 0; i < selections.size(); ++i) {
            IROLAPLevel level;
            Object memberOrList = selections.get(i);
            IMember mem = null;
            ArrayList memberList = null;
            if (memberOrList instanceof ArrayList) {
                memberList = (ArrayList)memberOrList;
                mem = (IMember)memberList.get(0);
            } else {
                outputTuple[hierToIndexMap.get((String)mem.getHierarchy().getUniqueName())] = mem = (IMember)memberOrList;
            }
            if (i == measuresIndex || (level = (IROLAPLevel)mem.getLevel()).isAllLevel()) continue;
            if (memberList != null) {
                int hierNdx = hierToIndexMap.get(mem.getHierarchy().getUniqueName());
                ArrayList<ROLAPCompoundKeyMapping> compoundKeyMappings = new ArrayList<ROLAPCompoundKeyMapping>();
                for (IMember member : memberList) {
                    if (MemberOperations.isValueSecured(member, interpreterContext)) continue;
                    ROLAPCompoundKeyMapping keyMappingForListMember = new ROLAPCompoundKeyMapping(false);
                    keyMappingForListMember.addMemberSelection(member);
                    compoundKeyMappings.add(keyMappingForListMember);
                }
                if (this.aggregateLevels.contains(level)) {
                    extraAggregationFilters.put(hierNdx, compoundKeyMappings);
                    continue;
                }
                List projectedColumns = (List)((Object)((ROLAPCompoundKeyMapping)compoundKeyMappings.get(0)).getProjectedColumns().get(0));
                for (ROLAPMetaAttribute column : projectedColumns) {
                    result.addAttribute(column, IROLAPQuery.QueryTarget.COMMON);
                }
                aggregationCombinationFilters.put(hierNdx, compoundKeyMappings);
                continue;
            }
            ROLAPCompoundKeyMapping keyMapping = new ROLAPCompoundKeyMapping(false);
            keyMapping.addMemberSelection(mem);
            keyMapping.addToQuery(result);
        }
        for (ROLAPVirtualMeasure measure : measuresSelections) {
            AggregateTypeEnum aggrType = measure.getRegularAggregate();
            if (aggrType == AggregateTypeEnum.UNKNOWN) continue;
            result.addMeasure((ROLAPMeasure)measure.getSourceMember());
        }
        if (result.getMeasureSelection().isEmpty()) {
            return null;
        }
        if (extraAggregationFilters.size() > 0) {
            result.setExtraAggregateFilters(extraAggregationFilters);
        }
        if (aggregationCombinationFilters.size() > 0) {
            result.setAggregateCombinationFilters(aggregationCombinationFilters);
        }
        result.setOutputTuple(outputTuple);
        return result;
    }

    @Override
    public ROLAPQuery combinationToV5ProviderQuery(int index, List<V5ProviderSelection> selections, boolean isAgainstAggrTable, boolean isOverfetchingAllowed, boolean isCustomAggregateAllowed, HashMap<Level, HashSet<IROLAPCommonMember>> levelToSelectionsMap, HashMap<Level, ArrayList<Map<ROLAPMetaAttribute, HashSet<IValue>>>> levelToLevelKeysMap) {
        ROLAPQuery result = null;
        ROLAPVirtualCube vcCube = (ROLAPVirtualCube)this.getCube();
        String queryName = this.generateQueryName(index);
        boolean isAtLowestLevels = true;
        IMember[] outputTuple = new IMember[this.getCubeHierarchies().length];
        HashMapObjectInt<String> hierToIndexMap = this.getHierToIndexMap();
        int measuresIndex = -1;
        ROLAPBaseCube queryCube = this.getQueryCube();
        result = new ROLAPQuery(queryName, queryCube.getSchema(), queryCube, false);
        if (isAgainstAggrTable) {
            result.getQueryMetrics().setQueryType(SQLQueryMetrics.QueryType.AggregateTable);
        } else {
            result.getQueryMetrics().setQueryType(SQLQueryMetrics.QueryType.Fact);
        }
        result.setXmdxNodeId(this.getInfoData().getXmdxSelectId());
        int predicateThresholdPercent = vcCube.getConfigPredicateThreshold();
        HashSet<ROLAPLevel> levels = new HashSet<ROLAPLevel>();
        boolean cubeHasPCH = queryCube.isPCH();
        HashSet<IROLAPDimension> joinedDimensions = new HashSet<IROLAPDimension>();
        List<V5ProviderSelection> selectionList = selections;
        for (int i = 0; i < selectionList.size(); ++i) {
            IMember sourceMem;
            List<IMember> memberList = selectionList.get(i).getMembersList();
            IMember mem = memberList.get(0);
            if (mem.getDimension().isMeasuresDimension()) {
                measuresIndex = i;
            }
            if (mem instanceof ROLAPVirtualMember && (sourceMem = ((ROLAPVirtualMember)mem).getSourceMember(queryCube)) == null) continue;
            if (memberList.size() == 1) {
                int tupleIndex = hierToIndexMap.get(mem.getHierarchy().getUniqueName());
                outputTuple[tupleIndex] = mem;
            }
            if (i == measuresIndex) continue;
            IROLAPLevel rolapLevel = (IROLAPLevel)mem.getLevel();
            ROLAPLevel level = null;
            level = rolapLevel instanceof ROLAPLevel ? (ROLAPLevel)rolapLevel : (ROLAPLevel)((ROLAPVirtualLevel)rolapLevel).getSourceLevel(queryCube);
            if (level == null) continue;
            levels.add(level);
            if (!(level.isAllLevel() || memberList.size() == 1 && mem instanceof NullMember)) {
                boolean completeLevel;
                boolean isPCH = ((IROLAPHierarchy)level.getHierarchy()).isParentChild();
                joinedDimensions.add((IROLAPDimension)level.getHierarchy().getDimension());
                ROLAPCompoundKeyMapping keyMapping = new ROLAPCompoundKeyMapping(predicateThresholdPercent, isOverfetchingAllowed);
                boolean bl = completeLevel = memberList.size() == level.getCardinality();
                if (!completeLevel || cubeHasPCH) {
                    HashSet<IROLAPCommonMember> memberSelections = null;
                    if (levelToSelectionsMap != null && !isPCH) {
                        memberSelections = levelToSelectionsMap.get(level);
                    }
                    if (memberSelections == null) {
                        keyMapping.addMemberSelections(memberList, queryCube);
                        if (levelToSelectionsMap != null && !isPCH) {
                            levelToSelectionsMap.put(level, keyMapping.getRequestedMembers());
                        }
                    } else {
                        keyMapping.setMemberSelections(level, memberSelections);
                    }
                } else {
                    keyMapping.addAllMembersFromLevel(level);
                }
                ArrayList<Map<ROLAPMetaAttribute, HashSet<IValue>>> levelKeys = null;
                if (levelToLevelKeysMap != null && !isPCH && (levelKeys = levelToLevelKeysMap.get(level)) == null) {
                    levelKeys = keyMapping.getSelectionsLevelKeys();
                    levelToLevelKeysMap.put(level, levelKeys);
                }
                keyMapping.addToQuery(result, levelKeys);
            }
            if (level.isBottomLevel()) continue;
            isAtLowestLevels = false;
        }
        List<IMember> measuresSelections = selections.get(measuresIndex).getMembersList();
        boolean checkedHierCoverage = false;
        for (IMember measure : measuresSelections) {
            ROLAPVirtualMeasure virtualMeasure;
            ROLAPMeasure rolapMeasure;
            boolean addMeasure = true;
            AggregateTypeEnum aggrType = measure.getRegularAggregate();
            if (aggrType == AggregateTypeEnum.UNKNOWN) {
                if (isCustomAggregateAllowed) {
                    if (!checkedHierCoverage) {
                        if (isAtLowestLevels) {
                            int nbrHierarchy = 0;
                            for (IDimension dim : measure.getDimension().getCube().getDimensions()) {
                                if (dim.isMeasuresDimension()) continue;
                                nbrHierarchy += dim.getHierarchyCount();
                            }
                            if (nbrHierarchy > levels.size()) {
                                isAtLowestLevels = false;
                            }
                        }
                        result.setIsAtLowestLevels(isAtLowestLevels);
                        checkedHierCoverage = true;
                    }
                    addMeasure = isAgainstAggrTable || isAtLowestLevels;
                } else {
                    addMeasure = false;
                }
            }
            if (!addMeasure || (rolapMeasure = (ROLAPMeasure)(virtualMeasure = (ROLAPVirtualMeasure)measure).getSourceMember(queryCube)) == null) continue;
            result.addMeasure(rolapMeasure);
        }
        if (result.getMeasureSelection().isEmpty()) {
            return null;
        }
        if (queryCube.getModelCube().isDbContainsDirtyData()) {
            HashSet<String> fmFiltersToAdd = new HashSet<String>();
            for (IDimension dim : vcCube.getDimensions()) {
                ROLAPMetaDimension metaDim;
                ROLAPMetaDirtyDataCompensation dirtyDataComp;
                ROLAPVirtualDimension rolapDim = (ROLAPVirtualDimension)dim;
                if (rolapDim.isMeasuresDimension() || joinedDimensions.contains(rolapDim) || rolapDim.getType() == DimensionTypeEnum.INTERNAL || null == (dirtyDataComp = (metaDim = rolapDim.getMetaDimension()).getDirtyDataCompensation())) continue;
                joinedDimensions.add(rolapDim);
                fmFiltersToAdd.add(dirtyDataComp.getFMFilter());
            }
            for (String fmFilter : fmFiltersToAdd) {
                result.addJoinFilter(fmFilter);
            }
        }
        result.setOutputTuple(outputTuple);
        return result;
    }

    public HashMapObjectInt<String> getHierToIndexMap(Cube cube) {
        if (this.hierToIndex == null) {
            List<IHierarchy> cubeHierarchies = cube.getHierarchies();
            this.hierToIndex = new HashMapObjectInt();
            for (int i = 0; i < cubeHierarchies.size(); ++i) {
                Hierarchy hier = (Hierarchy)cubeHierarchies.get(i);
                this.hierToIndex.put(hier.getUniqueName(), i);
            }
        }
        return this.hierToIndex;
    }

    private Set replaceReferenceRelativeTimeMembers(Set set) {
        IHierarchy[] hiers;
        if (set == null || set.size() < 1L) {
            return set;
        }
        boolean containRelativeTimeEnabledHierarchies = false;
        for (IHierarchy hier : hiers = set.getHierarchies()) {
            if (!(hier instanceof ROLAPVirtualHierarchy) || !((ROLAPVirtualHierarchy)hier).isRelativeTimeEnabled()) continue;
            containRelativeTimeEnabledHierarchies = true;
            break;
        }
        if (!containRelativeTimeEnabledHierarchies) {
            return set;
        }
        boolean replacedAtLeastOneMember = false;
        ArrayList<Tuple> tuples = new ArrayList<Tuple>();
        IIterator calcSetIt = set.iterator();
        while (calcSetIt.hasNext()) {
            Tuple tuple = (Tuple)calcSetIt.next();
            for (int i = 0; i < tuple.size(); ++i) {
                IMember member = tuple.getMember(i);
                if (!member.isExtendedCalculatedMember() || member.isExtendedCalculatedMemberWithFormula()) continue;
                tuple.replaceMember(i, ((ROLAPRelativeTimeMember)member).getReferenceMember());
                replacedAtLeastOneMember = true;
            }
            tuples.add(tuple);
        }
        if (replacedAtLeastOneMember) {
            set = new Set(tuples.toArray(new Tuple[tuples.size()]));
        }
        return set;
    }

    private Set collapseToFirstLastMember(Set aggSet, InterpreterContext interpreterContext) throws ExternalAggregateStrategyException {
        IMember[] members;
        IAggregateRule[] rules;
        if (aggSet == null || aggSet.size() < 1L) {
            return aggSet;
        }
        IHierarchy[] setHierarchies = aggSet.getHierarchies();
        IHierarchy measuresHier = interpreterContext.getCube().getMeasuresHierarchy();
        IMember[] measures = aggSet.getMembers(measuresHier);
        if (measures.length == 0) {
            measures = interpreterContext.getContextSet().getMembers(measuresHier);
        }
        if (measures.length > 1) {
            return aggSet;
        }
        IMember theMeasure = measures[0];
        HashMap<IDimension, IAggregateRule> firstLastAggrRuleDimensions = new HashMap<IDimension, IAggregateRule>();
        HashMap<IDimension, Boolean> firstLastAggrRuleDimensionsProjectingNotAllLevel = new HashMap<IDimension, Boolean>();
        for (IAggregateRule rule : rules = theMeasure.getAggregateRules()) {
            if (rule.getAggregate() != AggregateTypeEnum.FIRST && rule.getAggregate() != AggregateTypeEnum.LAST && rule.getAggregate() != AggregateTypeEnum.CURRENTPERIOD) continue;
            IDimension dim = interpreterContext.getCube().getDimension(rule.getDimensionRef());
            firstLastAggrRuleDimensions.put(dim, rule);
            members = aggSet.getMembers(dim);
            boolean projectingNotAllLevel = false;
            for (IMember member : members) {
                Level level = (Level)member.getLevel();
                if (level.isAllLevel()) continue;
                projectingNotAllLevel = true;
                break;
            }
            firstLastAggrRuleDimensionsProjectingNotAllLevel.put(dim, projectingNotAllLevel);
        }
        if (firstLastAggrRuleDimensions.size() == 0) {
            return aggSet;
        }
        ArrayList<Tuple> tuples = new ArrayList<Tuple>();
        ArrayList<IMember> firstLastMembers = new ArrayList<IMember>();
        ArrayList<IHierarchy> firstLastHierarchies = new ArrayList<IHierarchy>();
        for (int h = 0; h < setHierarchies.length; ++h) {
            IAggregateRule rule = (IAggregateRule)firstLastAggrRuleDimensions.get(setHierarchies[h].getDimension());
            if (rule == null) continue;
            members = aggSet.getMembers(setHierarchies[h]);
            if (((Boolean)firstLastAggrRuleDimensionsProjectingNotAllLevel.get(setHierarchies[h].getDimension())).booleanValue()) {
                if (members.length == 1 && ((Level)members[0].getLevel()).isAllLevel() || members.length == 1 && members[0].getLevel().isLeafLevel()) {
                    continue;
                }
            } else {
                IDimension dim = setHierarchies[h].getDimension();
                if (members.length == 1 && ((Level)members[0].getLevel()).isAllLevel() && !dim.getDefaultHierarchy().equals(setHierarchies[h])) continue;
            }
            firstLastHierarchies.add(setHierarchies[h]);
            Set sortedSet = new Set(Tuple.createTupleList(members));
            sortedSet = sortedSet.hierarchize();
            if (rule.getAggregate() == AggregateTypeEnum.LAST) {
                long last = sortedSet.size() - 1L;
                IMember mem = sortedSet.getTuple(last).getMember(setHierarchies[h]);
                mem = this.getFirstLastMember(rule.getAggregate(), mem);
                firstLastMembers.add(mem);
                continue;
            }
            if (rule.getAggregate() == AggregateTypeEnum.CURRENTPERIOD) {
                long last = sortedSet.size() - 1L;
                IMember lastMem = sortedSet.getTuple(last).getMember(setHierarchies[h]);
                lastMem = this.getFirstLastMember(AggregateTypeEnum.LAST, lastMem);
                IMember currentPeriodLeafMember = null;
                IHierarchy hierarchy = setHierarchies[h];
                if (hierarchy instanceof ROLAPAbstractHierarchy) {
                    currentPeriodLeafMember = ((ROLAPAbstractHierarchy)hierarchy).getLeafLevelCurrentPeriodMember();
                }
                if (currentPeriodLeafMember != null) {
                    IMember[] cp = new IMember[]{currentPeriodLeafMember, lastMem};
                    Set s = new Set(Tuple.createTupleList(cp));
                    if ((s = s.hierarchize()).getTuple(0L).getMember(hierarchy).equals(currentPeriodLeafMember)) {
                        firstLastMembers.add(currentPeriodLeafMember);
                        continue;
                    }
                    firstLastMembers.add(lastMem);
                    continue;
                }
                firstLastMembers.add(lastMem);
                continue;
            }
            IMember mem = sortedSet.getTuple(0L).getMember(setHierarchies[h]);
            mem = this.getFirstLastMember(rule.getAggregate(), mem);
            firstLastMembers.add(mem);
        }
        IIterator it = aggSet.iterator();
        while (it.hasNext()) {
            Tuple tuple = (Tuple)it.next();
            boolean delete = false;
            Iterator itHier = firstLastHierarchies.iterator();
            int next = -1;
            while (itHier.hasNext()) {
                IHierarchy hier = (IHierarchy)itHier.next();
                IMember member = tuple.getMember(hier);
                if (((IMember)firstLastMembers.get(++next)).getUniqueName().startsWith(member.getUniqueName())) continue;
                delete = true;
                break;
            }
            if (delete) continue;
            Tuple newTuple = (Tuple)tuple.copy();
            for (IMember firstLastMember : firstLastMembers) {
                IHierarchy hier = firstLastMember.getHierarchy();
                int hierPosition = newTuple.getHierarchyIndex(hier);
                newTuple.replaceMember(hierPosition, firstLastMember);
            }
            tuples.add(newTuple);
        }
        aggSet = new Set(tuples.toArray(new Tuple[tuples.size()]));
        return aggSet;
    }

    private IMember getFirstLastMember(AggregateTypeEnum rule, IMember mem) {
        List<IMember> children;
        IHierarchy hier = mem.getHierarchy();
        int nLevel = hier.getLevelCount();
        ILevel scopeLevel = hier.getLevel(nLevel - 1);
        int scopeLevelIdx = scopeLevel.getIndex();
        IMember childMember = mem;
        for (int currentLevelIdx = mem.getLevel().getIndex(); currentLevelIdx < scopeLevelIdx && (children = childMember.getChildren()).size() != 0; ++currentLevelIdx) {
            if (rule == AggregateTypeEnum.LAST) {
                childMember = children.get(children.size() - 1);
                if (!(childMember instanceof ROLAPSecurityPaddingMemberProxy)) continue;
                childMember = children.get(children.size() - 2);
                continue;
            }
            if (rule == AggregateTypeEnum.CURRENTPERIOD) {
                return childMember;
            }
            childMember = children.get(0);
        }
        return childMember;
    }

    private boolean requireTupleFilters(List<Object> selections, Set[] aggSets) {
        long selectionSize = 1L;
        for (int i = 0; i < selections.size(); ++i) {
            Object memberList = selections.get(i);
            if (!(memberList instanceof ArrayList) || ((ArrayList)memberList).size() <= 1) continue;
            selectionSize *= (long)((ArrayList)memberList).size();
        }
        long aggSetSize = 0L;
        for (Set set : aggSets) {
            aggSetSize += set.size();
        }
        return selectionSize > aggSetSize;
    }

    private Value calculateMergedValue(Cell cell, int opId, int opCubeIndex, Value retValue) {
        double outputValue = retValue.getDouble();
        boolean allNull = outputValue == 0.0;
        boolean anyNull = false;
        FormatId outputFormatId = null;
        if (cell == null) {
            anyNull = true;
        } else {
            Value v = (Value)cell.getValue();
            if (v.isError()) {
                return v;
            }
            double value = cell.getDoubleValue();
            if (Double.isNaN(value)) {
                anyNull = true;
            } else {
                switch (opId) {
                    case 0: {
                        allNull = false;
                        outputValue = 0.0;
                        break;
                    }
                    case 1: {
                        if (allNull) {
                            allNull = false;
                            outputValue = value;
                        } else {
                            outputValue += value;
                        }
                        outputFormatId = ROLAPVirtualQueryStrategy.calculateMergeFormatId("Add", outputFormatId, cell);
                        break;
                    }
                    case 2: {
                        if (allNull) {
                            allNull = false;
                            outputValue = value;
                        } else {
                            outputValue *= value;
                        }
                        outputFormatId = ROLAPVirtualQueryStrategy.calculateMergeFormatId("Multiply", outputFormatId, cell);
                        break;
                    }
                    case 3: {
                        if (allNull) {
                            allNull = false;
                            outputValue = value * -1.0;
                        } else {
                            outputValue -= value;
                        }
                        outputFormatId = ROLAPVirtualQueryStrategy.calculateMergeFormatId("Subtract", outputFormatId, cell);
                        break;
                    }
                    case 4: {
                        if (allNull) {
                            outputValue = value;
                            allNull = false;
                        } else {
                            outputValue = value != 0.0 ? (outputValue /= value) : Double.NaN;
                        }
                        outputFormatId = ROLAPVirtualQueryStrategy.calculateMergeFormatId("Divide", outputFormatId, cell);
                        break;
                    }
                    case 5: {
                        if (allNull) {
                            outputValue = value;
                            allNull = false;
                        } else if (value > outputValue) {
                            outputValue = value;
                        }
                        outputFormatId = ROLAPVirtualQueryStrategy.calculateMergeFormatId("Add", outputFormatId, cell);
                        break;
                    }
                    case 6: {
                        if (allNull) {
                            outputValue = value;
                            allNull = false;
                        } else if (value < outputValue) {
                            outputValue = value;
                        }
                        outputFormatId = ROLAPVirtualQueryStrategy.calculateMergeFormatId("Add", outputFormatId, cell);
                        break;
                    }
                    case 7: {
                        if (allNull) {
                            outputValue = value;
                            allNull = false;
                        }
                        outputFormatId = ROLAPVirtualQueryStrategy.calculateMergeFormatId("Add", outputFormatId, cell);
                        break;
                    }
                    default: {
                        if (allNull) {
                            allNull = false;
                            outputValue = value;
                        } else {
                            outputValue += value;
                        }
                        outputFormatId = ROLAPVirtualQueryStrategy.calculateMergeFormatId("Add", outputFormatId, cell);
                    }
                }
            }
        }
        if ((opId == 2 || opId == 4) && anyNull) {
            allNull = true;
        }
        if (Double.isNaN(outputValue)) {
            retValue = DataValueFactory.createDoubleValue();
            retValue.setState(ValueState.DIV_BY_ZERO);
        } else if (!allNull) {
            retValue = DataValueFactory.createDoubleValue();
            if (outputFormatId != null) {
                retValue.setFormatId(outputFormatId);
            } else {
                retValue.setFormatId(FormatId.DEFAULT_NUMBER_FORMAT_FID);
            }
            retValue.set(outputValue);
        }
        return retValue;
    }
}

