/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual;

import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.StringType;
import com.cognos.xqe.exception.XQEMessageKeys_not_retranslatable;
import com.cognos.xqe.exception.XQEMessages;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IProperty;
import com.cognos.xqe.runtree.olap.mdx.metadata.Property;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPProperty;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPContext;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.IROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaAttribute;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualLevel;
import com.cognos.xqe.util.AbstractSingleLocaleString;
import com.cognos.xqe.util.ILocalizedString;
import com.cognos.xqe.util.LocaleConverter;
import com.cognos.xqe.util.LocaleUtility;
import com.cognos.xqe.util.LocalizedString;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class ROLAPVirtualProperty
extends Property
implements IROLAPProperty {
    public static final String MEMBER_KEY_PROPERTY_NAME = "MEMBER_KEY";
    public static final String SPACE = " ";
    private List<IROLAPCube> sourceCubesForProperties = new ArrayList<IROLAPCube>();
    private List<IProperty> allSourceProperties = new ArrayList<IProperty>();

    public ROLAPVirtualProperty(String name) {
        super(name);
    }

    public ROLAPVirtualProperty(String name, ILevel level) {
        super(name);
        super.setLevel(level);
        super.setDimension(level.getDimension());
        super.setHierarchy(level.getHierarchy());
    }

    @Override
    public IROLAPHierarchy getROLAPHierarchy() {
        return (IROLAPHierarchy)this.getHierarchy();
    }

    @Override
    public IROLAPLevel getROLAPLevel() {
        return (IROLAPLevel)this.getLevel();
    }

    @Override
    public String getCaption() {
        ILocalizedString lcCaption = this.getLocalizedCaption();
        String lzCaption = null;
        Locale runLocale = ExecutionEnvironmentContext.getExecutionEnvironment().getRequestEnvironment().getRunLocale();
        String locale = LocaleConverter.localeToStr(runLocale);
        if (lcCaption != null && (lzCaption = lcCaption.toString(locale = LocaleUtility.getSupportedLocale(locale, lcCaption, this.getROLAPLevel().getROLAPDimension().getROLAPCube().getDefaultLocale()))) == null) {
            lzCaption = lcCaption.toString();
        }
        if (lzCaption == null) {
            lzCaption = super.getName();
        }
        return lzCaption;
    }

    @Override
    public ILocalizedString getLocalizedCaption() {
        if (this.getInitialSourceProperty() != null && this.getInitialSourceProperty() instanceof IROLAPProperty) {
            if (this.getInitialSourceProperty().getDimension().isShareable()) {
                String previousCurrentCubeName = ROLAPContext.getCurrentCubeName();
                ROLAPContext.removeCurrentCubeName(previousCurrentCubeName != null);
                ROLAPContext.setCurrentCubeName(this.sourceCubesForProperties.get(0).getName());
                try {
                    ILocalizedString iLocalizedString = ((IROLAPProperty)this.getInitialSourceProperty()).getLocalizedCaption();
                    return iLocalizedString;
                }
                finally {
                    ROLAPContext.removeCurrentCubeName(true);
                    if (previousCurrentCubeName != null) {
                        ROLAPContext.setCurrentCubeName(previousCurrentCubeName);
                    }
                }
            }
            return ((IROLAPProperty)this.getInitialSourceProperty()).getLocalizedCaption();
        }
        ILocalizedString caption = null;
        StringBuilder newCaption = new StringBuilder();
        if (this.getUniqueName().equals(MEMBER_KEY_PROPERTY_NAME)) {
            ILocalizedString parentObjectCaption = this.getHierarchy().isParentChild() ? ((IROLAPHierarchy)this.getHierarchy()).getLocalizedCaption() : ((IROLAPLevel)this.getLevel()).getLocalizedCaption();
            String defaultLocale = parentObjectCaption.getDefaultLocale();
            String defaultCaption = this.constructPropertyCaption(defaultLocale, parentObjectCaption.toString());
            caption = new LocalizedString(defaultLocale, defaultCaption);
            for (String locale : parentObjectCaption.getSupportedLocales()) {
                String localeCaption = parentObjectCaption.toString(locale);
                caption.put(locale, this.constructPropertyCaption(locale, localeCaption));
            }
        } else {
            newCaption.append(super.getCaption());
        }
        if (caption == null) {
            caption = AbstractSingleLocaleString.getSingleLocaleString(this.getROLAPLevel().getROLAPDimension().getROLAPCube().getDefaultLocale(), newCaption.toString());
        }
        return caption;
    }

    private String constructPropertyCaption(String locale, String propertyName) {
        if (propertyName == null || locale == null) {
            return super.getCaption();
        }
        StringBuilder newCaption = new StringBuilder();
        Locale localeObject = LocaleConverter.strToLocale(locale);
        if (this.getUniqueName().equals(MEMBER_KEY_PROPERTY_NAME)) {
            newCaption.append(propertyName);
            newCaption.append(SPACE + XQEMessages.getMessage(XQEMessageKeys_not_retranslatable.LOC_KEY_SUFFIX, localeObject));
        } else {
            newCaption.append(propertyName);
        }
        return newCaption.toString();
    }

    @Override
    public String getUniqueName() {
        if (this.uniqueName == null) {
            this.uniqueName = UniqueNameGenerator.createUniqueName(this.getName());
            if (this.hierarchy != null && this.hierarchy.isParentChild()) {
                this.uniqueName = UniqueNameGenerator.join(this.hierarchy.getUniqueName(), this.uniqueName);
            } else if (this.level != null) {
                this.uniqueName = UniqueNameGenerator.join(this.level.getUniqueName(), this.uniqueName);
            }
        }
        return this.uniqueName;
    }

    @Override
    public IDataType getDataType() {
        ROLAPMetaAttribute businessKeyAttribute;
        if (this.dataType != null) {
            return this.dataType;
        }
        ROLAPVirtualLevel virtualLevel = (ROLAPVirtualLevel)this.getLevel();
        List<ROLAPMetaLevel> sourceMetaLevels = virtualLevel.getSourceMetaLevels();
        for (ROLAPMetaLevel sourceMetaLevel : sourceMetaLevels) {
            businessKeyAttribute = sourceMetaLevel.getBusinessKey();
            if (businessKeyAttribute == null) continue;
            this.dataType = businessKeyAttribute.getDataType();
            return this.dataType;
        }
        for (ROLAPMetaLevel sourceMetaLevel : sourceMetaLevels) {
            businessKeyAttribute = sourceMetaLevel.getCaption();
            if (businessKeyAttribute == null) continue;
            this.dataType = businessKeyAttribute.getDataType();
            return this.getDataType();
        }
        for (ROLAPMetaLevel sourceMetaLevel : sourceMetaLevels) {
            businessKeyAttribute = sourceMetaLevel.getLastLevelKey();
            if (businessKeyAttribute == null) continue;
            this.dataType = businessKeyAttribute.getDataType();
            return this.dataType;
        }
        this.dataType = StringType.DEFAULTSTRINGTYPE;
        return this.dataType;
    }

    public void addSourceProperty(IProperty property, IROLAPCube sourceCube) {
        if (sourceCube != null) {
            this.sourceCubesForProperties.add(sourceCube);
        }
        this.allSourceProperties.add(property);
    }

    public IProperty getInitialSourceProperty() {
        if (this.allSourceProperties.size() > 0) {
            return this.allSourceProperties.get(0);
        }
        return null;
    }

    public List<IProperty> getAllSourceProperties() {
        return this.allSourceProperties;
    }

    public List<IROLAPCube> getAllSourceCubes() {
        return this.sourceCubesForProperties;
    }
}

