/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.storage;

import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.metadata.AllLevel;
import com.cognos.xqe.runtree.olap.mdx.storage.BTreeTupleIDHelper;
import com.cognos.xqe.runtree.olap.mdx.storage.DimensionToIdCounter;
import com.cognos.xqe.runtree.olap.mdx.storage.TupleNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import org.apache.xindice.core.data.Value;
import org.apache.xindice.core.filer.BTreeException;
import org.apache.xindice.core.filer.BTreeNotFoundException;
import org.apache.xindice.util.Configuration;

public class AdaptiveTupleIDHelper
extends BTreeTupleIDHelper {
    private static final int ALL_MEMBER_UNIQUE_ID = 0;
    private DimensionToIdCounter dimensionCounter = new DimensionToIdCounter();
    private boolean bUseMemberId = false;

    public AdaptiveTupleIDHelper(String fileName, Configuration config, boolean create, boolean deleteFiles, boolean includeUser) {
        super(fileName, config, create, deleteFiles, includeUser);
    }

    public AdaptiveTupleIDHelper(String fileName, Configuration config, boolean create, boolean deleteFiles, boolean includeUser, boolean bUseMemberID) {
        super(fileName, config, create, deleteFiles, includeUser);
        this.bUseMemberId = bUseMemberID;
    }

    @Override
    public int getIndexIDForMember(IMember mem, boolean create) throws TupleNotFoundException {
        ILevel level = mem.getLevel();
        if (level.isRootLevel() && !mem.isMeasure() && !mem.isCalculatedMember() || level instanceof AllLevel) {
            return 0;
        }
        if (this.isUseMemberId()) {
            return super.getIndexIDForMember(mem, create);
        }
        return this.getIndexIDForMemberName(mem.getDimension().getUniqueName(), mem.getUniqueName(), create);
    }

    @Override
    public int getIndexIDForMemberName(String dimName, String memName, boolean create) throws TupleNotFoundException {
        int id;
        block8: {
            id = -1;
            try {
                Value memKey = new Value(memName);
                try {
                    id = (int)this.indexFindValue(memKey);
                }
                catch (BTreeNotFoundException e) {
                    if (create) {
                        String maxDimIDKey = dimName + ":__MaxID__";
                        Value maxKey = new Value(maxDimIDKey);
                        id = 1;
                        try {
                            id = (int)this.indexFindValue(maxKey);
                            ++id;
                        }
                        catch (BTreeNotFoundException bTreeNotFoundException) {
                            // empty catch block
                        }
                        this.indexAddValue(maxKey, id);
                        this.indexAddValue(memKey, id);
                        break block8;
                    }
                    throw new TupleNotFoundException("X01507", new String[]{memName}, e);
                }
            }
            catch (IOException e) {
                throw new XQERuntimeException(e);
            }
            catch (BTreeException e) {
                throw new XQERuntimeException(e);
            }
        }
        return id;
    }

    @Override
    protected byte[] tupleToByteArray(Tuple t, String userName, boolean create) throws TupleNotFoundException {
        int iSize = t.size();
        int maxActualOrder = 0;
        int[] tupleOrder = new int[iSize];
        int[] memberIds = new int[iSize];
        for (int i = 0; i < iSize; ++i) {
            int memberId;
            int order;
            IMember m = t.getMember(i);
            IDimension d = m.getDimension();
            tupleOrder[i] = order = this.dimensionCounter.getDimensionIndex(d);
            memberIds[i] = memberId = this.getIndexIDForMember(m, create);
            if (memberId == 0 || order <= maxActualOrder) continue;
            maxActualOrder = order;
        }
        int tSize = maxActualOrder + 1;
        if (this.includeUserID) {
            ++tSize;
        }
        int userID = -1;
        if (this.includeUserID && userName != null) {
            userID = this.getIndexIDForUserName(userName, create);
        }
        byte[] b = new byte[tSize * this.bytesPerID];
        Arrays.fill(b, (byte)0);
        int userIdOffset = 0;
        if (this.includeUserID) {
            int j = userIdOffset;
            for (int k = this.bytesPerID - 1; k >= 0; --k) {
                b[j] = (byte)((userID >> 8 * k) - 128 & 0xFF);
                ++j;
            }
            ++userIdOffset;
        }
        for (int i = 0; i < iSize; ++i) {
            int memberOrderValue = memberIds[i];
            int reOrderIndex = tupleOrder[i];
            int j = 0;
            if (memberOrderValue == 0) continue;
            j = (reOrderIndex + userIdOffset) * this.bytesPerID;
            for (int k = this.bytesPerID - 1; k >= 0; --k) {
                b[j] = (byte)((memberOrderValue >> 8 * k) - 128 & 0xFF);
                ++j;
            }
        }
        return b;
    }

    private boolean isUseMemberId() {
        return this.bUseMemberId;
    }
}

