/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate;

import com.cognos.xqe.data.values.IAddable;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.AggregateTypeEnum;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Cell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.TupleValue;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPCallable;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.AggregateCalculationMetrics;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.AggregateCalculationResult;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.CalculationDescription;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.CellCache;
import com.cognos.xqe.trace.LogLevel;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;

public abstract class AbstractAggregateCalculationTask
extends ROLAPCallable<Void> {
    protected static final String ADDITIONAL_LOG_MSG_TEXT = "%additional_text%";
    private static final int ONE_HUNDRED = 100;
    private final IHierarchy[] hiers;
    private final List<Set<IMember>> filterMeasures;
    private final List<CalculationDescription> calcDescriptions;
    private final BlockingQueue<AggregateCalculationResult> resultQueue;
    private Iterator<TupleValue> aggregateTupleIterator = null;

    public AbstractAggregateCalculationTask(ROLAPCube cube, BlockingQueue<AggregateCalculationResult> aResultQueue, IHierarchy[] hierarchies, List<CalculationDescription> calculcationDescriptions, List<Set<IMember>> aFilterMeasures) {
        super(cube);
        this.hiers = hierarchies;
        this.resultQueue = aResultQueue;
        this.calcDescriptions = calculcationDescriptions;
        this.filterMeasures = aFilterMeasures;
    }

    public void setAggregateData(Iterator<TupleValue> theAggregateTupleIterator) {
        this.aggregateTupleIterator = theAggregateTupleIterator;
    }

    @Override
    public Void callImpl() throws Exception {
        ROLAPLog.logOpStart(LogLevel.INFO, "ROLAPCubes.AggregateCache", "AggregateCalculationTask starting");
        int numberOfTasksThatBuiltResult = 1;
        AggregateCalculationMetrics metrics = new AggregateCalculationMetrics();
        XQERuntimeException error = null;
        String logMsg = null;
        int numCalcDescriptions = this.calcDescriptions.size();
        try {
            CellCache[] cellCaches = new CellCache[numCalcDescriptions];
            for (int i = 0; i < numCalcDescriptions; ++i) {
                cellCaches[i] = new CellCache(this.hiers);
            }
            long rollupStartTime = System.currentTimeMillis();
            ArrayList<Cell> cellList = new ArrayList<Cell>();
            IMember[][] rollupMembersByCalc = new IMember[numCalcDescriptions][];
            for (int i = 0; i < rollupMembersByCalc.length; ++i) {
                rollupMembersByCalc[i] = new IMember[this.hiers.length];
            }
            boolean[] tupleMembersFullyPopulatedByCalc = new boolean[numCalcDescriptions];
            Arrays.fill(tupleMembersFullyPopulatedByCalc, false);
            IMember[] previousAggregateTupleMembers = new IMember[this.hiers.length];
            long aggregateRowCount = 0L;
            long[] numTuplesSkippedPerCalculation = new long[numCalcDescriptions];
            int measuresIndex = -1;
            while (this.aggregateTupleIterator.hasNext()) {
                TupleValue tv = this.aggregateTupleIterator.next();
                ++aggregateRowCount;
                Cell c = tv.getCell();
                Tuple aggregateTuple = tv.getTuple();
                if (measuresIndex == -1) {
                    measuresIndex = Tuple.getMeasureIndex(aggregateTuple, true);
                }
                for (int i = 0; i < numCalcDescriptions; ++i) {
                    IMember[] rollupMembers;
                    Set<IMember> filterMeasuresForThisCalc;
                    if (this.filterMeasures != null && (filterMeasuresForThisCalc = this.filterMeasures.get(i)) != null && filterMeasuresForThisCalc.contains(aggregateTuple.getMember(measuresIndex))) {
                        int n = i;
                        numTuplesSkippedPerCalculation[n] = numTuplesSkippedPerCalculation[n] + 1L;
                        tupleMembersFullyPopulatedByCalc[i] = false;
                        continue;
                    }
                    CalculationDescription calcDescription = this.calcDescriptions.get(i);
                    if (this.calcRollupMembers(aggregateTuple, calcDescription, rollupMembers = rollupMembersByCalc[i], previousAggregateTupleMembers, tupleMembersFullyPopulatedByCalc[i])) {
                        tupleMembersFullyPopulatedByCalc[i] = true;
                        ArrayList<Cell> cellsNeedingUpdate = cellCaches[i].getCachedCells(rollupMembers);
                        if (cellsNeedingUpdate == null) {
                            cellList.clear();
                            boolean addedNewCells = this.calcRollupCellsToUpdate(i, rollupMembers, c, cellList);
                            if (!addedNewCells) {
                                cellCaches[i].putCachedCells(rollupMembers, cellList);
                            }
                            cellsNeedingUpdate = cellList;
                        }
                        if (cellsNeedingUpdate.size() <= 0) continue;
                        AbstractAggregateCalculationTask.updateExistingCells(cellsNeedingUpdate, c, rollupMembers[measuresIndex].getRegularAggregate());
                        continue;
                    }
                    tupleMembersFullyPopulatedByCalc[i] = false;
                }
                System.arraycopy(aggregateTuple.getMembers(), 0, previousAggregateTupleMembers, 0, previousAggregateTupleMembers.length);
            }
            metrics.setAggregateRollupTime(System.currentTimeMillis() - rollupStartTime);
            metrics.setCellsInAggregateQuery(aggregateRowCount);
            metrics.setCellsInRequestedQuery(this.getResultSize());
            metrics.setCellRollupLocations(numCalcDescriptions);
            if (ROLAPLog.isOn("ROLAPCubes.AggregateCache", LogLevel.INFO)) {
                String numTuplesIgnoedText = " cells with 0 tuples ignored.";
                for (Object numTuplesIgnored : (Cell)numTuplesSkippedPerCalculation) {
                    if (numTuplesIgnored <= 0L) continue;
                    numTuplesIgnoedText = " cells with " + Arrays.toString(numTuplesSkippedPerCalculation) + " tuples ignored by calculation.";
                    break;
                }
                NumberFormat nf = NumberFormat.getInstance();
                StringBuilder sb = new StringBuilder("Aggregate calc thread finished.  Processed ");
                sb.append(nf.format(metrics.getCellsInAggregateQuery()));
                sb.append(numTuplesIgnoedText);
                sb.append("  Rollup time : ");
                sb.append(nf.format(metrics.getAggregateRollupTime()));
                sb.append(" ms into ");
                sb.append(nf.format(metrics.getCellsInRequestedQuery()));
                sb.append(" cells ");
                sb.append(ADDITIONAL_LOG_MSG_TEXT);
                sb.append("  Result combination time %combo_time%ms, representing %calc_threads% calc threads.");
                sb.append("   Cell cache hit rate:");
                for (CellCache cellCache : cellCaches) {
                    int totalAccesses = cellCache.getCacheHits() + cellCache.getCacheMisses();
                    int hitPct = 0;
                    if (totalAccesses > 0) {
                        hitPct = cellCache.getCacheHits() * 100 / totalAccesses;
                    }
                    sb.append(' ');
                    sb.append(String.valueOf(hitPct));
                    sb.append('%');
                }
                logMsg = this.extendLogMsg(sb.toString());
            }
            long combineTimeStart = System.currentTimeMillis();
            numberOfTasksThatBuiltResult = this.combineWithOtherTaskResults(metrics);
            if (ROLAPLog.isOn("ROLAPCubes.AggregateCache", LogLevel.INFO)) {
                logMsg = logMsg.replace("%combo_time%", NumberFormat.getInstance().format(System.currentTimeMillis() - combineTimeStart));
                logMsg = logMsg.replace("%calc_threads%", NumberFormat.getInstance().format(numberOfTasksThatBuiltResult));
            }
        }
        catch (Throwable t) {
            error = (XQERuntimeException)XQERuntimeException.wrap(t);
            logMsg = "AggregateCalculationTask had an error.";
            ROLAPLog.logError("ROLAPCubes.AggregateCache", logMsg, t);
        }
        AggregateCalculationResult result = this.createResult();
        result.setCommonData(error, metrics, numberOfTasksThatBuiltResult);
        this.resultQueue.add(result);
        ROLAPLog.logOpEnd(LogLevel.INFO, "ROLAPCubes.AggregateCache", logMsg);
        return null;
    }

    private int combineWithOtherTaskResults(AggregateCalculationMetrics metrics) {
        int numberOfTasks = 1;
        AggregateCalculationResult result = (AggregateCalculationResult)this.resultQueue.poll();
        while (result != null) {
            if (result.getException() == null) {
                this.combineResults(result);
                metrics.add(result.getMetrics());
                numberOfTasks += result.getNumberOfTasks();
                result = (AggregateCalculationResult)this.resultQueue.poll();
                continue;
            }
            this.resultQueue.add(result);
            break;
        }
        return numberOfTasks;
    }

    private boolean calcRollupMembers(Tuple aggregateTuple, CalculationDescription calcDescription, IMember[] rollupMembers, IMember[] previousAggregateMembers, boolean usePreviousAggregateMembers) {
        boolean tupleIsInQuerySet = true;
        IMember[] knownParents = calcDescription.getKnownParents();
        Set<IMember>[] validParentMembers = calcDescription.getParentMembers();
        int[] rollupDistances = calcDescription.getHierarchyRollupDistances();
        IMember[] aggregateMembers = aggregateTuple.getMembers();
        for (int i = 0; i < aggregateMembers.length && tupleIsInQuerySet; ++i) {
            if (knownParents[i] != null) {
                rollupMembers[i] = knownParents[i];
                continue;
            }
            if (usePreviousAggregateMembers && previousAggregateMembers[i] == aggregateMembers[i]) continue;
            rollupMembers[i] = aggregateMembers[i];
            for (int j = 0; j < rollupDistances[i]; ++j) {
                rollupMembers[i] = rollupMembers[i].getParent();
            }
            if (validParentMembers[i] == null || validParentMembers[i].contains(rollupMembers[i])) continue;
            tupleIsInQuerySet = false;
        }
        return tupleIsInQuerySet;
    }

    protected abstract String extendLogMsg(String var1);

    protected abstract boolean calcRollupCellsToUpdate(int var1, IMember[] var2, Cell var3, ArrayList<Cell> var4);

    protected abstract AggregateCalculationResult createResult();

    protected abstract void combineResults(AggregateCalculationResult var1);

    protected abstract int getResultSize();

    protected static void updateExistingCells(ArrayList<Cell> cells, Cell aggregateCell, AggregateTypeEnum measureType) {
        int numCells = cells.size();
        block4: for (int i = 0; i < numCells; ++i) {
            Cell originalQueryCell = cells.get(i);
            IValue origValue = originalQueryCell.getValue();
            switch (measureType) {
                case MAX: {
                    if (origValue.compareTo(aggregateCell.getValue()) >= 0) continue block4;
                    originalQueryCell.setValue((IValue)aggregateCell.getValue().copy());
                    continue block4;
                }
                case MIN: {
                    if (origValue.compareTo(aggregateCell.getValue()) <= 0) continue block4;
                    originalQueryCell.setValue((IValue)aggregateCell.getValue().copy());
                    continue block4;
                }
                default: {
                    ((IAddable)origValue).add(aggregateCell.getValue());
                }
            }
        }
    }
}

