/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate;

import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.resultset.interfaces.ISet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.aggregate.DataCacheAggregateDefinition;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.AggregateCalculationEngine;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.AggregateCubeletStorage;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.Cubelet;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.CubeletMonitor;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.CubeletStorage;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.IOrdinalValueStorage;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.util.ConfigurationValues;
import com.cognos.xqe.util.UniqueNameGenerator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class DataCacheCubeletMonitor
implements CubeletMonitor {
    public static final int DEFAULT_MAX_DATACACHE_AGGREGATE_DEFINITIONS = 0;
    private final AggregateCubeletStorage aggregateCache;
    private final CubeletStorage dataCache;
    private final int maxAggregateCount;
    private final AtomicInteger fullSliceCounter = new AtomicInteger(0);
    private final AtomicInteger cubeletsInspected = new AtomicInteger(0);

    public DataCacheCubeletMonitor(AggregateCubeletStorage theAggregateCache, CubeletStorage theDataCache) {
        this(theAggregateCache, theDataCache, ConfigurationValues.getInt("MaxDataCacheAggregateDefinitions", 0));
    }

    public DataCacheCubeletMonitor(AggregateCubeletStorage theAggregateCache, CubeletStorage theDataCache, int theMaxDataCacheAggregates) {
        this.aggregateCache = theAggregateCache;
        this.dataCache = theDataCache;
        this.maxAggregateCount = theMaxDataCacheAggregates > 0 ? theMaxDataCacheAggregates + this.aggregateCache.getAllAggregateDefinitions(false).size() : 0;
    }

    @Override
    public void creationProgress(Cubelet cubelet, long tupleCount, IOrdinalValueStorage valuesStorage) {
    }

    @Override
    public long getCreationNotificationInterval() {
        return -1L;
    }

    @Override
    public void creationFailed(ISet set, Cubelet cubelet) {
    }

    @Override
    public void creationSuccessful(ISet cubeletSet, Cubelet cubelet) {
        ArrayList<ILevel> levels;
        ArrayList<IMember> measures;
        this.cubeletsInspected.incrementAndGet();
        if (this.maxAggregateCount > this.aggregateCache.getAvailableAggregateDefinitions(true).size() && this.onlyFullSlicesWithAdditiveMeasures(cubeletSet, measures = new ArrayList<IMember>(), levels = new ArrayList<ILevel>())) {
            String aggregateName = this.generateAggregateName(levels);
            cubelet.setHint(aggregateName);
            IMember[] measuresArray = measures.toArray(new IMember[measures.size()]);
            DataCacheAggregateDefinition aggregateDef = new DataCacheAggregateDefinition(aggregateName, levels, measuresArray, cubelet.getNumValues(), cubelet.getBaseIncrementId(), this.dataCache);
            this.aggregateCache.notifyAggregateDefinitionLoaded(aggregateDef);
            if (ROLAPLog.isOn("ROLAPCubes.AggregateCache", LogLevel.INFO)) {
                ROLAPLog.log("ROLAPCubes.AggregateCache", String.format("DataCache aggregate definition added %s containing %,d cells using %,d bytes.  Aggregate cache now has %,d aggregates, and %,d data cache cubelets have been inspected.", aggregateDef.getName(), cubelet.getNumValues(), cubelet.getMemoryUsage(), this.aggregateCache.getAvailableAggregateDefinitions(true).size(), this.cubeletsInspected.get()));
            }
        }
    }

    private String generateAggregateName(List<ILevel> levels) {
        StringBuilder sb = new StringBuilder("DataCache_");
        boolean needComma = false;
        for (ILevel l : levels) {
            if (l.getIndex() <= 0 && l.getCardinality() <= 1) continue;
            if (needComma) {
                sb.append(',');
            }
            sb.append(UniqueNameGenerator.createUniqueName(l.getName()));
            needComma = true;
        }
        sb.append('_');
        sb.append(this.fullSliceCounter.incrementAndGet());
        return sb.toString();
    }

    private boolean onlyFullSlicesWithAdditiveMeasures(ISet set, List<IMember> measures, List<ILevel> levels) {
        IMember[][] members;
        IHierarchy[] setHierarchies = set.getHierarchies();
        for (IMember[] hierMembers : members = ((Set)set).getMembers(setHierarchies)) {
            if (hierMembers[0].getDimension().isMeasuresDimension()) {
                boolean foundAdditiveMeasure = false;
                for (IMember measure : hierMembers) {
                    measures.add(measure);
                    if (!AggregateCalculationEngine.canRollupMeasure(measure)) continue;
                    foundAdditiveMeasure = true;
                }
                if (foundAdditiveMeasure) continue;
                return false;
            }
            ILevel level = hierMembers[0].getLevel();
            if (level.getCardinality() != hierMembers.length) {
                return false;
            }
            if (!level.getHierarchy().isParentChild() || level.getIndex() == 0) continue;
            return false;
        }
        for (IMember[] hierMembers : members) {
            if (hierMembers[0].getDimension().isMeasuresDimension()) continue;
            HashSet<IMember> memberSet = new HashSet<IMember>(hierMembers.length);
            ILevel level = hierMembers[0].getLevel();
            for (IMember member : hierMembers) {
                if (!member.getLevel().equals(level)) {
                    return false;
                }
                if (memberSet.add(member)) continue;
                return false;
            }
            levels.add(level);
        }
        return true;
    }
}

