/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet;

import com.cognos.xqe.bibushandler.CancelManager;
import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.bibushandler.RequestMetrics;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.resultset.interfaces.ISet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Cell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.ResultSetToListAdaptor;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.TupleValue;
import com.cognos.xqe.runtree.olap.mdx.interpreter.pipeline.ConsumerEndedException;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.LOLAPMediator;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.LOLAPMemberProxy;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.tm1.LOLAPTM1Cube;
import com.cognos.xqe.runtree.olap.mdx.metadata.Cube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPCallable;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPContext;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.BlockTupleStorageUtil;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.OrdinalValue;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.VectorValue;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.AggregateCalculationEngine;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.combination.BlockTupleStorageFetchResult;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.AbstractQueuedIntersectionAction;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.ArrayOrdinalValueStorage;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.ArrayVectorValueStorage;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.BaseOrdinalValueStorage;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.CubeletIntersectionAction;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.CubeletIntersectionTaskAction;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.CubeletMonitor;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.CubeletStorage;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.DoubleNativeValueStorage;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.IOrdinalValueStorage;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.IOrdinalValueStorageFetcher;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.ResultSetIntersectionInterface;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.TupleValueListIntersectionInterface;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.VectorDoubleNativeValueStorage;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.ArrayCast;
import com.cognos.xqe.util.JavaObjectMemorySize;
import com.cognos.xqe.util.concurrent.ThreadPool;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqe.util.primitive.HashMapIntObject;
import com.cognos.xqe.util.primitive.HashSetInt;
import com.cognos.xqe.util.primitive.IntArrayList;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.configuration.ConversionException;

public class Cubelet {
    private static volatile int defaultMaxThreadsUsed = -1;
    private static final String USE_THREADS_FOR_LOOKUP = "UseThreadsForCubeletLookup";
    private static final String AUTO_CALC_NUM_THREADS = "AutomaticallyCalculateNumThreads";
    public static final String NUM_THREADS_TO_USE = "NumberOfThreadsToUse";
    protected static final int NUM_THREADS_DEFAULT = 2;
    private static final int SMALLEST_DEFAULT_MAX_NUM_THREADS = 4;
    private static final String MAX_NUM_THREADS = "MaxNumberOfThreadsToUse";
    private static final int NUM_CONCURRENT_CUBELET_POPULATES = 16;
    protected static final int USE_THREADS_THRESHOLD_DEFAULT = 25000;
    public static final String USE_THREADS_THRESHOLD = "ThresholdForUsingThreads";
    protected static final int NUM_TUPLES_THRESHOLD_DEFAULT = 5000;
    public static final String NUM_TUPLES_THRESHOLD = "MinNumberOfTuplesPerThread";
    protected static final int NUM_TUPLES_PER_BLOCK_DEFAULT = 75000;
    private static final String NUM_TUPLES_PER_BLOCK = "NumberOfTuplesPerBlock";
    private static final String CALC_ORDINALS = "CalculateTupleOrdinalsInThreads";
    public static final String STORE_BY_MEMBERID = "CubeletStoreValuesByMemberId";
    private static final boolean COLLECT_USAGE_DATA = true;
    private static final int CUBELET_STATIC_SIZE = 480;
    private static final byte ONE_HUNDRED = 100;
    protected static final String NEWLINE = System.getProperty("line.separator");
    protected static XQELogger traceLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "TupleStorage", LogLevel.TRACE);
    protected volatile long creationTime;
    private volatile long lastDataReuseTime;
    private AtomicLong completeDataHitCount;
    private AtomicLong partialDataHitNoReuseCount;
    private AtomicLong partialDataHitReuseCount;
    protected long estimatedMemoryUsage = Long.MIN_VALUE;
    private CubeletMonitor monitor = null;
    private String hint = null;
    protected int[][] intQuerySet;
    protected HashSetInt[] selectionLevels;
    protected long[] pageSizes;
    protected ICube cube;
    protected IValue defaultValue;
    protected IOrdinalValueStorage valuesStorage;
    protected HashMapIntObject<IMember>[] membersMap;
    protected int numValues = 0;
    protected long numQuerySetTuples = 0L;
    protected String storedDataType = null;
    private boolean storingByOrdinals = true;

    private static MultiRequestContext getCurrentMultiRequestContext() {
        return ExecutionEnvironmentContext.getExecutionEnvironment().getMultiRequestContext();
    }

    public static boolean isThreadsEnabled() {
        boolean ans;
        try {
            ans = Cubelet.getCurrentMultiRequestContext().fetchBooleanConfiguration(USE_THREADS_FOR_LOOKUP, true);
        }
        catch (ConversionException e) {
            ans = true;
        }
        return ans;
    }

    public static boolean autoCalcNumThreads() {
        boolean auto;
        try {
            auto = Cubelet.getCurrentMultiRequestContext().fetchBooleanConfiguration(AUTO_CALC_NUM_THREADS, true);
        }
        catch (ConversionException e) {
            auto = true;
        }
        return auto;
    }

    public static int getNumThreads() {
        int num;
        try {
            num = Cubelet.getCurrentMultiRequestContext().fetchgetIntConfiguration(NUM_THREADS_TO_USE, 2);
            if (num < 2) {
                num = 2;
            }
        }
        catch (ConversionException e) {
            num = 2;
        }
        return num;
    }

    public static int getMaxNumThreads() {
        int max;
        try {
            max = Cubelet.getCurrentMultiRequestContext().fetchgetIntConfiguration(MAX_NUM_THREADS, Cubelet.getDefaultMaxThreads());
            if (max < 2) {
                max = Cubelet.getDefaultMaxThreads();
            }
        }
        catch (ConversionException e) {
            max = Cubelet.getDefaultMaxThreads();
        }
        return max;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int getDefaultMaxThreads() {
        if (defaultMaxThreadsUsed != -1) return defaultMaxThreadsUsed;
        String string = MAX_NUM_THREADS;
        synchronized (MAX_NUM_THREADS) {
            if (defaultMaxThreadsUsed != -1) return defaultMaxThreadsUsed;
            defaultMaxThreadsUsed = Math.max(4, ThreadPool.getInstance().getMaximumPoolSize() / 16);
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultMaxThreadsUsed;
        }
    }

    public static int getUseThreadsThreshold() {
        int threshold;
        try {
            threshold = Cubelet.getCurrentMultiRequestContext().fetchgetIntConfiguration(USE_THREADS_THRESHOLD, 25000);
            if (threshold < 1) {
                threshold = 25000;
            }
        }
        catch (ConversionException e) {
            threshold = 25000;
        }
        return threshold;
    }

    public static int getNumTuplesThreshold() {
        int tuples;
        try {
            tuples = Cubelet.getCurrentMultiRequestContext().fetchgetIntConfiguration(NUM_TUPLES_THRESHOLD, 5000);
            if (tuples < 1) {
                tuples = 5000;
            }
        }
        catch (ConversionException e) {
            tuples = 5000;
        }
        return tuples;
    }

    public static int getNumTuplesInBlockToReturn() {
        int tuples;
        try {
            tuples = Cubelet.getCurrentMultiRequestContext().fetchgetIntConfiguration(NUM_TUPLES_PER_BLOCK, 75000);
            if (tuples < 1) {
                tuples = 75000;
            }
        }
        catch (ConversionException e) {
            tuples = 75000;
        }
        return tuples;
    }

    public static boolean getCalcOrdinals() {
        boolean calcOrds;
        try {
            calcOrds = Cubelet.getCurrentMultiRequestContext().fetchBooleanConfiguration(CALC_ORDINALS, true);
        }
        catch (ConversionException e) {
            calcOrds = true;
        }
        return calcOrds;
    }

    private static boolean getConfigStoreValuesByMemberIds(boolean largeSet) {
        if (largeSet) {
            return true;
        }
        boolean useMemberId = false;
        try {
            useMemberId = Cubelet.getCurrentMultiRequestContext().fetchBooleanConfiguration(STORE_BY_MEMBERID, false);
        }
        catch (ConversionException e) {
            useMemberId = false;
        }
        return useMemberId;
    }

    private OrdinalValue createOrdinalValue() {
        return this.valuesStorage.createOrdinalValue();
    }

    protected Cubelet() {
        this.initUsageParameter();
        this.estimatedMemoryUsage = 0L;
        this.logCubelet();
    }

    protected Cubelet(ISet set, Iterator<TupleValue> tupleValues, String cubeletID) {
        this(set, tupleValues, null, cubeletID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cubelet(ISet set, Iterator<TupleValue> tupleValues, CubeletMonitor aMonitor, String cubeletID) {
        boolean creationSuccessful = false;
        try {
            this.initUsageParameter();
            this.monitor = aMonitor;
            this.setHint(cubeletID);
            this.buildAxes(set);
            this.initCubeletParameters(tupleValues);
            this.logCubelet();
            creationSuccessful = true;
        }
        finally {
            if (this.monitor != null) {
                if (creationSuccessful) {
                    this.monitor.creationSuccessful(set, this);
                } else {
                    this.monitor.creationFailed(set, this);
                }
                this.monitor = null;
            }
        }
    }

    protected void initUsageParameter() {
        long ticks;
        this.lastDataReuseTime = this.creationTime = (ticks = System.currentTimeMillis());
        this.completeDataHitCount = new AtomicLong();
        this.partialDataHitNoReuseCount = new AtomicLong();
        this.partialDataHitReuseCount = new AtomicLong();
    }

    private void initCubeletParameters(Iterator<TupleValue> tupleValues) {
        if (Cubelet.getConfigStoreValuesByMemberIds(this.isLargeSet())) {
            this.valuesStorage = new ArrayVectorValueStorage();
            this.storingByOrdinals = false;
        } else {
            this.valuesStorage = new ArrayOrdinalValueStorage();
            this.storingByOrdinals = true;
        }
        this.computePageSizes();
        this.numValues = this.mapOrdinalValuesFromTupleValues(tupleValues);
        this.estimatedMemoryUsage = this.estimateMemoryUsage();
    }

    protected void logCubelet() {
        if (traceLogger.isOn(LogLevel.TRACE)) {
            long ticks2 = System.currentTimeMillis() - this.creationTime;
            traceLogger.log(String.format("Cubelet construct time: %,d ms", ticks2));
        }
    }

    protected void buildAxes(ISet set) {
        IHierarchy[] setHierarchies = set.getHierarchies();
        int hierCount = setHierarchies.length;
        this.cube = setHierarchies[0].getDimension().getCube();
        LOLAPMediator<Boolean> mediator = new LOLAPMediator<Boolean>(() -> ICube.CubeTypeEnum.TMR == this.cube.getType(), () -> ((LOLAPTM1Cube)this.cube).getTM1ServerVersion());
        int nonProjHierCount = 0;
        if (mediator.applicable(LOLAPMediator.Condition.LESS_THAN, "11.8.00600.6")) {
            for (int i = 0; i < hierCount; ++i) {
                IMember[] selectionsMemArray = (IMember[])ArrayCast.uncheckedCast(((Set)set).getMembers(setHierarchies[i]));
                if (!(selectionsMemArray[0] instanceof LOLAPMemberProxy) || setHierarchies[i].getDimension().getHierarchyCount() <= 1 || !((LOLAPMemberProxy)selectionsMemArray[0]).isMultiHierarchySlicer()) continue;
                ++nonProjHierCount;
            }
        }
        this.membersMap = (HashMapIntObject[])ArrayCast.uncheckedCast(new HashMapIntObject[hierCount - nonProjHierCount]);
        this.intQuerySet = new int[hierCount - nonProjHierCount][];
        this.selectionLevels = new HashSetInt[hierCount - nonProjHierCount];
        int i = -1;
        for (IHierarchy hier : setHierarchies) {
            IMember[] selectionsMemArray = (IMember[])ArrayCast.uncheckedCast(((Set)set).getMembers(hier));
            if (mediator.execute(LOLAPMediator.Condition.LESS_THAN, "11.8.00600.6", () -> selectionsMemArray[0] instanceof LOLAPMemberProxy && hier.getDimension().getHierarchyCount() > 1 && ((LOLAPMemberProxy)selectionsMemArray[0]).isMultiHierarchySlicer()) && Boolean.TRUE.equals(mediator.getResult())) continue;
            this.membersMap[++i] = new HashMapIntObject(selectionsMemArray.length);
            this.intQuerySet[i] = new int[selectionsMemArray.length];
            this.selectionLevels[i] = new HashSetInt();
            for (int j = 0; j < selectionsMemArray.length; ++j) {
                int memberId;
                this.intQuerySet[i][j] = memberId = this.getMemberIndex(selectionsMemArray[j]);
                this.membersMap[i].put(memberId, selectionsMemArray[j]);
                this.selectionLevels[i].add(selectionsMemArray[j].getLevel().getIndex());
            }
            Arrays.sort(this.intQuerySet[i]);
        }
    }

    protected int getMemberIndex(IMember mun) {
        return ((Cube)this.cube).getMemberIndex(mun);
    }

    protected BigInteger getSetSize() {
        if (this.intQuerySet.length == 0) {
            return BigInteger.ZERO;
        }
        BigInteger size = BigInteger.ONE;
        for (int[] set : this.intQuerySet) {
            size = size.multiply(BigInteger.valueOf(set.length));
        }
        return size;
    }

    public boolean isLargeSet() {
        return BlockTupleStorageUtil.isLargeSet(this.getSetSize());
    }

    public boolean isStoringByOrdinals() {
        return this.storingByOrdinals;
    }

    private int mapOrdinalValuesFromTupleValues(Iterator<TupleValue> tupleValues) {
        boolean storingByMemberIds;
        int[] memberIds = new int[this.intQuerySet.length];
        int[] memberOffsets = new int[this.intQuerySet.length];
        long monitorInterval = this.monitor != null ? this.monitor.getCreationNotificationInterval() : -1L;
        IExecutionEnvironment execEnv = ExecutionEnvironmentContext.getExecutionEnvironment();
        RequestEnvironment reqEnv = (RequestEnvironment)execEnv.getRequestEnvironment();
        RequestMetrics reqMetrics = reqEnv.getRequestMetrics();
        boolean allDoubleValues = true;
        int valueCount = 0;
        VectorValue commonOrdinalValueLarge = new VectorValue(memberIds, null);
        boolean bl = storingByMemberIds = !this.isStoringByOrdinals();
        while (tupleValues.hasNext()) {
            String msg;
            TupleValue aTupleValue = tupleValues.next();
            if (aTupleValue == null) continue;
            Tuple aTuple = aTupleValue.getTuple();
            IMember[] members = aTuple.getMembers();
            int j = 0;
            for (int i = 0; i < members.length; ++i) {
                if (null == members[i]) continue;
                if (j < this.intQuerySet.length) {
                    memberIds[j++] = this.getMemberIndex(members[i]);
                    continue;
                }
                msg = "Tuple [" + aTuple + "] has a member [" + members[i].getUniqueName() + "that is not in the querySet.";
                throw new IllegalStateException(msg);
            }
            IValue valueToStore = aTupleValue.getCell().getValue();
            if (this.storedDataType == null) {
                this.setStoredDataType(valueToStore);
            }
            if (valueCount == 0) {
                if (valueToStore.getDataType().isDouble()) {
                    this.valuesStorage = storingByMemberIds ? new VectorDoubleNativeValueStorage(memberIds.length) : new DoubleNativeValueStorage();
                } else {
                    allDoubleValues = false;
                }
            } else if (allDoubleValues && !valueToStore.getDataType().isDouble()) {
                this.convertStorage(valueCount);
                allDoubleValues = false;
            }
            if (storingByMemberIds) {
                VectorValue ov = commonOrdinalValueLarge;
                if (!allDoubleValues) {
                    int[] newMemberIds = new int[memberIds.length];
                    System.arraycopy(memberIds, 0, newMemberIds, 0, memberIds.length);
                    ov = new VectorValue(newMemberIds, valueToStore);
                } else {
                    ov.setValue(valueToStore);
                }
                this.valuesStorage.put(ov);
            } else {
                if ((memberOffsets = Cubelet.findOffset(this.intQuerySet, memberIds, memberOffsets)) == null) {
                    msg = "Tuple " + aTuple + " has a member that is not in the querySet.";
                    throw new IllegalStateException(msg);
                }
                long ordinal = this.computeOrdinalFromSetOffsets(memberOffsets);
                this.valuesStorage.put(new OrdinalValue(ordinal, valueToStore));
            }
            ++valueCount;
            if (reqMetrics != null) {
                reqMetrics.incrementCubeletsValueCount(1L);
            }
            if (this.monitor == null || (long)valueCount % monitorInterval != 0L) continue;
            this.monitor.creationProgress(this, valueCount, this.valuesStorage);
        }
        MultiRequestContext mrc = execEnv.getMultiRequestContextNoThrow();
        if (mrc != null && this.valuesStorage instanceof BaseOrdinalValueStorage) {
            ((BaseOrdinalValueStorage)this.valuesStorage).setIncrementId(mrc.getIncrementId(this.cube));
        }
        long startTime = System.currentTimeMillis();
        this.valuesStorage.fix(valueCount);
        long endTime = System.currentTimeMillis();
        this.logStorageClass(endTime - startTime, valueCount);
        return valueCount;
    }

    private void logStorageClass(long fixTime, int valueCount) {
        XQELogger aggrCacheLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "ROLAPCubes.AggregateCache", LogLevel.INFO);
        if (traceLogger.isOn(LogLevel.TRACE) || aggrCacheLogger.isOn(LogLevel.INFO) && this.hint != null) {
            String msg = String.format("Fixing cubelet values with %,d values took %,d ms.", valueCount, fixTime);
            if (this.valuesStorage instanceof VectorDoubleNativeValueStorage) {
                msg = msg + "  Bytes used per hierarchy in tuple to store values: " + Arrays.toString(((VectorDoubleNativeValueStorage)this.valuesStorage).getBytesPerHierarchyStats());
            }
            if (traceLogger.isOn(LogLevel.TRACE)) {
                traceLogger.log(LogLevel.TRACE, msg);
            } else {
                aggrCacheLogger.log(LogLevel.INFO, msg);
            }
        }
    }

    private void convertStorage(int valueCount) {
        long startTime = System.currentTimeMillis();
        this.valuesStorage.fix(valueCount);
        ArrayOrdinalValueStorage newStorage = !this.isStoringByOrdinals() ? new ArrayVectorValueStorage() : new ArrayOrdinalValueStorage();
        for (int i = 0; i < valueCount; ++i) {
            OrdinalValue ordinalValue = this.valuesStorage.get(i, null);
            newStorage.put(ordinalValue);
        }
        this.valuesStorage = newStorage;
        long endTime = System.currentTimeMillis();
        traceLogger.log(String.format("Converting the cubelet values storage with %,d values took %,d ms.", valueCount, endTime - startTime));
    }

    protected static int[] findOffset(int[][] set, int[] memberIds, int[] offsets) {
        for (int i = 0; i < set.length; ++i) {
            int position = Arrays.binarySearch(set[i], memberIds[i]);
            if (position < 0) {
                return null;
            }
            offsets[i] = position;
        }
        return offsets;
    }

    protected List<IHierarchy> getHierachies() {
        return ((Cube)this.cube).getHierarchies();
    }

    private IntersectionResult intersectSet(BlockTupleStorageFetchResult result) throws InterpreterException {
        long exceptCombinationSize;
        int requestIncrementId = MultiRequestContext.getCurrentIncrementId(this.cube);
        int baseCubletIncrementId = this.getBaseIncrementId();
        IMember[][] requestedSelections = result.getSelectionsToFetch();
        IHierarchy[] cubeHierarchies = new IHierarchy[requestedSelections.length];
        boolean bFailure = false;
        for (int i = 0; i < requestedSelections.length; ++i) {
            if (null == requestedSelections[i] || requestedSelections[i].length == 0) {
                bFailure = true;
                break;
            }
            cubeHierarchies[i] = requestedSelections[i][0].getHierarchy();
        }
        if (bFailure) {
            cubeHierarchies = this.getHierachies().toArray(new IHierarchy[0]);
        }
        int numHier = cubeHierarchies.length;
        int maxSize = 0;
        double[] percentageMissing = new double[numHier];
        IMember[][] exceptArray = new IMember[numHier][];
        int[][] intersectSetOffsets = new int[numHier][];
        int[][] intersectSetMemberIds = new int[numHier][];
        for (int[] querySet : this.intQuerySet) {
            if (maxSize >= querySet.length) continue;
            maxSize = querySet.length;
        }
        if (!this.intersectLevels(result) || requestIncrementId < baseCubletIncrementId) {
            return new IntersectionResult(requestedSelections, CubeletStorage.EMPTY_INTEGER_SET, CubeletStorage.EMPTY_INTEGER_SET);
        }
        IntArrayList offsets = new IntArrayList(maxSize);
        IntArrayList memberIds = new IntArrayList(maxSize);
        boolean allowAllMeasures = requestIncrementId == baseCubletIncrementId;
        boolean intersectIsEmpty = false;
        int memberId = -1;
        for (int i = 0; i < this.intQuerySet.length; ++i) {
            IMember[] dimSelections = requestedSelections[i];
            int arraySize = dimSelections.length;
            HashSet<IMember> exceptSet = new HashSet<IMember>();
            boolean isMeasures = dimSelections.length > 0 && dimSelections[0].getDimension().isMeasuresDimension();
            memberId = -1;
            for (IMember member : dimSelections) {
                if (!isMeasures || allowAllMeasures || AggregateCalculationEngine.canRollupMeasure(member)) {
                    memberId = this.getMemberIndex(member);
                    int position = Arrays.binarySearch(this.intQuerySet[i], memberId);
                    if (position >= 0) {
                        offsets.add(position);
                        memberIds.add(memberId);
                        continue;
                    }
                    exceptSet.add(member);
                    continue;
                }
                exceptSet.add(member);
            }
            if (offsets.size() == 0) {
                intersectIsEmpty = true;
                break;
            }
            intersectSetOffsets[i] = offsets.toArray();
            intersectSetMemberIds[i] = memberIds.toArray();
            offsets.clear();
            memberIds.clear();
            percentageMissing[i] = (double)exceptSet.size() / ((double)arraySize * 1.0);
            exceptArray[i] = exceptSet.toArray(new IMember[exceptSet.size()]);
        }
        int partialDimensions = 0;
        int emptyDimensions = 0;
        boolean emptyDimensionPresent = false;
        if (!intersectIsEmpty) {
            if (numHier > this.intQuerySet.length) {
                for (int i = this.intQuerySet.length; i < numHier; ++i) {
                    exceptArray[i] = i < requestedSelections.length ? requestedSelections[i] : new IMember[0];
                }
            }
            for (int k = 0; k < percentageMissing.length; ++k) {
                if (percentageMissing[k] < 1.0 && percentageMissing[k] > 0.0) {
                    ++partialDimensions;
                    continue;
                }
                if (percentageMissing[k] != 0.0) continue;
                emptyDimensionPresent = true;
                ++emptyDimensions;
            }
            if (emptyDimensions == numHier) {
                emptyDimensionPresent = false;
            }
            for (int[] memberOffsets : intersectSetOffsets) {
                if (memberOffsets != null && memberOffsets.length != 0) continue;
                intersectIsEmpty = true;
                break;
            }
        }
        if (intersectIsEmpty || partialDimensions > 1) {
            if (!intersectIsEmpty) {
                this.partialDataHitNoReuseCount.incrementAndGet();
            }
            return new IntersectionResult(requestedSelections, CubeletStorage.EMPTY_INTEGER_SET, CubeletStorage.EMPTY_INTEGER_SET);
        }
        if (partialDimensions <= 1 && emptyDimensionPresent) {
            for (int k = 0; k < percentageMissing.length; ++k) {
                if (percentageMissing[k] != 0.0) continue;
                exceptArray[k] = requestedSelections[k];
            }
        }
        if ((exceptCombinationSize = BlockTupleStorageUtil.getCombinationsSize(exceptArray)) > 0L) {
            this.partialDataHitReuseCount.incrementAndGet();
        } else {
            this.completeDataHitCount.incrementAndGet();
        }
        return new IntersectionResult(exceptArray, intersectSetOffsets, intersectSetMemberIds);
    }

    private boolean intersectLevels(BlockTupleStorageFetchResult result) {
        boolean levelsIntersect = true;
        for (int i = 0; i < this.selectionLevels.length && levelsIntersect && i <= result.getSelectionsToFetch().length - 1; ++i) {
            levelsIntersect = this.selectionLevels[i].containsAny(result.getLevels(i));
        }
        return levelsIntersect;
    }

    public BlockTupleStorageFetchResult fetch(BlockTupleStorageFetchResult result) throws InterpreterException {
        long ticks = -1L;
        if (traceLogger.isOn(LogLevel.TRACE)) {
            ticks = System.currentTimeMillis();
        }
        IntersectionResult matchResult = this.intersectSet(result);
        int[][] intersectSets = matchResult.getIntersectOffsets();
        if (traceLogger.isOn(LogLevel.TRACE)) {
            long ticks2 = System.currentTimeMillis() - ticks;
            traceLogger.log("IntersectSet Except Time: " + ticks2);
        }
        if (intersectSets.length == 0) {
            return result;
        }
        IMember[][] exceptSelections = matchResult.getExceptSelections();
        result.setSelectionToFetch(exceptSelections);
        List<TupleValue> tupleValues = result.getTuplesValues();
        long ticks3 = -1L;
        if (traceLogger.isOn(LogLevel.TRACE)) {
            ticks3 = System.currentTimeMillis();
        }
        if (tupleValues != null) {
            CubeletIntersectionAction intersectionAction = this.getIntersectionAction(tupleValues);
            int numThreadsUsed = matchResult.populateTupleValueList(intersectionAction);
            result.addNumThreadsUsed(numThreadsUsed);
        } else if (result.getTupleValueIterators() != null) {
            result.getTupleValueIterators().addAll(matchResult.createIterators(-1));
        }
        this.lastDataReuseTime = System.currentTimeMillis();
        if (traceLogger.isOn(LogLevel.TRACE)) {
            long ticks4 = System.currentTimeMillis() - ticks3;
            traceLogger.log("fetch result Time: " + ticks4);
        }
        return result;
    }

    private CubeletIntersectionAction getIntersectionAction(List<TupleValue> tupleValues) {
        boolean populateAsResultSet = tupleValues instanceof ResultSetToListAdaptor && Cubelet.getCalcOrdinals() && !((ResultSetToListAdaptor)tupleValues).getResultSet().getResultSetDelegateMode();
        AbstractQueuedIntersectionAction intersectionAction = null;
        intersectionAction = populateAsResultSet ? new ResultSetIntersectionInterface(((ResultSetToListAdaptor)tupleValues).getResultSet()) : new TupleValueListIntersectionInterface(tupleValues);
        return intersectionAction;
    }

    protected long computeOrdinalFromSetOffsets(int[] setOffsets) {
        long ordinal = 0L;
        for (int i = 0; i < this.intQuerySet.length - 1; ++i) {
            ordinal += this.pageSizes[i] * (long)setOffsets[i];
        }
        return ordinal += (long)setOffsets[this.intQuerySet.length - 1];
    }

    protected void computePageSizes() {
        if (!this.isLargeSet()) {
            this.pageSizes = new long[this.intQuerySet.length];
            for (int i = 0; i < this.intQuerySet.length - 1; ++i) {
                long otherSetsSize = 1L;
                for (int j = i + 1; j < this.intQuerySet.length; ++j) {
                    if ((otherSetsSize *= (long)this.intQuerySet[j].length) >= 0L) continue;
                    throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, String.format("The page size of the set at index %d exceeds %d: query set sizes = %s, page size = %s", i, Long.MAX_VALUE, Arrays.toString(this.getQuerySetSizes()), this.getPageSize(i)));
                }
                this.pageSizes[i] = otherSetsSize;
            }
        }
    }

    private int[] getQuerySetSizes() {
        int querySetCount = this.intQuerySet.length;
        int[] querySetSizes = new int[querySetCount];
        for (int querySetIndex = 0; querySetIndex < querySetCount; ++querySetIndex) {
            querySetSizes[querySetIndex] = this.intQuerySet[querySetIndex].length;
        }
        return querySetSizes;
    }

    private BigInteger getPageSize(int setIndex) {
        BigInteger pageSize = BigInteger.ONE;
        for (int i = setIndex + 1; i < this.intQuerySet.length; ++i) {
            pageSize = pageSize.multiply(BigInteger.valueOf(this.intQuerySet[i].length));
        }
        return pageSize;
    }

    protected long estimateMemoryUsage() {
        this.numQuerySetTuples = 1L;
        for (int[] memberIds : this.intQuerySet) {
            this.numQuerySetTuples *= (long)memberIds.length;
        }
        long estimatedRetainedSizeOfValuesStorage = this.valuesStorage.estimateMemoryUsage();
        if (estimatedRetainedSizeOfValuesStorage == -1L) {
            return -1L;
        }
        long estimatedRetainedSizeOfMembersMap = this.estimateMemoryUsageOfMembersMap();
        long estimatedRetainedSizeOfIntQuerySet = this.estimateMemoryUsageOfIntQuerySet();
        long estimatedRetainedSizeOfSelectionLevels = this.estimateMemoryUsageOfSelectionLevels();
        long estimatedMemory = 480L + estimatedRetainedSizeOfValuesStorage + estimatedRetainedSizeOfMembersMap + estimatedRetainedSizeOfIntQuerySet + estimatedRetainedSizeOfSelectionLevels;
        Cubelet.traceEstimatedMemoryUsage(this.getHint(), 480L, estimatedRetainedSizeOfValuesStorage, estimatedRetainedSizeOfMembersMap, estimatedRetainedSizeOfIntQuerySet, estimatedRetainedSizeOfSelectionLevels, estimatedMemory);
        return estimatedMemory;
    }

    public static long estimateMemoryUsage(String aggregateName, int[] hierarchyLevelMemberCounts, int[] hierarchyCardinalities, long cellCount, boolean cellsHaveSameFormatIds, boolean includeSizeOfValueStates) {
        long estimatedRetainedSizeOfValuesStorage;
        if (traceLogger.isOn(LogLevel.TRACE)) {
            traceLogger.log(String.format("Estimating memory usage of aggregate = %s: hierarchyLevelMemberCounts = %s, hierarchyCardinalities = %s, cellCount = %,d, cellsHaveSameFormatIds = %s, includeSizeOfValueStates = %s", aggregateName, Arrays.toString(hierarchyLevelMemberCounts), Arrays.toString(hierarchyCardinalities), cellCount, cellsHaveSameFormatIds, includeSizeOfValueStates));
        }
        int hierarchyCount = hierarchyLevelMemberCounts.length;
        Number setSize = BlockTupleStorageUtil.getSetSize(hierarchyLevelMemberCounts);
        boolean largeSet = BlockTupleStorageUtil.isLargeSet(setSize);
        if (Cubelet.getConfigStoreValuesByMemberIds(largeSet)) {
            boolean[] moreThanOneMemberUsedInHier = new boolean[hierarchyCardinalities.length];
            for (int i = 0; i < hierarchyLevelMemberCounts.length; ++i) {
                moreThanOneMemberUsedInHier[i] = hierarchyLevelMemberCounts[i] > 1;
            }
            estimatedRetainedSizeOfValuesStorage = VectorDoubleNativeValueStorage.estimateSizeToHoldValues(cellCount, cellsHaveSameFormatIds, includeSizeOfValueStates, hierarchyCardinalities, moreThanOneMemberUsedInHier);
        } else {
            estimatedRetainedSizeOfValuesStorage = DoubleNativeValueStorage.estimateSizeToHoldValues(cellCount, cellsHaveSameFormatIds, includeSizeOfValueStates);
        }
        long estimatedRetainedSizeOfMembersMap = Cubelet.estimateMemoryUsageOfMembersMap(hierarchyLevelMemberCounts);
        long estimatedRetainedSizeOfIntQuerySet = Cubelet.estimateMemoryUsageOfIntQuerySet(hierarchyLevelMemberCounts);
        long estimatedRetainedSizeOfSelectionLevels = Cubelet.estimateMemoryUsageOfSelectionLevels(hierarchyCount, 1);
        long estimatedMemory = 480L + estimatedRetainedSizeOfValuesStorage + estimatedRetainedSizeOfMembersMap + estimatedRetainedSizeOfIntQuerySet + estimatedRetainedSizeOfSelectionLevels;
        Cubelet.traceEstimatedMemoryUsage(aggregateName, 480L, estimatedRetainedSizeOfValuesStorage, estimatedRetainedSizeOfMembersMap, estimatedRetainedSizeOfIntQuerySet, estimatedRetainedSizeOfSelectionLevels, estimatedMemory);
        return estimatedMemory;
    }

    private static void traceEstimatedMemoryUsage(String cubeletName, long estimatedStaticSizeOfCubelet, long estimatedRetainedSizeOfValuesStorage, long estimatedRetainedSizeOfMembersMap, long estimatedRetainedSizeOfIntQuerySet, long estimatedRetainedSizeOfSelectionLevels, long estimatedRetainedSizeOfCubelet) {
        if (traceLogger.isOn(LogLevel.TRACE)) {
            String traceStringFormat = "%s = %,d bytes\n";
            if (cubeletName == null) {
                cubeletName = "";
            }
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("\nEstimated memory usage of cubelet: %s\n", cubeletName));
            sb.append(String.format(traceStringFormat, "cubelet static size", estimatedStaticSizeOfCubelet));
            sb.append(String.format(traceStringFormat, "valuesStorage retained size", estimatedRetainedSizeOfValuesStorage));
            sb.append(String.format(traceStringFormat, "membersMap retained size", estimatedRetainedSizeOfMembersMap));
            sb.append(String.format(traceStringFormat, "intQuerySet retained size", estimatedRetainedSizeOfIntQuerySet));
            sb.append(String.format(traceStringFormat, "selectionLevels retained size", estimatedRetainedSizeOfSelectionLevels));
            sb.append(String.format(traceStringFormat, "cubelet retained size", estimatedRetainedSizeOfCubelet));
            traceLogger.log(sb.toString());
        }
    }

    private long estimateMemoryUsageOfSelectionLevels() {
        if (this.selectionLevels == null) {
            return 0L;
        }
        if (traceLogger.isOn(LogLevel.TRACE)) {
            int hierarchyCount = this.selectionLevels.length;
            int[] hierarchyLevelCounts = new int[hierarchyCount];
            for (int i = 0; i < hierarchyCount; ++i) {
                hierarchyLevelCounts[i] = this.selectionLevels[i].size();
            }
            traceLogger.log(String.format("Estimating memory usage of selectionLevels: hierarchyLevelCounts = %s", Arrays.toString(hierarchyLevelCounts)));
        }
        long estimatedSize = JavaObjectMemorySize.getEstimatedJavaObjectArraySize(this.selectionLevels.length);
        for (HashSetInt hashSetInt : this.selectionLevels) {
            estimatedSize += hashSetInt.estimateMemoryUsage();
        }
        return estimatedSize;
    }

    private static long estimateMemoryUsageOfSelectionLevels(int hierarchyCount, int levelCount) {
        long estimatedSize = JavaObjectMemorySize.getEstimatedJavaObjectArraySize(hierarchyCount);
        return estimatedSize += HashSetInt.estimateMemoryUsage(levelCount) * (long)hierarchyCount;
    }

    private long estimateMemoryUsageOfIntQuerySet() {
        if (this.intQuerySet == null) {
            return 0L;
        }
        if (traceLogger.isOn(LogLevel.TRACE)) {
            int hierarchyCount = this.intQuerySet.length;
            int[] hierarchyMemberCounts = new int[hierarchyCount];
            for (int i = 0; i < hierarchyCount; ++i) {
                hierarchyMemberCounts[i] = this.intQuerySet[i].length;
            }
            traceLogger.log(String.format("Estimating memory usage of intQuerySet: hierarchyMemberCounts = %s", Arrays.toString(hierarchyMemberCounts)));
        }
        long estimatedSize = JavaObjectMemorySize.getEstimatedJavaObjectArraySize(this.intQuerySet.length);
        for (int[] intArray : this.intQuerySet) {
            estimatedSize += JavaObjectMemorySize.getEstimatedJavaPrimitiveArraySize(4, intArray.length);
        }
        return estimatedSize;
    }

    private static long estimateMemoryUsageOfIntQuerySet(int[] hierarchyLevelMemberCounts) {
        long estimatedSize = JavaObjectMemorySize.getEstimatedJavaObjectArraySize(hierarchyLevelMemberCounts.length);
        for (int hierarchyLevelMemberCount : hierarchyLevelMemberCounts) {
            estimatedSize += JavaObjectMemorySize.getEstimatedJavaPrimitiveArraySize(4, hierarchyLevelMemberCount);
        }
        return estimatedSize;
    }

    private long estimateMemoryUsageOfMembersMap() {
        if (this.membersMap == null) {
            return 0L;
        }
        if (traceLogger.isOn(LogLevel.TRACE)) {
            int hierarchyCount = this.membersMap.length;
            int[] hierarchyMemberCounts = new int[hierarchyCount];
            for (int i = 0; i < hierarchyCount; ++i) {
                hierarchyMemberCounts[i] = this.membersMap[i].size();
            }
            traceLogger.log(String.format("Estimating memory usage of membersMap: hierarchyMemberCounts = %s", Arrays.toString(hierarchyMemberCounts)));
        }
        long estimatedSize = JavaObjectMemorySize.getEstimatedJavaObjectArraySize(this.membersMap.length);
        for (HashMapIntObject<IMember> hashMapIntObject : this.membersMap) {
            estimatedSize += hashMapIntObject.estimateMemoryUsage();
        }
        return estimatedSize;
    }

    private static long estimateMemoryUsageOfMembersMap(int[] hierarchyLevelMemberCounts) {
        long estimatedSize = JavaObjectMemorySize.getEstimatedJavaObjectArraySize(hierarchyLevelMemberCounts.length);
        for (int hierarchyLevelMemberCount : hierarchyLevelMemberCounts) {
            estimatedSize += HashMapIntObject.estimateMemoryUsage(hierarchyLevelMemberCount);
        }
        return estimatedSize;
    }

    public long getMemoryUsage() {
        if (this.estimatedMemoryUsage == Long.MIN_VALUE) {
            return this.estimateMemoryUsage();
        }
        return this.estimatedMemoryUsage;
    }

    public long getNumValues() {
        return this.numValues;
    }

    protected String getStoredDataType() {
        return this.storedDataType;
    }

    protected void setStoredDataType(IValue value) {
        this.storedDataType = value.getDataType().toString();
    }

    public String toString() {
        StringBuilder strBldr = new StringBuilder("Cubelet").append(NEWLINE);
        if (this.hint != null) {
            strBldr.append("Auxiliary Key: \t\t\t\t").append(this.hint).append(NEWLINE);
        }
        strBldr.append("Stored Data Type: \t\t\t").append(this.storedDataType).append(NEWLINE);
        strBldr.append("Query Set tuples: \t\t\t").append(this.numQuerySetTuples).append(NEWLINE);
        strBldr.append("Number of values: \t\t\t").append(this.numValues).append(NEWLINE);
        float ratio = (float)((double)this.numValues / (double)this.numQuerySetTuples);
        strBldr.append("Value density (%): \t\t\t").append(ratio * 100.0f).append(NEWLINE);
        strBldr.append("Memory est. (bytes): \t\t\t").append(this.estimatedMemoryUsage).append(NEWLINE);
        strBldr.append("Creation time: \t\t\t\t").append(new Timestamp(this.creationTime)).append(NEWLINE);
        strBldr.append("Base incrementID: \t\t\t").append(this.getBaseIncrementId()).append("   Updateable: ").append(this.isUpdateable()).append(NEWLINE);
        strBldr.append("Last cache hit time: \t\t\t").append(new Timestamp(this.lastDataReuseTime)).append(NEWLINE);
        strBldr.append("Num complete hit: \t\t\t").append(this.completeDataHitCount.get()).append(NEWLINE);
        strBldr.append("Num partial hit: \t\t\t").append(this.partialDataHitReuseCount.get()).append(NEWLINE);
        strBldr.append("Num partial hit no reuse: \t\t").append(this.partialDataHitNoReuseCount.get()).append(NEWLINE);
        return strBldr.toString();
    }

    protected final long getNumQuerySetTuples() {
        return this.numQuerySetTuples;
    }

    public boolean contains(Cubelet other) {
        if (this.getClass() != other.getClass()) {
            return false;
        }
        if (null == this.intQuerySet || null == other.intQuerySet) {
            return false;
        }
        if (this.intQuerySet.length != other.intQuerySet.length) {
            return false;
        }
        for (int i = 0; i < this.intQuerySet.length; ++i) {
            if (this.intQuerySet[i].length < other.intQuerySet[i].length) {
                return false;
            }
            if (this.intQuerySet[i].length == other.intQuerySet[i].length) {
                if (Arrays.equals(this.intQuerySet[i], other.intQuerySet[i])) continue;
                return false;
            }
            for (int j = 0; j < other.intQuerySet[i].length; ++j) {
                int position = 0;
                while (true) {
                    if (position == this.intQuerySet[i].length) {
                        return false;
                    }
                    if (this.intQuerySet[i][position] >= other.intQuerySet[i][j]) break;
                    ++position;
                }
                if (this.intQuerySet[i][position] <= other.intQuerySet[i][j]) continue;
                return false;
            }
        }
        return true;
    }

    protected long getCombinedCacheHitCount() {
        return this.partialDataHitReuseCount.get() + this.completeDataHitCount.get();
    }

    protected long getLastDataReuseTime() {
        return this.lastDataReuseTime;
    }

    private int[] computeSetOffsetsFromOrdinal(long cellOrdinal, int[] setOffsets) {
        long remainder = cellOrdinal;
        int lastIndex = setOffsets.length - 1;
        for (int i = 0; i < lastIndex; ++i) {
            setOffsets[i] = (int)(remainder / this.pageSizes[i]);
            remainder -= (long)setOffsets[i] * this.pageSizes[i];
        }
        setOffsets[lastIndex] = (int)remainder;
        return setOffsets;
    }

    private void getMemberIdsFromOffsets(int[] offsets, int[] memberIds) {
        for (int j = 0; j < offsets.length; ++j) {
            memberIds[j] = this.intQuerySet[j][offsets[j]];
        }
    }

    private void advanceMembersByID(int[] memberIdsForTuple, int[] prevMemberIds, IMember[] members) {
        for (int i = 0; i < memberIdsForTuple.length; ++i) {
            if (prevMemberIds[i] == memberIdsForTuple[i] && members[i] != null) continue;
            prevMemberIds[i] = memberIdsForTuple[i];
            members[i] = this.membersMap[i].get(memberIdsForTuple[i]);
        }
    }

    private void advanceMembersByOffset(int[] offsets, int[] prevMemberIds, IMember[] members) {
        for (int i = 0; i < offsets.length; ++i) {
            if (prevMemberIds[i] == this.intQuerySet[i][offsets[i]] && members[i] != null) continue;
            prevMemberIds[i] = this.intQuerySet[i][offsets[i]];
            members[i] = this.membersMap[i].get(prevMemberIds[i]);
        }
    }

    protected TupleValue getFirstTupleValue() {
        int[] memberIds = new int[this.intQuerySet.length];
        int[] lastMemberIds = new int[this.intQuerySet.length];
        IMember[] tupleMembers = new IMember[this.intQuerySet.length];
        IOrdinalValueStorageFetcher ordinalStorageFetcher = this.getOrdinalStorageFetcher();
        if (ordinalStorageFetcher.getNumValues() == 0) {
            return null;
        }
        OrdinalValue ordVal = ordinalStorageFetcher.get(0, null);
        if (ordVal instanceof VectorValue) {
            System.arraycopy(((VectorValue)ordVal).getMemberIds(), 0, memberIds, 0, memberIds.length);
        } else {
            int[] offsets = new int[this.intQuerySet.length];
            offsets = this.computeSetOffsetsFromOrdinal(ordVal.getOrdinal(), offsets);
            this.getMemberIdsFromOffsets(offsets, memberIds);
        }
        this.advanceMembersByID(memberIds, lastMemberIds, tupleMembers);
        return new TupleValue(new Tuple(tupleMembers, false), new Cell(ordVal.getValue()));
    }

    protected IOrdinalValueStorageFetcher getOrdinalStorageFetcher() {
        return this.valuesStorage;
    }

    protected long getCreationTime() {
        return this.creationTime;
    }

    public boolean isUpdateable() {
        return false;
    }

    public int getBaseIncrementId() {
        if (this.valuesStorage == null) {
            return 0;
        }
        return this.valuesStorage.getIncrementId();
    }

    public final String getHint() {
        return this.hint;
    }

    public final void setHint(String aHint) {
        this.hint = aHint;
    }

    private final class IntersectionResult {
        private final int[][] intersectOffsets;
        private final int[][] intersectMemberIds;
        private final IMember[][] exceptSelections;
        private CancelManager cancelManager = ExecutionEnvironmentContext.getExecutionEnvironment().getCancelManager();

        private IntersectionResult(IMember[][] newExceptSelections, int[][] intersectionOffsets, int[][] intersectionMemberIds) {
            this.intersectOffsets = intersectionOffsets;
            this.exceptSelections = newExceptSelections;
            this.intersectMemberIds = intersectionMemberIds;
        }

        private boolean isExactMatch() {
            for (int i = 0; i < this.intersectOffsets.length; ++i) {
                if (Cubelet.this.intQuerySet[i].length == this.intersectOffsets[i].length) continue;
                return false;
            }
            return true;
        }

        private int determineThreadCount(int numFree, int numTuplesThreshold, long numItems, int requesterMaxThreads) {
            int numThreads;
            boolean autoCalc = Cubelet.autoCalcNumThreads();
            if (autoCalc) {
                long numThreadsIdealLong = numItems / (long)numTuplesThreshold;
                int numThreadsIdeal = (int)numThreadsIdealLong;
                if (numThreadsIdealLong > Integer.MAX_VALUE) {
                    numThreadsIdeal = Integer.MAX_VALUE;
                }
                int maxNumThreads = Cubelet.getMaxNumThreads();
                numThreads = Math.min(maxNumThreads, Math.min(numFree, numThreadsIdeal));
            } else {
                numThreads = Cubelet.getNumThreads();
            }
            if (requesterMaxThreads > 0) {
                numThreads = Math.min(numThreads, requesterMaxThreads);
            }
            if (numItems < (long)numThreads) {
                numThreads = (int)numItems;
            }
            numThreads = Math.max(1, numThreads);
            return numThreads;
        }

        private boolean useThreads(int numFreeThreads) {
            return Cubelet.isThreadsEnabled() && Cubelet.this.numValues >= Cubelet.getUseThreadsThreshold() && numFreeThreads >= 2 && Cubelet.this.numValues >= 2 * Cubelet.getNumTuplesThreshold();
        }

        private List<Iterator<TupleValue>> createIteratorsValueDriven(int requesterMaxThreads, boolean exactMatch, IOrdinalValueStorageFetcher valueFetcher) throws InterpreterException {
            OrdinalValue minPossibleForRequestSet = null;
            OrdinalValue maxPossibleForRequestSet = null;
            if (!exactMatch) {
                boolean usesOffsets = Cubelet.this.isStoringByOrdinals();
                for (int i = 0; i < this.intersectOffsets.length; ++i) {
                    if (usesOffsets) {
                        Arrays.sort(this.intersectOffsets[i]);
                        continue;
                    }
                    Arrays.sort(this.intersectMemberIds[i]);
                }
                maxPossibleForRequestSet = this.getRequestSetOrdinalLimit(true, true);
                minPossibleForRequestSet = this.getRequestSetOrdinalLimit(true, false);
            }
            int scanStartIndex = this.getStartIndex(minPossibleForRequestSet, valueFetcher);
            int scanEndIndex = this.getEndIndex(maxPossibleForRequestSet, valueFetcher);
            int numTuplesToScan = scanEndIndex - scanStartIndex;
            if (traceLogger.isOn(LogLevel.TRACE)) {
                traceLogger.log(LogLevel.TRACE, "Cubelet scan start " + scanStartIndex + "  scan end " + scanEndIndex + "  num values " + valueFetcher.getNumValues());
            }
            ThreadPool threadPool = ThreadPool.getInstance();
            int numFreeThreads = threadPool.getMaximumPoolSize() - threadPool.getActiveCount();
            int numThreads = 1;
            int tuplesPerThread = 0;
            if (this.useThreads(numFreeThreads)) {
                int tuplesPerThreadThreshold = Cubelet.getNumTuplesThreshold();
                numThreads = this.determineThreadCount(numFreeThreads, tuplesPerThreadThreshold, numTuplesToScan, requesterMaxThreads);
                tuplesPerThread = numTuplesToScan / numThreads;
            } else {
                numThreads = 1;
                tuplesPerThread = numTuplesToScan;
            }
            List<Iterator<TupleValue>> iters = this.createIteratorsValueDriven(numThreads, tuplesPerThread, exactMatch, valueFetcher, scanStartIndex, scanEndIndex);
            return iters;
        }

        private int getEndIndex(OrdinalValue ordinalValue, IOrdinalValueStorageFetcher valueFetcher) {
            if (Cubelet.this.valuesStorage.getNext() != null && Cubelet.this.valuesStorage.getNumValues() != valueFetcher.getNumValues()) {
                return valueFetcher.getNumValues();
            }
            int index = valueFetcher.getNumValues();
            if (ordinalValue != null) {
                index = Cubelet.this.valuesStorage.getIndex(ordinalValue);
                if (index < 0) {
                    index = Math.abs(index) - 1;
                }
                ++index;
            }
            if (index > valueFetcher.getNumValues()) {
                index = valueFetcher.getNumValues();
            }
            return index;
        }

        private int getStartIndex(OrdinalValue ordinalValue, IOrdinalValueStorageFetcher valueFetcher) {
            int index = 0;
            if (ordinalValue != null && (index = Cubelet.this.valuesStorage.getIndex(ordinalValue)) < 0) {
                index = Math.abs(index) - 1;
            }
            return index;
        }

        private OrdinalValue getRequestSetOrdinalLimit(boolean intersectValuesSorted, boolean getMaxLimit) {
            OrdinalValue ov = null;
            if (Cubelet.this.isStoringByOrdinals()) {
                int[] memberOffsets = this.getLimitValues(this.intersectOffsets, intersectValuesSorted, getMaxLimit);
                long ordinal = Cubelet.this.computeOrdinalFromSetOffsets(memberOffsets);
                if (ordinal >= 0L) {
                    ov = new OrdinalValue(ordinal, null);
                }
            } else {
                int[] memberIds = this.getLimitValues(this.intersectMemberIds, intersectValuesSorted, getMaxLimit);
                ov = new VectorValue(memberIds, null);
            }
            return ov;
        }

        private int[] getLimitValues(int[][] values, boolean valuesSorted, boolean getMaxLimit) {
            int[] value = new int[values.length];
            if (valuesSorted) {
                for (int i = 0; i < values.length; ++i) {
                    if (getMaxLimit) {
                        int lastIndex = values[i].length - 1;
                        value[i] = values[i][lastIndex];
                        continue;
                    }
                    value[i] = values[i][0];
                }
            } else {
                Arrays.fill((Object[])values, (Object)0);
                int foundValue = 0;
                foundValue = getMaxLimit ? 0 : Integer.MAX_VALUE;
                for (int i = 0; i < values[0].length; ++i) {
                    foundValue = getMaxLimit ? Math.max(foundValue, values[0][i]) : Math.min(foundValue, values[0][i]);
                }
                if (!getMaxLimit || foundValue < Integer.MAX_VALUE) {
                    // empty if block
                }
                value[0] = ++foundValue;
            }
            return value;
        }

        private List<Iterator<TupleValue>> createIteratorsValueDriven(int numThreads, int tuplesPerThread, boolean exactMatch, IOrdinalValueStorageFetcher valueFetcher, int scanStartIndex, int scanEndIndex) {
            ArrayList<Iterator<TupleValue>> iters = new ArrayList<Iterator<TupleValue>>();
            int currentOrdinalIndex = scanStartIndex;
            for (int i = 0; i < numThreads; ++i) {
                int startOrdinalIndex = currentOrdinalIndex;
                int endOrdinalIndex = startOrdinalIndex + tuplesPerThread;
                if (i == numThreads - 1) {
                    endOrdinalIndex = scanEndIndex;
                }
                iters.add(new IntersectionTupleValueIterator(startOrdinalIndex, endOrdinalIndex, exactMatch, valueFetcher));
                currentOrdinalIndex = endOrdinalIndex;
            }
            return iters;
        }

        private void executeTasks(List<TupleValueFetcherTask> tasks, CubeletIntersectionAction intersectionAction) throws InterpreterException {
            boolean traceOn = traceLogger.isOn(LogLevel.TRACE);
            long populateStartTime = System.currentTimeMillis();
            if (tasks.size() == 1) {
                TupleValueFetcherTask task = tasks.get(0);
                RuntimeException error = null;
                try {
                    task.iterateValues();
                }
                catch (RuntimeException e) {
                    error = e;
                    throw e;
                }
                finally {
                    task.getTaskAction().taskFinished(error);
                }
            } else {
                ThreadPool threadPool = ThreadPool.getInstance();
                ArrayList<Future<Void>> taskFutures = new ArrayList<Future<Void>>();
                for (TupleValueFetcherTask tupleValueFetcherTask : tasks) {
                    Callable<Void> wrappedTask = ROLAPCallable.decorateCallable(tupleValueFetcherTask);
                    taskFutures.add(threadPool.submit(wrappedTask));
                }
                intersectionAction.intersectionTasksRunning();
                for (Future future : taskFutures) {
                    try {
                        future.get();
                    }
                    catch (Throwable t) {
                        if (XQERuntimeException.isACause(t, ConsumerEndedException.class)) {
                            new InterpreterException("Cubelet IntersectionTask ended since the pipeline consuming thread quit.", t);
                            continue;
                        }
                        throw new InterpreterException("IntersectionTasks had error.", t);
                    }
                }
            }
            if (traceOn) {
                traceLogger.log("Executing of " + tasks.size() + " intersectionTasks took " + (System.currentTimeMillis() - populateStartTime) + "ms.");
            }
        }

        private List<Iterator<TupleValue>> createIterators(int requesterMaxThreads) throws InterpreterException {
            IOrdinalValueStorageFetcher valueFetcher = Cubelet.this.getOrdinalStorageFetcher();
            List<Iterator<TupleValue>> tvIters = null;
            if (valueFetcher.getNumValues() == 0) {
                return new ArrayList<Iterator<TupleValue>>();
            }
            if (this.isExactMatch()) {
                tvIters = this.createIteratorsValueDriven(requesterMaxThreads, true, valueFetcher);
            } else {
                long intersectTupleCount = 1L;
                for (int i = 0; i < this.intersectOffsets.length; ++i) {
                    intersectTupleCount *= (long)this.intersectOffsets[i].length;
                }
                tvIters = (long)valueFetcher.getNumValues() < intersectTupleCount || intersectTupleCount < 0L ? this.createIteratorsValueDriven(requesterMaxThreads, false, valueFetcher) : this.createIteratorsRequestSetDriven(requesterMaxThreads, intersectTupleCount, valueFetcher);
            }
            return tvIters;
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private int populateTupleValueList(CubeletIntersectionAction intersectionAction) throws InterpreterException {
            int n;
            List<Iterator<TupleValue>> tvIters = this.createIterators(intersectionAction.getMaxThreads());
            if (tvIters.size() == 0) {
                return 1;
            }
            XQERuntimeException error = null;
            try {
                ArrayList<TupleValueFetcherTask> tasks = new ArrayList<TupleValueFetcherTask>();
                CubeletIntersectionTaskAction[] intersectionTasks = intersectionAction.createTaskAction(tvIters.size(), Cubelet.this);
                for (int i = 0; i < intersectionTasks.length; ++i) {
                    tasks.add(new TupleValueFetcherTask(intersectionTasks[i], tvIters.get(i)));
                }
                this.executeTasks(tasks, intersectionAction);
                n = tasks.size();
            }
            catch (InterpreterException ie) {
                try {
                    error = (XQERuntimeException)XQERuntimeException.wrap(ie);
                    throw ie;
                    catch (RuntimeException re) {
                        error = (XQERuntimeException)XQERuntimeException.wrap(re);
                        throw error;
                    }
                }
                catch (Throwable throwable) {
                    intersectionAction.intersectionFinished(error);
                    throw throwable;
                }
            }
            intersectionAction.intersectionFinished(error);
            return n;
        }

        private List<Iterator<TupleValue>> createIteratorsRequestSetDriven(int requesterMaxThreads, long intersectTupleCount, IOrdinalValueStorageFetcher valueFetcher) throws InterpreterException {
            ArrayList<Iterator<TupleValue>> iters = new ArrayList<Iterator<TupleValue>>();
            int largestHierIndex = this.findLargestHier(this.intersectOffsets);
            int numTasks = this.calcNumTasksRequestSetDriven(intersectTupleCount, largestHierIndex, requesterMaxThreads);
            boolean traceOn = traceLogger.isOn(LogLevel.TRACE);
            if (traceOn) {
                traceLogger.log("Building TupleValues via the requestSet.  NumTasks = " + numTasks + "   number of intersect offsets per task: " + intersectTupleCount / (long)numTasks);
            }
            if (numTasks == 1) {
                IntersectionTupleValueIteratorViaQuerySet tvIter = new IntersectionTupleValueIteratorViaQuerySet(this.intersectOffsets, valueFetcher);
                iters.add(tvIter);
            } else {
                int offsetsPerTask = this.intersectOffsets[largestHierIndex].length / numTasks;
                for (int i = 0; i < numTasks; ++i) {
                    boolean lastTask = i + 1 == numTasks;
                    int[][] taskIntersectOffsets = new int[this.intersectOffsets.length][];
                    for (int j = 0; j < taskIntersectOffsets.length; ++j) {
                        if (j != largestHierIndex) {
                            taskIntersectOffsets[j] = this.intersectOffsets[j];
                            continue;
                        }
                        int startIndex = i * offsetsPerTask;
                        int endIndex = startIndex + offsetsPerTask;
                        if (lastTask) {
                            endIndex = this.intersectOffsets[j].length;
                        }
                        int numOffsetsForThisTask = endIndex - startIndex;
                        taskIntersectOffsets[j] = new int[numOffsetsForThisTask];
                        System.arraycopy(this.intersectOffsets[j], startIndex, taskIntersectOffsets[j], 0, numOffsetsForThisTask);
                    }
                    IntersectionTupleValueIteratorViaQuerySet tvIter = new IntersectionTupleValueIteratorViaQuerySet(taskIntersectOffsets, valueFetcher);
                    iters.add(tvIter);
                }
            }
            return iters;
        }

        private int calcNumTasksRequestSetDriven(long intersectTupleCount, int largestHierIndex, int requesterMaxThreads) {
            ThreadPool threadPool = ThreadPool.getInstance();
            int numFreeThreads = threadPool.getMaximumPoolSize() - threadPool.getActiveCount();
            int tuplesPerThreadThreshold = Cubelet.getNumTuplesThreshold();
            int numTasks = this.determineThreadCount(numFreeThreads, tuplesPerThreadThreshold, intersectTupleCount, requesterMaxThreads);
            if ((numTasks = Math.max(1, numTasks)) > this.intersectOffsets[largestHierIndex].length) {
                numTasks = this.intersectOffsets[largestHierIndex].length;
            }
            return numTasks;
        }

        private int findLargestHier(int[][] theIntersectOffsets) {
            int maxIntersectValuesHier = -1;
            int maxIntersectValues = -1;
            for (int i = 0; i < theIntersectOffsets.length; ++i) {
                if (theIntersectOffsets[i].length <= maxIntersectValues) continue;
                maxIntersectValuesHier = i;
                maxIntersectValues = theIntersectOffsets[i].length;
            }
            return maxIntersectValuesHier;
        }

        private boolean fetchMembersFromOrdinalValue(OrdinalValue ordVal, int[] prevMemberIds, IMember[] members, boolean exactMatch, int[] offsets) {
            offsets = Cubelet.this.computeSetOffsetsFromOrdinal(ordVal.getOrdinal(), offsets);
            if (!exactMatch) {
                boolean buildTuple = true;
                for (int i = 0; i < offsets.length; ++i) {
                    if (Arrays.binarySearch(this.intersectOffsets[i], offsets[i]) >= 0) continue;
                    buildTuple = false;
                    break;
                }
                if (!buildTuple) {
                    return false;
                }
            }
            Cubelet.this.advanceMembersByOffset(offsets, prevMemberIds, members);
            return true;
        }

        private boolean fetchMembersFromOrdinalValueLarge(VectorValue ordVal, int[] prevMemberIds, IMember[] members, boolean exactMatch) {
            int[] memberIds = ordVal.getMemberIds();
            if (!exactMatch) {
                boolean buildTuple = true;
                for (int i = 0; i < memberIds.length; ++i) {
                    if (Arrays.binarySearch(this.intersectMemberIds[i], memberIds[i]) >= 0) continue;
                    buildTuple = false;
                    break;
                }
                if (!buildTuple) {
                    return false;
                }
            }
            Cubelet.this.advanceMembersByID(memberIds, prevMemberIds, members);
            return true;
        }

        private int[][] getIntersectOffsets() {
            return this.intersectOffsets;
        }

        private IMember[][] getExceptSelections() {
            return this.exceptSelections;
        }

        private final class IntersectionTupleValueIteratorViaQuerySet
        extends AbstractIntersectionTupleValueIterator {
            private final int[] currentIndices;
            private final int[] selectionSize;
            private final int[][] taskIntersectOffsets;
            private final int[] memberIdsForTuple;
            private final int[] currentSetOffsets;
            private final int[] prevMemberIds;
            private final OrdinalValue searchKey;
            private final boolean isStoringByOrdinal;
            private int lastSelectionSizeIndex;
            private boolean more;

            IntersectionTupleValueIteratorViaQuerySet(int[][] theTaskIntersectOffsets, IOrdinalValueStorageFetcher valueFetcher) {
                super(valueFetcher, new IMember[theTaskIntersectOffsets.length]);
                this.more = true;
                this.taskIntersectOffsets = theTaskIntersectOffsets;
                this.selectionSize = new int[this.taskIntersectOffsets.length];
                this.currentIndices = new int[this.taskIntersectOffsets.length];
                for (int i = 0; i < this.selectionSize.length; ++i) {
                    this.selectionSize[i] = this.taskIntersectOffsets[i].length;
                }
                this.memberIdsForTuple = new int[this.taskIntersectOffsets.length];
                this.currentSetOffsets = new int[this.taskIntersectOffsets.length];
                this.prevMemberIds = new int[this.taskIntersectOffsets.length];
                this.searchKey = Cubelet.this.createOrdinalValue();
                this.isStoringByOrdinal = !(this.searchKey instanceof VectorValue);
                this.lastSelectionSizeIndex = this.selectionSize.length - 1;
            }

            @Override
            protected boolean fetchNext() {
                while (this.more) {
                    if (IntersectionResult.this.cancelManager != null && IntersectionResult.this.cancelManager.isRequestCancelled()) {
                        throw new OperationCanceledException();
                    }
                    for (int i = 0; i < this.memberIdsForTuple.length; ++i) {
                        this.memberIdsForTuple[i] = Cubelet.this.intQuerySet[i][this.taskIntersectOffsets[i][this.currentIndices[i]]];
                        this.currentSetOffsets[i] = this.taskIntersectOffsets[i][this.currentIndices[i]];
                    }
                    if (this.isStoringByOrdinal) {
                        this.searchKey.setOrdinal(Cubelet.this.computeOrdinalFromSetOffsets(this.currentSetOffsets));
                    } else {
                        ((VectorValue)this.searchKey).setMemberIds(this.memberIdsForTuple);
                    }
                    this.more = this.nextOrdinal(this.lastSelectionSizeIndex);
                    if (!this.ordinalValueFetcher.get(this.searchKey)) continue;
                    Cubelet.this.advanceMembersByID(this.memberIdsForTuple, this.prevMemberIds, this.members);
                    this.commonCell.setValue(this.searchKey.getValue());
                    return true;
                }
                return false;
            }

            private boolean nextOrdinal(int dim) {
                if (dim < 0) {
                    return false;
                }
                int n = dim;
                this.currentIndices[n] = this.currentIndices[n] + 1;
                if (this.currentIndices[n] >= this.selectionSize[dim]) {
                    this.currentIndices[dim] = 0;
                    return this.nextOrdinal(dim - 1);
                }
                return true;
            }
        }

        private final class IntersectionTupleValueIterator
        extends AbstractIntersectionTupleValueIterator {
            private final int startOrdinalIndex;
            private final int endOrdinalIndex;
            private final boolean exactMatch;
            private final int[] offsets;
            private final int[] prevMemberIds;
            private final OrdinalValue ordinalValue;
            private final boolean isStoringByMemberId;
            private int nextIndex;

            IntersectionTupleValueIterator(int startOrdIndex, int endOrdIndex, boolean match, IOrdinalValueStorageFetcher valueFetcher) {
                super(valueFetcher, new IMember[Cubelet.this.intQuerySet.length]);
                this.startOrdinalIndex = startOrdIndex;
                this.endOrdinalIndex = endOrdIndex;
                this.exactMatch = match;
                this.offsets = new int[Cubelet.this.intQuerySet.length];
                this.prevMemberIds = new int[Cubelet.this.intQuerySet.length];
                this.ordinalValue = Cubelet.this.createOrdinalValue();
                this.isStoringByMemberId = this.ordinalValue instanceof VectorValue;
                this.nextIndex = this.startOrdinalIndex;
            }

            @Override
            protected boolean fetchNext() {
                while (this.nextIndex < this.endOrdinalIndex) {
                    if (IntersectionResult.this.cancelManager != null && IntersectionResult.this.cancelManager.isRequestCancelled()) {
                        throw new OperationCanceledException();
                    }
                    this.ordinalValueFetcher.get(this.nextIndex, this.ordinalValue);
                    boolean tupleIsInItersection = this.isStoringByMemberId ? IntersectionResult.this.fetchMembersFromOrdinalValueLarge((VectorValue)this.ordinalValue, this.prevMemberIds, this.members, this.exactMatch) : IntersectionResult.this.fetchMembersFromOrdinalValue(this.ordinalValue, this.prevMemberIds, this.members, this.exactMatch, this.offsets);
                    ++this.nextIndex;
                    if (!tupleIsInItersection) continue;
                    this.commonCell.setValue(this.ordinalValue.getValue());
                    return true;
                }
                return false;
            }
        }

        private abstract class AbstractIntersectionTupleValueIterator
        implements Iterator<TupleValue> {
            protected final IOrdinalValueStorageFetcher ordinalValueFetcher;
            protected final IMember[] members;
            protected final TupleValue commonTupleValue;
            protected final Cell commonCell;
            private boolean commonTupleValuePopulated = false;

            AbstractIntersectionTupleValueIterator(IOrdinalValueStorageFetcher valueFetcher, IMember[] theMembers) {
                this.ordinalValueFetcher = valueFetcher;
                this.members = theMembers;
                this.commonCell = new Cell(0L, DataValueFactory.createDoubleValue());
                this.commonTupleValue = new TupleValue(new Tuple(this.members, false), this.commonCell);
            }

            @Override
            public boolean hasNext() {
                if (!this.commonTupleValuePopulated) {
                    this.commonTupleValuePopulated = this.fetchNext();
                }
                return this.commonTupleValuePopulated;
            }

            @Override
            public TupleValue next() {
                if (IntersectionResult.this.cancelManager != null && IntersectionResult.this.cancelManager.isRequestCancelled()) {
                    throw new OperationCanceledException();
                }
                if (this.hasNext()) {
                    this.commonTupleValuePopulated = false;
                    return this.commonTupleValue;
                }
                return null;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Remove is not supported");
            }

            protected abstract boolean fetchNext();
        }

        private class TupleValueFetcherTask
        implements Callable<Void> {
            private final CubeletIntersectionTaskAction intersectionTaskAction;
            private final Iterator<TupleValue> tvIter;

            TupleValueFetcherTask(CubeletIntersectionTaskAction anIntersectionTaskAction, Iterator<TupleValue> tupleValueIter) {
                this.intersectionTaskAction = anIntersectionTaskAction;
                this.tvIter = tupleValueIter;
            }

            @Override
            public Void call() {
                ExecutionEnvironment execEnv = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
                boolean isRolap = Cubelet.this.cube instanceof ROLAPCube;
                if (isRolap) {
                    ROLAPContext.queryEnter(execEnv, (ROLAPCube)Cubelet.this.cube);
                }
                RuntimeException error = null;
                try {
                    this.iterateValues();
                }
                catch (RuntimeException e) {
                    error = e;
                    throw e;
                }
                finally {
                    this.intersectionTaskAction.taskFinished(error);
                    if (isRolap) {
                        ROLAPContext.queryExit(execEnv);
                    }
                }
                return null;
            }

            protected void iterateValues() {
                TupleValue tv = this.tvIter.next();
                if (tv != null) {
                    Cell commonCell = tv.getCell();
                    Tuple commonTuple = tv.getTuple();
                    while (tv != null) {
                        this.intersectionTaskAction.valueFound(commonCell.getValue(), commonTuple);
                        tv = this.tvIter.next();
                    }
                }
            }

            public CubeletIntersectionTaskAction getTaskAction() {
                return this.intersectionTaskAction;
            }
        }
    }
}

