/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet;

import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Cell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IResultSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.TupleOrdinalCalculationCache;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.Cubelet;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.CubeletIntersectionTaskAction;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.CubeletLookupThreadReturnType;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.OperationEnum;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;

public class ResultSetIntersectionTaskInterface
implements CubeletIntersectionTaskAction {
    private final BlockingQueue<CubeletLookupThreadReturnType> resultQueue;
    private List<List<long[]>> resultSetTupleOrdinals = null;
    private List<Cell> cells = null;
    private final int numValuesToPost;
    private final IResultSet resultSet;
    private final TupleOrdinalCalculationCache ordinalCalcCache;
    private final List<long[]> cachedOrdinalList;

    public ResultSetIntersectionTaskInterface(IResultSet aResultSet) {
        this(null, -1, aResultSet);
    }

    public ResultSetIntersectionTaskInterface(BlockingQueue<CubeletLookupThreadReturnType> aResultQueue, int numberOfValuesToPost, IResultSet aResultSet) {
        this.resultQueue = aResultQueue;
        this.resultSetTupleOrdinals = new ArrayList<List<long[]>>();
        this.cells = new ArrayList<Cell>();
        this.numValuesToPost = numberOfValuesToPost;
        this.resultSet = aResultSet;
        this.ordinalCalcCache = new TupleOrdinalCalculationCache(this.resultSet.getMetadata().getQuerySet());
        this.cachedOrdinalList = this.resultQueue == null ? new ArrayList<long[]>() : null;
    }

    @Override
    public void taskFinished(Throwable error) {
        if (this.resultQueue != null && error == null) {
            CubeletLookupThreadReturnType msg = new CubeletLookupThreadReturnType(null, this.resultSetTupleOrdinals, this.cells, true);
            try {
                this.resultQueue.put(msg);
            }
            catch (InterruptedException e) {
                Cubelet.traceLogger.log(LogLevel.ERROR, OperationEnum.DEFAULT, "Could not enqueue msg", e);
            }
        }
    }

    @Override
    public void valueFound(IValue value, ITuple tuple) {
        List<long[]> ordinals = this.resultSet.getTupleOrdinals(tuple, this.ordinalCalcCache, this.cachedOrdinalList);
        if (ordinals == null || ordinals.size() == 0) {
            return;
        }
        Cell c = new Cell(value);
        c.setIsCalculation(Tuple.containsCalculation(tuple.getMembers()));
        if (this.resultQueue != null) {
            this.saveResultForQueue(ordinals, c);
        } else {
            this.resultSet.addCell(ordinals, c, c.isCalculation(), false);
        }
    }

    private void saveResultForQueue(List<long[]> ordinals, Cell cell) {
        this.resultSetTupleOrdinals.add(ordinals);
        this.cells.add(cell);
        if (this.resultSetTupleOrdinals.size() >= this.numValuesToPost) {
            CubeletLookupThreadReturnType msg = new CubeletLookupThreadReturnType(null, this.resultSetTupleOrdinals, this.cells, false);
            try {
                this.resultQueue.put(msg);
            }
            catch (InterruptedException e) {
                throw new XQERuntimeException(e);
            }
            this.resultSetTupleOrdinals = new ArrayList<List<long[]>>(this.numValuesToPost);
            this.cells = new ArrayList<Cell>(this.numValuesToPost);
        }
    }
}

