/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.incremental;

import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.TupleValue;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPBaseCube;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.AggregateCalculationEngine;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.AggregateUtilities;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.UpdateableCacheEntry;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.incremental.AggregateCalculationGraph;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.incremental.AggregateCalculationGraphSubscriber;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.incremental.IStreamedValues;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.incremental.LevelSet;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.incremental.LevelSetWithMeasures;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.util.Pipe;
import com.cognos.xqe.util.primitive.ArrayListInt;
import com.cognos.xqe.util.primitive.IteratorInt;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AggregateCalculationStrategy {
    private static final String SPACE_PAREN = " (";
    private final ListMultimap<AggregateCalculationGraphSubscriber, Iterable<TupleValue>> results = ArrayListMultimap.create();
    private final AggregateCalculationGraph acg;
    private final List<IHierarchy> hierarchies;

    public AggregateCalculationStrategy(Collection<UpdateableCacheEntry> subscribers, ROLAPBaseCube cube) {
        this.acg = new AggregateCalculationGraph(cube, false);
        this.hierarchies = cube.getHierarchies();
        AggregateCalculationStrategy.buildCalculationGraph(subscribers, this.acg, "ROLAPCubes.IncrementalUpdates", false);
    }

    public static void buildCalculationGraph(Collection<? extends AggregateCalculationGraphSubscriber> subscribers, AggregateCalculationGraph graph, String logGroup, boolean includeMeasures) {
        ROLAPLog.logOpStart(LogLevel.INFO, logGroup, "Started building Aggregate Calculation Graph.");
        int totalLevelSetSubscriptionCount = 0;
        ArrayListMultimap subscribersByLevelSet = ArrayListMultimap.create();
        for (AggregateCalculationGraphSubscriber aggregateCalculationGraphSubscriber : subscribers) {
            int[][] levelSelections = aggregateCalculationGraphSubscriber.getLevels();
            List<int[]> levelSets = AggregateUtilities.arrayCrossProduct(levelSelections);
            totalLevelSetSubscriptionCount += levelSets.size();
            for (int[] levelSet : levelSets) {
                if (includeMeasures) {
                    subscribersByLevelSet.put((Object)new LevelSetWithMeasures(levelSet, aggregateCalculationGraphSubscriber.getMeasures()), (Object)aggregateCalculationGraphSubscriber);
                    continue;
                }
                subscribersByLevelSet.put((Object)new LevelSet(levelSet), (Object)aggregateCalculationGraphSubscriber);
            }
        }
        for (Map.Entry entry : subscribersByLevelSet.asMap().entrySet()) {
            graph.insertNode((LevelSet)entry.getKey(), (Collection)entry.getValue());
        }
        String logMsg = String.format("Finished building Aggregate Calculation Graph.  Subscribers = %d,  Unique levelSets (nodes) = %d, total subscription count = %d", subscribers.size(), graph.size(), totalLevelSetSubscriptionCount);
        ROLAPLog.logOpEnd(LogLevel.INFO, logGroup, logMsg);
    }

    public void execute(Collection<TupleValue> leafValues, IStreamedValues<TupleValue> leafValuesAsStream, int incrementId, int estimateNumLeafTuples) throws InterpreterException {
        ROLAPLog.logOpStart(LogLevel.INFO, "ROLAPCubes.IncrementalUpdates", "Started executing Aggregate Calculation Strategy.");
        this.initializeGraphForRollup(leafValues, leafValuesAsStream);
        this.executeRollups(estimateNumLeafTuples);
        this.distributeResultsToSubscribers(incrementId);
        long numLeafValues = AggregateCalculationStrategy.getNumValues(leafValues, leafValuesAsStream);
        ROLAPLog.logOpEnd(LogLevel.INFO, "ROLAPCubes.IncrementalUpdates", "Finished executing Aggregate Calculation Strategy using " + numLeafValues + " tupleValues.");
    }

    private static long getNumValues(Collection<TupleValue> leafValues, IStreamedValues<TupleValue> leafValuesAsStream) {
        long numLeafValues = -1L;
        if (leafValuesAsStream != null) {
            numLeafValues = leafValuesAsStream.getStream().getNumTotalElementsAdded();
        } else if (leafValues != null) {
            numLeafValues = leafValues.size();
        }
        return numLeafValues;
    }

    private void initializeGraphForRollup(Collection<TupleValue> leafValues, IStreamedValues<TupleValue> leafValuesAsStream) {
        AggregateCalculationGraph.AGNode root = this.acg.getRootNode();
        if (this.isPCH()) {
            Iterator<TupleValue> leafIter = leafValuesAsStream != null ? leafValuesAsStream.getStream().iterator() : leafValues.iterator();
            this.initializePchNodes(leafIter, root);
        } else if (leafValuesAsStream != null) {
            root.setValueStream(leafValuesAsStream);
        } else {
            root.setValues(leafValues);
        }
        this.acg.optimize();
        if (ROLAPLog.isOn("ROLAPCubes.IncrementalUpdates", LogLevel.TRACE)) {
            ROLAPLog.logTrace("ROLAPCubes.IncrementalUpdates", "Hiers in graph are : " + this.hierarchies.toString());
            ROLAPLog.logTrace("ROLAPCubes.IncrementalUpdates", "AggregateCalculationGraph is : " + this.acg.toString());
        }
    }

    private void initializePchNodes(Iterator<TupleValue> leafValues, AggregateCalculationGraph.AGNode root) {
        LevelSet rootLevelSet = root.getLevelSet();
        ListMultimap<LevelSet, TupleValue> sourceValuesByLeaf = this.binTupleValuesByLevelSet(leafValues, rootLevelSet);
        this.insertPchLeafValues(sourceValuesByLeaf);
    }

    private static ArrayListInt getPchHierIndexes(Tuple sample) {
        ArrayListInt pchHierIdxs = new ArrayListInt();
        IHierarchy[] h = sample.getHierarchies();
        for (int i = 0; i < sample.size(); ++i) {
            if (!h[i].isParentChild()) continue;
            pchHierIdxs.add(i);
        }
        return pchHierIdxs;
    }

    private void insertPchLeafValues(ListMultimap<LevelSet, TupleValue> sourceValuesByLeaf) {
        for (LevelSet lvlSet : sourceValuesByLeaf.keySet()) {
            List values = sourceValuesByLeaf.get((Object)lvlSet);
            AggregateCalculationGraph.AGNode node = this.acg.insertNode(lvlSet, Collections.emptyList());
            node.addValues(values);
        }
    }

    private ListMultimap<LevelSet, TupleValue> binTupleValuesByLevelSet(Iterator<TupleValue> leafValues, LevelSet rootLevelSet) {
        ArrayListInt pchHierIdxs = null;
        ArrayListMultimap sourceValuesByLeaf = ArrayListMultimap.create();
        while (leafValues.hasNext()) {
            TupleValue tv = leafValues.next();
            Tuple t = tv.getTuple();
            if (pchHierIdxs == null) {
                pchHierIdxs = AggregateCalculationStrategy.getPchHierIndexes(t);
            }
            IteratorInt itr = pchHierIdxs.iterator();
            int[] lvlSet = Arrays.copyOf(rootLevelSet.getIndexes(), rootLevelSet.size());
            while (itr.hasNext()) {
                int lvlIdx;
                int hierIdx = itr.next();
                lvlSet[hierIdx] = lvlIdx = t.getMember(hierIdx).getLevel().getIndex();
            }
            sourceValuesByLeaf.put((Object)new LevelSet(lvlSet), (Object)tv);
        }
        return sourceValuesByLeaf;
    }

    private void executeRollups(int estimateNumLeafTuples) throws InterpreterException {
        ROLAPLog.logOpStart(LogLevel.INFO, "ROLAPCubes.IncrementalUpdates", "Started executing rollup calculations with num estimated tuples = " + estimateNumLeafTuples);
        boolean pchCube = this.isPCH();
        AggregateCalculationGraph.AGNode rootNode = this.acg.getRootNode();
        for (AggregateCalculationGraph.AGNode node : this.acg) {
            AggregateCalculationStrategy.executeRollupForNode(node, estimateNumLeafTuples, node == rootNode, node.getDependents(), this.hierarchies, pchCube, "ROLAPCubes.IncrementalUpdates");
        }
        ROLAPLog.logOpEnd(LogLevel.INFO, "ROLAPCubes.IncrementalUpdates", "Finished executing rollup calculations.");
    }

    private static void drainPipe(Pipe<TupleValue> valueStream) {
        Iterator<TupleValue> tvIter = valueStream.iterator();
        while (tvIter.hasNext()) {
            tvIter.next();
        }
    }

    private boolean isPCH() {
        for (IHierarchy h : this.hierarchies) {
            if (!h.isParentChild()) continue;
            return true;
        }
        return false;
    }

    private void distributeResultsToSubscribers(int incrementId) {
        for (AggregateCalculationGraph.AGNode aGNode : this.acg) {
            Collection<AggregateCalculationGraphSubscriber> subs = aGNode.getSubscribers();
            Collection<TupleValue> nodeValues = aGNode.getValues();
            for (AggregateCalculationGraphSubscriber sub : subs) {
                this.addNodeValuesToSubscriberResults(nodeValues, sub);
            }
        }
        try {
            for (Map.Entry entry : this.results.asMap().entrySet()) {
                AggregateCalculationGraphSubscriber subscriber = (AggregateCalculationGraphSubscriber)entry.getKey();
                Collection allCollectionsForThisSubscriber = (Collection)entry.getValue();
                Iterable allResults = Iterables.concat((Iterable)allCollectionsForThisSubscriber);
                ((UpdateableCacheEntry)subscriber).createNewIncrement(incrementId, allResults);
            }
        }
        catch (RuntimeException re) {
            for (AggregateCalculationGraphSubscriber subscriber : this.results.keySet()) {
                ((UpdateableCacheEntry)subscriber).removeIncrement(incrementId);
            }
            throw re;
        }
    }

    private void addNodeValuesToSubscriberResults(Collection<TupleValue> nodeValues, AggregateCalculationGraphSubscriber sub) {
        this.results.put((Object)sub, nodeValues);
    }

    private static List<ILevel> getLevelsFromIndices(int[] indices, List<IHierarchy> hiers) {
        ArrayList<ILevel> levels = new ArrayList<ILevel>(indices.length);
        for (int i = 0; i < indices.length; ++i) {
            ILevel level = hiers.get(i).getLevel(indices[i]);
            levels.add(level);
        }
        return levels;
    }

    public static void executeRollupForNode(AggregateCalculationGraph.AGNode node, int estimatedNumTuples, boolean nodeIsSourceForAllAdditiveMeasures, List<AggregateCalculationGraph.AGNode> destinations, List<IHierarchy> hiers, boolean dependentNodesMayAlreadyHaveValues, String logEventGroup) throws InterpreterException {
        List<List<TupleValue>> allTargetTupleValues;
        List<ILevel> sourceLevels;
        if (destinations == null || destinations.size() == 0) {
            if (node.getValueStream() != null) {
                AggregateCalculationStrategy.drainPipe(node.getValueStream().getStream());
                node.setValues(node.getValueStream().getValues());
            }
            return;
        }
        ArrayList<List<ILevel>> allDestinationLevels = new ArrayList<List<ILevel>>();
        ArrayList<Set<IMember>> allFilteredMeasures = new ArrayList<Set<IMember>>();
        for (AggregateCalculationGraph.AGNode destination : destinations) {
            List<ILevel> destinationLevelSet = AggregateCalculationStrategy.getLevelsFromIndices(destination.getLevelSet().getIndexes(), hiers);
            HashSet<IMember> unusedMeasures = new HashSet<IMember>(node.getSelfAndDepsAdditiveMeasures());
            if (nodeIsSourceForAllAdditiveMeasures) {
                IMember[] allMeasures;
                for (IMember measure : allMeasures = hiers.get(0).getDimension().getCube().getMeasureDimension().getMembers()) {
                    if (!AggregateCalculationEngine.canRollupMeasure(measure)) continue;
                    unusedMeasures.add(measure);
                }
            }
            unusedMeasures.removeAll(destination.getSelfAndDepsAdditiveMeasures());
            if (unusedMeasures.size() == 0) {
                unusedMeasures = null;
            }
            allDestinationLevels.add(destinationLevelSet);
            allFilteredMeasures.add(unusedMeasures);
        }
        long startTime = System.currentTimeMillis();
        if (node.getValueStream() != null) {
            sourceLevels = AggregateCalculationStrategy.getLevelsFromIndices(node.getLevelSet().getIndexes(), hiers);
            allTargetTupleValues = AggregateCalculationEngine.calculateValuesAtLevelsetFromSourceValues(node.getValueStream().getStream(), estimatedNumTuples, sourceLevels, allDestinationLevels, allFilteredMeasures);
            node.setValues(node.getValueStream().getValues());
        } else if (node.getValueIterators() != null) {
            sourceLevels = AggregateCalculationStrategy.getLevelsFromIndices(node.getLevelSet().getIndexes(), hiers);
            allTargetTupleValues = AggregateCalculationEngine.calculateValuesAtLevelsetFromSourceValues(node.getValueIterators(), estimatedNumTuples, sourceLevels, allDestinationLevels, allFilteredMeasures);
        } else {
            allTargetTupleValues = AggregateCalculationEngine.calculateValuesAtLevelsetFromSourceValues(node.getValues(), allDestinationLevels, allFilteredMeasures);
        }
        long numSourceTuples = AggregateCalculationStrategy.getNumValues(node.getValues(), node.getValueStream());
        for (int i = 0; i < destinations.size(); ++i) {
            AggregateCalculationGraph.AGNode destination = destinations.get(i);
            Collection<TupleValue> targetTupleValues = (Collection<TupleValue>)allTargetTupleValues.get(i);
            if (destination.getValues() != null && destination.getValues().size() > 0) {
                if (dependentNodesMayAlreadyHaveValues) {
                    ArrayList targetExistingValues = Lists.newArrayList(destination.getValues());
                    if (targetTupleValues.isEmpty()) {
                        targetTupleValues = targetExistingValues;
                    } else {
                        targetExistingValues.addAll(targetTupleValues);
                        targetTupleValues = AggregateCalculationEngine.calculateValuesAtLevelsetFromSourceValues((Collection<TupleValue>)targetExistingValues, (List)allDestinationLevels.get(i), (Set)allFilteredMeasures.get(i));
                    }
                } else {
                    ROLAPLog.logError(logEventGroup, "Node " + destination + " already has values set, replacing " + destination.getValues().size() + " values with " + allTargetTupleValues.get(i).size() + " values");
                    throw new IllegalStateException("Target node already has values.");
                }
            }
            destination.setValues(targetTupleValues);
        }
        long endRollupTime = System.currentTimeMillis();
        if (ROLAPLog.isOn(logEventGroup, LogLevel.TRACE)) {
            NumberFormat nf = NumberFormat.getInstance();
            StringBuilder logMsg = new StringBuilder("\nRollup from " + node + SPACE_PAREN);
            logMsg.append(nf.format(numSourceTuples) + " tupleValues) to\n");
            for (int i = 0; i < destinations.size(); ++i) {
                AggregateCalculationGraph.AGNode destination = destinations.get(i);
                logMsg.append("  " + destination + SPACE_PAREN);
                logMsg.append(nf.format(allTargetTupleValues.get(i).size()) + " tupleValues) \n");
            }
            logMsg.append(" took " + nf.format(endRollupTime - startTime) + "ms.");
            ROLAPLog.logTrace(logEventGroup, logMsg.toString());
        }
    }
}

