/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.incremental;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.NullValue;
import com.cognos.xqe.data.values.StringValue;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.AggregateTypeEnum;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.QueryEngine;
import com.cognos.xqe.query.engine.QueryEnvironmentHelper;
import com.cognos.xqe.query.parameters.RequestParameters;
import com.cognos.xqe.query.planner.QueryPlanner;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIEdgeIterator;
import com.cognos.xqe.rsapi.RSAPIPartialDataset;
import com.cognos.xqe.rsapi.RSAPIResultSet;
import com.cognos.xqe.rsapi.RSAPIRow;
import com.cognos.xqe.runtree.PlannedV5QuerySet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IResultSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.TupleValue;
import com.cognos.xqe.runtree.olap.mdx.metadata.Hierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPQueryResultIterator;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPCompoundKeyMapping;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPContext;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPMeasure;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPMemberProxy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPQuery;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPQueryExecuteMetrics;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPQueryStrategy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.RolapQueryHelper;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPBaseCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeManager;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.QueryHelper;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.util.RolapV5Builder;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.AggregateCalculationEngine;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.incremental.IIncrementStagingAdapter;
import com.cognos.xqe.runtree.olap.mdx.v5provider.V5ProviderCombination;
import com.cognos.xqe.runtree.olap.mdx.v5provider.V5ProviderQueryResult;
import com.cognos.xqe.runtree.olap.mdx.v5provider.V5ProviderSelection;
import com.cognos.xqe.trace.TraceContext;
import com.cognos.xqe.util.ClosableIterator;
import com.cognos.xqe.util.ClosableIteratorFromIterator;
import com.cognos.xqe.util.CollectionCast;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqe.util.primitive.HashMapIntObject;
import com.cognos.xqe.util.primitive.HashMapObjectInt;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class QueryIncrementalStagingAdaper
implements IIncrementStagingAdapter {
    private static final String EXPRESSION_LTEQ = " <= ";
    private static final String EXPRESSION_GT = " > ";
    private static final String EXPRESSION_NOT_NULL = " <> null";
    private static final String EXPRESSION_IS_NULL = " = null";
    private static final String EXPRESSION_AND = " and ";
    private static final String EXPRESSION_OR = " or ";
    public static final String JVM_PARAM_TID_COL = "tidColumnName";
    public static final String JVM_PARAM_TID_VAL_AT_CUBE_START = "tidValueAtCubeStart";
    public static final String JVM_PARAM_INC_ID_VAL = "incrementIdCurrentValue";
    private int incrementCounter = 0;
    public static final IValue DEFAULT_TID_VALUE = NullValue.NULLVALUE;
    private IValue nextTID = DEFAULT_TID_VALUE;
    private IValue currentTID = DEFAULT_TID_VALUE;
    private final ROLAPBaseCube cube;
    private final HashMapIntObject<IValue> incrementIdToTid = new HashMapIntObject();

    private static IValue formatUserSpecifiedTID(String tidValue) {
        if (tidValue == null) {
            return null;
        }
        if (tidValue.equalsIgnoreCase("null")) {
            return DEFAULT_TID_VALUE;
        }
        StringValue tid = DataValueFactory.createStringValue();
        tid.set(tidValue);
        return tid;
    }

    private String getTidColName() {
        ROLAPMetaCube metaCube;
        String tidColName = System.getProperty(JVM_PARAM_TID_COL);
        if (tidColName == null && (metaCube = this.cube.getModelCube()) != null) {
            tidColName = metaCube.getFactTransactionIDQueryItem();
        }
        return tidColName;
    }

    public QueryIncrementalStagingAdaper(ROLAPBaseCube theCube) {
        this.cube = theCube;
        this.initialize();
    }

    @Override
    public int getNextIncrementId(String strTID) {
        this.getNextTid(strTID);
        if (!this.currentTID.equals(this.nextTID)) {
            return this.incrementCounter + 1;
        }
        return this.incrementCounter;
    }

    private void getNextTid(String strTID) {
        IValue temp = QueryIncrementalStagingAdaper.formatUserSpecifiedTID(strTID);
        if (temp == null) {
            temp = this.fetchNextTidFromDB();
        }
        if (temp != null && !this.isDefaultTid(temp)) {
            this.nextTID = temp;
        }
    }

    @Override
    public ClosableIterator<TupleValue> getTupleValuesForCurrentIncrement(boolean throwIfNewTIDHasNoData) {
        if (this.isDefaultTid(this.nextTID) || this.nextTID.equals(this.currentTID)) {
            List emptyList = Collections.emptyList();
            return new ClosableIteratorFromIterator<TupleValue>(emptyList.iterator());
        }
        V5ProviderCombination set = this.getLeafSet();
        V5ProviderCombination predicateSet = this.getRootSet();
        ROLAPQuery query = this.buildQuery(set, predicateSet);
        ClosableIterator<TupleValue> leafValuesIter = this.executeQuery(query);
        if (throwIfNewTIDHasNoData && !leafValuesIter.hasNext()) {
            leafValuesIter.close();
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, String.format("No values for TID: %s, current tid is %s.  Values should have been found since system found the later TID.", this.nextTID.toString(), this.currentTID.toString()));
        }
        return leafValuesIter;
    }

    @Override
    public void commitIncrement() {
        this.commitIncrement(true);
    }

    private void commitIncrement(boolean updateIncrementId) {
        if (updateIncrementId) {
            ++this.incrementCounter;
        }
        this.incrementIdToTid.put(this.incrementCounter, this.nextTID);
        this.currentTID = this.nextTID;
    }

    @Override
    public IValue getCurrentTID() {
        return this.currentTID;
    }

    private V5ProviderCombination getLeafSet() {
        V5ProviderCombination combination = new V5ProviderCombination();
        List<IHierarchy> hiers = this.cube.getHierarchies();
        for (int i = 0; i < hiers.size(); ++i) {
            IHierarchy hier = hiers.get(i);
            if (!hier.isParentChild()) {
                ILevel leafLevel = hier.getLevel(hier.getLevelCount() - 1);
                combination.addSelection(new V5ProviderSelection(leafLevel.getMembers()));
                continue;
            }
            IMember[] hierMembers = hier.getMembers();
            ArrayList<IMember> leafMembers = new ArrayList<IMember>(hierMembers.length);
            for (IMember member : hierMembers) {
                if (!((ROLAPMemberProxy)member).isLeaf()) continue;
                leafMembers.add(member);
            }
            combination.addSelection(new V5ProviderSelection(leafMembers));
        }
        return combination;
    }

    private V5ProviderCombination getRootSet() {
        V5ProviderCombination combination = new V5ProviderCombination();
        List<IHierarchy> hiers = this.cube.getHierarchies();
        for (int i = 0; i < hiers.size(); ++i) {
            IHierarchy hier = hiers.get(i);
            ILevel rootLevel = hier.getLevel(0);
            combination.addSelection(new V5ProviderSelection(rootLevel.getMembers()));
        }
        return combination;
    }

    private ROLAPQuery buildQuery(V5ProviderCombination actualSelections, V5ProviderCombination predicateSelections) {
        HashMapObjectInt<String> hierToIndex = this.getHierToIndexMap();
        ROLAPQuery result = null;
        String queryName = "IncrementValueFetch-TID:" + this.nextTID.toString();
        IMember[] outputTuple = new IMember[hierToIndex.size()];
        int measuresIndex = -1;
        boolean factOnly = true;
        boolean injectTidFilters = false;
        result = new ROLAPQuery(queryName, this.cube.getSchema(), this.cube, false, true, false);
        result.setWorkloadLogger(null);
        HashSet<ROLAPLevel> levels = new HashSet<ROLAPLevel>();
        List<V5ProviderSelection> selectionList = actualSelections.getSelections();
        List<V5ProviderSelection> predicateSelectionsList = predicateSelections.getSelections();
        for (int i = 0; i < selectionList.size(); ++i) {
            List<IMember> memberList = selectionList.get(i).getMembersList();
            IMember mem = memberList.get(0);
            if (memberList.size() == 1) {
                int tupleIndex = hierToIndex.get(mem.getHierarchy().getUniqueName());
                outputTuple[tupleIndex] = mem;
            }
            if (mem.getDimension().isMeasuresDimension()) {
                measuresIndex = i;
            }
            if (i == measuresIndex) continue;
            ROLAPLevel level = (ROLAPLevel)mem.getLevel();
            levels.add(level);
            if (level.isAllLevel()) continue;
            ROLAPCompoundKeyMapping keyMapping = new ROLAPCompoundKeyMapping(true);
            keyMapping.addMemberSelections(memberList);
            if (!level.getHierarchy().isParentChild()) {
                List<ROLAPMemberProxy> predicateList = CollectionCast.uncheckedCast(predicateSelectionsList.get(i).getMembersList());
                keyMapping.setOverridePredicateMembers(predicateList);
            }
            keyMapping.addToQuery(result);
        }
        List<IMember> measuresSelections = selectionList.get(measuresIndex).getMembersList();
        for (IMember measure : measuresSelections) {
            if (!AggregateCalculationEngine.canRollupMeasure(measure)) continue;
            result.addMeasure((ROLAPMeasure)measure);
        }
        result.addValueFilterExpression(this.generateIncrementQueryTidExpression());
        result.setOutputTuple(outputTuple);
        return result;
    }

    private ClosableIterator<TupleValue> executeQuery(ROLAPQuery query) {
        V5ProviderQueryResult v5Result = query.execute(null);
        IROLAPQueryResultIterator result = v5Result.getProviderQueryResultIter();
        MultiRequestContext context = ExecutionEnvironmentContext.getExecutionEnvironment().getMultiRequestContext();
        RSAPIResultSet rs = context.removeResultset(result.getRSAPIDataset());
        MyTupleValueIterator tupleValueIterator = new MyTupleValueIterator(this.getHierToIndexMap(), v5Result, query, null, new ROLAPQueryExecuteMetrics(0), true);
        tupleValueIterator.setRs(rs);
        tupleValueIterator.setV5Result(v5Result);
        return tupleValueIterator;
    }

    private HashMapObjectInt<String> getHierToIndexMap() {
        List<IHierarchy> cubeHierarchiesList = this.cube.getHierarchies();
        HashMapObjectInt<String> hierToIndex = new HashMapObjectInt<String>();
        for (int i = 0; i < cubeHierarchiesList.size(); ++i) {
            Hierarchy hier = (Hierarchy)cubeHierarchiesList.get(i);
            hierToIndex.put(hier.getUniqueName(), i);
        }
        return hierToIndex;
    }

    private String generateIncrementQueryTidExpression() {
        String tidColName = this.getTidColName();
        String expression = tidColName + EXPRESSION_LTEQ + this.nextTID + EXPRESSION_AND + tidColName;
        expression = this.currentTID.isNull() ? expression + EXPRESSION_NOT_NULL : expression + EXPRESSION_GT + this.currentTID;
        return expression;
    }

    @Override
    public String generateFactQueryTidExpression(int incrementId) {
        IValue tid = this.incrementIdToTid.get(incrementId);
        String tidColName = this.getTidColName();
        String expression = "";
        if (!this.isDefaultTid(tid)) {
            expression = tidColName + EXPRESSION_LTEQ + tid + EXPRESSION_OR;
        }
        expression = expression + tidColName + EXPRESSION_IS_NULL;
        return expression;
    }

    @Override
    public String generateFactQueryNonDefaultTidExpression(int incrementId) {
        IValue tid = this.incrementIdToTid.get(incrementId);
        String tidColName = this.getTidColName();
        if (this.isDefaultTid(tid)) {
            return null;
        }
        return tidColName + EXPRESSION_LTEQ + tid + EXPRESSION_AND + tidColName + EXPRESSION_NOT_NULL;
    }

    private boolean isDefaultTid(IValue tid) {
        return tid.equals(DEFAULT_TID_VALUE) || tid.isNull();
    }

    @Override
    public void expireIncrementId(int incrementId) {
        this.incrementIdToTid.remove(incrementId);
    }

    private void initialize() {
        if (this.isIncrementalUpdatesEnabled()) {
            String strTIDOverride = System.getProperty(JVM_PARAM_TID_VAL_AT_CUBE_START);
            this.getNextTid(strTIDOverride);
            ROLAPLog.log("ROLAPCubes.IncrementalUpdates", String.format("Cube '%s' started with near real time updates enabled.  Initial TID is '%s'.", this.cube.getName(), this.nextTID));
        }
        this.commitIncrement(false);
    }

    private IValue fetchNextTidFromDB() {
        String tidColName = this.getTidColName();
        if (tidColName == null) {
            throw new IllegalStateException("TID column could not be determined.");
        }
        return TIDQuery.getCellValueForExecutedV5QuerySet(this.cube.getName(), new TIDQuery(this.cube, new String[]{"TID", tidColName}));
    }

    @Override
    public boolean isIncrementalUpdatesEnabled() {
        return this.getTidColName() != null;
    }

    private static class MyTupleValueIterator
    extends ROLAPQueryStrategy.TupleValueIterator {
        private V5ProviderQueryResult v5Result = null;
        private RSAPIResultSet rs = null;

        MyTupleValueIterator(HashMapObjectInt<String> hierToIndexMap, V5ProviderQueryResult queryResultIter, ROLAPQuery queryObj, IResultSet resultSet, ROLAPQueryExecuteMetrics metrics, boolean internallyManageNotifyStartAndEnd) {
            super(hierToIndexMap, queryResultIter, queryObj, resultSet, metrics, internallyManageNotifyStartAndEnd);
        }

        public void setV5Result(V5ProviderQueryResult theV5Result) {
            this.v5Result = theV5Result;
        }

        public void setRs(RSAPIResultSet theRS) {
            this.rs = theRS;
        }

        @Override
        public void close() {
            if (this.v5Result != null) {
                this.v5Result.release();
                this.v5Result = null;
            }
            try {
                super.close();
            }
            catch (Throwable ex) {
                ROLAPLog.logError("Exception", "Exception caught in TupleValueIterator.close()", ex);
            }
            if (this.rs != null) {
                this.rs.release();
                this.rs = null;
            }
        }
    }

    public static final class TIDQuery
    extends QueryHelper.QuerySetBuilder {
        private static final String REQUEST_ID_FOR_TID_QUERY = "requestIdForTidQuery";
        private static final String TID_QUERY_NAME_PREFIX = "TidQuery_for_";
        public static final String DATAITEM_AGGREGATE_NONE = "none";
        private final ROLAPBaseCube cube;
        private final String[] dataItemInfo;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static IValue getCellValueForExecutedV5QuerySet(String cubeName, QueryHelper.QuerySetBuilder queryBuilder) {
            TraceContext traceCtx = TraceContext.enter();
            IValue value = null;
            try {
                QueryEnvironmentHelper envHelper = new QueryEnvironmentHelper();
                ROLAPBaseCube cube = (ROLAPBaseCube)ROLAPCubeManager.getInstance().getCube(cubeName);
                envHelper.setCMRequestExecutor(cube.getAccountManager());
                envHelper.setInternalUse(true);
                envHelper.setUpEnvironment(false);
                ExecutionEnvironment newExecEnv = envHelper.getExecutionEnvironment();
                RequestEnvironment newReqEnv = envHelper.getRequestEnvironment();
                MultiRequestContext context = newExecEnv.getMultiRequestContext();
                RequestParameters origParams = context.getRequestParameters();
                context.clearRequestParameters();
                ROLAPContext.setRelQueryExecuting();
                try {
                    TIDQuery.setupRequestEnvironment(newReqEnv, cube);
                    RolapV5Builder.setupConnectionElement(newExecEnv);
                    PlanningEnvironment planEnv = QueryPlanner.setupEnvironment(newReqEnv);
                    planEnv.setMetdataConnection(cube.getConnection());
                    V5QuerySet v5QuerySet = queryBuilder.build(planEnv);
                    PlannedV5QuerySet plannedQuerySet = QueryPlanner.getInstance().planQuery(v5QuerySet, planEnv);
                    RSAPIDataset dataset = RolapQueryHelper.getDataset(queryBuilder.getMainQueryName(), plannedQuerySet);
                    RSAPIPartialDataset partialDataset = null;
                    RSAPIEdgeIterator edgeIterator = null;
                    if (dataset != null) {
                        try {
                            partialDataset = QueryEngine.getInstance().getPartialDataset(dataset, new int[]{0}, new int[]{0}, true, false, newExecEnv);
                            edgeIterator = partialDataset.edgeIterator(0);
                            while (edgeIterator.hasNext()) {
                                RSAPIRow r = edgeIterator.next();
                                IValue[] values = r.getColumns();
                                if (values.length <= 0) continue;
                                value = values[0];
                                break;
                            }
                            if (value == null) {
                                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Empty result set while fetching next TID.");
                            }
                        }
                        finally {
                            try {
                                if (edgeIterator != null) {
                                    edgeIterator.close();
                                    edgeIterator = null;
                                }
                            }
                            finally {
                                try {
                                    if (partialDataset != null) {
                                        partialDataset.release();
                                        partialDataset = null;
                                    }
                                }
                                finally {
                                    dataset.releaseResultset(newExecEnv);
                                    dataset = null;
                                }
                            }
                        }
                    }
                    IValue iValue = value;
                    envHelper.tearDownEnvironment();
                    context.setRequestParameters(origParams);
                    return iValue;
                }
                catch (Throwable throwable) {
                    envHelper.tearDownEnvironment();
                    context.setRequestParameters(origParams);
                    throw throwable;
                }
            }
            finally {
                traceCtx.exit();
            }
        }

        private static void setupRequestEnvironment(RequestEnvironment reqEnv, ROLAPBaseCube cube) {
            RolapV5Builder.setRequestEnvironmentCubeInfo(reqEnv, cube);
            reqEnv.setRequestID(REQUEST_ID_FOR_TID_QUERY);
            reqEnv.setSubRequestID(null);
            reqEnv.setOperationName("command");
            reqEnv.setReportName(REQUEST_ID_FOR_TID_QUERY);
        }

        public TIDQuery(ROLAPBaseCube theCube, String[] theDataItemInfo) {
            this.cube = theCube;
            this.dataItemInfo = theDataItemInfo;
        }

        @Override
        public String getMainQueryName() {
            return TID_QUERY_NAME_PREFIX + this.cube.getName();
        }

        @Override
        public V5QuerySet build(PlanningEnvironment planEnv) {
            XQENodeFactory nodeFactory = planEnv.getNodeFactory();
            String queryName = this.getMainQueryName();
            String modelPath = this.cube.getSchema().getCommonCubeModel().getModelPath();
            V5QuerySet v5QuerySet = RolapV5Builder.addNewV5QuerySetToPlanner(planEnv, modelPath, nodeFactory);
            IXQEQueryNode selection = RolapV5Builder.addRelationalQuerySelection(nodeFactory, v5QuerySet, queryName);
            IXQEQueryNode groupBody = RolapV5Builder.addGroupBodyNode(nodeFactory, queryName);
            String dataItemName = this.dataItemInfo[0];
            String dataItemExpression = this.dataItemInfo[1];
            String aggregateType = AggregateTypeEnum.MAX.toV5Type();
            RolapV5Builder.addDataItem(nodeFactory, selection, groupBody, dataItemName, dataItemExpression, aggregateType);
            RolapV5Builder.buildAndInsertQRD(nodeFactory, v5QuerySet, queryName, groupBody);
            return v5QuerySet;
        }
    }
}

