/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.util;

import com.cognos.xqe.runtree.olap.mdx.util.CopyOnWriteIntegerSet;
import java.util.Arrays;

public class FastIntersectIntegerSet {
    private int[] data;
    private int length;

    public FastIntersectIntegerSet(int[] items, boolean sort) {
        if (sort) {
            Arrays.sort(items);
        }
        this.data = items;
        this.length = this.data.length;
    }

    public int size() {
        return this.length;
    }

    public int[] getData() {
        return this.data;
    }

    public final void intersect(CopyOnWriteIntegerSet subject) {
        int maxSize;
        int i1 = 0;
        int i2 = 0;
        int outIndex = 0;
        int[] data2 = subject.getData();
        int d1Len = this.length;
        int d2Len = data2.length;
        if (this.data == null || d1Len == 0 || d2Len == 0 || this.data[d1Len - 1] < data2[0] || data2[d2Len - 1] < this.data[0]) {
            this.length = 0;
        }
        if (d2Len < (maxSize = d1Len)) {
            maxSize = d2Len;
        }
        while (i1 < d1Len && i2 < d2Len) {
            if (this.data[i1] == data2[i2]) {
                this.data[outIndex++] = this.data[i1++];
                ++i2;
                continue;
            }
            if (this.data[i1] > data2[i2]) {
                ++i2;
                continue;
            }
            ++i1;
        }
        this.length = outIndex;
    }

    public String toString() {
        String result = "IntegerSet (";
        for (int i = 0; i < this.length; ++i) {
            int v = this.data[i];
            result = result + v;
            if (i >= this.length - 1) continue;
            result = result + ",";
        }
        result = result + ")";
        return result;
    }
}

