/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.util;

import java.util.Arrays;
import java.util.Iterator;

public class IntegerSet {
    private int[] data;
    private int[] pending;
    private int pendingCount;
    private boolean needSort;
    private static final int INITIAL_SET_SIZE = 100;

    public String toString() {
        String result = "IntegerSet (";
        int[] tmpData = this.getData();
        for (int i = 0; i < tmpData.length; ++i) {
            int v = tmpData[i];
            result = result + v;
            if (i >= tmpData.length - 1) continue;
            result = result + ",";
        }
        result = result + ")";
        return result;
    }

    public IntegerSet(int[] items) {
        Arrays.sort(items);
        this.pendingCount = 0;
        this.needSort = false;
        this.pending = null;
        this.data = items;
    }

    public final int[] getData() {
        this.addPending();
        if (this.needSort) {
            Arrays.sort(this.data);
            this.needSort = false;
        }
        return this.data;
    }

    public IntegerSet(int[] items, boolean sortIt) {
        this.pendingCount = 0;
        this.needSort = false;
        if (sortIt) {
            Arrays.sort(items);
        }
        this.data = items;
    }

    public static IntegerSet fromArrays(int[][] inputs, boolean sort) {
        int[] indexes = new int[inputs.length];
        int[] lengths = new int[inputs.length];
        int outSize = 0;
        for (int i = 0; i < inputs.length; ++i) {
            outSize += inputs[i].length;
            lengths[i] = inputs[i].length;
            if (!sort) continue;
            Arrays.sort(inputs[i]);
        }
        int[] output = new int[outSize];
        int outIdx = 0;
        int duplicates = 0;
        while (outIdx + duplicates < outSize) {
            int leastValue = Integer.MAX_VALUE;
            int leastValueArrayIdx = -1;
            for (int i = 0; i < inputs.length; ++i) {
                int v;
                if (indexes[i] >= lengths[i] || (v = inputs[i][indexes[i]]) >= leastValue) continue;
                leastValue = v;
                leastValueArrayIdx = i;
            }
            if (outIdx > 0 && output[outIdx - 1] == leastValue) {
                ++duplicates;
            } else {
                output[outIdx] = leastValue;
                ++outIdx;
            }
            int n = leastValueArrayIdx;
            indexes[n] = indexes[n] + 1;
        }
        if (duplicates > 0) {
            int[] current = output;
            output = new int[outIdx];
            for (int i = 0; i < outIdx; ++i) {
                output[i] = current[i];
            }
        }
        return new IntegerSet(output, false);
    }

    public IntegerSet() {
        this.data = null;
        this.pending = null;
        this.pendingCount = 0;
    }

    public final void add(int i) {
        this.needSort = true;
        if (this.pending == null) {
            this.pending = new int[100];
        }
        this.pending[this.pendingCount] = i;
        ++this.pendingCount;
        if (this.pendingCount == this.pending.length) {
            this.addPending();
        }
    }

    private void addPending() {
        if (this.pending != null && this.pendingCount > 0) {
            int currentDataSize = 0;
            if (this.data != null && this.data.length > 0) {
                currentDataSize = this.data.length;
            }
            int[] temp = new int[this.pendingCount + currentDataSize];
            for (int i = 0; i < currentDataSize; ++i) {
                temp[i] = this.data[i];
            }
            int count = 0;
            for (int j = currentDataSize; j < temp.length; ++j) {
                temp[j] = this.pending[count];
                ++count;
            }
            this.data = temp;
            if (this.pendingCount != 100) {
                this.pending = null;
                Arrays.sort(this.data);
                this.needSort = false;
            }
            this.pendingCount = 0;
        }
    }

    public IntegerSet union2(IntegerSet subject) {
        int[] data1 = this.getData();
        int[] data2 = subject.getData();
        int[][] input = new int[][]{data1, data2};
        return IntegerSet.fromArrays(input, false);
    }

    public IntegerSet union(IntegerSet subject) {
        int i1 = 0;
        int i2 = 0;
        int outIndex = 0;
        int[] data1 = this.getData();
        int[] data2 = subject.getData();
        int maxSize = data1.length + data2.length;
        int[] out = new int[maxSize];
        while (i1 < data1.length || i2 < data2.length) {
            if (i1 == data1.length) {
                out[outIndex] = data2[i2];
                ++outIndex;
                ++i2;
                continue;
            }
            if (i2 == data2.length) {
                out[outIndex] = data1[i1];
                ++outIndex;
                ++i1;
                continue;
            }
            if (data1[i1] == data2[i2]) {
                int value = data1[i1];
                while (i1 < data1.length && data1[i1] == value) {
                    ++i1;
                }
                while (i2 < data2.length && data2[i2] == value) {
                    ++i2;
                }
                out[outIndex] = value;
                ++outIndex;
                continue;
            }
            if (data1[i1] > data2[i2]) {
                out[outIndex] = data2[i2];
                ++outIndex;
                ++i2;
                continue;
            }
            out[outIndex] = data1[i1];
            ++outIndex;
            ++i1;
        }
        int[] result = new int[outIndex];
        for (int i = 0; i < result.length; ++i) {
            result[i] = out[i];
        }
        return new IntegerSet(result, false);
    }

    public final IntegerSet intersect(IntegerSet subject) {
        int i1 = 0;
        int i2 = 0;
        int outIndex = 0;
        int[] data1 = this.getData();
        int[] data2 = subject.getData();
        int d1Len = data1.length;
        int d2Len = data2.length;
        if (d1Len == 0 || d2Len == 0 || data1[d1Len - 1] < data2[0] || data2[d2Len - 1] < data1[0]) {
            return new IntegerSet(new int[0], false);
        }
        int maxSize = d1Len;
        if (d2Len < maxSize) {
            maxSize = d2Len;
        }
        int[] out = new int[maxSize];
        while (i1 < d1Len && i2 < d2Len) {
            if (data1[i1] == data2[i2]) {
                out[outIndex++] = this.data[i1++];
                ++i2;
                continue;
            }
            if (data1[i1] > data2[i2]) {
                ++i2;
                continue;
            }
            ++i1;
        }
        int[] result = new int[outIndex];
        for (int i = 0; i < result.length; ++i) {
            result[i] = out[i];
        }
        return new IntegerSet(result, false);
    }

    public int size() {
        if (this.pendingCount > 0) {
            this.addPending();
        }
        if (this.data != null) {
            return this.data.length;
        }
        return 0;
    }

    public Iterator<Integer> iterator() {
        if (this.pendingCount > 0) {
            this.addPending();
        }
        return new QuickIntersectSetIterator(this.data);
    }

    class QuickIntersectSetIterator
    implements Iterator<Integer> {
        int idx = 0;
        int[] subject;
        int size;

        QuickIntersectSetIterator(int[] theData) {
            this.subject = theData;
            this.size = theData.length;
        }

        @Override
        public boolean hasNext() {
            return this.idx < this.size;
        }

        @Override
        public Integer next() {
            Integer result = new Integer(this.subject[this.idx]);
            ++this.idx;
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

