/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.util;

import com.cognos.xqe.runtree.olap.mdx.metadata.ProviderException;
import com.ibm.icu.util.StringTokenizer;
import java.io.BufferedReader;
import java.io.IOException;

public class MDLParser {
    private BufferedReader modelBR;
    private String pending;
    private static final String ONE_SPACE = " ";

    public MDLParser(BufferedReader br) {
        this.modelBR = br;
    }

    public String next(String expectedKeyword, String skipKeyword) {
        String ln = this.getPending();
        if (ln == null) {
            try {
                ln = this.modelBR.readLine();
            }
            catch (IOException ioe) {
                throw new ProviderException(ioe.toString());
            }
        }
        if (ln != null) {
            while (true) {
                if (ln == null) {
                    return null;
                }
                if (ln.startsWith(expectedKeyword)) {
                    return this.readBlock(ln, skipKeyword);
                }
                if (!ln.equals("")) {
                    this.pending = ln;
                    StringTokenizer st = new StringTokenizer(ln);
                    String token = st.nextToken();
                    if (MDLKeywordsEnum.isKeyword(token + ONE_SPACE)) {
                        return null;
                    }
                }
                try {
                    ln = this.modelBR.readLine();
                }
                catch (IOException ioe) {
                    throw new ProviderException(ioe.toString());
                }
            }
        }
        return ln;
    }

    public String next(String expectedKeyword) {
        return this.next(expectedKeyword, null);
    }

    private String readBlock(String ln, String skipKeyword) {
        StringBuilder sb = new StringBuilder();
        sb.append(ln);
        boolean sameBlock = true;
        while (sameBlock) {
            try {
                ln = this.modelBR.readLine();
            }
            catch (IOException ioe) {
                throw new ProviderException(ioe.toString());
            }
            if (ln == null || ln.equals("")) {
                sameBlock = false;
                this.pending = null;
                continue;
            }
            StringTokenizer st = new StringTokenizer(ln);
            String token = st.nextToken();
            if (MDLKeywordsEnum.isKeyword(token + ONE_SPACE) && !(token + ONE_SPACE).equals(skipKeyword)) {
                this.pending = ln;
                sameBlock = false;
                continue;
            }
            sb.append(ln);
            this.pending = null;
        }
        return sb.toString();
    }

    public String getPending() {
        return this.pending;
    }

    public static enum MDLKeywordsEnum {
        COGNOSSOURCE("CognosSource "),
        CUBE("Cube "),
        ORGNAME("OrgName "),
        DIMENSION("Dimension "),
        LEVEL("Levels "),
        MEASURE("Measure "),
        NAME("Name "),
        CATEGORY("Category ");

        private final String keyword;

        private MDLKeywordsEnum(String st) {
            this.keyword = st;
        }

        public String getKeyword() {
            return this.keyword;
        }

        public static boolean isKeyword(String s) {
            for (MDLKeywordsEnum e : MDLKeywordsEnum.values()) {
                if (!e.getKeyword().equals(s)) continue;
                return true;
            }
            return false;
        }
    }
}

