/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.util;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.resultset.interfaces.ISet;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.CrossJoinedSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.metadata.Cube;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.ArrayCast;
import com.cognos.xqe.util.primitive.HashMapIntObject;
import com.cognos.xqe.util.primitive.IteratorInt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class SymmetricQueryBuilder {
    private List<MemberCubelet> cubelets = new ArrayList<MemberCubelet>();
    private boolean bMergeByLevel = false;
    ArrayList<CrossJoinedSet> consolidatedSets;

    public SymmetricQueryBuilder(boolean mergeByLevel) {
        this.bMergeByLevel = mergeByLevel;
    }

    public void addSet(Set set) {
        if (this.consolidatedSets != null) {
            throw new InternalError("Improper use of SymmetricQueryBuilder: cannot add input set once consolidation sets have been built");
        }
        boolean foundMatch = false;
        ICube cube = set.getDimensions()[0].getCube();
        IMember[][] requestedSelections = set.getMembers(((Cube)cube).getHierarchies(true).toArray(new IHierarchy[0]));
        for (MemberCubelet cubelet : this.cubelets) {
            if (!cubelet.merge(requestedSelections)) continue;
            foundMatch = true;
            break;
        }
        if (!foundMatch) {
            if (this.bMergeByLevel) {
                this.cubelets.add(new LevelMemberCubelet(set));
            } else {
                this.cubelets.add(new MemberCubelet(set));
            }
        }
    }

    public List<CrossJoinedSet> getConsolidatedSets(double weakConsolidationThreshold) {
        XQELogger symmetricSubqueryLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "SymmetricSubqueryIterator", LogLevel.TRACE);
        if (this.consolidatedSets == null) {
            CrossJoinedSet cjs;
            symmetricSubqueryLogger.log("Consolidating " + this.cubelets.size() + " member cubelets");
            this.consolidatedSets = new ArrayList();
            this.consolidateCubelets(this.cubelets, false);
            for (MemberCubelet cube : this.cubelets) {
                if (cube.isMerged()) continue;
                cjs = cube.getQuerySet();
                this.consolidatedSets.add(cjs);
            }
            if (weakConsolidationThreshold > 0.0 && (double)this.consolidatedSets.size() > weakConsolidationThreshold) {
                symmetricSubqueryLogger.log("Proceeding to weak merge with " + this.consolidatedSets.size() + " cubelets, threshold: " + weakConsolidationThreshold);
                this.consolidatedSets = new ArrayList();
                this.consolidateCubelets(this.cubelets, true);
                for (MemberCubelet cube : this.cubelets) {
                    if (cube.isMerged()) continue;
                    cjs = cube.getQuerySet();
                    this.consolidatedSets.add(cjs);
                }
            }
            symmetricSubqueryLogger.log("Number of cubelets after consolidation: " + this.consolidatedSets.size());
        }
        return this.consolidatedSets;
    }

    private void consolidateCubelets(List<MemberCubelet> cubeletsToConsolidate, boolean allowWeakMerge) {
        boolean merged = false;
        block0: for (int i = 0; i < cubeletsToConsolidate.size(); ++i) {
            MemberCubelet base = cubeletsToConsolidate.get(i);
            if (base.isMerged()) continue;
            for (int j = i + 1; j < cubeletsToConsolidate.size(); ++j) {
                MemberCubelet cube = cubeletsToConsolidate.get(j);
                if (cube.isMerged() || !base.mergeCubelet(cube, allowWeakMerge)) continue;
                merged = true;
                continue block0;
            }
        }
        if (merged) {
            this.consolidateCubelets(cubeletsToConsolidate, allowWeakMerge);
        }
    }

    private class LevelMemberCubelet
    extends MemberCubelet {
        LevelMemberCubelet(ISet set) {
            super(set);
        }

        @Override
        public boolean merge(IMember[][] setToMerge) {
            int memberId;
            if (setToMerge.length != this.projectedLevelsByHierarchy.size()) {
                return false;
            }
            ArrayList exceptSetByHierarchy = new ArrayList();
            for (int i = 0; i < setToMerge.length; ++i) {
                HashSet expectedLevels = (HashSet)this.projectedLevelsByHierarchy.get(i);
                HashSet<IMember> exceptSet = new HashSet<IMember>();
                for (IMember member : setToMerge[i]) {
                    if (!expectedLevels.contains(member.getLevel())) {
                        return false;
                    }
                    memberId = this.getMemberIndex(member);
                    int position = Arrays.binarySearch(this.intQuerySet[i], memberId);
                    if (position >= 0) continue;
                    exceptSet.add(member);
                }
                exceptSetByHierarchy.add(exceptSet);
            }
            boolean bMerged = false;
            for (int i = 0; i < exceptSetByHierarchy.size(); ++i) {
                HashSet membersToAdd = (HashSet)exceptSetByHierarchy.get(i);
                if (membersToAdd.isEmpty()) continue;
                int[] temp = this.intQuerySet[i];
                int[] bigger = new int[this.intQuerySet[i].length + membersToAdd.size()];
                System.arraycopy(temp, 0, bigger, 0, temp.length);
                this.intQuerySet[i] = bigger;
                for (IMember member : membersToAdd) {
                    memberId = this.getMemberIndex(member);
                    this.membersMap[i].put(memberId, member);
                    int j = this.membersMap[i].size() - 1;
                    this.intQuerySet[i][j] = memberId;
                }
                Arrays.sort(this.intQuerySet[i]);
                bMerged = true;
            }
            return bMerged;
        }

        @Override
        public boolean mergeCubelet(MemberCubelet mc, boolean allowWeakMerge) {
            if (!mc.projectedLevelsByHierarchy.equals(this.projectedLevelsByHierarchy)) {
                return false;
            }
            Integer[][] exceptSetByHierarchy = new Integer[this.intQuerySet.length][];
            for (int i = 0; i < mc.intQuerySet.length; ++i) {
                ArrayList<Integer> exceptSet = new ArrayList<Integer>();
                for (int memberId : mc.intQuerySet[i]) {
                    int position = Arrays.binarySearch(this.intQuerySet[i], memberId);
                    if (position >= 0) continue;
                    exceptSet.add(memberId);
                }
                exceptSetByHierarchy[i] = exceptSet.toArray(new Integer[0]);
            }
            boolean bMerged = false;
            for (int i = 0; i < exceptSetByHierarchy.length; ++i) {
                Integer[] membersToAdd = exceptSetByHierarchy[i];
                if (membersToAdd.length == 0) continue;
                int[] temp = this.intQuerySet[i];
                int[] bigger = new int[this.intQuerySet[i].length + membersToAdd.length];
                System.arraycopy(temp, 0, bigger, 0, temp.length);
                this.intQuerySet[i] = bigger;
                for (Integer memberId : membersToAdd) {
                    IMember member = mc.membersMap[i].get(memberId);
                    this.membersMap[i].put(memberId, member);
                    int j = this.membersMap[i].size() - 1;
                    this.intQuerySet[i][j] = memberId;
                }
                Arrays.sort(this.intQuerySet[i]);
                bMerged = true;
            }
            if (bMerged) {
                mc.merged = true;
            }
            return bMerged;
        }
    }

    private class MemberCubelet {
        protected ICube cube;
        private boolean merged = false;
        protected HashMapIntObject<IMember>[] membersMap;
        protected List<HashSet<ILevel>> projectedLevelsByHierarchy = new ArrayList<HashSet<ILevel>>();
        protected int[][] intQuerySet;

        MemberCubelet(ISet set) {
            this.buildAxes(set);
        }

        protected void buildAxes(ISet set) {
            this.cube = set.getDimensions()[0].getCube();
            IHierarchy[] cubeHierarchies = this.getHierachies().toArray(new IHierarchy[0]);
            int hierCount = cubeHierarchies.length;
            this.membersMap = (HashMapIntObject[])ArrayCast.uncheckedCast(new HashMapIntObject[hierCount]);
            this.intQuerySet = new int[hierCount][];
            for (int i = 0; i < hierCount; ++i) {
                HashSet<ILevel> projectedLevels = new HashSet<ILevel>();
                this.projectedLevelsByHierarchy.add(projectedLevels);
                IMember[] selectionsMemArray = (IMember[])ArrayCast.uncheckedCast(((Set)set).getMembers(cubeHierarchies[i]));
                this.membersMap[i] = new HashMapIntObject(selectionsMemArray.length);
                this.intQuerySet[i] = new int[selectionsMemArray.length];
                for (int j = 0; j < selectionsMemArray.length; ++j) {
                    int memberId;
                    this.intQuerySet[i][j] = memberId = this.getMemberIndex(selectionsMemArray[j]);
                    this.membersMap[i].put(memberId, selectionsMemArray[j]);
                    projectedLevels.add(selectionsMemArray[j].getLevel());
                }
                Arrays.sort(this.intQuerySet[i]);
            }
        }

        protected List<IHierarchy> getHierachies() {
            return ((Cube)this.cube).getHierarchies(true);
        }

        public boolean merge(IMember[][] setToMerge) {
            int numDiffHierarchies = 0;
            for (int i = 0; i < this.intQuerySet.length; ++i) {
                if (this.intQuerySet[i].length == setToMerge[i].length) continue;
                ++numDiffHierarchies;
                if (this.intQuerySet[i].length != 0 && setToMerge[i].length != 0) continue;
                return false;
            }
            if (numDiffHierarchies > 1) {
                return false;
            }
            int variableHierarchy = -1;
            HashSet membersToAdd = new HashSet();
            for (int i = 0; i < this.intQuerySet.length; ++i) {
                boolean sameSize;
                IMember[] hierarchySelections = setToMerge[i];
                HashSet<IMember> exceptSet = new HashSet<IMember>();
                boolean bl = sameSize = this.intQuerySet[i].length == hierarchySelections.length;
                if (!sameSize && variableHierarchy > -1) {
                    return false;
                }
                for (IMember member : hierarchySelections) {
                    int memberId = this.getMemberIndex(member);
                    int position = Arrays.binarySearch(this.intQuerySet[i], memberId);
                    if (position >= 0) continue;
                    if (variableHierarchy > -1) {
                        return false;
                    }
                    exceptSet.add(member);
                }
                if (exceptSet.isEmpty() && sameSize) continue;
                if (variableHierarchy == -1) {
                    variableHierarchy = i;
                    membersToAdd = exceptSet;
                    continue;
                }
                return false;
            }
            if (variableHierarchy > -1) {
                int[] temp = this.intQuerySet[variableHierarchy];
                int[] bigger = new int[this.intQuerySet[variableHierarchy].length + membersToAdd.size()];
                System.arraycopy(temp, 0, bigger, 0, temp.length);
                this.intQuerySet[variableHierarchy] = bigger;
                for (IMember member : membersToAdd) {
                    int memberId = this.getMemberIndex(member);
                    this.membersMap[variableHierarchy].put(memberId, member);
                    int j = this.membersMap[variableHierarchy].size() - 1;
                    this.intQuerySet[variableHierarchy][j] = memberId;
                }
                Arrays.sort(this.intQuerySet[variableHierarchy]);
            }
            return true;
        }

        public CrossJoinedSet getQuerySet() {
            ISet[] sets = new ISet[this.intQuerySet.length];
            for (int i = 0; i < this.intQuerySet.length; ++i) {
                ITuple[] members = new ITuple[this.membersMap[i].size()];
                IteratorInt it = this.membersMap[i].keySetIterator();
                int j = 0;
                while (it.hasNext()) {
                    members[j] = new Tuple(this.membersMap[i].get(it.next()));
                    ++j;
                }
                sets[i] = new Set(members);
            }
            CrossJoinedSet cjs = new CrossJoinedSet(sets);
            return cjs;
        }

        public boolean isMerged() {
            return this.merged;
        }

        /*
         * WARNING - void declaration
         */
        public boolean mergeCubelet(MemberCubelet mc, boolean allowWeakMerge) {
            void memberId;
            int i;
            int variableHierarchyOne = -1;
            int[] membersHierarchyOne = null;
            int numMembersHierarchyOne = -1;
            int totalNumberOfDiffsHierarchyOne = -1;
            int variableHierarchyTwo = -1;
            int[] membersHierarchyTwo = null;
            int numMembersHierarchyTwo = -1;
            int numDiffHierarchies = 0;
            for (i = 0; i < this.intQuerySet.length; ++i) {
                if (this.membersMap[i].size() == mc.membersMap[i].size()) continue;
                ++numDiffHierarchies;
                if (this.membersMap[i].size() != 0 && mc.membersMap[i].size() != 0) continue;
                return false;
            }
            if (!allowWeakMerge && numDiffHierarchies > 1 || numDiffHierarchies > 2) {
                return false;
            }
            for (i = 0; i < this.intQuerySet.length; ++i) {
                if (this.membersMap[i].size() == mc.membersMap[i].size() && Arrays.equals(this.intQuerySet[i], mc.intQuerySet[i])) continue;
                if (!(variableHierarchyOne <= -1 || allowWeakMerge && variableHierarchyTwo <= -1)) {
                    return false;
                }
                int numMembersA = this.membersMap[i].size();
                int[] cubeADiffs = new int[numMembersA];
                int numADiffs = 0;
                int indexA = 0;
                int[] querySetA = this.intQuerySet[i];
                int numMembersB = mc.membersMap[i].size();
                int[] cubeBDiffs = new int[numMembersB];
                int numBDiffs = 0;
                int indexB = 0;
                int[] querySetB = mc.intQuerySet[i];
                while (indexA < numMembersA || indexB < numMembersB) {
                    if (indexA >= numMembersA) {
                        cubeBDiffs[numBDiffs] = querySetB[indexB];
                        ++numBDiffs;
                        ++indexB;
                    } else if (indexB >= numMembersB) {
                        cubeADiffs[numADiffs] = querySetA[indexA];
                        ++numADiffs;
                        ++indexA;
                    } else if (querySetA[indexA] == querySetB[indexB]) {
                        ++indexA;
                        ++indexB;
                    } else if (querySetA[indexA] < querySetB[indexB]) {
                        cubeADiffs[numADiffs] = querySetA[indexA];
                        ++numADiffs;
                        ++indexA;
                    } else if (querySetA[indexA] > querySetB[indexB]) {
                        cubeBDiffs[numBDiffs] = querySetB[indexB];
                        ++numBDiffs;
                        ++indexB;
                    }
                    if (numADiffs <= 0 && numBDiffs <= 0 || allowWeakMerge || variableHierarchyOne <= -1) continue;
                    return false;
                }
                if (numBDiffs <= 0 && numADiffs <= 0) continue;
                int potentialTotalNumberOfDiffs = numADiffs + numBDiffs;
                if (variableHierarchyOne == -1) {
                    variableHierarchyOne = i;
                    membersHierarchyOne = cubeBDiffs;
                    numMembersHierarchyOne = numBDiffs;
                    totalNumberOfDiffsHierarchyOne = potentialTotalNumberOfDiffs;
                    continue;
                }
                if (variableHierarchyTwo == -1 && allowWeakMerge) {
                    long numberOfExcessTuples = potentialTotalNumberOfDiffs * totalNumberOfDiffsHierarchyOne;
                    long numberRequestedTuples = this.intQuerySet[i].length * this.intQuerySet[variableHierarchyOne].length + mc.intQuerySet[i].length * mc.intQuerySet[variableHierarchyOne].length;
                    if (numberOfExcessTuples < numberRequestedTuples / 2L) {
                        variableHierarchyTwo = i;
                        membersHierarchyTwo = cubeBDiffs;
                        numMembersHierarchyTwo = numBDiffs;
                        continue;
                    }
                    return false;
                }
                return false;
            }
            if (variableHierarchyOne > -1) {
                int[] temp = this.intQuerySet[variableHierarchyOne];
                int[] bigger = new int[this.intQuerySet[variableHierarchyOne].length + numMembersHierarchyOne];
                System.arraycopy(temp, 0, bigger, 0, temp.length);
                this.intQuerySet[variableHierarchyOne] = bigger;
                for (int i2 = 0; i2 < numMembersHierarchyOne; ++i2) {
                    memberId = membersHierarchyOne[i2];
                    IMember member = mc.membersMap[variableHierarchyOne].get((int)memberId);
                    this.membersMap[variableHierarchyOne].put((int)memberId, member);
                    int j = this.membersMap[variableHierarchyOne].size() - 1;
                    this.intQuerySet[variableHierarchyOne][j] = memberId;
                }
                Arrays.sort(this.intQuerySet[variableHierarchyOne]);
            }
            if (variableHierarchyTwo > -1) {
                int[] temp = this.intQuerySet[variableHierarchyTwo];
                int[] bigger = new int[temp.length + numMembersHierarchyTwo];
                System.arraycopy(temp, 0, bigger, 0, temp.length);
                this.intQuerySet[variableHierarchyTwo] = bigger;
                for (int i3 = 0; i3 < numMembersHierarchyTwo; ++i3) {
                    memberId = membersHierarchyTwo[i3];
                    IMember member = mc.membersMap[variableHierarchyTwo].get((int)memberId);
                    this.membersMap[variableHierarchyTwo].put((int)memberId, member);
                    int j = this.membersMap[variableHierarchyTwo].size() - 1;
                    this.intQuerySet[variableHierarchyTwo][j] = memberId;
                }
                Arrays.sort(this.intQuerySet[variableHierarchyTwo]);
            }
            mc.merged = true;
            return true;
        }

        protected int getMemberIndex(IMember mun) {
            return ((Cube)this.cube).getMemberIndex(mun);
        }
    }
}

