/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.v5provider;

import com.cognos.xqe.runtree.olap.mdx.interpreter.QueryContext;
import com.cognos.xqe.runtree.olap.mdx.v5provider.V5ProviderQuery;
import com.cognos.xqe.runtree.olap.mdx.v5provider.V5ProviderQueryResult;
import com.cognos.xqe.trace.XQEDebugLog;
import java.util.ArrayList;
import java.util.HashMap;

public abstract class V5ProviderQueryGroup {
    private ArrayList<V5ProviderQuery> queries = new ArrayList();
    private HashMap<String, V5ProviderQuery> queryNameToQuery = new HashMap();
    private HashMap<String, V5ProviderQueryResult> queryNameToResult = new HashMap();
    private QueryContext mUserInfo = null;

    public ArrayList<V5ProviderQuery> getQueries() {
        return this.queries;
    }

    public HashMap<String, V5ProviderQuery> getQueryNameToQuery() {
        return this.queryNameToQuery;
    }

    public HashMap<String, V5ProviderQueryResult> getQueryNameToResult() {
        return this.queryNameToResult;
    }

    public boolean containsQuery(String name) {
        return this.queryNameToQuery.containsKey(name);
    }

    public void setQueries(V5ProviderQuery query) {
        this.queries.add(query);
    }

    public void setQueryNameToQuery(String name, V5ProviderQuery query) {
        this.queryNameToQuery.put(name, query);
    }

    public void setQueryNameToResult(String name, V5ProviderQueryResult result) {
        this.queryNameToResult.put(name, result);
    }

    public int queryCount() {
        if (this.queries != null) {
            return this.queries.size();
        }
        return 0;
    }

    public V5ProviderQuery getQuery(int i) {
        return this.queries.get(i);
    }

    public void addQuery(V5ProviderQuery query) {
        if (this.queryNameToQuery.containsKey(query.getName())) {
            XQEDebugLog.err.println("V5Query group already contains a query called " + query.getName() + ". Queries in a group must have distinct names.");
        }
        this.queries.add(query);
        this.queryNameToQuery.put(query.getName(), query);
    }

    public V5ProviderQueryResult getResult(String queryName) {
        return this.queryNameToResult.get(queryName);
    }

    public V5ProviderQueryResult getResult(int queryIndex) {
        V5ProviderQuery q = this.queries.get(queryIndex);
        return this.getResult(q.getName());
    }

    public void resetV5QueryResult() {
        this.getQueryNameToResult().clear();
    }

    public QueryContext getUserInfo() {
        return this.mUserInfo;
    }

    public void release() {
        for (int i = 0; i < this.getQueryNameToResult().size(); ++i) {
            this.queryNameToResult.get(this.getQueries().get(i).getName()).release();
        }
        this.queryNameToResult.clear();
    }
}

