/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.v5provider;

import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.QueryEngine;
import com.cognos.xqe.rsapi.RSAPIColumn;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIEdgeIterator;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.rsapi.RSAPIPartialDataset;
import com.cognos.xqe.rsapi.RSAPIRow;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class V5ProviderQueryResultIterator {
    private final RSAPIDataset rsapiDataset;
    private RSAPIEdgeIterator it = null;
    private RSAPIPartialDataset partialDataset = null;
    FormatId[] formatIds = null;
    protected final AtomicBoolean released = new AtomicBoolean(false);

    public V5ProviderQueryResultIterator(RSAPIDataset dataset, ExecutionEnvironment env) {
        this.rsapiDataset = dataset;
        RSAPIEdgeRowset rowset = null;
        this.partialDataset = QueryEngine.getInstance().getPartialDataset(this.rsapiDataset, new int[]{0}, new int[]{0}, true, false, env);
        try {
            rowset = this.partialDataset.getMasterDataset().getEdge(0).getRowsets()[0];
            this.it = this.partialDataset.edgeIterator(0);
            RSAPIColumn[] columns = rowset.getColumns();
            FormatService formatService = FormatService.getInstance();
            this.formatIds = new FormatId[columns.length];
            for (int i = 0; i < columns.length; ++i) {
                String format = columns[i].getFormat();
                this.formatIds[i] = format != null && format.length() > 0 ? formatService.registerV5Format(format, null) : (columns[i].getDatatype().isNumeric() ? FormatId.DEFAULT_NUMBER_FORMAT_FID : FormatId.INVALID_FORMAT_FID);
            }
        }
        catch (RuntimeException ex) {
            this.close();
            throw ex;
        }
        catch (Throwable ex) {
            this.close();
            throw XQERuntimeException.wrap(XQEMessageKeys.GEN_UnexpectedException, ex);
        }
    }

    public boolean hasNext() {
        return this.it.hasNext();
    }

    public RSAPIRow next() {
        return this.it.next();
    }

    public FormatId[] getColumnFormat() {
        return this.formatIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (!this.released.compareAndSet(false, true)) {
            return;
        }
        try {
            if (this.it != null) {
                this.it.release();
                this.it = null;
            }
        }
        finally {
            try {
                if (this.partialDataset != null) {
                    this.partialDataset.release();
                    this.partialDataset = null;
                }
            }
            finally {
                ExecutionEnvironment execEnv = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
                this.rsapiDataset.releaseResultset(execEnv);
            }
        }
    }
}

