/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.v5provider.pushdown;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.query.V5DetailFilter;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5.result.V5GroupBody;
import com.cognos.xqe.bibushandler.datasource.ProviderCapabilites;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.values.NumericValue;
import com.cognos.xqe.data.values.StringValue;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.resultset.interfaces.ISet;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.ParameterFetcher;
import com.cognos.xqe.runtree.olap.mdx.functions.set.CellValueComparatorFactory;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Cell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.FilteredTupleList;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.ITupleList;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.TupleListFilter;
import com.cognos.xqe.runtree.olap.mdx.v5provider.pushdown.PushdownManager;
import com.cognos.xqe.runtree.olap.mdx.v5provider.pushdown.PushdownUtility;
import com.cognos.xqe.util.UniqueNameGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public final class TopBottomCountPushdownUtility {
    private static final String ORDER_ASC = "ASC";
    private static final String ORDER_DESC = "DESC";
    private static final String STR_SPACE = " ";
    private static final String STR_REQUIRED = "required";
    private static final String STR_LESS_THAN_EQUAL = "<=";
    private static final String STR_RANK = "rank";
    private static final String CLOSE_PARENTHESIS_STR = ")";
    private static final String OPEN_PARENTHESIS_STR = "(";
    private static final String OPEN_SQUARE = "[";
    private static final String CLOSE_SQUARE = "]";

    public static void generateRankExpression(String key, V5Query query, V5GroupBody groupBody, XQENodeFactory nodeFactory, boolean sortDescending, PushdownManager pushdownManager, String functionName) {
        String dataItemName = (String)pushdownManager.getParameter(functionName, "dataItemName");
        double value = (Double)pushdownManager.getParameter(functionName, "count");
        V5Selection selection = (V5Selection)query.getFirstChildByType(101009);
        boolean useCoalesce = false;
        IDataSourceCapabilities providerCapabilities = ProviderCapabilites.getInstance().getOrAddProviderCapabilities(key);
        useCoalesce = providerCapabilities.isSupported("enableCoalesceRankInPushDownMode");
        String rankItemName = dataItemName;
        if (useCoalesce) {
            rankItemName = PushdownUtility.addCoalesceDataItem(selection, nodeFactory, dataItemName);
        }
        TopBottomCountPushdownUtility.addRankDataItem(nodeFactory, sortDescending, selection, rankItemName, groupBody, pushdownManager, functionName);
        V5DetailFilter detailFilter = (V5DetailFilter)nodeFactory.createNode(101008);
        detailFilter.setPostAutoAggregation(true);
        detailFilter.setStringPropertyValue("use", STR_REQUIRED);
        query.addChild(detailFilter);
        IXQEQueryNode filterExpression = nodeFactory.createNode(101013);
        filterExpression.setPropertyValue("expression", UniqueNameGenerator.createUniqueName(STR_RANK) + STR_LESS_THAN_EQUAL + STR_SPACE + value);
        detailFilter.addChild(filterExpression);
    }

    public static void generateOrderExpression(String key, V5Query query, V5GroupBody groupBody, XQENodeFactory nodeFactory, String dataItemName, boolean sortDescending) {
        V5Selection selection = (V5Selection)query.getFirstChildByType(101009);
        boolean useCoalesce = false;
        IDataSourceCapabilities providerCapabilities = ProviderCapabilites.getInstance().getOrAddProviderCapabilities(key);
        useCoalesce = providerCapabilities.isSupported("enableCoalesceRankInPushDownMode");
        String orderItemName = dataItemName;
        if (useCoalesce) {
            orderItemName = PushdownUtility.addCoalesceDataItem(selection, nodeFactory, dataItemName);
        }
        TopBottomCountPushdownUtility.addRankDataItem(nodeFactory, sortDescending, selection, orderItemName, groupBody, null, null);
    }

    private static void addRankDataItem(XQENodeFactory nodeFactory, boolean sortDescending, V5Selection selection, String rankOrderItemName, V5GroupBody groupBody, PushdownManager pushdownManager, String functionName) {
        String sortOrder = sortDescending ? ORDER_DESC : ORDER_ASC;
        IXQEQueryNode dataItem = nodeFactory.createNode(101003);
        dataItem.setPropertyValue("aggregate", "calculated");
        dataItem.setPropertyValue("name", STR_RANK);
        selection.addChild(dataItem);
        String forClause = "";
        IXQEQueryNode expression = nodeFactory.createNode(101004);
        if (pushdownManager != null) {
            Object projectedColumnsToDataItem = pushdownManager.getParameter(functionName, "projectedColumnsToDataItem");
            Set s = (Set)pushdownManager.getParameter(functionName, "contexts");
            if (projectedColumnsToDataItem != null) {
                forClause = TopBottomCountPushdownUtility.createForClause(s, (Map)projectedColumnsToDataItem);
            }
        }
        expression.setPropertyValue("expression", "rank(" + UniqueNameGenerator.createUniqueName(rankOrderItemName) + sortOrder + forClause + CLOSE_PARENTHESIS_STR);
        dataItem.addChild(expression);
        IXQEQueryNode dataItemRef = nodeFactory.createNode(101015);
        dataItemRef.setPropertyValue("refDataItem", STR_RANK);
        groupBody.addChild(dataItemRef);
    }

    private static String createForClause(Set s, Map<IMetadata, List<String>> projectedColumnsToDataItem) {
        if (s.isEmpty()) {
            return "";
        }
        ArrayList<String> dataItems = new ArrayList<String>();
        for (ITuple tuple : s.getTupleList()) {
            for (IMember member : tuple.getMembers()) {
                ILevel level = member.getLevel();
                List<String> dataItemNames = projectedColumnsToDataItem.get(level);
                for (String dataItemName : dataItemNames) {
                    if (dataItems.contains(dataItemName)) continue;
                    dataItems.add(dataItemName);
                }
            }
        }
        StringBuilder sb = new StringBuilder(" for ");
        for (int i = 0; i < dataItems.size() - 1; ++i) {
            sb.append(OPEN_SQUARE);
            sb.append((String)dataItems.get(i));
            sb.append("], ");
        }
        sb.append(OPEN_SQUARE);
        sb.append((String)dataItems.get(dataItems.size() - 1));
        sb.append(CLOSE_SQUARE);
        return sb.toString();
    }

    public static boolean configurePushdown(Block setParam, Block countparam, ParameterFetcher parameterFetcher, String functionName) throws InterpreterException {
        InterpreterContext interpreterContext = null;
        if (parameterFetcher != null) {
            interpreterContext = parameterFetcher.getInterpreterContext();
        }
        if (!PushdownUtility.getPushdownEnabled(interpreterContext) || !functionName.equals("TopCount") && !functionName.equals("TopSum") || parameterFetcher.getParameterCount() <= 2) {
            return false;
        }
        PushdownManager pushdownManager = PushdownManager.initializePushdownManager(interpreterContext, false);
        if (pushdownManager == null) {
            return false;
        }
        double count = 0.0;
        Object countVal = countparam.first();
        if (countVal == null) {
            pushdownManager.cancel(interpreterContext, "invalid count parameter, null.");
            return false;
        }
        if (countVal instanceof NumericValue) {
            count = ((NumericValue)countVal).getDouble();
        } else if (countVal instanceof StringValue) {
            count = ((StringValue)countVal).getDouble();
        } else {
            pushdownManager.cancel(interpreterContext, "invalid count parameter, unsupported type.");
            return false;
        }
        if (!PushdownUtility.validateSetParameter(setParam)) {
            pushdownManager.cancel(interpreterContext, "set contains calculated members.");
            return false;
        }
        ISet contextSet = PushdownUtility.evaluateNumericExpression(parameterFetcher, pushdownManager, functionName);
        if (contextSet == null) {
            pushdownManager.cancel(interpreterContext, "only simple (base) numeric expressions are supported.");
            return false;
        }
        if (!PushdownUtility.evaluateContext(interpreterContext)) {
            pushdownManager.cancel(interpreterContext, "context contains calculated members.");
            return false;
        }
        pushdownManager.addPushdownFunction(functionName);
        pushdownManager.setParameter(functionName, "contexts", contextSet);
        pushdownManager.setParameter(functionName, "count", count);
        pushdownManager.setParameter(functionName, "nullHandling", CellValueComparatorFactory.getComparator(interpreterContext, false));
        pushdownManager.setEnabled(true);
        return true;
    }

    public static Set handleNullFiltering(InterpreterContext interpreterContext, String functionName, boolean pushdown, boolean filterSet, Set s, TreeSet<Cell> v) {
        if (v != null && (PushdownManager.isNullFilteringNeeded(interpreterContext, functionName) || filterSet && pushdown && PushdownManager.isPushdownExecutionFinished(interpreterContext))) {
            Set retSet;
            TupleListFilter filter = new TupleListFilter(s.size());
            long j = 0L;
            for (Cell cell : v) {
                if (cell.getOrdinal() < 0L) continue;
                filter.enable(cell.getOrdinal());
                cell.setOrdinal(j);
                ++j;
            }
            ITupleList outputList = FilteredTupleList.construct(s.getTupleList(), filter);
            s = retSet = new Set(outputList);
        }
        return s;
    }
}

