/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.querytemplates;

import com.cognos.xqe.ast.olap.util.DescendantsRangeFlagEnum;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.TreeOperatorEnum;
import com.cognos.xqe.runtree.olap.querytemplates.MemberQuery;
import java.util.EnumSet;
import org.apache.velocity.VelocityContext;

public class MemberQueryBasedOnMUN
extends MemberQuery {
    private static final String TEMPLATE_PATH = "com/cognos/xqe/runtree/olap/querytemplates/MemberQueryBasedOnMUN";
    private static final String MDX_COMMA = " , ";
    private static final String MDX_CURLY_OPEN_BRACKET = "{";
    private static final String MDX_CLOSE_BRACKET = ")";
    public static final String TYPE_NAME = "MemberQueryBasedOnMUN";
    protected String memberUName;
    protected EnumSet<TreeOperatorEnum> treeOpSet;
    protected Integer descendantsFunctionRangeFlag = null;
    protected Integer descendantsFunctionLevelDistance = null;

    protected MemberQueryBasedOnMUN(ICube aCube) {
        super(aCube);
    }

    @Override
    protected VelocityContext constructContext() {
        VelocityContext context = super.constructContext();
        StringBuilder mdxBuffer = new StringBuilder();
        String nonEmptyString = "";
        boolean nonEmpty = false;
        if (this.treeOpSet.contains((Object)TreeOperatorEnum.ANCESTORS)) {
            mdxBuffer.append("ASCENDANTS(");
            mdxBuffer.append(this.memberUName);
            mdxBuffer.append(MDX_CLOSE_BRACKET);
            this.treeOpSet.remove((Object)TreeOperatorEnum.ANCESTORS);
            this.treeOpSet.remove((Object)TreeOperatorEnum.PARENT);
        }
        if (this.treeOpSet.contains((Object)TreeOperatorEnum.SIBLINGS)) {
            if (mdxBuffer.length() > 0) {
                mdxBuffer.append(MDX_COMMA);
            }
            mdxBuffer.append(this.memberUName);
            mdxBuffer.append(".SIBLINGS");
            this.treeOpSet.remove((Object)TreeOperatorEnum.SIBLINGS);
            this.treeOpSet.remove((Object)TreeOperatorEnum.SELF);
            nonEmpty = true;
        }
        if (this.treeOpSet.contains((Object)TreeOperatorEnum.PARENT)) {
            if (mdxBuffer.length() > 0) {
                mdxBuffer.append(MDX_COMMA);
            }
            mdxBuffer.append(MDX_CURLY_OPEN_BRACKET);
            mdxBuffer.append(this.memberUName);
            mdxBuffer.append(".PARENT}");
            this.treeOpSet.remove((Object)TreeOperatorEnum.PARENT);
        }
        if (this.treeOpSet.contains((Object)TreeOperatorEnum.DESCENDANTS)) {
            if (mdxBuffer.length() > 0) {
                mdxBuffer.append(MDX_COMMA);
            }
            mdxBuffer.append("DESCENDANTS(");
            mdxBuffer.append(this.memberUName);
            if (this.descendantsFunctionLevelDistance != null) {
                mdxBuffer.append(MDX_COMMA);
                mdxBuffer.append(this.descendantsFunctionLevelDistance);
            }
            if (this.descendantsFunctionRangeFlag != null) {
                mdxBuffer.append(MDX_COMMA);
                mdxBuffer.append(DescendantsRangeFlagEnum.getStringFlag(this.descendantsFunctionRangeFlag));
            }
            mdxBuffer.append(MDX_CLOSE_BRACKET);
            nonEmpty = this.nonEmpty;
            this.treeOpSet.remove((Object)TreeOperatorEnum.DESCENDANTS);
        }
        if (this.treeOpSet.contains((Object)TreeOperatorEnum.SELF)) {
            if (mdxBuffer.length() > 0) {
                mdxBuffer.append(MDX_COMMA);
            }
            mdxBuffer.append(MDX_CURLY_OPEN_BRACKET);
            mdxBuffer.append(this.memberUName);
            mdxBuffer.append("}");
            this.treeOpSet.remove((Object)TreeOperatorEnum.SELF);
        }
        if (this.treeOpSet.contains((Object)TreeOperatorEnum.CHILDREN)) {
            if (mdxBuffer.length() > 0) {
                mdxBuffer.append(MDX_COMMA);
            }
            mdxBuffer.append(this.memberUName);
            mdxBuffer.append(".CHILDREN");
            nonEmpty = true;
            this.treeOpSet.remove((Object)TreeOperatorEnum.CHILDREN);
        }
        if (!this.treeOpSet.isEmpty()) {
            this.throwInternalError("Unknown tree operations: " + this.treeOpSet);
        }
        if (nonEmpty) {
            nonEmptyString = "NON EMPTY";
        }
        context.put("MDX", (Object)mdxBuffer.toString());
        context.put("NON_EMPTY", (Object)nonEmptyString);
        return context;
    }

    public void setMemberUName(String memberUniqueName) {
        this.memberUName = memberUniqueName;
    }

    @Override
    protected String getTemplateName() {
        return TEMPLATE_PATH;
    }

    public void setOperations(EnumSet<TreeOperatorEnum> treeOpSetIn) {
        this.treeOpSet = treeOpSetIn;
    }

    public void setDescendantsFunctionOptionParameter(Integer descRangeFlag, Integer levelDistance) {
        this.descendantsFunctionRangeFlag = descRangeFlag;
        this.descendantsFunctionLevelDistance = levelDistance;
    }
}

