/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational;

import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.bibushandler.CancelRequestSourceEnum;
import com.cognos.xqe.bibushandler.CancelUnsuccessfulException;
import com.cognos.xqe.bibushandler.ICancelable;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.IRow;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.NumericValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.resultset.interfaces.IExecutable;
import com.cognos.xqe.resultset.interfaces.IHybridResultSet;
import com.cognos.xqe.resultset.interfaces.ITabularIterator;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.resultsets.ContextBase;
import com.cognos.xqe.resultsets.ContextValue;
import com.cognos.xqe.resultsets.tabular.TabularHybridResultSet;
import com.cognos.xqe.rsapi.RSAPIRowset;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XNode;
import com.cognos.xqe.runtree.XTabularIterator;
import com.cognos.xqe.runtree.relational.XBurstPrefetch;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.xml.XMLWriter;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class XBurstCacheKeys
extends XNode {
    private static final long serialVersionUID = 1L;
    private static final String ATTRIBUTE_PREFETCH_ID = "prefetchID";
    private static final String ATTRIBUTE_EDGE_NUM = "edgeNum";
    private static final String ATTRIBUTE_ROWSET_ID = "rowsetId";
    private static final String ATTRIBUTE_DATAITEM_INDEX = "dataItemIndex";
    private String prefetchID;
    private int mEdgeNum;
    private int mRowsetId;
    private int mDataItemIndex;
    private static final String ATTRIBUTE_BURST_KEYS = "burstKeys";
    private static final String COMMA = ",";
    private ConcurrentLinkedQueue<String> mKeys = null;

    @Override
    public int getType() {
        return 501161;
    }

    public void setProperites(int edgeNumber, int rowSetID, int dataItemIndex, String thePrefetchID) {
        this.mEdgeNum = edgeNumber;
        this.mRowsetId = rowSetID;
        this.mDataItemIndex = dataItemIndex;
        this.prefetchID = thePrefetchID;
    }

    @Override
    protected IValue executeImpl(XDataContext context) {
        TabularHybridResultSet result = (TabularHybridResultSet)((IExecutable)((Object)this.getChild(0))).execute(context);
        return new PrefetchMasterQueryResultSet(context, result);
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        super.dumpExtraInfo(trace, includeRuntimeSpecifics);
        StringBuilder builder = new StringBuilder();
        for (String key : this.mKeys) {
            builder.append(key);
            builder.append(COMMA);
        }
        builder.setLength(builder.length() - 1);
        trace.attribute(ATTRIBUTE_BURST_KEYS, builder.toString());
    }

    @Override
    protected void persistAttributeProperties(XQEPersistContext ctx) {
        super.persistAttributeProperties(ctx);
        ctx.property(ATTRIBUTE_PREFETCH_ID, this.prefetchID);
        ctx.property(ATTRIBUTE_EDGE_NUM, this.mEdgeNum);
        ctx.property(ATTRIBUTE_ROWSET_ID, this.mRowsetId);
        ctx.property(ATTRIBUTE_DATAITEM_INDEX, this.mDataItemIndex);
    }

    @Override
    protected void persistElementProperties(XQEPersistContext ctx) {
        super.persistElementProperties(ctx);
        if (this.mKeys != null) {
            ctx.elementProperty(ATTRIBUTE_BURST_KEYS, this.mKeys);
        }
    }

    @Override
    protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element inputNode) {
        String attname = att.getName();
        if (attname.equals(ATTRIBUTE_PREFETCH_ID)) {
            Object val = ctx.attributeValue(att);
            this.prefetchID = (String)val;
        } else if (attname.equals(ATTRIBUTE_EDGE_NUM)) {
            Object val = ctx.attributeValue(att);
            this.mEdgeNum = (Integer)val;
        } else if (attname.equals(ATTRIBUTE_ROWSET_ID)) {
            Object val = ctx.attributeValue(att);
            this.mRowsetId = (Integer)val;
        } else if (attname.equals(ATTRIBUTE_DATAITEM_INDEX)) {
            Object val = ctx.attributeValue(att);
            this.mDataItemIndex = (Integer)val;
        } else {
            super.restoreAttributeProperty(ctx, att, inputNode);
        }
    }

    @Override
    protected void restoreElementProperty(XQERestoreContext ctx, Element node, Element inputNode) {
        String pname = node.attributeValue("pname");
        if (pname.equals(ATTRIBUTE_BURST_KEYS)) {
            Object val = ctx.elementValue(node);
            this.mKeys = (ConcurrentLinkedQueue)val;
        } else {
            super.restoreElementProperty(ctx, node, inputNode);
        }
    }

    private final class PrefetchMasterQueryResultSet
    extends TabularHybridResultSet
    implements IHybridResultSet,
    ICancelable {
        private ITabularResultSet tabularResultSet;
        private ITabularIterator wrappedIterator;

        PrefetchMasterQueryResultSet(XDataContext context, ITabularResultSet sourceResult) {
            super(context, sourceResult);
            this.tabularResultSet = sourceResult;
        }

        @Override
        public ITabularIterator getTabularIterator() {
            return new PrefetchMasterQueryIterator(this.getDataContext());
        }

        @Override
        public void releaseImpl() {
            if (this.tabularResultSet != null) {
                this.tabularResultSet.release();
                this.tabularResultSet = null;
            }
            if (XBurstCacheKeys.this.mKeys != null) {
                XBurstCacheKeys.this.mKeys.clear();
                XBurstCacheKeys.this.mKeys = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void toXML(XMLWriter xmlWriter) {
            ITabularIterator tabIt = this.getTabularIterator();
            try {
                IRow row;
                if (xmlWriter.isEmpty()) {
                    xmlWriter.writeProcessingInstruction("<?xml-stylesheet type=\"text/xsl\" href=\"http://wottcub1:4444/stylesheets/TabularHybridResultSet.xsl\"?>\n");
                }
                xmlWriter.beginElement("TabularHybridResultSet", -1);
                this.rowsetInfo.dumpFormattedXMLResult(xmlWriter);
                xmlWriter.beginElement("RowList", -1);
                while ((row = (IRow)tabIt.next()) != null) {
                    xmlWriter.beginElement("Row", -1);
                    for (int i = 0; i < row.getNumColumns(); ++i) {
                        IValue value = row.getColumn(i);
                        if (value == null) continue;
                        try {
                            value.toXML(xmlWriter);
                            continue;
                        }
                        finally {
                            value.release();
                        }
                    }
                    xmlWriter.endElement();
                }
            }
            finally {
                tabIt.release();
            }
            xmlWriter.endElement();
            xmlWriter.endElement();
        }

        @Override
        public void cancel() throws CancelUnsuccessfulException {
            ((ICancelable)((Object)this.tabularResultSet)).cancel();
        }

        @Override
        public synchronized void cancel(CancelRequestSourceEnum cancelSource) throws CancelUnsuccessfulException {
            throw new CancelUnsuccessfulException();
        }

        public final class PrefetchMasterQueryIterator
        extends XTabularIterator {
            PrefetchMasterQueryIterator(XDataContext xContext) {
                super(xContext, xContext.getNodeId());
                PrefetchMasterQueryResultSet.this.wrappedIterator = PrefetchMasterQueryResultSet.this.tabularResultSet.getTabularIterator();
                XBurstCacheKeys.this.mKeys = XBurstPrefetch.PrefetchManager.getInstance().getBurstKeys(XBurstCacheKeys.this.prefetchID);
                if (XBurstCacheKeys.this.mKeys == null) {
                    XBurstCacheKeys.this.mKeys = new ConcurrentLinkedQueue();
                    XBurstPrefetch.PrefetchManager.getInstance().addBurstKeys(XBurstCacheKeys.this.prefetchID, XBurstCacheKeys.this.mKeys);
                }
            }

            @Override
            public Object nextImpl() {
                IRow currentRow = (IRow)PrefetchMasterQueryResultSet.this.wrappedIterator.next();
                if (currentRow != null) {
                    for (int i = 0; i < currentRow.getNumColumns(); ++i) {
                        ContextBase columnValue;
                        RSAPIRowset rowset;
                        if (currentRow.getColumn(i) == null || (rowset = (columnValue = (ContextBase)((Object)currentRow.getColumn(i))).getRowset()) == null || rowset.getRowsetId() != XBurstCacheKeys.this.mRowsetId || rowset.getEdge().getOrdinal() != XBurstCacheKeys.this.mEdgeNum || columnValue.getDataItemIndex() != XBurstCacheKeys.this.mDataItemIndex || !(columnValue instanceof ContextValue)) continue;
                        IValue value = ((ContextValue)columnValue).getValue();
                        String key = null;
                        if (!(value instanceof Value)) continue;
                        if (value instanceof NumericValue) {
                            IDataType dataType = ((Value)value).getDataType();
                            int intKey = ((NumericValue)value).getInteger(dataType.getPrecision(), dataType.getScale());
                            key = String.valueOf(intKey);
                        } else {
                            key = ((Value)value).getString();
                        }
                        if (XBurstCacheKeys.this.mKeys.contains(key)) continue;
                        XBurstCacheKeys.this.mKeys.add(key);
                    }
                }
                return currentRow;
            }

            @Override
            public void release() {
                if (PrefetchMasterQueryResultSet.this.wrappedIterator != null) {
                    PrefetchMasterQueryResultSet.this.wrappedIterator.release();
                }
                PrefetchMasterQueryResultSet.this.wrappedIterator = null;
                super.release();
            }
        }
    }
}

