/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational;

import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.bibushandler.CancelRequestSourceEnum;
import com.cognos.xqe.bibushandler.CancelUnsuccessfulException;
import com.cognos.xqe.bibushandler.ICancelable;
import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.providers.relational.jdbc.JDBCLog;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IRow;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.RowValue;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.IContextable;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.QueryEnvironmentHelper;
import com.cognos.xqe.query.parameters.Parameter;
import com.cognos.xqe.query.parameters.ParameterValueItem;
import com.cognos.xqe.query.parameters.ParameterValues;
import com.cognos.xqe.query.parameters.V5ParameterValueItem;
import com.cognos.xqe.resultset.interfaces.IRowsetInfo;
import com.cognos.xqe.resultset.interfaces.ITabularIterator;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.resultsets.tabular.TabularHybridResultSet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XNode;
import com.cognos.xqe.runtree.XResultSetBase;
import com.cognos.xqe.runtree.XTabularIterator;
import com.cognos.xqe.runtree.relational.XSql;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.IReleasable;
import com.cognos.xqe.util.SingletonHelper;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqe.util.xml.XMLWriter;
import java.util.Enumeration;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class XBurstPrefetch
extends XNode {
    private static final long serialVersionUID = 1L;
    private static final String ATTRIBUTE_PARAMETER_NAME = "parameterName";
    private static final int DEFAULT_WAIT_IN_MS = 100;
    private static final int BYTES_IN_MB = 0x100000;
    private static final String PREFETCH_ERROR_FRMT_STR = "Burst prefetch for prefetchID: %1$s encountered an error\n%2$s";
    private String prefetchID;
    private String paramName;

    @Override
    public int getType() {
        return 501160;
    }

    @Override
    public IValue getJDBCTabularResultSet(XDataContext context) {
        XNode xsqlNode = (XNode)this.getChild(0);
        ITabularResultSet resultSet = this.getResultSet(context, (XSql)xsqlNode);
        if (resultSet != null) {
            return new TabularHybridResultSet(context, resultSet);
        }
        return xsqlNode.getJDBCTabularResultSet(context);
    }

    @Override
    protected IValue executeImpl(XDataContext context) {
        XNode xsqlNode = (XNode)this.getChild(0);
        ITabularResultSet resultSet = this.getResultSet(context, (XSql)xsqlNode);
        if (resultSet != null) {
            return new TabularHybridResultSet(context, resultSet, this.getId());
        }
        return xsqlNode.execute(context);
    }

    private ITabularResultSet getResultSet(XDataContext context, XSql xsql) {
        ITabularResultSet cachedResultSet;
        PrefetchManager manager = PrefetchManager.getInstance();
        ExecutionEnvironment xEnv = (ExecutionEnvironment)context.getEnvironment();
        BurstPrefetchCache cache = manager.getCache(this.prefetchID);
        ConcurrentLinkedQueue<String> burstKeys = PrefetchManager.getInstance().getBurstKeys(this.prefetchID);
        if (burstKeys == null || burstKeys.isEmpty()) {
            return null;
        }
        if (cache == null) {
            cache = new BurstPrefetchCache(this.paramName, burstKeys, this.prefetchID, xsql);
            xEnv.getMultiRequestContext().registerResource(cache);
            manager.addCache(this.prefetchID, cache);
            xEnv.getCancelManager().addCancelHandler(cache);
        }
        if ((cachedResultSet = cache.getNextResultSet(context)) != null) {
            ((PrefetchTabularResultSet)cachedResultSet).setConsumerDataContext(context);
        } else {
            Exception e = cache.getException();
            if (e instanceof XQERuntimeException) {
                throw (XQERuntimeException)e;
            }
            if (e != null) {
                throw new XQERuntimeException(e);
            }
        }
        return cachedResultSet;
    }

    public void setPrefetchID(String thePrefetchID) {
        this.prefetchID = thePrefetchID;
    }

    public void setParamName(String parameterName) {
        this.paramName = parameterName;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        super.dumpExtraInfo(trace, includeRuntimeSpecifics);
        trace.attribute(ATTRIBUTE_PARAMETER_NAME, this.paramName);
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        this.paramName = inputNode.attribute(ATTRIBUTE_PARAMETER_NAME).getText();
        super.capture(env, inputNode);
    }

    @Override
    protected void persistAttributeProperties(XQEPersistContext ctx) {
        super.persistAttributeProperties(ctx);
    }

    @Override
    protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element inputNode) {
        super.restoreAttributeProperty(ctx, att, inputNode);
    }

    private static final class PrefetchTabularResultSet
    extends XResultSetBase
    implements ITabularResultSet,
    ICancelable {
        private PrefetchTabularIterator prefetchIterator = null;
        private ITabularResultSet tabularResultSet;
        private ITabularIterator wrappedIterator;
        private XDataContext consumerContext = null;
        private final Queue<IRow> prefetchQueue = new ConcurrentLinkedQueue<IRow>();
        private boolean prefetching = true;
        private final Lock iteratorLock = new ReentrantLock();
        private final Condition prefetchingDone = this.iteratorLock.newCondition();
        private boolean canceled = false;
        private int consumedMemory = 0;
        private int numPrefetchedRows = 0;

        PrefetchTabularResultSet(XDataContext context, ITabularResultSet resultSet) {
            super(context, null, context.getNodeId());
            this.tabularResultSet = resultSet;
            this.wrappedIterator = this.tabularResultSet.getTabularIterator();
        }

        @Override
        public IRowsetInfo getTabularRowsetInfo() {
            if (this.rowsetInfo == null) {
                this.rowsetInfo = this.tabularResultSet.getTabularRowsetInfo();
            }
            return this.rowsetInfo;
        }

        @Override
        public ITabularIterator getTabularIterator() {
            this.iteratorLock.lock();
            try {
                if (this.prefetching) {
                    this.prefetching = false;
                    try {
                        this.prefetchingDone.await();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            finally {
                this.iteratorLock.unlock();
            }
            PrefetchTabularIterator iterator = this.getOrCreateTabularIterator();
            iterator.setupConsumer(this.consumerContext);
            return iterator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean prefetch(int maxPrefetchMemory) {
            if (this.isCanceled()) {
                return false;
            }
            if (!this.prefetching) {
                this.iteratorLock.lock();
                try {
                    this.prefetchingDone.signal();
                }
                finally {
                    this.iteratorLock.unlock();
                }
                return false;
            }
            IRow aRow = (IRow)this.wrappedIterator.next();
            if (aRow == null) {
                this.releaseWrappedIterator();
                this.iteratorLock.lock();
                this.prefetching = false;
                try {
                    this.prefetchingDone.signal();
                }
                finally {
                    this.iteratorLock.unlock();
                }
                return false;
            }
            if (aRow instanceof RowValue) {
                this.prefetchQueue.add((IRow)((RowValue)aRow).copy(false));
            } else {
                this.prefetchQueue.add((IRow)aRow.copy());
            }
            ++this.numPrefetchedRows;
            this.consumedMemory += aRow.sizeOf();
            if (this.consumedMemory >= maxPrefetchMemory) {
                this.iteratorLock.lock();
                this.prefetching = false;
                try {
                    this.prefetchingDone.signal();
                }
                finally {
                    this.iteratorLock.unlock();
                }
                return false;
            }
            return true;
        }

        private synchronized void releaseWrappedIterator() {
            if (this.wrappedIterator != null) {
                this.wrappedIterator.release();
            }
            this.wrappedIterator = null;
        }

        private synchronized PrefetchTabularIterator getOrCreateTabularIterator() {
            if (this.prefetchIterator == null) {
                this.prefetchIterator = new PrefetchTabularIterator(this.getDataContext());
            }
            return this.prefetchIterator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void releaseImpl() {
            if (this.tabularResultSet != null) {
                ITabularResultSet iTabularResultSet = this.tabularResultSet;
                synchronized (iTabularResultSet) {
                    this.tabularResultSet.release();
                }
                this.tabularResultSet = null;
            }
        }

        public void setConsumerDataContext(XDataContext context) {
            this.consumerContext = context;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void toXML(XMLWriter xmlWriter) {
            ITabularIterator tabIt = this.getTabularIterator();
            try {
                IRow row;
                if (xmlWriter.isEmpty()) {
                    xmlWriter.writeProcessingInstruction("<?xml-stylesheet type=\"text/xsl\" href=\"http://wottcub1:4444/stylesheets/TabularHybridResultSet.xsl\"?>\n");
                }
                xmlWriter.beginElement("TabularHybridResultSet", -1);
                this.rowsetInfo.dumpFormattedXMLResult(xmlWriter);
                xmlWriter.beginElement("RowList", -1);
                while ((row = (IRow)tabIt.next()) != null) {
                    xmlWriter.beginElement("Row", -1);
                    for (int i = 0; i < row.getNumColumns(); ++i) {
                        IValue value = row.getColumn(i);
                        if (value == null) continue;
                        try {
                            value.toXML(xmlWriter);
                            continue;
                        }
                        finally {
                            value.release();
                        }
                    }
                    xmlWriter.endElement();
                }
            }
            finally {
                tabIt.release();
            }
            xmlWriter.endElement();
            xmlWriter.endElement();
        }

        @Override
        public void cancel() throws CancelUnsuccessfulException {
            this.canceled = true;
            this.prefetching = false;
            ((ICancelable)((Object)this.tabularResultSet)).cancel();
        }

        @Override
        public synchronized void cancel(CancelRequestSourceEnum cancelSource) throws CancelUnsuccessfulException {
            throw new CancelUnsuccessfulException();
        }

        public boolean isCanceled() {
            return this.canceled;
        }

        public final class PrefetchTabularIterator
        extends XTabularIterator {
            private IRow consumableRow;

            PrefetchTabularIterator(XDataContext prefetchContext) {
                super(prefetchContext, prefetchContext.getNodeId());
                this.consumableRow = null;
            }

            public void setupConsumer(XDataContext context) {
                IRowsetInfo rowsetInfo = PrefetchTabularResultSet.this.getTabularRowsetInfo();
                this.consumableRow = DataValueFactory.createRowValue(context.getLocalCollator(), rowsetInfo);
            }

            @Override
            public Object nextImpl() {
                IRow toReturn = null;
                if (PrefetchTabularResultSet.this.isCanceled()) {
                    throw new OperationCanceledException();
                }
                if (!PrefetchTabularResultSet.this.prefetchQueue.isEmpty()) {
                    toReturn = (IRow)PrefetchTabularResultSet.this.prefetchQueue.remove();
                } else if (PrefetchTabularResultSet.this.wrappedIterator != null) {
                    toReturn = (IRow)PrefetchTabularResultSet.this.wrappedIterator.next();
                }
                if (toReturn != null) {
                    for (int i = 0; i < toReturn.getNumColumns(); ++i) {
                        this.consumableRow.setColumn(i, toReturn.getColumn(i));
                    }
                } else {
                    this.consumableRow = null;
                }
                return this.consumableRow;
            }

            @Override
            public void release() {
                PrefetchTabularResultSet.this.releaseWrappedIterator();
                super.release();
            }
        }
    }

    private static final class PrefetchRunner
    implements Callable<Void> {
        private final BurstPrefetchCache prefetchCache;
        private static final String TASK_NAME = "BurstPrefetchRunner";
        private static AtomicInteger newThreadIndex = new AtomicInteger();

        public static Callable<Void> decoratePrefetchTask(BurstPrefetchCache cache) {
            QueryEnvironmentHelper envHelper = cache.getQueryEnvironmentHelper();
            PrefetchRunner runner = new PrefetchRunner(cache);
            return new TaskSubmitDecorator(cache, envHelper.decorateCallable(runner, true, TASK_NAME, null, newThreadIndex.incrementAndGet()));
        }

        PrefetchRunner(BurstPrefetchCache cache) {
            this.prefetchCache = cache;
        }

        @Override
        public Void call() throws Exception {
            this.fillCache();
            return null;
        }

        public String toString() {
            return TASK_NAME;
        }

        public void fillCache() {
            block4: {
                IExecutionEnvironment xEnv = ExecutionEnvironmentContext.getExecutionEnvironment();
                XSql xsql = this.prefetchCache.getXSqlNode();
                String parameterName = this.prefetchCache.getParameterName();
                XQELogger jdbcInfoLog = JDBCLog.getLogger(LogLevel.INFO);
                if (!this.prefetchCache.continuePrefetching()) {
                    return;
                }
                IReleasable liveResultSet = null;
                try {
                    boolean continuePrefetch;
                    String key = this.prefetchCache.getNextKey();
                    jdbcInfoLog.log(String.format("Prefetching burst key: %1$s for prefetchID: %2$s", key, this.prefetchCache.mPrefetchID));
                    XDataContext dataContext = new XDataContext(null, xEnv);
                    Parameter detailFilter = dataContext.getParameter(parameterName);
                    detailFilter.clearParameterValueItems();
                    detailFilter.addValue(key);
                    liveResultSet = (ITabularResultSet)xsql.execute(dataContext);
                    PrefetchTabularResultSet prefetchResultSet = new PrefetchTabularResultSet(dataContext, (ITabularResultSet)liveResultSet);
                    this.prefetchCache.addCache(key, prefetchResultSet);
                    int prefetchedRows = 0;
                    do {
                        continuePrefetch = prefetchResultSet.prefetch(this.prefetchCache.maxAvailableMemory);
                        ++prefetchedRows;
                    } while (continuePrefetch);
                    jdbcInfoLog.log(String.format("Finished prefetching burst key: %1$s for prefetchID: %2$s", key, this.prefetchCache.mPrefetchID));
                }
                catch (Exception e) {
                    JDBCLog.getLogger(LogLevel.ERROR).log(String.format(XBurstPrefetch.PREFETCH_ERROR_FRMT_STR, this.prefetchCache.mPrefetchID, e.toString()));
                    this.prefetchCache.invalidateCache(e);
                    if (liveResultSet == null) break block4;
                    liveResultSet.release();
                }
            }
        }
    }

    private static final class BurstPrefetchCache
    implements IContextable,
    ICancelable {
        private final int maxPrefetchedResultSets;
        private final int maxAvailableMemory;
        private int missMatchingCount = 0;
        private static final int MAXNUMKEYMISSMATCHING = 10;
        private final ConcurrentLinkedQueue<String> keys;
        private final String parameterName;
        private final String mPrefetchID;
        private final XSql xsql;
        private AtomicBoolean fetching = new AtomicBoolean(false);
        private Exception caughtException = null;
        private String previousKey = null;
        private String firstKey = null;
        private AtomicBoolean valid = new AtomicBoolean(true);
        private final ReentrantLock cacheLock = new ReentrantLock();
        private final Condition cacheModified = this.cacheLock.newCondition();
        private ConcurrentHashMap<String, ITabularResultSet> prefetchMap = new ConcurrentHashMap();
        private final QueryEnvironmentHelper envHelper;
        private final XQELogger jdbcInfoLogger = JDBCLog.getLogger(LogLevel.INFO);

        BurstPrefetchCache(String keyName, ConcurrentLinkedQueue<String> burstKeys, String prefetchID, XSql xNode) {
            this.parameterName = keyName;
            this.keys = burstKeys;
            this.mPrefetchID = prefetchID;
            this.xsql = xNode;
            XQEConfiguration config = XQEConfigurationManager.getInstance().getOrCreateXQEConfiguration();
            this.maxAvailableMemory = config.getIntProperty("queryExecution.burstPrefetch.maxMemoryPerResultSet[@value]", 1) * 0x100000;
            this.maxPrefetchedResultSets = config.getIntProperty("queryExecution.burstPrefetch.maxResultSetPrefetch[@value]", 1);
            this.firstKey = this.keys.peek();
            this.envHelper = new QueryEnvironmentHelper();
            this.envHelper.copyRequestEnvironmentInfo(true);
            this.jdbcInfoLogger.log("Created BurstPrefetchCache for prefetchID:" + this.mPrefetchID);
            this.doPrefetch();
        }

        public boolean isValid() {
            return this.valid.get();
        }

        public boolean isFinished() {
            return this.keys.isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ITabularResultSet getNextResultSet(XDataContext dataContext) {
            if (!this.isValid()) {
                return null;
            }
            this.jdbcInfoLogger.log(String.format("Retrieving prefetched result set for prefetchID: %1$s", this.mPrefetchID));
            Parameter param = dataContext.getParameter(this.parameterName);
            ParameterValues pValues = param.getParameterValueItems();
            ParameterValueItem valueItem = (ParameterValueItem)pValues.get(0);
            ITabularResultSet resultSet = null;
            long startTime = System.currentTimeMillis();
            if (valueItem instanceof V5ParameterValueItem) {
                String internalValue = ((V5ParameterValueItem)valueItem).getInternalValue();
                if (!internalValue.equals(this.previousKey) && !internalValue.equals(this.firstKey)) {
                    ++this.missMatchingCount;
                    if (this.jdbcInfoLogger.isOn(LogLevel.INFO)) {
                        StringBuilder logMessage = new StringBuilder("Reques ");
                        logMessage.append(this.mPrefetchID);
                        logMessage.append(" with burst key: ");
                        logMessage.append(internalValue);
                        logMessage.append(" is not cached. ");
                        logMessage.append("missMatchingCount: ");
                        logMessage.append(this.missMatchingCount);
                        this.jdbcInfoLogger.log(logMessage.toString());
                    }
                    if (this.missMatchingCount >= 10) {
                        this.valid.set(false);
                    }
                    if (!this.keys.contains(internalValue)) {
                        return null;
                    }
                    String currentKey = null;
                    while (!internalValue.equals(this.keys.peek())) {
                        currentKey = this.keys.poll();
                        this.prefetchMap.remove(currentKey);
                    }
                    if (internalValue.equals(currentKey)) {
                        this.keys.poll();
                        this.doPrefetch();
                    }
                    return null;
                }
                this.cacheLock.lock();
                try {
                    while (!this.prefetchMap.containsKey(internalValue) && this.isValid()) {
                        try {
                            this.cacheModified.await(100L, TimeUnit.MILLISECONDS);
                        }
                        catch (InterruptedException currentKey) {}
                    }
                }
                finally {
                    this.cacheLock.unlock();
                }
                long endTime = System.currentTimeMillis();
                if (!this.isValid()) {
                    return null;
                }
                resultSet = this.prefetchMap.remove(internalValue);
                this.firstKey = this.keys.peek();
                this.jdbcInfoLogger.log(String.format("Retrieved prefetched result set for prefetchID: %1$s in %2$d ms. Key: %3$s.", this.mPrefetchID, endTime - startTime, internalValue));
                this.doPrefetch();
            }
            return resultSet;
        }

        public void addCache(String parameterValue, PrefetchTabularResultSet cache) {
            this.prefetchMap.put(parameterValue, cache);
            this.cacheLock.lock();
            try {
                this.cacheModified.signal();
            }
            finally {
                this.cacheLock.unlock();
            }
        }

        @Override
        public void release() {
            this.invalidateCache(null);
            PrefetchManager.getInstance().removeCache(this.mPrefetchID);
            Enumeration<ITabularResultSet> caches = this.prefetchMap.elements();
            while (caches.hasMoreElements()) {
                caches.nextElement().release();
            }
            ConcurrentLinkedQueue<String> keysFinished = PrefetchManager.getInstance().removeBurstKeys(this.mPrefetchID);
            if (keysFinished != null) {
                keysFinished.clear();
                keysFinished = null;
            }
        }

        @Override
        public boolean isSessionScope() {
            return false;
        }

        public boolean isCacheFull() {
            return this.prefetchMap.size() >= this.maxPrefetchedResultSets;
        }

        public String getNextKey() {
            if (this.keys.peek().equals(this.previousKey)) {
                this.keys.poll();
            }
            this.previousKey = this.keys.poll();
            return this.previousKey;
        }

        public String getParameterName() {
            return this.parameterName;
        }

        public XSql getXSqlNode() {
            return this.xsql;
        }

        public void invalidateCache(Exception e) {
            if (!this.valid.compareAndSet(true, false)) {
                return;
            }
            this.caughtException = e;
            this.jdbcInfoLogger.log("Cache invalidated");
            this.cacheLock.lock();
            try {
                this.cacheModified.signal();
            }
            finally {
                this.cacheLock.unlock();
            }
        }

        public QueryEnvironmentHelper getQueryEnvironmentHelper() {
            return this.envHelper;
        }

        public void donePrefetch() {
            this.fetching.set(false);
        }

        public boolean continuePrefetching() {
            return !this.isCacheFull() && !this.isFinished() && this.isValid();
        }

        private void doPrefetch() {
            if (!this.fetching.compareAndSet(false, true) || !this.isValid()) {
                return;
            }
            PrefetchManager.submitTask(PrefetchRunner.decoratePrefetchTask(this));
        }

        @Override
        public void cancel() throws CancelUnsuccessfulException {
            this.invalidateCache(null);
            this.cacheLock.lock();
            try {
                this.cacheModified.signal();
            }
            finally {
                this.cacheLock.unlock();
            }
        }

        @Override
        public synchronized void cancel(CancelRequestSourceEnum cancelSource) throws CancelUnsuccessfulException {
            throw new CancelUnsuccessfulException();
        }

        public Exception getException() {
            return this.caughtException;
        }
    }

    public static final class PrefetchManager {
        public static final int IDLE_THREAD_TIMEOUT_IN_MIN = 15;
        public static final int INITIAL_NUM_THREADS = 10;
        final ExecutorService executorService;
        private static SingletonHelper<PrefetchManager> singletonHelper = new SingletonHelper<PrefetchManager>(){

            @Override
            protected PrefetchManager newInstance() {
                return new PrefetchManager();
            }

            @Override
            protected void releaseImpl(PrefetchManager theInstance) {
            }

            @Override
            protected void initializeImpl(PrefetchManager theInstance) {
            }
        };
        private final ConcurrentHashMap<String, BurstPrefetchCache> cacheMap = new ConcurrentHashMap();
        private final ConcurrentHashMap<String, ConcurrentLinkedQueue<String>> keyMap = new ConcurrentHashMap();

        public static PrefetchManager getInstance() {
            return singletonHelper.getInstance();
        }

        private PrefetchManager() {
            XQEConfiguration config = XQEConfigurationManager.getInstance().getOrCreateXQEConfiguration();
            this.executorService = new ThreadPoolExecutor(config.getIntProperty("queryExecution.burstPrefetch.minThreads[@value]", 10), config.getIntProperty("queryExecution.burstPrefetch.maxThreads[@value]", 20), 15L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>());
        }

        public void addCache(String prefetchID, BurstPrefetchCache cache) {
            this.cacheMap.put(prefetchID, cache);
        }

        public BurstPrefetchCache removeCache(String prefetchID) {
            return this.cacheMap.remove(prefetchID);
        }

        public BurstPrefetchCache getCache(String prefetchID) {
            BurstPrefetchCache cache = this.cacheMap.get(prefetchID);
            return cache;
        }

        public void addBurstKeys(String prefetchID, ConcurrentLinkedQueue<String> burstKeys) {
            this.keyMap.put(prefetchID, burstKeys);
        }

        public ConcurrentLinkedQueue<String> removeBurstKeys(String prefetchID) {
            return this.keyMap.remove(prefetchID);
        }

        public ConcurrentLinkedQueue<String> getBurstKeys(String prefetchID) {
            return this.keyMap.get(prefetchID);
        }

        public static synchronized void submitTask(Callable<Void> prefetchTask) {
            PrefetchManager.getInstance().executorService.submit(prefetchTask);
        }
    }

    private static final class TaskSubmitDecorator
    implements Callable<Void> {
        private final BurstPrefetchCache cache;
        private final Callable<Void> prefetchTask;

        TaskSubmitDecorator(BurstPrefetchCache aCache, Callable<Void> delegate) {
            this.cache = aCache;
            this.prefetchTask = delegate;
        }

        @Override
        public Void call() {
            try {
                Void void_ = this.prefetchTask.call();
                return void_;
            }
            catch (Exception e) {
                JDBCLog.getLogger(LogLevel.ERROR).log(String.format(XBurstPrefetch.PREFETCH_ERROR_FRMT_STR, this.cache.mPrefetchID, e.toString()));
                this.cache.invalidateCache(e);
                Void void_ = null;
                return void_;
            }
            finally {
                this.cache.donePrefetch();
                if (this.cache.continuePrefetching()) {
                    this.cache.doPrefetch();
                }
            }
        }
    }
}

