/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational;

import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.values.IRow;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.RowValue;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.IExecutable;
import com.cognos.xqe.resultset.interfaces.ITabularIterator;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.resultsets.tabular.TabularHybridResultSet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XResultSetBase;
import com.cognos.xqe.runtree.XTabularIterator;
import com.cognos.xqe.runtree.XTabularResultSet;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.trace.XQETrace;
import java.util.concurrent.BlockingQueue;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class XEnqueue
extends XTabularResultSet {
    private static final long serialVersionUID = 1L;
    private static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);
    private static final String ATTRIBUTE_QUEUENAME = "queueName";
    private String queueName;

    @Override
    protected IValue executeImpl(XDataContext context) {
        return new TabularHybridResultSet(context, new XEnqueueResultSet(context), this.getId());
    }

    @Override
    public int getType() {
        return 501035;
    }

    public void setQueueName(String name) {
        this.queueName = name;
    }

    public String getQueueName() {
        return this.queueName;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute(ATTRIBUTE_QUEUENAME, this.queueName);
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        this.queueName = inputNode.attributeValue(ATTRIBUTE_QUEUENAME);
        this.capture(env, inputNode, 0);
    }

    @Override
    protected void persistAttributeProperties(XQEPersistContext ctx) {
        super.persistAttributeProperties(ctx);
        ctx.property(ATTRIBUTE_QUEUENAME, this.queueName);
    }

    @Override
    protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element inputNode) {
        String attname = att.getName();
        if (attname.equals(ATTRIBUTE_QUEUENAME)) {
            Object val = ctx.attributeValue(att);
            this.queueName = (String)val;
        } else {
            super.restoreAttributeProperty(ctx, att, inputNode);
        }
    }

    private final class XEnqueueResultSet
    extends XResultSetBase
    implements ITabularResultSet {
        private ITabularResultSet iResultSet;

        XEnqueueResultSet(XDataContext context) {
            super(context, XEnqueue.this.getId());
            this.iResultSet = (ITabularResultSet)((IExecutable)((Object)XEnqueue.this.getChild(0))).execute(this.getDataContext());
            super.setTabularRowsetInfo(this.iResultSet.getTabularRowsetInfo());
        }

        @Override
        public ITabularIterator getTabularIterator() {
            return new XEnqueueIterator(this.getDataContext());
        }

        @Override
        public void releaseImpl() {
            if (this.iResultSet != null) {
                this.iResultSet.release();
                this.iResultSet = null;
            }
            this.rowsetInfo = null;
        }

        private final class XEnqueueIterator
        extends XTabularIterator {
            private BlockingQueue<IRow> queue;
            private ITabularIterator tabIt;

            private XEnqueueIterator(XDataContext context) {
                super(context, XEnqueue.this.getId());
                try {
                    this.startTimer();
                    this.tabIt = XEnqueueResultSet.this.iResultSet.getTabularIterator();
                    this.queue = context.getQueue(XEnqueue.this.queueName);
                }
                catch (RuntimeException e) {
                    this.release();
                    throw e;
                }
                finally {
                    this.stopTimer();
                }
            }

            @Override
            public Object nextImpl() {
                if (this.context.isCanceled()) {
                    throw new OperationCanceledException(this.context.getCancelSource());
                }
                IRow row = (IRow)this.tabIt.next();
                if (row != null) {
                    try {
                        if (row instanceof RowValue) {
                            this.queue.put((IRow)((RowValue)row).copy(false));
                        } else {
                            this.queue.put((IRow)row.copy());
                        }
                    }
                    catch (InterruptedException e) {
                        mErrorLogger.log(e);
                        row = null;
                    }
                    ++this.nRows;
                }
                return row;
            }

            @Override
            public long getIndex() {
                return this.nRows;
            }

            @Override
            public void release() {
                if (this.tabIt != null) {
                    try {
                        this.tabIt.release();
                    }
                    catch (Exception ex) {
                        mErrorLogger.log(ex);
                    }
                    finally {
                        this.tabIt = null;
                    }
                }
                this.queue = null;
                super.release();
            }
        }
    }
}

