/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational;

import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.values.BooleanValue;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IRow;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.IExecutable;
import com.cognos.xqe.resultset.interfaces.IHybridResultSet;
import com.cognos.xqe.resultset.interfaces.ITabularIterator;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.resultsets.tabular.TabularHybridResultSet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XResultSetBase;
import com.cognos.xqe.runtree.XTabularIterator;
import com.cognos.xqe.runtree.XTabularResultSet;
import com.cognos.xqe.runtree.relational.XExpression;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.trace.XQETrace;
import java.util.List;
import org.dom4j.Element;

public class XFilter
extends XTabularResultSet {
    private static final long serialVersionUID = 1L;
    private static final String ATTRIBUTE_CONTEXTNO = "contextNo";
    private static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);

    @Override
    protected IValue executeImpl(XDataContext context) {
        return new TabularHybridResultSet(context, new XFilterResultSet(context), this.getId());
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        super.dumpExtraInfo(trace, includeRuntimeSpecifics);
        trace.attribute(ATTRIBUTE_CONTEXTNO, String.valueOf(this.contextNo));
    }

    @Override
    public int getType() {
        return 501007;
    }

    public XExpression getPredicate() {
        return (XExpression)this.getChild(1);
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        List elements = inputNode.elements();
        super.capture(env, inputNode, elements.size() - 2);
    }

    private final class XFilterResultSet
    extends XResultSetBase
    implements ITabularResultSet {
        private int contextNo;
        private IHybridResultSet iResultSet;
        private XExpression predicate;

        XFilterResultSet(XDataContext context) {
            super(context, XFilter.this.getId());
            this.contextNo = XFilter.this.getContextNo();
            this.iResultSet = (IHybridResultSet)((IExecutable)((Object)XFilter.this.getChild(0))).execute(this.getDataContext());
            super.setTabularRowsetInfo(this.iResultSet.getTabularRowsetInfo());
            this.predicate = XFilter.this.getPredicate();
            try {
                this.predicate.open(context, this.rowsetInfo);
            }
            catch (XQERuntimeException e) {
                this.release();
                throw e;
            }
        }

        @Override
        public ITabularIterator getTabularIterator() {
            return new XFilterIterator(this.getDataContext());
        }

        @Override
        public void releaseImpl() {
            if (this.iResultSet != null) {
                this.iResultSet.release();
                this.iResultSet = null;
            }
            this.predicate.close(this.getDataContext());
            this.rowsetInfo = null;
        }

        private final class XFilterIterator
        extends XTabularIterator {
            private ITabularIterator tabIt;
            private IRow row;
            private BooleanValue result;

            private XFilterIterator(XDataContext context) {
                super(context, XFilter.this.getId());
                this.result = DataValueFactory.createBooleanValue();
                try {
                    this.startTimer();
                    this.tabIt = XFilterResultSet.this.iResultSet.getTabularIterator();
                }
                catch (RuntimeException e) {
                    this.release();
                    throw e;
                }
                finally {
                    this.stopTimer();
                }
            }

            @Override
            public Object nextImpl() {
                if (this.context.isCanceled()) {
                    throw new OperationCanceledException(this.context.getCancelSource());
                }
                do {
                    this.row = (IRow)this.tabIt.next();
                    if (this.row == null) break;
                    this.context.pushRow(XFilterResultSet.this.contextNo, this.row);
                    this.result = (BooleanValue)XFilterResultSet.this.predicate.execute(this.context);
                    this.context.popRow();
                } while (!this.result.getBoolean());
                if (this.row != null) {
                    ++this.nRows;
                }
                return this.row;
            }

            @Override
            public long getIndex() {
                return this.tabIt.getIndex();
            }

            @Override
            public void release() {
                if (this.tabIt != null) {
                    try {
                        this.tabIt.release();
                    }
                    catch (Exception ex) {
                        mErrorLogger.log(ex);
                    }
                    finally {
                        this.tabIt = null;
                    }
                }
                super.release();
            }
        }
    }
}

