/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.DataSubType;
import com.cognos.xqe.data.DataTypeComparator;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.MemberType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DateValue;
import com.cognos.xqe.data.values.IRow;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.StringValue;
import com.cognos.xqe.data.values.TextValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.IColumnInfo;
import com.cognos.xqe.resultset.interfaces.IExecutable;
import com.cognos.xqe.resultset.interfaces.IHybridResultSet;
import com.cognos.xqe.resultset.interfaces.ITabularIterator;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.resultsets.ContextBase;
import com.cognos.xqe.resultsets.ContextMember;
import com.cognos.xqe.resultsets.ContextValue;
import com.cognos.xqe.resultsets.tabular.ColumnInfo;
import com.cognos.xqe.resultsets.tabular.MeasureColumnInfo;
import com.cognos.xqe.resultsets.tabular.NumericColumnInfo;
import com.cognos.xqe.resultsets.tabular.RowsetInfo;
import com.cognos.xqe.resultsets.tabular.StringColumnInfo;
import com.cognos.xqe.resultsets.tabular.TabularHybridResultSet;
import com.cognos.xqe.rsapi.RSAPIColumn;
import com.cognos.xqe.rsapi.RSAPIDataItem;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIEdge;
import com.cognos.xqe.rsapi.RSAPIRowset;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XIterator;
import com.cognos.xqe.runtree.XResultSetBase;
import com.cognos.xqe.runtree.XTabularIterator;
import com.cognos.xqe.runtree.XTabularResultSet;
import com.cognos.xqe.runtree.olap.XMdxLocal;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.transformation.rsapi.RSAPIUtilities;
import com.cognos.xqe.util.Pair;
import com.cognos.xqe.util.UniqueNameGenerator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class XFlatten
extends XTabularResultSet {
    private static final long serialVersionUID = 1L;
    private static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);
    protected static final String COLUMN_INFO_DATA = "ColumnInfo";
    protected static final String COLUMN_TYPE = "datatype";
    protected static final String COLUMN_NAME = "name";
    protected static final String TYPE_STRING = "string";
    protected static final String ATTRIBUTE_USE_SAP_MUN_AS_KEY = "useSAPMUNAsBusinessKey";
    protected static final String ELEMENT_COLUMNS = "columns";
    protected static final String ELEMENT_RSAPI_EDGE = "rsapiEdge";
    List<IColumnInfo> columns = new ArrayList<IColumnInfo>();
    private boolean mUseSAPMUNAsBusinessKey = true;
    protected RSAPIEdge rsapiEdge = null;

    public void setColumns(RSAPIEdge edge, boolean noMetaData) {
        RSAPIColumn[] cols = edge.getRowset(0).getColumns();
        this.rsapiEdge = edge;
        for (RSAPIColumn column : cols) {
            RSAPIDataItem dataItem = column.getBaseRefDataItem();
            ColumnInfo colInfo = dataItem.getPreserveMetadata() ? new StringColumnInfo(column.getName(), MemberType.MEMBERTYPE) : (column.getDatatype().isNumeric() ? new NumericColumnInfo(column.getName(), column.getDatatype()) : (RSAPIUtilities.isCanonicalProperty(column.getDatatype()) ? new StringColumnInfo(column.getName(), column.getDatatype()) : (noMetaData ? new ColumnInfo(column.getName(), DataTypeFactory.getVarcharType()) : new StringColumnInfo(column.getName(), column.getDatatype()))));
            this.columns.add(colInfo);
        }
    }

    @Override
    public int getType() {
        return 501031;
    }

    @Override
    protected IValue executeImpl(XDataContext context) {
        return new TabularHybridResultSet(context, new XFlattenResultSet(context), this.getId());
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        Element child;
        List children = inputNode.elements();
        int i = 0;
        Iterator iterator = children.iterator();
        while (iterator.hasNext() && (child = (Element)iterator.next()).getName().equals(COLUMN_INFO_DATA)) {
            String att = child.attributeValue(COLUMN_TYPE);
            String attName = child.attributeValue(COLUMN_NAME);
            IDataType dataType = att.compareTo(TYPE_STRING) == 0 ? DataTypeFactory.getMemberType() : DataTypeFactory.getType(att);
            ColumnInfo colInfo = dataType.isNumeric() ? new NumericColumnInfo(attName, dataType) : new StringColumnInfo(attName, dataType);
            this.columns.add(colInfo);
            ++i;
        }
        super.capture(env, inputNode, i);
    }

    @Override
    protected void persistAttributeProperties(XQEPersistContext ctx) {
        super.persistAttributeProperties(ctx);
        ctx.property(ATTRIBUTE_USE_SAP_MUN_AS_KEY, this.mUseSAPMUNAsBusinessKey);
    }

    @Override
    protected void persistElementProperties(XQEPersistContext ctx) {
        super.persistElementProperties(ctx);
        if (this.columns != null) {
            ctx.elementProperty(ELEMENT_COLUMNS, this.columns);
        }
        if (this.rsapiEdge != null) {
            ctx.elementProperty(ELEMENT_RSAPI_EDGE, this.rsapiEdge);
        }
    }

    @Override
    protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element inputNode) {
        String attname = att.getName();
        if (attname.equals(ATTRIBUTE_USE_SAP_MUN_AS_KEY)) {
            Object val = ctx.attributeValue(att);
            this.mUseSAPMUNAsBusinessKey = (Boolean)val;
        } else {
            super.restoreAttributeProperty(ctx, att, inputNode);
        }
    }

    @Override
    protected void restoreElementProperty(XQERestoreContext ctx, Element node, Element inputNode) {
        String pname = node.attributeValue("pname");
        if (pname.equals(ELEMENT_COLUMNS)) {
            Object val = ctx.elementValue(node);
            this.columns = (List)val;
        } else if (pname.equals(ELEMENT_RSAPI_EDGE)) {
            Object val = ctx.elementValue(node);
            this.rsapiEdge = (RSAPIEdge)val;
        } else {
            super.restoreElementProperty(ctx, node, inputNode);
        }
    }

    private final class XFlattenResultSet
    extends XResultSetBase
    implements ITabularResultSet {
        private IHybridResultSet iResultSet;

        XFlattenResultSet(XDataContext theContext) {
            IDataSource dataSource;
            super(theContext, XFlatten.this.getId());
            IXQEQueryNode child = XFlatten.this.getChild(0);
            this.iResultSet = (IHybridResultSet)((IExecutable)((Object)child)).execute(this.getDataContext());
            boolean bNeedToUseCompatibleDataTypeFromValues = false;
            IXQEQueryNode xmdxlocal = XFlatten.this.getFirstDescendantOfTypeOrdered(501053, false);
            if (xmdxlocal != null && (dataSource = ((XMdxLocal)xmdxlocal).getDataSource()) != null) {
                String providerType = dataSource.getType();
                bNeedToUseCompatibleDataTypeFromValues = DataSourceTypeEnum.isTM(providerType);
            }
            if (!bNeedToUseCompatibleDataTypeFromValues) {
                this.buildRowsetInfo();
            } else {
                this.buildRowsetInfoUseCompatibleDataTypeFromValues();
            }
        }

        @Override
        public ITabularIterator getTabularIterator() {
            return new XFlattenIterator(this.getDataContext());
        }

        @Override
        public void releaseImpl() {
            if (this.iResultSet != null) {
                this.iResultSet.release();
                this.iResultSet = null;
            }
            this.rowsetInfo = null;
        }

        private void buildRowsetInfo() {
            this.rowsetInfo = new RowsetInfo();
            XIterator iterator = this.iResultSet.getV5EdgeIterator(XFlatten.this.rsapiEdge);
            IRow aRow = null;
            try {
                aRow = (IRow)iterator.next();
            }
            finally {
                iterator.release();
            }
            for (IColumnInfo column : XFlatten.this.columns) {
                ContextValue aValue;
                int index = this.rowsetInfo.getNumColumns();
                ContextBase contextItem = null;
                if (aRow != null) {
                    for (IValue current : aRow.getColumns()) {
                        if (((ContextBase)((Object)current)).getDataItemIndex() != index) continue;
                        contextItem = (ContextBase)((Object)current);
                        break;
                    }
                }
                if (contextItem != null && contextItem.contextIsAValue() && (aValue = (ContextValue)contextItem).getDataType() != column.getDataType()) {
                    IDataType dt = DataTypeComparator.getCompatibleType(aValue.getDataType(), column.getDataType());
                    if (dt == null) {
                        dt = aValue.getDataType();
                    }
                    if (dt != column.getDataType()) {
                        if (aValue.getContextMember() != null) {
                            this.rowsetInfo.addColumnInfo(new MeasureColumnInfo(aValue.getContextMember(), dt));
                            continue;
                        }
                        this.rowsetInfo.addColumnInfo(new ColumnInfo(column.getName(), dt));
                        continue;
                    }
                }
                this.rowsetInfo.addColumnInfo(column);
            }
            RSAPIDataset ds = (RSAPIDataset)XFlatten.this.getAncestorOfType(401005);
            if (ds != null) {
                XFlatten.this.mUseSAPMUNAsBusinessKey = ds.isUseSAPMUNAsBusinessKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void buildRowsetInfoUseCompatibleDataTypeFromValues() {
            this.rowsetInfo = new RowsetInfo();
            XIterator iterator = this.iResultSet.getV5EdgeIterator(XFlatten.this.rsapiEdge);
            HashMap<Integer, Pair> contextValueDataType = null;
            try {
                Object aRow = null;
                do {
                    if ((aRow = (IRow)iterator.next()) == null) continue;
                    if (contextValueDataType == null) {
                        contextValueDataType = this.initialContextValueDataType((IRow)aRow);
                        if (contextValueDataType == null) {
                            break;
                        }
                    } else {
                        this.upadteContextValueDataType((IRow)aRow, contextValueDataType);
                    }
                    if (!this.isContextValueDataTypeResolved(contextValueDataType)) continue;
                    break;
                } while (aRow != null);
            }
            finally {
                iterator.release();
            }
            for (IColumnInfo column : XFlatten.this.columns) {
                Pair src;
                int index = this.rowsetInfo.getNumColumns();
                if (contextValueDataType != null && (src = contextValueDataType.get(index)) != null && !src.getFirst().equals(column.getDataType())) {
                    IDataType dt = DataTypeComparator.getCompatibleType((IDataType)src.getFirst(), column.getDataType());
                    if (dt == null) {
                        dt = (IDataType)src.getFirst();
                    }
                    if (!dt.equals(column.getDataType())) {
                        MeasureColumnInfo columnNew = new MeasureColumnInfo((IMember)src.getSecond(), (IDataType)src.getFirst());
                        this.rowsetInfo.addColumnInfo(columnNew);
                        continue;
                    }
                }
                this.rowsetInfo.addColumnInfo(column);
            }
            RSAPIDataset ds = (RSAPIDataset)XFlatten.this.getAncestorOfType(401005);
            if (ds != null) {
                XFlatten.this.mUseSAPMUNAsBusinessKey = ds.isUseSAPMUNAsBusinessKey();
            }
        }

        private HashMap<Integer, Pair> initialContextValueDataType(IRow aRow) {
            HashMap<Integer, Pair> rt = null;
            for (IValue current : aRow.getColumns()) {
                if (!((ContextBase)((Object)current)).contextIsAValue()) continue;
                if (rt == null) {
                    rt = new HashMap<Integer, Pair>();
                }
                int index = ((ContextBase)((Object)current)).getDataItemIndex();
                Pair p = null;
                Value aValue = (Value)((ContextValue)current).getValue();
                if (aValue != null && aValue.isOK()) {
                    p = new Pair(aValue.getDataType(), ((ContextValue)current).getContextMember());
                }
                rt.put(index, p);
            }
            return rt;
        }

        private void upadteContextValueDataType(IRow aRow, HashMap<Integer, Pair> contextValueDataType) {
            for (IValue current : aRow.getColumns()) {
                Value aValue;
                int index;
                Pair p;
                if (!((ContextBase)((Object)current)).contextIsAValue() || (p = contextValueDataType.get(index = ((ContextBase)((Object)current)).getDataItemIndex())) != null || (aValue = (Value)((ContextValue)current).getValue()) == null || !aValue.isOK()) continue;
                p = new Pair(aValue.getDataType(), ((ContextValue)current).getContextMember());
                contextValueDataType.put(index, p);
            }
        }

        private boolean isContextValueDataTypeResolved(HashMap<Integer, Pair> contextValueDataType) {
            for (Pair p : contextValueDataType.values()) {
                if (p != null) continue;
                return false;
            }
            return true;
        }

        private final class XFlattenIterator
        extends XTabularIterator {
            private static final long serialVersionUID = 1L;
            private XIterator sourceTabularIterator;
            private IRow rowToReturn;

            private boolean isIntrinsicProperty(IDataType dType) {
                return RSAPIUtilities.isCanonicalProperty(dType);
            }

            XFlattenIterator(XDataContext theContext) {
                super(theContext, XFlatten.this.getId());
                try {
                    this.sourceTabularIterator = XFlattenResultSet.this.iResultSet.getV5EdgeIterator(XFlatten.this.rsapiEdge);
                    this.rowToReturn = (IRow)XFlattenResultSet.this.rowsetInfo.getDataType().createValue(theContext.getLocalCollator());
                }
                catch (RuntimeException e) {
                    this.release();
                    throw e;
                }
            }

            @Override
            public Object nextImpl() {
                if (this.context.isCanceled()) {
                    throw new OperationCanceledException(this.context.getCancelSource());
                }
                if (this.rowToReturn == null || this.sourceTabularIterator == null) {
                    return null;
                }
                IRow aRow = (IRow)this.sourceTabularIterator.next();
                if (aRow == null) {
                    return null;
                }
                IValue[] values = this.rowToReturn.getColumns();
                this.generateRow(values, aRow);
                return this.rowToReturn;
            }

            private void generateRow(IValue[] values, IRow aRow) {
                int numColumns = aRow.getNumColumns();
                if (values.length != numColumns) {
                    for (IValue current : values) {
                        if (current.isMetadata()) {
                            ((ContextMember)current).setMember(null);
                            continue;
                        }
                        current.setNull();
                    }
                }
                for (int i = 0; i < numColumns; ++i) {
                    ContextBase contextItem = (ContextBase)((Object)aRow.getColumn(i));
                    if (contextItem.contextIsAValue()) {
                        IValue aValue = ((ContextValue)contextItem).getValue();
                        int index = contextItem.getDataItemIndex();
                        values[index].copyFrom(aValue);
                        continue;
                    }
                    this.copyMembers((ContextMember)contextItem, values);
                }
                for (IValue value : values) {
                    if (!(value instanceof TextValue)) continue;
                    ((TextValue)value).setCollator(this.getDataContext().getLocalCollator());
                }
            }

            private void copyMembers(ContextMember contextMember, IValue[] values) {
                while (contextMember != null) {
                    int index = contextMember.getDataItemIndex();
                    RSAPIRowset rowset = contextMember.getRowset();
                    List<Integer> additionalDataItems = contextMember.getAdditionalDataItemIndices();
                    int aIndex = -1;
                    if (additionalDataItems != null) {
                        aIndex = additionalDataItems.size() - 1;
                    }
                    do {
                        RSAPIDataItem item = null;
                        if (rowset != null) {
                            item = rowset.getDataItem(index);
                        }
                        String propertyName = null;
                        if (item != null) {
                            propertyName = item.getPropertyName();
                        }
                        if (propertyName != null && values[index].getDataType() != MemberType.MEMBERTYPE) {
                            IMember member = contextMember.getMember();
                            Object object = member.getProperty(propertyName);
                            if (object != null) {
                                IValue value = object instanceof IValue ? (IValue)object : DataValueFactory.convertObjectToIValue(object);
                                if (values[index].getDataType().getCCLTypeCode() == 57 && "SAP_BUSINESS_KEY".equals(propertyName)) {
                                    DateValue date = DataValueFactory.createDateValue();
                                    date.setFormat("yyyyMMdd");
                                    date.set(object);
                                    values[index].copyFrom(date);
                                } else if (!XFlatten.this.mUseSAPMUNAsBusinessKey && "SAP_BUSINESS_KEY".equals(propertyName)) {
                                    values[index] = DataValueFactory.createStringValue();
                                    ((StringValue)values[index]).set(UniqueNameGenerator.getSAPBusinessKeyFromMUN((String)object));
                                } else {
                                    values[index].copyFrom(value);
                                }
                            } else {
                                values[index].setNull();
                            }
                        } else if (values[index].getDataType() == MemberType.MEMBERTYPE) {
                            values[index].copyFrom(contextMember.getMember());
                            if (propertyName != null) {
                                ((ContextMember)values[index]).setCustomPropertyName(propertyName);
                            }
                        } else if (!this.isIntrinsicProperty(values[index].getDataType()) && values[index].getDataType().getSubType() == DataSubType.TEXTTYPE) {
                            ((TextValue)values[index]).set(contextMember.getMember().getCaptionValue().getString());
                        } else if (!values[index].getDataType().isNumeric() && !item.isCustomProperty()) {
                            ((Value)values[index]).set(contextMember.getMember());
                        }
                        if (additionalDataItems == null) break;
                        if (aIndex < 0) continue;
                        index = additionalDataItems.get(aIndex);
                    } while (aIndex-- >= 0);
                    contextMember = contextMember.getContextMember();
                }
            }

            @Override
            public void release() {
                if (this.sourceTabularIterator != null) {
                    try {
                        this.sourceTabularIterator.release();
                    }
                    catch (Exception ex) {
                        mErrorLogger.log(ex);
                    }
                    finally {
                        this.sourceTabularIterator = null;
                    }
                }
                this.rowToReturn = null;
                super.release();
            }
        }
    }
}

