/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.RowValue;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.resultset.interfaces.IExecutable;
import com.cognos.xqe.resultset.interfaces.IHybridResultSet;
import com.cognos.xqe.resultset.interfaces.IRowsetInfo;
import com.cognos.xqe.resultset.interfaces.ITabularIterator;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.resultsets.tabular.Join;
import com.cognos.xqe.resultsets.tabular.TabularHybridResultSet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XResultSetBase;
import com.cognos.xqe.runtree.XTabularIterator;
import com.cognos.xqe.runtree.relational.XJoin;
import com.cognos.xqe.runtree.relational.util.FileBasedPersistedResultSet;
import com.cognos.xqe.runtree.relational.util.HashKeysSet;
import com.cognos.xqe.runtree.relational.util.IPersistedResultSet;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.IReleasable;
import java.util.HashSet;
import java.util.Set;

public class XHashAntiJoin
extends XJoin {
    private static final long serialVersionUID = 1L;
    private static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);

    @Override
    protected IValue executeImpl(XDataContext context) throws XQERuntimeException {
        return new TabularHybridResultSet(context, new XHashAntiJoinResultSet(context), this.getId());
    }

    @Override
    public int getType() {
        return 501008;
    }

    private final class XHashAntiJoinResultSet
    extends XResultSetBase
    implements ITabularResultSet {
        private IHybridResultSet[] iResultSets;

        XHashAntiJoinResultSet(XDataContext theContext) {
            super(theContext, XHashAntiJoin.this.getId());
            try {
                this.iResultSets = new IHybridResultSet[2];
                for (int i = 0; i < 2; ++i) {
                    this.iResultSets[i] = (IHybridResultSet)((IExecutable)((Object)XHashAntiJoin.this.getChild(i))).execute(this.getDataContext());
                }
                super.setTabularRowsetInfo(this.iResultSets[0].getTabularRowsetInfo());
            }
            catch (RuntimeException e) {
                this.release();
                throw e;
            }
        }

        @Override
        public ITabularIterator getTabularIterator() {
            return new XHashAntiJoinIterator(this.getDataContext());
        }

        @Override
        public void releaseImpl() {
            if (this.iResultSets != null) {
                XHashAntiJoinResultSet.releaseNonNullReleasables((IReleasable[])this.iResultSets);
                this.iResultSets = null;
                this.rowsetInfo = null;
            }
        }

        private final class XHashAntiJoinIterator
        extends XTabularIterator {
            private static final long serialVersionUID = 1L;
            private static final int BUILD_INDEX = 1;
            private static final int PROBE_INDEX = 0;
            private ITabularIterator probeIterator;
            private RowValue probeRow;
            private IRowsetInfo probeRowsetInfo;
            private IPersistedResultSet probeScan;
            private BuildTable buildTable;

            private XHashAntiJoinIterator(XDataContext context) {
                super(context, XHashAntiJoin.this.getId());
                this.probeRowsetInfo = null;
                this.probeScan = null;
                this.buildTable = null;
                try {
                    this.startTimer();
                    this.probeRowsetInfo = XHashAntiJoinResultSet.this.iResultSets[0].getTabularRowsetInfo();
                    this.probeIterator = XHashAntiJoinResultSet.this.iResultSets[0].getTabularIterator();
                    this.buildTable = new BuildTable();
                }
                catch (RuntimeException e) {
                    this.release();
                    throw e;
                }
                finally {
                    this.stopTimer();
                }
            }

            @Override
            public Object nextImpl() {
                while (true) {
                    this.getNextProbeRow();
                    if (this.probeRow == null) {
                        return null;
                    }
                    if (this.buildTable.matchProbeRow()) continue;
                    if (this.buildTable.lastPartition()) break;
                    this.writeProbeRow();
                }
                return this.probeRow;
            }

            private void writeProbeRow() {
                if (this.probeScan == null) {
                    this.probeScan = new FileBasedPersistedResultSet(this.probeRowsetInfo.getDataType(), this.context);
                }
                this.probeScan.write(this.probeRow);
            }

            private void getNextProbeRow() {
                while (true) {
                    this.probeRow = (RowValue)this.probeIterator.next();
                    if (this.probeRow != null) break;
                    this.probeIterator.release();
                    this.probeIterator = null;
                    if (this.probeScan == null) break;
                    this.probeIterator = this.probeScan.getIterator();
                    this.probeScan = null;
                    if (this.buildTable.lastPartition()) {
                        throw new RuntimeException("Incorrect state - build there is no more build partitions, but the probe table is saved");
                    }
                    this.buildTable.loadNextPartition();
                }
            }

            @Override
            public long getIndex() {
                return this.nRows;
            }

            @Override
            public void release() {
                this.buildTable.release();
                try {
                    if (this.probeIterator != null) {
                        this.probeIterator.release();
                    }
                }
                catch (Exception ex) {
                    mErrorLogger.log(ex);
                }
                finally {
                    this.probeIterator = null;
                }
                if (this.probeScan != null) {
                    this.probeScan.release();
                    this.probeScan = null;
                }
            }

            private class BuildTable {
                private Set<HashKeysSet> hashSet = null;
                private ITabularIterator buildIterator = null;
                private RowValue buildRow;
                long memory = 0L;
                int[] probeJoinColumns = null;
                private boolean useFastHash = true;
                private IRowsetInfo buildRowsetInfo = null;
                private HashKeysSet probeKeys = null;
                private boolean first = true;

                BuildTable() {
                    int i;
                    int nJoins = XHashAntiJoin.this.joins.size();
                    this.probeJoinColumns = new int[nJoins];
                    for (i = 0; i < nJoins; ++i) {
                        Join join = (Join)XHashAntiJoin.this.joins.get(i);
                        this.probeJoinColumns[i] = join.getLeftJoin().getColumnNo();
                    }
                    this.buildRowsetInfo = XHashAntiJoinResultSet.this.iResultSets[1].getTabularRowsetInfo();
                    for (i = 0; i < nJoins; ++i) {
                        if (this.buildRowsetInfo.getColumnInfo(i).getDataType().getCCLTypeCode() == XHashAntiJoinIterator.this.probeRowsetInfo.getColumnInfo(this.probeJoinColumns[i]).getDataType().getCCLTypeCode()) continue;
                        this.useFastHash = false;
                        break;
                    }
                    this.buildIterator = XHashAntiJoinResultSet.this.iResultSets[1].getTabularIterator();
                    this.hashSet = new HashSet<HashKeysSet>();
                    this.probeKeys = new HashKeysSet(nJoins, XHashAntiJoinIterator.this.getDataContext().getLocalCollator(), this.useFastHash);
                }

                public boolean matchProbeRow() {
                    if (this.first) {
                        this.first = false;
                        this.loadNextPartition();
                    }
                    for (int i = 0; i < this.probeJoinColumns.length; ++i) {
                        if (!XHashAntiJoinIterator.this.probeRow.getColumn(this.probeJoinColumns[i]).isNull()) continue;
                        return false;
                    }
                    this.probeKeys.set(XHashAntiJoinIterator.this.probeRow, this.probeJoinColumns);
                    return this.hashSet.contains(this.probeKeys);
                }

                public boolean lastPartition() {
                    return this.buildIterator == null;
                }

                private void loadNextPartition() {
                    IPersistedResultSet scan = null;
                    if (this.memory > 0L) {
                        XHashAntiJoinIterator.this.context.getMemoryManager().releaseMemory(this.memory);
                    }
                    this.hashSet.clear();
                    while (true) {
                        try {
                            this.buildRow = (RowValue)this.buildIterator.next();
                        }
                        catch (RuntimeException e) {
                            if (scan != null) {
                                scan.release();
                            }
                            this.release();
                            throw e;
                        }
                        if (this.buildRow == null) {
                            this.buildIterator.release();
                            this.buildIterator = null;
                            if (scan == null) break;
                            this.buildIterator = scan.getIterator();
                            scan = null;
                            break;
                        }
                        boolean ignore = false;
                        for (int i = 0; i < this.buildRow.getNumColumns(); ++i) {
                            if (!this.buildRow.getColumn(i).isNull()) continue;
                            ignore = true;
                            break;
                        }
                        if (ignore) continue;
                        HashKeysSet buildKeys = new HashKeysSet(this.buildRow.getNumColumns(), XHashAntiJoinIterator.this.getDataContext().getLocalCollator(), this.useFastHash);
                        buildKeys.set(this.buildRow);
                        if (this.hashSet.contains(buildKeys)) continue;
                        if (scan == null) {
                            boolean forced;
                            long memRequired = buildKeys.sizeOf();
                            boolean bl = forced = this.hashSet.size() == 0;
                            if (XHashAntiJoinIterator.this.context.getMemoryManager().allocateMemory(memRequired, forced)) {
                                this.hashSet.add(buildKeys.copy());
                                this.memory += memRequired;
                                continue;
                            }
                            scan = new FileBasedPersistedResultSet(this.buildRowsetInfo.getDataType(), XHashAntiJoinIterator.this.context);
                            scan.write(this.buildRow);
                            continue;
                        }
                        scan.write(this.buildRow);
                    }
                }

                void release() {
                    try {
                        if (this.buildIterator != null) {
                            this.buildIterator.release();
                        }
                    }
                    catch (Exception ex) {
                        mErrorLogger.log(ex);
                    }
                    finally {
                        this.buildIterator = null;
                    }
                    this.hashSet.clear();
                    if (this.memory > 0L) {
                        XHashAntiJoinIterator.this.context.getMemoryManager().releaseMemory(this.memory);
                    }
                }
            }
        }
    }
}

