/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.values.IRow;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.LongValue;
import com.cognos.xqe.resultset.interfaces.IExecutable;
import com.cognos.xqe.resultset.interfaces.IHybridResultSet;
import com.cognos.xqe.resultset.interfaces.IRowsetInfo;
import com.cognos.xqe.resultset.interfaces.ITabularIterator;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.resultsets.tabular.NumericColumnInfo;
import com.cognos.xqe.resultsets.tabular.RowsetInfo;
import com.cognos.xqe.resultsets.tabular.TabularHybridResultSet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XResultSetBase;
import com.cognos.xqe.runtree.XTabularIterator;
import com.cognos.xqe.runtree.XTabularResultSet;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class XOrdinalDecoration
extends XTabularResultSet {
    private static final long serialVersionUID = 1L;
    private static final String ATTRIBUTE_COUNTER = "counter";
    private static final String ATTRIBUTE_COLUMNNAME = "columnName";
    private static final String ELEMENT_REMOVE_COLUMNS = "removeColumns";
    private long counter = 0L;
    private String columnName;
    List<Integer> removeColomns = null;
    private static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);

    public void setColumnName(String name) {
        this.columnName = name;
    }

    public void setRemovedColumns(List<Integer> list) {
        this.removeColomns = list;
    }

    @Override
    public int getType() {
        return 501148;
    }

    @Override
    protected IValue executeImpl(XDataContext context) {
        return new TabularHybridResultSet(context, new XNumberedResultSet(context), this.getId());
    }

    @Override
    protected void persistAttributeProperties(XQEPersistContext ctx) {
        super.persistAttributeProperties(ctx);
        ctx.property(ATTRIBUTE_COUNTER, this.counter);
        ctx.property(ATTRIBUTE_COLUMNNAME, this.columnName);
    }

    @Override
    protected void persistElementProperties(XQEPersistContext ctx) {
        super.persistElementProperties(ctx);
        if (this.removeColomns != null) {
            ctx.elementProperty(ELEMENT_REMOVE_COLUMNS, this.removeColomns);
        }
    }

    @Override
    protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element inputNode) {
        String attname = att.getName();
        if (attname.equals(ATTRIBUTE_COUNTER)) {
            Object val = ctx.attributeValue(att);
            this.counter = this.counter;
        } else if (attname.equals(ATTRIBUTE_COLUMNNAME)) {
            Object val = ctx.attributeValue(att);
            this.columnName = (String)val;
        } else {
            super.restoreAttributeProperty(ctx, att, inputNode);
        }
    }

    @Override
    protected void restoreElementProperty(XQERestoreContext ctx, Element node, Element inputNode) {
        String pname = node.attributeValue("pname");
        if (pname.equals(ELEMENT_REMOVE_COLUMNS)) {
            Object val = ctx.elementValue(node);
            this.removeColomns = (List)val;
        } else {
            super.restoreElementProperty(ctx, node, inputNode);
        }
    }

    private final class XNumberedResultSet
    extends XResultSetBase
    implements ITabularResultSet {
        private IHybridResultSet iResultSet;

        XNumberedResultSet(XDataContext theContext) {
            super(theContext, XOrdinalDecoration.this.getId());
            IXQEQueryNode child = XOrdinalDecoration.this.getChild(0);
            this.iResultSet = (IHybridResultSet)((IExecutable)((Object)child)).execute(this.getDataContext());
            IRowsetInfo iRowsetInfo = this.iResultSet.getTabularRowsetInfo();
            this.rowsetInfo = new RowsetInfo();
            if (XOrdinalDecoration.this.removeColomns == null) {
                this.rowsetInfo.add(iRowsetInfo);
            } else {
                for (int i = 0; i < iRowsetInfo.getNumColumns(); ++i) {
                    if (XOrdinalDecoration.this.removeColomns.contains(i)) continue;
                    this.rowsetInfo.addColumnInfo(iRowsetInfo.getColumnInfo(i));
                }
            }
            NumericColumnInfo column = new NumericColumnInfo(XOrdinalDecoration.this.columnName, DataTypeFactory.getLongType());
            this.rowsetInfo.addColumnInfo(column);
        }

        @Override
        public ITabularIterator getTabularIterator() {
            return new XRowNumberIterator(this.getDataContext());
        }

        @Override
        public void releaseImpl() {
            if (this.iResultSet != null) {
                this.iResultSet.release();
                this.iResultSet = null;
            }
            this.rowsetInfo = null;
        }

        private final class XRowNumberIterator
        extends XTabularIterator {
            private static final long serialVersionUID = 1L;
            private ITabularIterator sourceTabularIterator;
            private IRow rowToReturn;

            XRowNumberIterator(XDataContext theContext) {
                super(theContext, XOrdinalDecoration.this.getId());
                try {
                    this.sourceTabularIterator = XNumberedResultSet.this.iResultSet.getTabularIterator();
                    this.rowToReturn = (IRow)XNumberedResultSet.this.rowsetInfo.getDataType().createValue(theContext.getLocalCollator());
                }
                catch (RuntimeException e) {
                    this.release();
                    throw e;
                }
            }

            @Override
            public Object nextImpl() {
                if (this.context.isCanceled()) {
                    throw new OperationCanceledException(this.context.getCancelSource());
                }
                if (this.rowToReturn == null || this.sourceTabularIterator == null) {
                    return null;
                }
                IRow aRow = (IRow)this.sourceTabularIterator.next();
                if (aRow == null) {
                    return null;
                }
                IValue[] values = this.rowToReturn.getColumns();
                int numColumns = values.length - 1;
                if (XOrdinalDecoration.this.removeColomns == null) {
                    for (int i = 0; i < numColumns; ++i) {
                        values[i] = aRow.getColumn(i);
                    }
                } else {
                    int i = 0;
                    int j = 0;
                    while (i < numColumns) {
                        if (!XOrdinalDecoration.this.removeColomns.contains(j)) {
                            values[i++] = aRow.getColumn(j);
                        }
                        ++j;
                    }
                }
                ((LongValue)values[numColumns]).set(++XOrdinalDecoration.this.counter);
                return this.rowToReturn;
            }

            @Override
            public void release() {
                if (this.sourceTabularIterator != null) {
                    try {
                        this.sourceTabularIterator.release();
                    }
                    catch (Exception ex) {
                        mErrorLogger.log(ex);
                    }
                    finally {
                        this.sourceTabularIterator = null;
                    }
                }
                this.rowToReturn = null;
                super.release();
            }
        }
    }
}

