/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational;

import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.values.IRow;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.IExecutable;
import com.cognos.xqe.resultset.interfaces.IRowsetInfo;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.exception.XCardinalityViolation;
import com.cognos.xqe.runtree.exception.XRuntimeException;
import com.cognos.xqe.runtree.relational.SubQueryState;
import com.cognos.xqe.runtree.relational.XSubQuery;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.IReleasable;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Element;

public class XScalarSubQuery
extends XSubQuery {
    private static final long serialVersionUID = 1L;
    private static final String ATTRIBUTE_DATATYPE = "dataType";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ELEMENT_PARAMETERS = "Parameters";
    private static final String ELEMENT_PARAMETER = "Parameter";

    @Override
    public void open(XDataContext context, IRowsetInfo rowsetInfo) {
        context.setStateObject(this, new SubQueryState(context, this.getParameters()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IValue executeImpl(XDataContext context) throws XRuntimeException {
        SubQueryState state = (SubQueryState)context.getStateObject(this);
        if (!state.isValid()) {
            this.lock.writeLock().lock();
            try {
                IValue value = null;
                ITabularResultSet resultSet = null;
                IReleasable tabIt = null;
                try {
                    resultSet = (ITabularResultSet)((IExecutable)((Object)this.getChild(0))).execute(context);
                    tabIt = resultSet.getTabularIterator();
                    IRow row = (IRow)tabIt.next();
                    if (row != null) {
                        value = this.getChild(0).getType() == 501051 ? row : (IValue)row.getColumn(0).copy();
                        if (tabIt.next() != null) {
                            throw new XCardinalityViolation(XQEMessageKeys.EXE_InvalidSubQuery);
                        }
                    } else {
                        value = this.getDataType().createValue(context.getLocalCollator());
                        value.setNull();
                    }
                    state.setValue(value);
                }
                finally {
                    if (tabIt != null) {
                        tabIt.release();
                        tabIt = null;
                    }
                    if (resultSet != null) {
                        resultSet.release();
                        resultSet = null;
                    }
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        return (IValue)state.getValue();
    }

    @Override
    public void close(XDataContext context) {
        context.removeStateObject(this);
    }

    @Override
    public int getType() {
        return 501049;
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        List elements;
        this.setContextNo(Integer.valueOf(inputNode.attribute("contextNo").getValue()));
        String dataTypeStr = inputNode.attributeValue(ATTRIBUTE_DATATYPE);
        if (dataTypeStr != null) {
            this.setDataType(DataTypeFactory.getType(dataTypeStr));
        }
        if ((elements = inputNode.elements()).size() > 1) {
            this.parameters = new ArrayList();
            List parameterList = ((Element)elements.get(0)).elements();
            for (Element parameter : parameterList) {
                String name = parameter.attributeValue(ATTRIBUTE_NAME);
                this.parameters.add(name);
            }
        }
        super.capture(env, inputNode, elements.size() - 1);
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute("contextNo", this.getContextNo());
        trace.attribute(ATTRIBUTE_DATATYPE, this.getDataType().toString());
        if (this.parameters != null) {
            trace.beginElement(ELEMENT_PARAMETERS);
            for (String name : this.parameters) {
                trace.beginElement(ELEMENT_PARAMETER);
                trace.attribute(ATTRIBUTE_NAME, name);
                trace.endElement();
            }
            trace.endElement();
        }
        super.dumpExtraInfo(trace, includeRuntimeSpecifics);
    }
}

