/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational;

import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.ast.sql.SQLSortKey;
import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.values.IRow;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.IExecutable;
import com.cognos.xqe.resultset.interfaces.IRowsetInfo;
import com.cognos.xqe.resultset.interfaces.ITabularIterator;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.resultsets.tabular.OrderBy;
import com.cognos.xqe.resultsets.tabular.RowComparator;
import com.cognos.xqe.resultsets.tabular.TabularHybridResultSet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XNode;
import com.cognos.xqe.runtree.XNodeFactory;
import com.cognos.xqe.runtree.XResultSetBase;
import com.cognos.xqe.runtree.XTabularIterator;
import com.cognos.xqe.runtree.XTabularResultSet;
import com.cognos.xqe.runtree.relational.util.SortEngine;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.trace.XQETrace;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class XSort
extends XTabularResultSet {
    private static final long serialVersionUID = 1L;
    private static final String ELEMENT_SORTKEYLIST = "SortKeyList";
    private static final String ELEMENT_SORTKEY = "SortKey";
    private static final String ATTRIBUTE_DISTINCT = "distinct";
    private static final String ATTRIBUTE_ASCENDING = "ascending";
    private static final String ATTRIBUTE_NULLSORDERING = "nullOrdering";
    private static final String ATTRIBUTE_POSITION = "position";
    private static final String ATTRIBUTE_LEVEL_NUMBER = "levelNumber";
    private static final String ATTRIBUTE_SORT_MEMBER_BY_CAPTION = "sortMemberByCaption";
    private boolean distinct;
    private boolean sortMemberByCaption = true;
    private OrderBy[] sortKeyList;
    private static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);

    public void setSortKeyList(OrderBy[] list) {
        this.sortKeyList = list;
    }

    public void setSortMemberByCaption(boolean value) {
        this.sortMemberByCaption = value;
    }

    @Override
    protected IValue executeImpl(XDataContext context) {
        return new TabularHybridResultSet(context, new XSortResultSet(context), this.getId());
    }

    @Override
    public int getType() {
        return 501012;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        if (this.distinct) {
            trace.attribute(ATTRIBUTE_DISTINCT, this.distinct);
        }
        super.dumpExtraInfo(trace, includeRuntimeSpecifics);
        trace.beginElement(ELEMENT_SORTKEYLIST);
        for (int i = 0; i < this.sortKeyList.length; ++i) {
            OrderBy sortKey = this.sortKeyList[i];
            trace.beginElement(ELEMENT_SORTKEY);
            trace.attribute(ATTRIBUTE_POSITION, sortKey.getPosition());
            trace.attribute(ATTRIBUTE_ASCENDING, sortKey.isAscending());
            trace.attribute(ATTRIBUTE_NULLSORDERING, sortKey.getNullOrdering().toString());
            if (sortKey.getLevelNo() >= 0) {
                trace.attribute(ATTRIBUTE_LEVEL_NUMBER, sortKey.getLevelNo());
            }
            trace.endElement();
        }
        trace.endElement();
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        XNodeFactory nodeFactory = (XNodeFactory)env.getNodeFactory();
        Element child = (Element)inputNode.elements().get(0);
        List keyList = child.elements();
        this.sortKeyList = new OrderBy[keyList.size()];
        for (int i = 0; i < keyList.size(); ++i) {
            int position = 0;
            boolean isAscending = false;
            int levelNumber = -1;
            child = (Element)keyList.get(i);
            position = Integer.valueOf(child.attributeValue(ATTRIBUTE_POSITION));
            isAscending = Boolean.valueOf(child.attributeValue(ATTRIBUTE_ASCENDING));
            String levelNumberString = child.attributeValue(ATTRIBUTE_LEVEL_NUMBER);
            if (levelNumberString != null && !"".equals(levelNumberString)) {
                levelNumber = Integer.parseInt(levelNumberString);
            }
            String nullOrdering = child.attributeValue(ATTRIBUTE_NULLSORDERING);
            this.sortKeyList[i] = new OrderBy(position, levelNumber, isAscending);
            if (nullOrdering == null) continue;
            if (nullOrdering.equals(SQLSortKey.NullOrdering.NULLS_FIRST.toString())) {
                this.sortKeyList[i].setNullOrdering(SQLSortKey.NullOrdering.NULLS_FIRST);
                continue;
            }
            if (nullOrdering.equals(SQLSortKey.NullOrdering.NULLS_LAST.toString())) {
                this.sortKeyList[i].setNullOrdering(SQLSortKey.NullOrdering.NULLS_LAST);
                continue;
            }
            this.sortKeyList[i].setNullOrdering(SQLSortKey.NullOrdering.UNSPECIFIED);
        }
        child = (Element)inputNode.elements().get(1);
        XNode xChild = (XNode)nodeFactory.createNodeByName(child.getName());
        xChild.capture(env, child);
        this.addChild(xChild);
        if ("true".equals(inputNode.attributeValue(ATTRIBUTE_DISTINCT))) {
            this.distinct = true;
        }
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean vDistinct) {
        this.distinct = vDistinct;
    }

    @Override
    public SQLSortKey.NullOrdering[] getNullOrdering() {
        SQLSortKey.NullOrdering[] nullOrdering = new SQLSortKey.NullOrdering[this.sortKeyList.length];
        for (int i = 0; i < this.sortKeyList.length; ++i) {
            nullOrdering[i] = this.sortKeyList[i].getNullOrdering();
        }
        return nullOrdering;
    }

    @Override
    protected void persistAttributeProperties(XQEPersistContext ctx) {
        super.persistAttributeProperties(ctx);
        if (this.distinct) {
            ctx.property(ATTRIBUTE_DISTINCT, this.distinct);
        }
        ctx.property(ATTRIBUTE_SORT_MEMBER_BY_CAPTION, this.sortMemberByCaption);
    }

    @Override
    protected void persistElementProperties(XQEPersistContext ctx) {
        super.persistElementProperties(ctx);
        if (this.sortKeyList != null) {
            ctx.elementProperty(ELEMENT_SORTKEYLIST, this.sortKeyList);
        }
    }

    @Override
    protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element inputNode) {
        String attname = att.getName();
        if (attname.equals(ATTRIBUTE_DISTINCT)) {
            Object val = ctx.attributeValue(att);
            this.distinct = (Boolean)val;
        } else if (attname.equals(ATTRIBUTE_SORT_MEMBER_BY_CAPTION)) {
            Object val = ctx.attributeValue(att);
            this.sortMemberByCaption = (Boolean)val;
        } else {
            super.restoreAttributeProperty(ctx, att, inputNode);
        }
    }

    @Override
    protected void restoreElementProperty(XQERestoreContext ctx, Element node, Element inputNode) {
        String pname = node.attributeValue("pname");
        if (pname != null && pname.equals(ELEMENT_SORTKEYLIST)) {
            Object val = ctx.elementValue(node);
            this.sortKeyList = (OrderBy[])val;
        } else {
            super.restoreElementProperty(ctx, node, inputNode);
        }
    }

    private final class XSortResultSet
    extends XResultSetBase
    implements ITabularResultSet {
        private ITabularResultSet iResultSet;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        XSortResultSet(XDataContext context) {
            super(context, XSort.this.getId());
            IExecutionEnvironment execEnv = context.getEnvironment();
            boolean useThreads = context.useThreads();
            try {
                if (useThreads) {
                    context = execEnv.pushDataContext();
                }
                this.iResultSet = (ITabularResultSet)((IExecutable)((Object)XSort.this.getChild(0))).execute(context);
            }
            finally {
                if (useThreads) {
                    execEnv.popDataContext(context);
                }
            }
            super.setTabularRowsetInfo(this.iResultSet.getTabularRowsetInfo());
        }

        @Override
        public ITabularIterator getTabularIterator() {
            return new XSortIterator(this.getDataContext(), this.iResultSet, this.rowsetInfo, XSort.this);
        }

        @Override
        public void releaseImpl() {
            if (this.iResultSet != null) {
                this.iResultSet.release();
                this.iResultSet = null;
            }
            this.rowsetInfo = null;
        }

        private final class XSortIterator
        extends XTabularIterator {
            private SortEngine sortEngine;
            private XTabularIterator tabIt;

            private XSortIterator(XDataContext context, ITabularResultSet resultSet, IRowsetInfo rowsetInfo, XSort parent) {
                super(context, XSort.this.getId());
                this.tabIt = null;
                try {
                    this.startTimer();
                    this.nRows = 0;
                    RowComparator comparator = new RowComparator(rowsetInfo, XSort.this.sortKeyList, context.getLocalCollator(), XSort.this.sortMemberByCaption);
                    this.sortEngine = new SortEngine(context, rowsetInfo, comparator, XSort.this.distinct);
                    this.tabIt = (XTabularIterator)resultSet.getTabularIterator();
                }
                catch (RuntimeException e) {
                    if (this.tabIt != null && this.sortEngine == null) {
                        this.tabIt.release();
                    }
                    this.release();
                    throw e;
                }
                finally {
                    this.stopTimer();
                }
            }

            private void loadSortEngine() {
                IRow inputRow = (IRow)this.tabIt.next();
                this.traceRow("inRow", inputRow);
                while (inputRow != null) {
                    this.sortEngine.write((IRow)inputRow.copy());
                    inputRow = (IRow)this.tabIt.next();
                    this.traceRow("inRow", inputRow);
                }
            }

            @Override
            public Object nextImpl() {
                this.openIteratorTrace(XSort.this, -1, "", true);
                this.openNextImplTrace(++this.callId);
                if (this.nRows == 0) {
                    this.loadSortEngine();
                }
                if (this.context.isCanceled()) {
                    throw new OperationCanceledException(this.context.getCancelSource());
                }
                IRow row = this.sortEngine.next();
                if (row != null) {
                    ++this.nRows;
                }
                this.traceRow("outRow", row);
                return row;
            }

            @Override
            public long getIndex() {
                return this.nRows;
            }

            @Override
            public void release() {
                if (this.tabIt != null) {
                    this.tabIt.release();
                }
                if (this.sortEngine != null) {
                    try {
                        this.sortEngine.release();
                    }
                    catch (Exception ex) {
                        mErrorLogger.log(ex);
                    }
                    finally {
                        this.sortEngine = null;
                    }
                }
                super.release();
            }
        }
    }
}

