/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.dataset;

import com.cognos.xqe.ast.sql.parser.ParseException;
import com.cognos.xqe.ast.sql.parser.SQLProcessor;
import com.cognos.xqe.data.DataType;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.RowType;
import com.ibm.bi.platform.datasetutils.metadata.ColumnMetadata;
import com.ibm.bi.platform.datasetutils.metadata.RowSchema;
import com.ibm.bi.platform.datasetutils.metadata.types.DecimalType;
import com.ibm.bi.platform.datasetutils.metadata.types.TemporalType;
import java.util.ArrayList;
import java.util.Map;

public final class RowTypeHelper {
    private RowTypeHelper() {
    }

    public static RowType resolveRowType(Map<String, String> kvMetadata, RowSchema recordSchema) throws ParseException {
        RowType rowType = kvMetadata.containsKey("rowType") ? (RowType)SQLProcessor.parseDataType(kvMetadata.get("rowType")) : RowTypeHelper.inferRowType(recordSchema);
        return rowType;
    }

    public static RowType inferRowType(RowSchema recordSchema) {
        ArrayList<String> colNames = new ArrayList<String>(recordSchema.getNumOfColumns());
        ArrayList<DataType> colTypes = new ArrayList<DataType>(recordSchema.getNumOfColumns());
        block15: for (int fieldIndex = 0; fieldIndex < recordSchema.getNumOfColumns(); ++fieldIndex) {
            ColumnMetadata fieldMeta = recordSchema.getColumnMetadata(fieldIndex);
            colNames.add(fieldMeta.getName());
            switch (fieldMeta.getType().getIntrinsicType()) {
                case BINARY: {
                    colTypes.add(DataTypeFactory.getBinaryType());
                    continue block15;
                }
                case BOOLEAN: {
                    colTypes.add(DataTypeFactory.getBooleanType());
                    continue block15;
                }
                case BYTE: {
                    colTypes.add(DataTypeFactory.getTinyintType());
                    continue block15;
                }
                case DATE: {
                    colTypes.add(DataTypeFactory.getDateType());
                    continue block15;
                }
                case DECIMAL: {
                    colTypes.add(DataTypeFactory.getDecimalType(((DecimalType)fieldMeta.getType()).getPrecision(), ((DecimalType)fieldMeta.getType()).getScale()));
                    continue block15;
                }
                case DOUBLE: {
                    colTypes.add(DataTypeFactory.getDoubleType());
                    continue block15;
                }
                case FLOAT: {
                    colTypes.add(DataTypeFactory.getFloatType());
                    continue block15;
                }
                case INT: {
                    colTypes.add(DataTypeFactory.getIntegerType());
                    continue block15;
                }
                case LONG: {
                    colTypes.add(DataTypeFactory.getLongType());
                    continue block15;
                }
                case SHORT: {
                    colTypes.add(DataTypeFactory.getSmallintType());
                    continue block15;
                }
                case STRING: {
                    colTypes.add(DataTypeFactory.getStringType());
                    continue block15;
                }
                case TIME: {
                    if (((TemporalType)fieldMeta.getType()).hasTimeZone()) {
                        colTypes.add(DataTypeFactory.getTimeWithTZType());
                        continue block15;
                    }
                    colTypes.add(DataTypeFactory.getTimeType());
                    continue block15;
                }
                case TIMESTAMP: {
                    if (((TemporalType)fieldMeta.getType()).hasTimeZone()) {
                        colTypes.add(DataTypeFactory.getTimestampWithTZType());
                        continue block15;
                    }
                    colTypes.add(DataTypeFactory.getTimestampType());
                    continue block15;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported type: " + fieldMeta.getType().toString());
                }
            }
        }
        return DataTypeFactory.getRowType(colNames.toArray(new String[colNames.size()]), colTypes.toArray(new IDataType[colTypes.size()]));
    }
}

