/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.dataset;

import com.cognos.xqe.ast.XQEIDGenerator;
import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.ast.sql.SQLExpression;
import com.cognos.xqe.ast.sql.SQLNodeFactory;
import com.cognos.xqe.ast.sql.parser.ParseException;
import com.cognos.xqe.ast.sql.parser.SQLProcessor;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.IntervalYearMonthType;
import com.cognos.xqe.data.types.RowType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.IntervalDayTimeValue;
import com.cognos.xqe.data.values.IntervalYearMonthValue;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.IColumnInfo;
import com.cognos.xqe.resultset.interfaces.ITabularIterator;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.resultsets.tabular.ColumnInfo;
import com.cognos.xqe.resultsets.tabular.RowsetInfo;
import com.cognos.xqe.resultsets.tabular.TabularHybridResultSet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XResultSetBase;
import com.cognos.xqe.runtree.XTabularResultSet;
import com.cognos.xqe.runtree.relational.dataset.ParquetFilters;
import com.cognos.xqe.runtree.relational.dataset.RowTypeHelper;
import com.cognos.xqe.runtree.relational.vectorization.ColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.TimestampColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.XVectorContext;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatchUtil;
import com.cognos.xqe.runtree.relational.vectorization.XVectorTabularIterator;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.datasets.FlintUtils;
import com.cognos.xqe.zipi.ZipiBridge;
import com.cognos.xqe.zipi.ZipiContext;
import com.cognos.xqerdp.flint.result.RSVPLegacyIntervalFormat;
import com.ibm.bi.platform.datasetutils.metadata.ColumnMetadata;
import com.ibm.bi.platform.datasetutils.metadata.RowSchema;
import com.ibm.bi.platform.datasetutils.metadata.types.TemporalType;
import com.ibm.bi.platform.datasetutils.parquet.DatasetParquetReadHelper;
import com.ibm.bi.platform.datasetutils.parquet.DatasetParquetReaderBuilder;
import com.ibm.bi.platform.datasetutils.parquet.ParquetOptions;
import com.ibm.bi.platform.datasetutils.utils.DateTimeUtils;
import com.ibm.bi.platform.datasetutils.utils.ReadableRecord;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.sql.Date;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.hadoop.ParquetReader;
import org.dom4j.Attribute;
import org.dom4j.Element;
import shaded.org.apache.hadoop.conf.Configuration;

public class XDataset
extends XTabularResultSet {
    private static final long serialVersionUID = 1L;
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_LOCATION = "location";
    private static final String ATTRIBUTE_FORMAT = "format";
    private static final String ATTRIBUTE_COLUMNNO = "columnNo";
    private static final String ATTRIBUTE_SORTED = "sorted";
    private static final String ELEMENT_XVECTORCONTEXT = "XVectorContext";
    private static final String ELEMENT_COLUMNS = "Columns";
    private static final String ELEMENT_COLUMN = "Column";
    private static final String ELEMENT_FILTER = "Filter";
    private static final String ELEMENT_DATA_SOURCE = "dataSource";
    private static final String ELEMENT_SORTED = "sorted";
    public static final long MILLISECONDS_PER_SECOND = 1000L;
    private IDataSource dataSource;
    private String location;
    private String name;
    private String format;
    private int nProjectedColumns;
    private int[] columns;
    private boolean[] sorted;
    private SQLExpression predicate;
    protected static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);

    @Override
    protected IValue executeImpl(XDataContext context) {
        return new TabularHybridResultSet(context, new XDatasetResultSet(context), this.getId());
    }

    @Override
    public int getType() {
        return 501169;
    }

    public void setName(String tableName) {
        this.name = tableName;
    }

    public void setFormat(String storageFormat) {
        this.format = storageFormat.toLowerCase();
    }

    public void setLocation(String storageLocation) {
        this.location = storageLocation;
    }

    public void setNumberOfProjectedColumns(int nColumns) {
        this.nProjectedColumns = nColumns;
    }

    public void setColumns(int[] refColumns) {
        this.columns = refColumns;
    }

    public void setFilter(SQLExpression thePredicate) {
        this.predicate = thePredicate;
    }

    public IDataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(IDataSource theDataSource) {
        this.dataSource = theDataSource;
    }

    @Override
    public XVectorContext getVectorizationContext() {
        return this.vContext;
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        this.name = inputNode.attributeValue(ATTRIBUTE_NAME);
        this.location = inputNode.attributeValue(ATTRIBUTE_LOCATION);
        this.format = inputNode.attributeValue(ATTRIBUTE_FORMAT);
        List children = inputNode.elements();
        Element child = (Element)children.get(0);
        if (child.getName().equals(ELEMENT_XVECTORCONTEXT)) {
            this.vContext = new XVectorContext();
            this.vContext.capture(env, child);
            if (children.size() > 1) {
                child = (Element)children.get(1);
            }
        }
        if (child.getName().equals(ELEMENT_COLUMNS)) {
            List columnList = child.elements();
            this.columns = new int[columnList.size()];
            this.sorted = new boolean[columnList.size()];
            int i = 0;
            for (Element e : columnList) {
                this.columns[i] = Integer.valueOf(e.attributeValue(ATTRIBUTE_COLUMNNO));
                String sortedAttr = e.attributeValue("sorted");
                this.sorted[i] = Boolean.valueOf(sortedAttr);
                ++i;
            }
            this.nProjectedColumns = this.columns.length;
            if (children.size() > 2) {
                child = (Element)children.get(2);
            }
        }
        if (child.getName().equals(ELEMENT_FILTER)) {
            SQLNodeFactory factory = new SQLNodeFactory();
            factory.setNodeIDGenerator(new XQEIDGenerator());
            factory.setPlanningEnvironment(env);
            try {
                this.predicate = (SQLExpression)SQLProcessor.parseExpression(child.getText(), factory);
            }
            catch (ParseException e) {
                throw new XQERuntimeException(e);
            }
        }
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute(ATTRIBUTE_NAME, this.name);
        trace.attribute(ATTRIBUTE_LOCATION, this.location);
        trace.attribute(ATTRIBUTE_FORMAT, this.format);
        if (this.vContext != null) {
            this.vContext.dumpInfo(trace);
        }
        trace.beginElement(ELEMENT_COLUMNS);
        for (int i = 0; i < this.columns.length; ++i) {
            trace.beginElement(ELEMENT_COLUMN);
            trace.attribute(ATTRIBUTE_COLUMNNO, this.columns[i]);
            trace.endElement();
        }
        trace.endElement();
        if (this.predicate != null) {
            trace.beginElement(ELEMENT_FILTER);
            this.predicate.dump(trace, includeRuntimeSpecifics);
            trace.endElement();
        }
    }

    @Override
    protected void persistAttributeProperties(XQEPersistContext ctx) {
        super.persistAttributeProperties(ctx);
        ctx.property(ATTRIBUTE_LOCATION, this.location);
        ctx.property(ATTRIBUTE_NAME, this.name);
        ctx.property(ATTRIBUTE_FORMAT, this.format);
    }

    @Override
    protected void persistElementProperties(XQEPersistContext ctx) {
        super.persistElementProperties(ctx);
        if (this.dataSource != null) {
            ctx.elementProperty(ELEMENT_DATA_SOURCE, this.dataSource);
        }
        if (this.columns != null) {
            ctx.elementProperty(ELEMENT_COLUMNS, this.columns);
        }
        if (this.sorted != null) {
            ctx.elementProperty("sorted", this.sorted);
        }
    }

    @Override
    protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element inputNode) {
        String attname = att.getName();
        if (attname.equals(ATTRIBUTE_LOCATION)) {
            Object val = ctx.attributeValue(att);
            this.location = (String)val;
        } else if (attname.equals(ATTRIBUTE_NAME)) {
            Object val = ctx.attributeValue(att);
            this.name = (String)val;
        } else if (attname.equals(ATTRIBUTE_FORMAT)) {
            Object val = ctx.attributeValue(att);
            this.format = (String)val;
        } else {
            super.restoreAttributeProperty(ctx, att, inputNode);
        }
    }

    @Override
    protected void restoreElementProperty(XQERestoreContext ctx, Element node, Element inputNode) {
        String pname = node.attributeValue("pname");
        if (pname.equals(ELEMENT_DATA_SOURCE)) {
            Object val = ctx.elementValue(node);
            this.dataSource = (IDataSource)val;
        } else if (pname.equals(ELEMENT_COLUMNS)) {
            Object val = ctx.elementValue(node);
            this.columns = (int[])val;
        } else if (pname.equals("sorted")) {
            Object val = ctx.elementValue(node);
            this.sorted = (boolean[])val;
        } else {
            super.restoreElementProperty(ctx, node, inputNode);
        }
    }

    private static VectorAssigner createVectorAssigner(IColumnInfo destColInfo, ColumnMetadata srcFieldMeta) {
        IDataType destColType = destColInfo.getDataType();
        switch (srcFieldMeta.getType().getIntrinsicType()) {
            case BINARY: {
                if (destColType.isBinary()) {
                    return new BinaryVectorAssigner();
                }
                throw new IllegalArgumentException("Cannot assign binary value to non-binary column: " + destColInfo.toString());
            }
            case BYTE: {
                if (destColType.isNumeric()) {
                    return new ByteVectorAssigner();
                }
                throw new IllegalArgumentException("Cannot assign byte value to non-numeric column: " + destColInfo.toString());
            }
            case BOOLEAN: {
                if (destColType.isTextType() || destColType.isClob()) {
                    return new BooleanAsStringVectorAssigner();
                }
                if (destColType.isNumeric()) {
                    return new BooleanAsLongVectorAssigner();
                }
                throw new IllegalArgumentException("Cannot assign boolean value to non-text/numeric column: " + destColInfo.toString());
            }
            case DATE: {
                if (destColType.isDate()) {
                    return new DateVectorAssigner();
                }
                throw new IllegalArgumentException("Cannot assign date value to non-date column: " + destColInfo.toString());
            }
            case DECIMAL: {
                if (destColType.isNumeric()) {
                    return new DecimalVectorAssigner();
                }
                throw new IllegalArgumentException("Cannot assign decimal value to non-numeric column: " + destColInfo.toString());
            }
            case DOUBLE: {
                if (destColType.isNumeric()) {
                    return new DoubleVectorAssigner();
                }
                throw new IllegalArgumentException("Cannot assign double value to non-numeric column: " + destColInfo.toString());
            }
            case FLOAT: {
                if (destColType.isNumeric()) {
                    return new FloatVectorAssigner();
                }
                throw new IllegalArgumentException("Cannot assign float value to non-numeric column: " + destColInfo.toString());
            }
            case INT: {
                if (destColType.isNumeric()) {
                    return new IntegerVectorAssigner();
                }
                throw new IllegalArgumentException("Cannot assign integer value to non-numeric column: " + destColInfo.toString());
            }
            case LONG: {
                if (destColType.isNumeric()) {
                    return new LongVectorAssigner();
                }
                throw new IllegalArgumentException("Cannot assign long value to non-numeric column: " + destColInfo.toString());
            }
            case SHORT: {
                if (destColType.isNumeric()) {
                    return new ShortVectorAssigner();
                }
                throw new IllegalArgumentException("Cannot assign short value to non-numeric column: " + destColInfo.toString());
            }
            case STRING: {
                if (destColType.isTextType() || destColType.isClob()) {
                    return new StringVectorAssigner();
                }
                if (destColType.isInterval()) {
                    return new IntervalVectorAssigner(IntervalYearMonthType.DEFAULT_INTERVALYEARMONTHTYPE.getCCLTypeCode() == destColType.getCCLTypeCode());
                }
                throw new IllegalArgumentException("Cannot assign string value to non-text column: " + destColInfo.toString());
            }
            case TIME: {
                if (destColType.isTime() || destColType.isTimestamp()) {
                    if (((TemporalType)srcFieldMeta.getType()).hasTimeZone()) {
                        return new OffsetTimeVectorAssigner();
                    }
                    return new TimeVectorAssigner();
                }
                throw new IllegalArgumentException("Cannot assign time value to non-temporal column: " + destColInfo.toString());
            }
            case TIMESTAMP: {
                if (destColType.isTime() || destColType.isTimestamp()) {
                    if (((TemporalType)srcFieldMeta.getType()).hasTimeZone()) {
                        return new OffsetDateTimeVectorAssigner();
                    }
                    return new DateTimeVectorAssigner();
                }
                throw new IllegalArgumentException("Cannot assign timestamp value to non-temporal column: " + destColInfo.toString());
            }
        }
        throw new IllegalArgumentException("Unsupported field type: " + srcFieldMeta.getType().toString());
    }

    static class OffsetDateTimeVectorAssigner
    implements VectorAssigner {
        OffsetDateTimeVectorAssigner() {
        }

        @Override
        public void assign(ColumnVector dest, int destIndex, ReadableRecord src, int srcIndex) {
            OffsetDateTime dateTime = src.getOffsetDateTime(srcIndex);
            Instant instant = dateTime.toInstant();
            dest.assign(destIndex, new TimestampColumnVector.UnixTimestamp(53, 1000L * instant.getEpochSecond(), instant.getNano(), (int)(1000L * (long)dateTime.getOffset().getTotalSeconds())));
        }
    }

    static class DateTimeVectorAssigner
    implements VectorAssigner {
        DateTimeVectorAssigner() {
        }

        @Override
        public void assign(ColumnVector dest, int destIndex, ReadableRecord src, int srcIndex) {
            LocalDateTime dateTime = src.getDateTime(srcIndex);
            Instant instant = dateTime.atZone(ZoneId.systemDefault()).toInstant();
            dest.assign(destIndex, new TimestampColumnVector.UnixTimestamp(59, 1000L * instant.getEpochSecond(), instant.getNano()));
        }
    }

    static class OffsetTimeVectorAssigner
    implements VectorAssigner {
        OffsetTimeVectorAssigner() {
        }

        @Override
        public void assign(ColumnVector dest, int destIndex, ReadableRecord src, int srcIndex) {
            OffsetTime time = src.getOffsetTime(srcIndex);
            Instant instant = DateTimeUtils.EPOCH_ZERO_DATE.atTime(time).toInstant();
            dest.assign(destIndex, new TimestampColumnVector.UnixTimestamp(52, 1000L * instant.getEpochSecond(), instant.getNano(), (int)(1000L * (long)time.getOffset().getTotalSeconds())));
        }
    }

    static class TimeVectorAssigner
    implements VectorAssigner {
        TimeVectorAssigner() {
        }

        @Override
        public void assign(ColumnVector dest, int destIndex, ReadableRecord src, int srcIndex) {
            LocalTime time = src.getTime(srcIndex);
            Instant instant = DateTimeUtils.EPOCH_ZERO_DATE.atTime(time).atZone(ZoneId.systemDefault()).toInstant();
            dest.assign(destIndex, new TimestampColumnVector.UnixTimestamp(58, 1000L * instant.getEpochSecond(), instant.getNano()));
        }
    }

    static class DateVectorAssigner
    implements VectorAssigner {
        DateVectorAssigner() {
        }

        @Override
        public void assign(ColumnVector dest, int destIndex, ReadableRecord src, int srcIndex) {
            LocalDate localDate = src.getDate(srcIndex);
            Date date = Date.valueOf(localDate);
            dest.assign(destIndex, date.getTime());
        }
    }

    static class DecimalVectorAssigner
    implements VectorAssigner {
        DecimalVectorAssigner() {
        }

        @Override
        public void assign(ColumnVector dest, int destIndex, ReadableRecord src, int srcIndex) {
            dest.assign(destIndex, src.getDecimal(srcIndex));
        }
    }

    static class ShortVectorAssigner
    implements VectorAssigner {
        ShortVectorAssigner() {
        }

        @Override
        public void assign(ColumnVector dest, int destIndex, ReadableRecord src, int srcIndex) {
            dest.assign(destIndex, src.getShort(srcIndex));
        }
    }

    static class LongVectorAssigner
    implements VectorAssigner {
        LongVectorAssigner() {
        }

        @Override
        public void assign(ColumnVector dest, int destIndex, ReadableRecord src, int srcIndex) {
            dest.assign(destIndex, src.getLong(srcIndex));
        }
    }

    static class IntegerVectorAssigner
    implements VectorAssigner {
        IntegerVectorAssigner() {
        }

        @Override
        public void assign(ColumnVector dest, int destIndex, ReadableRecord src, int srcIndex) {
            dest.assign(destIndex, src.getInt(srcIndex));
        }
    }

    static class FloatVectorAssigner
    implements VectorAssigner {
        FloatVectorAssigner() {
        }

        @Override
        public void assign(ColumnVector dest, int destIndex, ReadableRecord src, int srcIndex) {
            dest.assign(destIndex, Float.valueOf(src.getFloat(srcIndex)));
        }
    }

    static class DoubleVectorAssigner
    implements VectorAssigner {
        DoubleVectorAssigner() {
        }

        @Override
        public void assign(ColumnVector dest, int destIndex, ReadableRecord src, int srcIndex) {
            dest.assign(destIndex, src.getDouble(srcIndex));
        }
    }

    static class ByteVectorAssigner
    implements VectorAssigner {
        ByteVectorAssigner() {
        }

        @Override
        public void assign(ColumnVector dest, int destIndex, ReadableRecord src, int srcIndex) {
            dest.assign(destIndex, src.getByte(srcIndex));
        }
    }

    static class BooleanAsLongVectorAssigner
    implements VectorAssigner {
        BooleanAsLongVectorAssigner() {
        }

        @Override
        public void assign(ColumnVector dest, int destIndex, ReadableRecord src, int srcIndex) {
            if (src.getBoolean(srcIndex)) {
                dest.assign(destIndex, 1L);
            } else {
                dest.assign(destIndex, 0L);
            }
        }
    }

    static class BooleanAsStringVectorAssigner
    implements VectorAssigner {
        BooleanAsStringVectorAssigner() {
        }

        @Override
        public void assign(ColumnVector dest, int destIndex, ReadableRecord src, int srcIndex) {
            dest.assign(destIndex, Boolean.toString(src.getBoolean(srcIndex)));
        }
    }

    static class BinaryVectorAssigner
    implements VectorAssigner {
        BinaryVectorAssigner() {
        }

        @Override
        public void assign(ColumnVector dest, int destIndex, ReadableRecord src, int srcIndex) {
            dest.assign(destIndex, src.getBinary(srcIndex));
        }
    }

    static class IntervalVectorAssigner
    implements VectorAssigner {
        final boolean isYearMonthInterval;
        final IntervalYearMonthValue intervalYearMonthValue;
        final IntervalDayTimeValue intervalDayTimeValue;

        IntervalVectorAssigner(boolean isYearMonth) {
            this.isYearMonthInterval = isYearMonth;
            this.intervalYearMonthValue = DataValueFactory.createIntervalYearMonthValue();
            this.intervalDayTimeValue = DataValueFactory.createIntervalDayTimeValue();
        }

        @Override
        public void assign(ColumnVector dest, int destIndex, ReadableRecord src, int srcIndex) {
            String sValue = src.getString(srcIndex);
            if (StringUtils.isEmpty((String)sValue)) {
                dest.assign(destIndex, (Object)null);
                return;
            }
            if (sValue.startsWith("P") || sValue.startsWith("-P")) {
                dest.assign(destIndex, sValue);
            } else {
                try {
                    if (this.isYearMonthInterval) {
                        RSVPLegacyIntervalFormat.parseIntervalYM(this.intervalYearMonthValue, sValue);
                        dest.assign(destIndex, this.intervalYearMonthValue);
                    } else {
                        RSVPLegacyIntervalFormat.parseIntervalDT(this.intervalDayTimeValue, sValue);
                        dest.assign(destIndex, this.intervalDayTimeValue);
                    }
                }
                catch (Exception e) {
                    dest.assign(destIndex, sValue);
                }
            }
        }
    }

    static class StringVectorAssigner
    implements VectorAssigner {
        StringVectorAssigner() {
        }

        @Override
        public void assign(ColumnVector dest, int destIndex, ReadableRecord src, int srcIndex) {
            dest.assign(destIndex, src.getString(srcIndex));
        }
    }

    static interface VectorAssigner {
        public void assign(ColumnVector var1, int var2, ReadableRecord var3, int var4);
    }

    private final class XDatasetResultSet
    extends XResultSetBase
    implements ITabularResultSet {
        private final RowSchema fullRecordSchema;
        private final ParquetOptions parquetOptions;
        private final int[] columnIndexToRequestedFieldIndex;
        private final ParquetReader<ReadableRecord> recordReader;

        XDatasetResultSet(XDataContext context) {
            super(context, XDataset.this.getId());
            ZipiTimer zipiTimer = ZipiBridge.startTimer("XDatasetResultSet", "XDataset", ZipiContext.getQRDName());
            try {
                Path parquetFile = this.locateParquetFile();
                Files.setLastModifiedTime(parquetFile, FileTime.from(Instant.now()));
                shaded.org.apache.hadoop.fs.Path hadoopPath = new shaded.org.apache.hadoop.fs.Path(parquetFile.toString());
                Configuration hadoopConf = FlintUtils.getHadoopConfiguration();
                DatasetParquetReadHelper readHelper = new DatasetParquetReadHelper();
                readHelper.readFooter(hadoopPath, hadoopConf);
                this.fullRecordSchema = readHelper.getRecordSchema();
                this.parquetOptions = readHelper.getParquetOptions();
                Map kvMetadata = readHelper.getKeyValueMetadata();
                RowType rowType = RowTypeHelper.resolveRowType(kvMetadata, this.fullRecordSchema);
                ArrayList<String> projectedFieldNames = new ArrayList<String>();
                this.rowsetInfo = new RowsetInfo();
                if (XDataset.this.columns.length > 0) {
                    this.columnIndexToRequestedFieldIndex = new int[XDataset.this.columns.length];
                    HashMap<String, Integer> fieldNameToRequestedFieldIndex = new HashMap<String, Integer>();
                    int requestedFieldIndex = 0;
                    for (int colIndex = 0; colIndex < XDataset.this.columns.length; ++colIndex) {
                        int fullSchemaIndex = XDataset.this.columns[colIndex];
                        ColumnMetadata colMeta = this.fullRecordSchema.getColumnMetadata(fullSchemaIndex);
                        if (fieldNameToRequestedFieldIndex.containsKey(colMeta.getName())) {
                            this.columnIndexToRequestedFieldIndex[colIndex] = (Integer)fieldNameToRequestedFieldIndex.get(colMeta.getName());
                        } else {
                            projectedFieldNames.add(colMeta.getName());
                            this.columnIndexToRequestedFieldIndex[colIndex] = requestedFieldIndex;
                            fieldNameToRequestedFieldIndex.put(colMeta.getName(), requestedFieldIndex);
                            ++requestedFieldIndex;
                        }
                        if (colIndex >= XDataset.this.nProjectedColumns) continue;
                        this.rowsetInfo.addColumnInfo(new ColumnInfo(colMeta.getName(), rowType.getFieldDataType(fullSchemaIndex)));
                    }
                } else {
                    this.columnIndexToRequestedFieldIndex = new int[0];
                    projectedFieldNames.add(this.fullRecordSchema.getColumnMetadata(0).getName());
                }
                if (this.parquetOptions.isUnicodeNormalizeEnabled()) {
                    this.rowsetInfo.setNormalizationForm(this.parquetOptions.getUnicodeNormalizerForm());
                }
                ParquetReader.Builder readerBuilder = new DatasetParquetReaderBuilder(hadoopPath).withProjectionFields(projectedFieldNames).withConf(hadoopConf);
                if (XDataset.this.predicate != null) {
                    FilterCompat.Filter filter = FilterCompat.get((FilterPredicate)ParquetFilters.buildFilterPredicate(context, XDataset.this.predicate, this.parquetOptions));
                    readerBuilder.withFilter(filter);
                }
                this.recordReader = readerBuilder.build();
            }
            catch (Exception e) {
                throw new XQERuntimeException(e);
            }
            finally {
                if (zipiTimer != null) {
                    zipiTimer.stop();
                }
            }
        }

        private Path locateParquetFile() {
            Path path = Paths.get(XDataset.this.location, String.format("%s.parquet", XDataset.this.name));
            if (!Files.exists(path, new LinkOption[0])) {
                path = Paths.get(XDataset.this.location, String.format("%s.data", XDataset.this.name));
            }
            if (!Files.exists(path, new LinkOption[0])) {
                mErrorLogger.log(String.format("Failed to locate a parquet file with location [%s] and name [%s]", XDataset.this.location, XDataset.this.name));
                throw new XQERuntimeException(XQEMessageKeys.EXE_DataSetNotFound);
            }
            return path;
        }

        @Override
        public ITabularIterator getTabularIterator() {
            return new XDatasetIterator(this.getDataContext());
        }

        @Override
        public void releaseImpl() {
            try {
                this.recordReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private final class XDatasetIterator
        extends XVectorTabularIterator {
            private final XVectorRowBatch batch;
            private final VectorAssigner[] vectorAssigners;

            protected XDatasetIterator(XDataContext context) {
                super(context, XDataset.this.getId(), XDatasetResultSet.this.rowsetInfo);
                this.setMaxRowsRetrievedLimit(context.getEnvironment().getMultiRequestContext().fetchLongConfiguration("ibmcognos.flint.maxRowsRetrieved", 0L));
                this.setMaxRowsLocalProcessing(context.getEnvironment().getMaxRowsLocalProcessing());
                this.batch = XVectorRowBatchUtil.createRowBatch(XDataset.this.vContext, XDatasetResultSet.this.rowsetInfo, context.getLocalCollator());
                this.vectorAssigners = new VectorAssigner[XDatasetResultSet.this.rowsetInfo.getNumColumns()];
                for (int colIndex = 0; colIndex < XDatasetResultSet.this.rowsetInfo.getNumColumns(); ++colIndex) {
                    IColumnInfo colInfo = XDatasetResultSet.this.rowsetInfo.getColumnInfo(colIndex);
                    int fullSchemaIndex = XDataset.this.columns[colIndex];
                    ColumnMetadata fieldMeta = XDatasetResultSet.this.fullRecordSchema.getColumnMetadata(fullSchemaIndex);
                    this.vectorAssigners[colIndex] = XDataset.createVectorAssigner(colInfo, fieldMeta);
                }
            }

            @Override
            public Object nextBatch() {
                try {
                    ReadableRecord inputRow;
                    this.batch.reset();
                    ColumnVector[] vectors = this.batch.columns;
                    int size = 0;
                    for (int batchIndex = 0; batchIndex < this.batch.maxBatchSize && (inputRow = (ReadableRecord)XDatasetResultSet.this.recordReader.read()) != null; ++batchIndex) {
                        for (int colIndex = 0; colIndex < XDatasetResultSet.this.rowsetInfo.getNumColumns(); ++colIndex) {
                            int requestedFieldIndex = XDatasetResultSet.this.columnIndexToRequestedFieldIndex[colIndex];
                            if (inputRow.isNull(requestedFieldIndex)) {
                                vectors[colIndex].setNull(batchIndex);
                                continue;
                            }
                            this.vectorAssigners[colIndex].assign(vectors[colIndex], batchIndex, inputRow, requestedFieldIndex);
                        }
                        ++size;
                    }
                    this.batch.size = size;
                    if (size == 0) {
                        this.batch.eod = true;
                    } else {
                        this.batch.complete(size);
                    }
                }
                catch (IOException e) {
                    throw new XQERuntimeException(e);
                }
                return this.batch;
            }

            @Override
            public long getIndex() {
                return 0L;
            }
        }
    }
}

