/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.olapengine;

import com.cognos.xqe.data.values.IEncodable;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.relational.olapengine.AbstractColumnStorage;
import com.cognos.xqe.runtree.relational.olapengine.ColumnStorageControl;
import com.cognos.xqe.runtree.relational.olapengine.ICompressedColumnStorage;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import java.io.IOException;
import java.util.LinkedList;

public class CompressedColumnStorage
extends AbstractColumnStorage
implements ICompressedColumnStorage {
    private int currentValueCounter;
    protected LinkedList<IValue> values = new LinkedList();
    protected LinkedList<Integer> counters = new LinkedList();
    protected State state;
    protected State stateInitial = new StateInitial();
    protected State stateInMemory = new StateInMemory();
    protected State stateOnDisk = new StateOnDisk();

    public CompressedColumnStorage(ColumnStorageControl control) {
        super(control);
        this.state = this.stateInitial;
    }

    @Override
    public boolean retrieve() {
        if (this.state == this.stateInitial) {
            return false;
        }
        if (this.currentValueCounter == 0) {
            if (this.values.size() > 0) {
                IValue value = this.values.removeFirst();
                Integer counter = this.counters.removeFirst();
                this.allocator.releaseMemory(value.sizeOf());
                this.buffer.copyFrom(value);
                this.currentValueCounter = counter;
            } else {
                try {
                    this.currentValueCounter = this.iStream.readInt();
                    ((IEncodable)((Object)this.buffer)).decode(this.context, this.iStream);
                }
                catch (IOException e) {
                    throw new XQERuntimeException(e);
                }
            }
        }
        --this.valueCount;
        --this.currentValueCounter;
        if (this.valueCount == 0) {
            this.state = this.stateInitial;
        }
        return true;
    }

    @Override
    public void store(IValue theValue, int counter) {
        this.state.store(theValue, counter);
    }

    private class StateOnDisk
    extends State {
        private StateOnDisk() {
        }

        @Override
        public void store(IValue theValue, int counter) {
            try {
                CompressedColumnStorage.this.oStream.writeInt(counter);
                ((IEncodable)((Object)theValue)).encode(CompressedColumnStorage.this.context, CompressedColumnStorage.this.oStream);
                CompressedColumnStorage.this.valueCount += counter;
            }
            catch (IOException e) {
                throw new XQERuntimeException(e);
            }
        }
    }

    private class StateInMemory
    extends State {
        private StateInMemory() {
        }

        @Override
        public void store(IValue theValue, int counter) {
            if (CompressedColumnStorage.this.allocator.allocateMemory(theValue.sizeOf())) {
                CompressedColumnStorage.this.values.add((IValue)theValue.copy());
                CompressedColumnStorage.this.counters.add(XQEIntegerPool.getInteger(counter));
                CompressedColumnStorage.this.valueCount += counter;
            } else {
                CompressedColumnStorage.this.state = CompressedColumnStorage.this.stateOnDisk;
                CompressedColumnStorage.this.state.store(theValue, counter);
            }
        }
    }

    private class StateInitial
    extends State {
        private StateInitial() {
        }

        @Override
        public void store(IValue theValue, int counter) {
            CompressedColumnStorage.this.buffer.copyFrom(theValue);
            CompressedColumnStorage.this.currentValueCounter = counter;
            CompressedColumnStorage.this.valueCount = counter;
            CompressedColumnStorage.this.state = CompressedColumnStorage.this.stateInMemory;
        }
    }

    private abstract class State {
        private State() {
        }

        public abstract void store(IValue var1, int var2);
    }
}

