/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.olapengine;

import com.cognos.xqe.data.values.IEncodable;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.relational.olapengine.AbstractColumnStorage;
import com.cognos.xqe.runtree.relational.olapengine.ColumnStorageControl;
import com.cognos.xqe.runtree.relational.olapengine.IPartitionColumnStorage;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import java.io.IOException;
import java.util.LinkedList;

public class PartitionColumnStorage
extends AbstractColumnStorage
implements IPartitionColumnStorage {
    private static final String INVALID_STATE = "Invalid state";
    private int bufferCount = 0;
    private int currentValueCounter = 0;
    protected LinkedList<IValue> values = new LinkedList();
    protected LinkedList<Integer> counters = new LinkedList();
    protected State state;
    protected State stateBuffer = new StateBuffer();
    protected State stateInMemory = new StateInMemory();
    protected State stateOnDisk = new StateOnDisk();

    public PartitionColumnStorage(ColumnStorageControl control) {
        super(control);
        this.state = this.stateBuffer;
    }

    @Override
    public boolean retrieve() {
        if (this.valueCount == 0) {
            return false;
        }
        if (this.bufferCount == 0) {
            if (this.values.size() > 0) {
                this.buffer.copyFrom(this.values.removeFirst());
                if (this.valueCount > this.currentValueCounter) {
                    this.bufferCount = this.counters.removeFirst();
                } else {
                    this.bufferCount = this.currentValueCounter;
                    this.currentValueCounter = 0;
                    this.state = this.stateBuffer;
                }
                this.allocator.releaseMemory(this.buffer.sizeOf());
            } else {
                try {
                    ((IEncodable)((Object)this.buffer)).decode(this.context, this.iStream);
                    if (this.valueCount > this.currentValueCounter) {
                        this.bufferCount = this.iStream.readInt();
                    } else {
                        this.bufferCount = this.currentValueCounter;
                        this.currentValueCounter = 0;
                        this.state = this.stateBuffer;
                    }
                }
                catch (IOException e) {
                    throw new XQERuntimeException(e);
                }
            }
        }
        --this.bufferCount;
        --this.valueCount;
        return true;
    }

    @Override
    public void store(IValue theValue) {
        this.state.store(theValue);
    }

    @Override
    public void store() {
        this.state.store();
    }

    private class StateOnDisk
    implements State {
        private StateOnDisk() {
        }

        @Override
        public void store(IValue theValue) {
            try {
                if (PartitionColumnStorage.this.currentValueCounter > 0) {
                    PartitionColumnStorage.this.oStream.writeInt(PartitionColumnStorage.this.currentValueCounter);
                }
                ((IEncodable)((Object)theValue)).encode(PartitionColumnStorage.this.context, PartitionColumnStorage.this.oStream);
                PartitionColumnStorage.this.currentValueCounter = 1;
                ++PartitionColumnStorage.this.valueCount;
            }
            catch (IOException e) {
                throw new XQERuntimeException(e);
            }
        }

        @Override
        public void store() {
            PartitionColumnStorage.this.currentValueCounter++;
            ++PartitionColumnStorage.this.valueCount;
        }
    }

    private class StateInMemory
    implements State {
        private StateInMemory() {
        }

        @Override
        public void store(IValue theValue) {
            if (PartitionColumnStorage.this.currentValueCounter > 0) {
                if (PartitionColumnStorage.this.values.size() == 0) {
                    throw new RuntimeException(PartitionColumnStorage.INVALID_STATE);
                }
                PartitionColumnStorage.this.counters.add(XQEIntegerPool.getInteger(PartitionColumnStorage.this.currentValueCounter));
                PartitionColumnStorage.this.currentValueCounter = 0;
            }
            if (PartitionColumnStorage.this.allocator.allocateMemory(theValue.sizeOf())) {
                PartitionColumnStorage.this.values.add((IValue)theValue.copy());
                ++PartitionColumnStorage.this.valueCount;
                PartitionColumnStorage.this.currentValueCounter = 1;
            } else {
                PartitionColumnStorage.this.state = PartitionColumnStorage.this.stateOnDisk;
                PartitionColumnStorage.this.state.store(theValue);
            }
        }

        @Override
        public void store() {
            if (PartitionColumnStorage.this.values.size() == 0) {
                PartitionColumnStorage.this.bufferCount++;
            } else {
                PartitionColumnStorage.this.currentValueCounter++;
            }
            ++PartitionColumnStorage.this.valueCount;
        }
    }

    private class StateBuffer
    implements State {
        private StateBuffer() {
        }

        @Override
        public void store(IValue theValue) {
            if (PartitionColumnStorage.this.bufferCount > 0) {
                PartitionColumnStorage.this.state = PartitionColumnStorage.this.stateInMemory;
                PartitionColumnStorage.this.state.store(theValue);
            } else {
                PartitionColumnStorage.this.buffer.copyFrom(theValue);
                PartitionColumnStorage.this.bufferCount = 1;
                PartitionColumnStorage.this.valueCount = 1;
            }
        }

        @Override
        public void store() {
            PartitionColumnStorage.this.bufferCount++;
            ++PartitionColumnStorage.this.valueCount;
        }
    }

    private static interface State {
        public void store();

        public void store(IValue var1);
    }
}

