/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.olapengine;

import com.cognos.xqe.ast.sql.SQLAbstractFunction;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.ISetFunctionState;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.XSetFunction;
import com.cognos.xqe.runtree.relational.olapengine.IColumnStorage;
import com.cognos.xqe.runtree.relational.olapengine.IColumnStorageFactory;
import com.cognos.xqe.runtree.relational.olapengine.IPlainColumnStorage;
import com.cognos.xqe.runtree.relational.olapengine.IWindowProcessor;
import com.cognos.xqe.runtree.relational.olapengine.WindowDescriptor;
import java.util.LinkedList;

public class WindowProcessorMoving
implements IWindowProcessor,
IParameterEvaluator {
    private XSetFunction xFunction;
    private ISetFunctionState state;
    private int partitionByLength;
    private int atListLength;
    private boolean iterate;
    private XDataContext context;
    private LinkedList<IValue> inList;
    private IPlainColumnStorage columnStorage;
    private int frameEndOffset;
    private int currentEndOffset;
    private int frameStartOffset;
    private int currentStartOffset;
    private boolean removing = false;

    public WindowProcessorMoving(WindowDescriptor wd, XDataContext theContext, XSetFunction function) {
        this.xFunction = function;
        this.partitionByLength = wd.getPartitionByLength();
        this.atListLength = wd.getAtListLength();
        this.context = theContext;
        this.state = this.xFunction.initialize(this.context);
        this.frameEndOffset = wd.getWindowEnd();
        this.frameStartOffset = wd.getWindowStart();
        if (this.inList == null) {
            this.inList = new LinkedList();
        }
        this.iterate = true;
        this.currentEndOffset = this.frameEndOffset;
        this.currentStartOffset = this.frameStartOffset;
    }

    @Override
    public void iterate() {
        Value theValue;
        if (this.currentEndOffset < 0) {
            while (this.currentEndOffset < 0) {
                theValue = (Value)this.xFunction.getDataType().createValue(this.context.getLocalCollator());
                theValue.setNull();
                this.columnStorage.store(theValue);
                ++this.currentEndOffset;
                ++this.currentStartOffset;
            }
        }
        if (this.iterate) {
            this.captureValueForWindow();
            if (this.atListLength > 0) {
                this.iterate = false;
            }
        }
        if (this.currentEndOffset > 0) {
            --this.currentEndOffset;
        } else {
            if (this.currentStartOffset <= 0) {
                ++this.currentStartOffset;
            } else if (this.iterate) {
                this.removeValueFromWindow();
            }
            theValue = (Value)this.xFunction.getDataType().createValue(this.context.getLocalCollator());
            this.xFunction.getResult(this.context, this.state, theValue);
            this.columnStorage.store(theValue);
        }
    }

    @Override
    public void processBreak(int breakpointColumn) {
        if (this.atListLength > 0 && breakpointColumn < this.atListLength) {
            this.iterate = true;
        }
        if (breakpointColumn < this.partitionByLength) {
            if (this.frameEndOffset > 0) {
                while (this.currentEndOffset < this.frameEndOffset) {
                    if (this.currentStartOffset <= 0) {
                        ++this.currentStartOffset;
                    } else {
                        this.removeValueFromWindow();
                    }
                    Value theValue = (Value)this.xFunction.getDataType().createValue(this.context.getLocalCollator());
                    this.xFunction.getResult(this.context, this.state, theValue);
                    this.columnStorage.store(theValue);
                    ++this.currentEndOffset;
                }
            } else if (this.frameEndOffset < 0) {
                this.columnStorage.clearlast(-this.frameEndOffset);
                this.currentEndOffset = this.frameEndOffset;
            }
            this.currentStartOffset = this.frameStartOffset;
            this.xFunction.terminate(this.context, this.state);
            this.inList.clear();
            this.state = this.xFunction.initialize(this.context);
        }
    }

    @Override
    public IColumnStorage createColumnStorage(IColumnStorageFactory csf) {
        if (this.columnStorage == null) {
            this.columnStorage = csf.createPlainColumnStorage();
        }
        return this.columnStorage;
    }

    private synchronized void removeValueFromWindow() {
        this.removing = true;
        this.xFunction.remove(this.context, this.state, this);
    }

    private synchronized void captureValueForWindow() {
        this.removing = false;
        this.xFunction.iterate(this.context, this.state, this);
    }

    @Override
    public int getParameterCount() {
        return this.xFunction.getParameterCount();
    }

    @Override
    public IValue getParameter(XDataContext aContext, int index) {
        if (this.removing) {
            return this.inList.removeFirst();
        }
        this.inList.addLast((IValue)this.xFunction.getParameter(aContext, index).copy());
        return this.inList.getLast();
    }

    @Override
    public IValue[] getParameters(XDataContext aContext) {
        int nChildren = this.getParameterCount();
        IValue[] pValues = new IValue[nChildren];
        for (int i = 0; i < nChildren; ++i) {
            pValues[i] = this.getParameter(this.context, i);
        }
        return pValues;
    }

    @Override
    public String getParameterName(int index) {
        return this.xFunction.getName(index);
    }

    @Override
    public boolean isParameterLiteral(int index) {
        return this.xFunction.isParameterLiteral(index);
    }

    @Override
    public IDataType getParameterType(int index) {
        return null;
    }

    @Override
    public IDataSource getDataSource() {
        return null;
    }

    @Override
    public SQLAbstractFunction.OnErrorPolicy getOnErrorPolicy() {
        throw new UnsupportedOperationException();
    }
}

