/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.olapengine;

import com.cognos.xqe.ast.sql.SQLAbstractFunction;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.BooleanValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.ISetFunctionState;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.XSetFunction;
import com.cognos.xqe.runtree.relational.olapengine.IColumnStorage;
import com.cognos.xqe.runtree.relational.olapengine.IColumnStorageFactory;
import com.cognos.xqe.runtree.relational.olapengine.IPeerCounter;
import com.cognos.xqe.runtree.relational.olapengine.IPlainColumnStorage;
import com.cognos.xqe.runtree.relational.olapengine.IWindowProcessor;
import com.cognos.xqe.runtree.relational.olapengine.WindowDescriptor;

public class WindowProcessorOther
implements IWindowProcessor,
IParameterEvaluator {
    private IPlainColumnStorage columnStorage;
    private Value value;
    private XSetFunction function;
    int fArgCount = 0;
    private XDataContext context;
    private ISetFunctionState fState;
    private int partition = 0;
    private int order = 0;
    private int computeBreak = 0;
    private boolean iterate = true;
    private boolean change;
    private boolean isTwoPass = false;
    private int iteratorCount = 0;
    IPeerCounter peerCounter;

    public WindowProcessorOther(WindowDescriptor wd, XDataContext theContext, XSetFunction theFunction) {
        this.partition = wd.getPartitionByLength();
        this.order = wd.getOrderByLength();
        this.computeBreak = wd.getAtListLength();
        this.context = theContext;
        this.function = theFunction;
        this.fState = this.function.initialize(this.context);
        this.value = (Value)this.function.getDataType().createValue(theContext.getLocalCollator());
        this.iterate = true;
        this.change = false;
        this.iteratorCount = 0;
        this.peerCounter = null;
        this.fArgCount = this.function.getParameterCount();
    }

    @Override
    public IColumnStorage createColumnStorage(IColumnStorageFactory csf) {
        if (this.isTwoPass() && this.computeBreak > 0) {
            this.peerCounter = csf.createPeerCounter();
        }
        if (this.columnStorage == null) {
            this.columnStorage = csf.createPlainColumnStorage();
        }
        return this.columnStorage;
    }

    @Override
    public void iterate() {
        if (this.iterate) {
            this.function.iterate(this.context, this.fState, this);
            if (this.computeBreak > 0) {
                this.iterate = false;
            }
        }
        if (!this.isTwoPass()) {
            this.function.getResult(this.context, this.fState, this.value);
            this.columnStorage.store(this.value);
        } else {
            ++this.iteratorCount;
            if (this.computeBreak > 0) {
                this.peerCounter.addPeer();
            }
        }
        this.change = false;
    }

    @Override
    public void processBreak(int breakpointColumn) {
        if (this.computeBreak > 0 && breakpointColumn < this.computeBreak) {
            this.iterate = true;
            if (this.isTwoPass()) {
                this.peerCounter.newPeerGroup();
            }
        }
        if (breakpointColumn < this.partition + this.order) {
            this.change = true;
            if (breakpointColumn < this.partition) {
                if (this.isTwoPass()) {
                    if (this.computeBreak == 0) {
                        for (int i = 0; i < this.iteratorCount; ++i) {
                            this.function.getResult(this.context, this.fState, this.value);
                            this.columnStorage.store(this.value);
                        }
                    } else {
                        for (int i = 0; i < this.iteratorCount; ++i) {
                            if (!this.peerCounter.isPeer()) {
                                this.function.getResult(this.context, this.fState, this.value);
                            }
                            this.columnStorage.store(this.value);
                        }
                    }
                }
                this.function.terminate(this.context, this.fState);
                this.fState = this.function.initialize(this.context);
                this.iteratorCount = 0;
                this.change = false;
            }
        }
    }

    @Override
    public IValue getParameter(XDataContext theContext, int index) {
        if (index == this.fArgCount) {
            if (this.change) {
                return BooleanValue.TRUE;
            }
            return BooleanValue.FALSE;
        }
        if (index < this.fArgCount) {
            return this.function.getParameter(theContext, index);
        }
        return null;
    }

    @Override
    public int getParameterCount() {
        return this.fArgCount + 1 + this.order;
    }

    @Override
    public String getParameterName(int index) {
        return null;
    }

    @Override
    public boolean isParameterLiteral(int index) {
        return false;
    }

    @Override
    public IValue[] getParameters(XDataContext theContext) {
        return null;
    }

    @Override
    public IDataType getParameterType(int index) {
        return null;
    }

    public void setTwoPass(boolean twoPass) {
        this.isTwoPass = twoPass;
    }

    public boolean isTwoPass() {
        return this.isTwoPass;
    }

    @Override
    public IDataSource getDataSource() {
        return null;
    }

    @Override
    public SQLAbstractFunction.OnErrorPolicy getOnErrorPolicy() {
        throw new UnsupportedOperationException();
    }
}

